/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.Metadata;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InsertContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public boolean dontCompress;
    private Metadata.SplitfileAlgorithm splitfileAlgo;
    private final short splitfileAlgorithm;
    public int maxInsertRetries;
    public int consecutiveRNFsCountAsSuccess;
    public int splitfileSegmentDataBlocks;
    public int splitfileSegmentCheckBlocks;
    public final ClientEventProducer eventProducer;
    public boolean canWriteClientCache;
    public String compressorDescriptor;
    public boolean forkOnCacheable;
    public int extraInsertsSingleBlock;
    public int extraInsertsSplitfileHeaderBlock;
    public boolean localRequestOnly;
    public boolean ignoreUSKDatehints;
    private CompatibilityMode realCompatMode;
    private long compatibilityMode;
    public boolean getCHKOnly;
    public boolean earlyEncode;

    public CompatibilityMode getCompatibilityMode() {
        return this.realCompatMode;
    }

    public long getCompatibilityCode() {
        return this.realCompatMode.ordinal();
    }

    public void setCompatibilityMode(CompatibilityMode mode) {
        this.realCompatMode = mode.intern();
    }

    public InsertContext(int maxRetries, int rnfsToSuccess, int splitfileSegmentDataBlocks, int splitfileSegmentCheckBlocks, ClientEventProducer eventProducer, boolean canWriteClientCache, boolean forkOnCacheable, boolean localRequestOnly, String compressorDescriptor, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, CompatibilityMode compatibilityMode) {
        this.dontCompress = false;
        this.splitfileAlgo = Metadata.SplitfileAlgorithm.ONION_STANDARD;
        this.splitfileAlgorithm = this.splitfileAlgo.code;
        this.consecutiveRNFsCountAsSuccess = rnfsToSuccess;
        this.maxInsertRetries = maxRetries;
        this.eventProducer = eventProducer;
        this.splitfileSegmentDataBlocks = splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = splitfileSegmentCheckBlocks;
        this.canWriteClientCache = canWriteClientCache;
        this.forkOnCacheable = forkOnCacheable;
        this.compressorDescriptor = compressorDescriptor;
        this.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeaderBlock;
        this.realCompatMode = compatibilityMode.intern();
        this.localRequestOnly = localRequestOnly;
        this.ignoreUSKDatehints = false;
    }

    public InsertContext(InsertContext ctx, SimpleEventProducer producer) {
        this.dontCompress = ctx.dontCompress;
        this.splitfileAlgo = ctx.splitfileAlgo;
        this.splitfileAlgorithm = this.splitfileAlgo.code;
        this.consecutiveRNFsCountAsSuccess = ctx.consecutiveRNFsCountAsSuccess;
        this.maxInsertRetries = ctx.maxInsertRetries;
        this.eventProducer = producer;
        this.splitfileSegmentDataBlocks = ctx.splitfileSegmentDataBlocks;
        this.splitfileSegmentCheckBlocks = ctx.splitfileSegmentCheckBlocks;
        this.compressorDescriptor = ctx.compressorDescriptor;
        this.forkOnCacheable = ctx.forkOnCacheable;
        this.extraInsertsSingleBlock = ctx.extraInsertsSingleBlock;
        this.extraInsertsSplitfileHeaderBlock = ctx.extraInsertsSplitfileHeaderBlock;
        this.realCompatMode = ctx.realCompatMode;
        this.localRequestOnly = ctx.localRequestOnly;
        this.ignoreUSKDatehints = ctx.ignoreUSKDatehints;
    }

    public InsertContext clone() {
        try {
            return (InsertContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canWriteClientCache ? 1231 : 1237);
        result = 31 * result + this.realCompatMode.ordinal();
        result = 31 * result + (this.compressorDescriptor == null ? 0 : this.compressorDescriptor.hashCode());
        result = 31 * result + this.consecutiveRNFsCountAsSuccess;
        result = 31 * result + (this.dontCompress ? 1231 : 1237);
        result = 31 * result + this.extraInsertsSingleBlock;
        result = 31 * result + this.extraInsertsSplitfileHeaderBlock;
        result = 31 * result + (this.forkOnCacheable ? 1231 : 1237);
        result = 31 * result + (this.ignoreUSKDatehints ? 1231 : 1237);
        result = 31 * result + (this.localRequestOnly ? 1231 : 1237);
        result = 31 * result + this.maxInsertRetries;
        result = 31 * result + this.splitfileAlgo.code;
        result = 31 * result + this.splitfileSegmentCheckBlocks;
        result = 31 * result + this.splitfileSegmentDataBlocks;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InsertContext other = (InsertContext)obj;
        if (this.canWriteClientCache != other.canWriteClientCache) {
            return false;
        }
        if (this.compatibilityMode != other.compatibilityMode) {
            return false;
        }
        if (this.compressorDescriptor == null ? other.compressorDescriptor != null : !this.compressorDescriptor.equals(other.compressorDescriptor)) {
            return false;
        }
        if (this.consecutiveRNFsCountAsSuccess != other.consecutiveRNFsCountAsSuccess) {
            return false;
        }
        if (this.dontCompress != other.dontCompress) {
            return false;
        }
        if (this.extraInsertsSingleBlock != other.extraInsertsSingleBlock) {
            return false;
        }
        if (this.extraInsertsSplitfileHeaderBlock != other.extraInsertsSplitfileHeaderBlock) {
            return false;
        }
        if (this.forkOnCacheable != other.forkOnCacheable) {
            return false;
        }
        if (this.ignoreUSKDatehints != other.ignoreUSKDatehints) {
            return false;
        }
        if (this.localRequestOnly != other.localRequestOnly) {
            return false;
        }
        if (this.maxInsertRetries != other.maxInsertRetries) {
            return false;
        }
        if (this.splitfileAlgo != other.splitfileAlgo) {
            return false;
        }
        if (this.splitfileSegmentCheckBlocks != other.splitfileSegmentCheckBlocks) {
            return false;
        }
        return this.splitfileSegmentDataBlocks == other.splitfileSegmentDataBlocks;
    }

    public Metadata.SplitfileAlgorithm getSplitfileAlgorithm() {
        return this.splitfileAlgo;
    }

    public void onResume() {
        if (this.realCompatMode == null) {
            this.realCompatMode = CompatibilityMode.byCode((short)this.compatibilityMode);
        }
        this.splitfileSegmentDataBlocks = 256;
        this.splitfileSegmentCheckBlocks = 256;
        this.splitfileAlgo = Metadata.SplitfileAlgorithm.getByCode(this.splitfileAlgorithm);
    }

    public static enum CompatibilityMode {
        COMPAT_UNKNOWN(0),
        COMPAT_CURRENT(1),
        COMPAT_1250_EXACT(2),
        COMPAT_1250(3),
        COMPAT_1251(4),
        COMPAT_1255(5),
        COMPAT_1416(6),
        COMPAT_1468(7);

        public final short code;
        private static final CompatibilityMode[] values;
        private static final Map<Short, CompatibilityMode> modesByCode;
        public static final CompatibilityMode COMPAT_DEFAULT;

        private CompatibilityMode(short code) {
            this.code = code;
        }

        public static CompatibilityMode latest() {
            return values[values.length - 1];
        }

        public CompatibilityMode intern() {
            if (this == COMPAT_CURRENT) {
                return CompatibilityMode.latest();
            }
            return this;
        }

        public static CompatibilityMode byCode(short code) {
            if (!modesByCode.containsKey(code)) {
                throw new IllegalArgumentException();
            }
            return modesByCode.get(code);
        }

        public static boolean hasCode(short min) {
            return modesByCode.containsKey(min);
        }

        public static boolean maybeFutureCode(short code) {
            return code > CompatibilityMode.latest().code;
        }

        static {
            values = CompatibilityMode.values();
            HashMap<Short, CompatibilityMode> cmodes = new HashMap<Short, CompatibilityMode>();
            for (CompatibilityMode mode : values) {
                if (cmodes.containsKey(mode.code)) {
                    throw new Error("Duplicated code!");
                }
                cmodes.put(mode.code, mode);
            }
            modesByCode = Collections.unmodifiableMap(cmodes);
            COMPAT_DEFAULT = COMPAT_CURRENT;
        }
    }
}

