/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.FECCodec;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileInserterCrossSegmentStorage;
import freenet.client.async.SplitFileInserterSegmentStorage;
import freenet.client.async.SplitFileInserterStorageCallback;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.HashResult;
import freenet.crypt.MasterSecret;
import freenet.keys.ClientCHK;
import freenet.node.KeysFetchingLocally;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.RandomArrayIterator;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.io.ArrayBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.NullBucket;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PrependLengthOutputStream;
import freenet.support.io.RAFInputStream;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import freenet.support.math.MersenneTwister;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class SplitFileInserterStorage {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final LockableRandomAccessBuffer originalData;
    private final LockableRandomAccessBuffer raf;
    private final long rafLength;
    final boolean persistent;
    final SplitFileInserterStorageCallback callback;
    final SplitFileInserterSegmentStorage[] segments;
    final SplitFileInserterCrossSegmentStorage[] crossSegments;
    private final RandomArrayIterator<SplitFileInserterSegmentStorage> randomSegmentIterator;
    final int totalDataBlocks;
    final int totalCheckBlocks;
    final FECCodec codec;
    final long dataLength;
    private final ClientMetadata clientMetadata;
    private final boolean isMetadata;
    private final Compressor.COMPRESSOR_TYPE compressionCodec;
    private final long decompressedLength;
    private final InsertContext.CompatibilityMode cmode;
    private final byte[] hashThisLayerOnly;
    private final ArchiveManager.ARCHIVE_TYPE archiveType;
    private final HashResult[] hashes;
    private final boolean topDontCompress;
    final int topRequiredBlocks;
    final int topTotalBlocks;
    private final long origDataSize;
    private final long origCompressedDataSize;
    private final Metadata.SplitfileAlgorithm splitfileType;
    private final int segmentSize;
    private final int checkSegmentSize;
    private final int deductBlocksFromSegments;
    private final int crossCheckBlocks;
    private final byte[] splitfileCryptoKey;
    private final byte splitfileCryptoAlgorithm;
    private final boolean specifySplitfileKeyInMetadata;
    final ChecksumChecker checker;
    private final int keyLength;
    private final int maxRetries;
    private final int consecutiveRNFsCountAsSuccess;
    final MemoryLimitedJobRunner memoryLimitedJobRunner;
    final PersistentJobRunner jobRunner;
    final Ticker ticker;
    final Random random;
    private final boolean hasPaddedLastBlock;
    private Status status;
    private final FailureCodeTracker errors;
    private boolean overallStatusDirty;
    private InsertException failing;
    private final long[] underlyingOffsetDataSegments;
    private final long offsetPaddedLastBlock;
    private final long offsetOverallStatus;
    private final long[] offsetCrossSegmentBlocks;
    private final long[] offsetSegmentCheckBlocks;
    private final long[] offsetSegmentStatus;
    private final long[] offsetCrossSegmentStatus;
    private final long[] offsetSegmentKeys;
    private final int overallStatusLength;
    private final Object cooldownLock = new Object();
    private boolean noBlocksToSend;
    static final long MAGIC = 5560326343234641381L;
    static final int VERSION = 1;
    static final long LAZY_WRITE_METADATA_DELAY;
    private final PersistentJob writeMetadataJob = new PersistentJob(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ClientContext context) {
            try {
                if (SplitFileInserterStorage.this.isFinishing()) {
                    return false;
                }
                LockableRandomAccessBuffer.RAFLock lock = SplitFileInserterStorage.this.raf.lockOpen();
                try {
                    for (SplitFileInserterSegmentStorage segment : SplitFileInserterStorage.this.segments) {
                        segment.storeStatus(false);
                    }
                }
                finally {
                    lock.unlock();
                }
                SplitFileInserterStorage.this.writeOverallStatus(false);
                return false;
            }
            catch (IOException e) {
                if (SplitFileInserterStorage.this.isFinishing()) {
                    return false;
                }
                Logger.error(this, "Failed writing metadata for " + SplitFileInserterStorage.this + ": " + e, (Throwable)e);
                return false;
            }
        }
    };
    private final Runnable wrapLazyWriteMetadata = new Runnable(){

        @Override
        public void run() {
            SplitFileInserterStorage.this.jobRunner.queueNormalOrDrop(SplitFileInserterStorage.this.writeMetadataJob);
        }
    };

    public SplitFileInserterStorage(LockableRandomAccessBuffer originalData, long decompressedLength, SplitFileInserterStorageCallback callback, Compressor.COMPRESSOR_TYPE compressionCodec, ClientMetadata meta, boolean isMetadata, ArchiveManager.ARCHIVE_TYPE archiveType, LockableRandomAccessBufferFactory rafFactory, boolean persistent, InsertContext ctx, byte splitfileCryptoAlgorithm, byte[] splitfileCryptoKey, byte[] hashThisLayerOnly, HashResult[] hashes, BucketFactory bf, ChecksumChecker checker, Random random, MemoryLimitedJobRunner memoryLimitedJobRunner, PersistentJobRunner jobRunner, Ticker ticker, KeysFetchingLocally keysFetching, boolean topDontCompress, int topRequiredBlocks, int topTotalBlocks, long origDataSize, long origCompressedDataSize) throws IOException, InsertException {
        int i;
        int segs;
        this.originalData = originalData;
        this.callback = callback;
        this.persistent = persistent;
        this.dataLength = originalData.size();
        if (this.dataLength > 70368744144896L) {
            throw new InsertException(InsertException.InsertExceptionMode.TOO_BIG);
        }
        this.totalDataBlocks = (int)((this.dataLength + 32768L - 1L) / 32768L);
        this.decompressedLength = decompressedLength;
        this.compressionCodec = compressionCodec;
        this.clientMetadata = meta;
        this.checker = checker;
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        this.jobRunner = jobRunner;
        this.isMetadata = isMetadata;
        this.archiveType = archiveType;
        this.hashThisLayerOnly = hashThisLayerOnly;
        this.topDontCompress = topDontCompress;
        this.origDataSize = origDataSize;
        this.origCompressedDataSize = origCompressedDataSize;
        this.maxRetries = ctx.maxInsertRetries;
        this.errors = new FailureCodeTracker(true);
        this.ticker = ticker;
        this.random = random;
        this.cmode = ctx.getCompatibilityMode();
        if (this.cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
            this.hashes = null;
            splitfileCryptoKey = null;
        } else {
            this.hashes = hashes;
        }
        if (this.cmode == InsertContext.CompatibilityMode.COMPAT_1250_EXACT) {
            segs = (this.totalDataBlocks + 128 - 1) / 128;
            this.segmentSize = 128;
            this.deductBlocksFromSegments = 0;
        } else {
            segs = this.cmode == InsertContext.CompatibilityMode.COMPAT_1251 ? (this.totalDataBlocks + 131 - 1) / 131 : (this.totalDataBlocks > 520 ? (this.totalDataBlocks + 128 - 1) / 128 : (this.totalDataBlocks > 393 ? 4 : (this.totalDataBlocks > 266 ? 3 : (this.totalDataBlocks > 136 ? 2 : 1))));
            int segSize = (this.totalDataBlocks + segs - 1) / segs;
            if (ctx.splitfileSegmentDataBlocks < segSize) {
                segs = (this.totalDataBlocks + ctx.splitfileSegmentDataBlocks - 1) / ctx.splitfileSegmentDataBlocks;
                segSize = (this.totalDataBlocks + segs - 1) / segs;
            }
            this.segmentSize = segSize;
            if (this.cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || this.cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
                int lastSegmentSize = this.totalDataBlocks - this.segmentSize * (segs - 1);
                this.deductBlocksFromSegments = this.segmentSize - lastSegmentSize;
            } else {
                this.deductBlocksFromSegments = 0;
            }
        }
        int crossCheckBlocks = 0;
        if (segs >= 20 && (this.cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || this.cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal())) {
            crossCheckBlocks = 3;
        }
        this.crossCheckBlocks = crossCheckBlocks;
        this.splitfileType = ctx.getSplitfileAlgorithm();
        this.codec = FECCodec.getInstance(this.splitfileType);
        this.checkSegmentSize = this.codec.getCheckBlocks(this.segmentSize + crossCheckBlocks, this.cmode);
        this.splitfileCryptoAlgorithm = splitfileCryptoAlgorithm;
        if (splitfileCryptoKey != null) {
            this.splitfileCryptoKey = splitfileCryptoKey;
            this.specifySplitfileKeyInMetadata = true;
        } else if (this.cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || this.cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
            this.splitfileCryptoKey = hashThisLayerOnly != null ? Metadata.getCryptoKey(hashThisLayerOnly) : Metadata.getCryptoKey(hashes);
            this.specifySplitfileKeyInMetadata = false;
        } else {
            this.splitfileCryptoKey = null;
            this.specifySplitfileKeyInMetadata = false;
        }
        int totalCheckBlocks = 0;
        int checkTotalDataBlocks = 0;
        this.underlyingOffsetDataSegments = new long[segs];
        this.keyLength = SplitFileInserterSegmentStorage.getKeyLength(this);
        this.consecutiveRNFsCountAsSuccess = ctx.consecutiveRNFsCountAsSuccess;
        this.segments = this.makeSegments(this.segmentSize, segs, this.totalDataBlocks, crossCheckBlocks, this.deductBlocksFromSegments, persistent, this.cmode, random, keysFetching, this.consecutiveRNFsCountAsSuccess);
        this.randomSegmentIterator = new RandomArrayIterator<SplitFileInserterSegmentStorage>(this.segments);
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            totalCheckBlocks += segment.checkBlockCount;
            checkTotalDataBlocks += segment.dataBlockCount;
        }
        assert (checkTotalDataBlocks == this.totalDataBlocks);
        this.totalCheckBlocks = totalCheckBlocks;
        if (crossCheckBlocks != 0) {
            byte[] seed = Metadata.getCrossSegmentSeed(hashes, hashThisLayerOnly);
            if (logMINOR) {
                Logger.minor(this, "Cross-segment seed: " + HexUtil.bytesToHex(seed));
            }
            MersenneTwister xsRandom = new MersenneTwister(seed);
            this.crossSegments = new SplitFileInserterCrossSegmentStorage[segs];
            int segLen = this.segmentSize;
            for (int i2 = 0; i2 < this.crossSegments.length; ++i2) {
                int j;
                SplitFileInserterCrossSegmentStorage seg;
                if (logMINOR) {
                    Logger.minor(this, "Allocating blocks for cross segment " + i2);
                }
                if (this.segments.length - i2 == this.deductBlocksFromSegments) {
                    --segLen;
                }
                this.crossSegments[i2] = seg = new SplitFileInserterCrossSegmentStorage(this, i2, persistent, segLen, crossCheckBlocks);
                for (j = 0; j < segLen; ++j) {
                    this.allocateCrossDataBlock(seg, (Random)((Object)xsRandom));
                }
                for (j = 0; j < crossCheckBlocks; ++j) {
                    this.allocateCrossCheckBlock(seg, (Random)((Object)xsRandom));
                }
            }
        } else {
            this.crossSegments = null;
        }
        if (this.crossSegments != null) {
            this.offsetCrossSegmentBlocks = new long[this.crossSegments.length];
            this.offsetCrossSegmentStatus = (long[])(persistent ? new long[this.crossSegments.length] : null);
        } else {
            this.offsetCrossSegmentBlocks = null;
            this.offsetCrossSegmentStatus = null;
        }
        this.offsetSegmentCheckBlocks = new long[this.segments.length];
        this.offsetSegmentKeys = new long[this.segments.length];
        this.offsetSegmentStatus = (long[])(persistent ? new long[this.segments.length] : null);
        byte[] paddedLastBlock = null;
        if (this.dataLength % 32768L != 0L) {
            this.hasPaddedLastBlock = true;
            long from = this.dataLength / 32768L * 32768L;
            byte[] buf = new byte[(int)(this.dataLength - from)];
            this.originalData.pread(from, buf, 0, buf.length);
            paddedLastBlock = BucketTools.pad(buf, 32768, buf.length);
        } else {
            this.hasPaddedLastBlock = false;
        }
        byte[] header = null;
        Bucket segmentSettings = null;
        Bucket crossSegmentSettings = null;
        int offsetsLength = 0;
        if (persistent) {
            header = this.encodeHeader();
            offsetsLength = this.encodeOffsets().length;
            segmentSettings = this.encodeSegmentSettings();
            try {
                crossSegmentSettings = this.encodeCrossSegmentSettings(bf);
            }
            catch (IOException e) {
                throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, "Failed to write to temporary storage while creating splitfile inserter", null);
            }
        }
        long ptr = 0L;
        if (persistent) {
            this.offsetOverallStatus = ptr = (long)(header.length + offsetsLength) + segmentSettings.size() + (crossSegmentSettings == null ? 0L : crossSegmentSettings.size());
            this.overallStatusLength = this.encodeOverallStatus().length;
            int padding = 0;
            padding = (int)((ptr += (long)this.overallStatusLength) % 4096L);
            if (padding != 0) {
                padding = 4096 - padding;
            }
            ptr += (long)padding;
        } else {
            this.overallStatusLength = 0;
            this.offsetOverallStatus = 0L;
        }
        this.offsetPaddedLastBlock = ptr;
        if (this.hasPaddedLastBlock) {
            ptr += 32768L;
        }
        if (this.crossSegments != null) {
            for (i = 0; i < this.crossSegments.length; ++i) {
                this.offsetCrossSegmentBlocks[i] = ptr;
                ptr += (long)(this.crossSegments[i].crossCheckBlockCount * 32768);
            }
        }
        for (i = 0; i < this.segments.length; ++i) {
            this.offsetSegmentCheckBlocks[i] = ptr;
            ptr += (long)(this.segments[i].checkBlockCount * 32768);
        }
        if (persistent) {
            for (i = 0; i < this.segments.length; ++i) {
                this.offsetSegmentStatus[i] = ptr;
                ptr += this.segments[i].storedStatusLength();
            }
            if (this.crossSegments != null) {
                for (i = 0; i < this.crossSegments.length; ++i) {
                    this.offsetCrossSegmentStatus[i] = ptr;
                    ptr += this.crossSegments[i].storedStatusLength();
                }
            }
        }
        for (i = 0; i < this.segments.length; ++i) {
            this.offsetSegmentKeys[i] = ptr;
            ptr += (long)this.segments[i].storedKeysLength();
        }
        this.rafLength = ptr;
        this.raf = rafFactory.makeRAF(ptr);
        if (persistent) {
            ptr = 0L;
            this.raf.pwrite(ptr, header, 0, header.length);
            ptr += (long)header.length;
            byte[] encodedOffsets = this.encodeOffsets();
            assert (encodedOffsets.length == offsetsLength);
            this.raf.pwrite(ptr, encodedOffsets, 0, encodedOffsets.length);
            BucketTools.copyTo(segmentSettings, this.raf, ptr += (long)encodedOffsets.length, Long.MAX_VALUE);
            ptr += segmentSettings.size();
            segmentSettings.free();
            if (crossSegmentSettings != null) {
                BucketTools.copyTo(crossSegmentSettings, this.raf, ptr, Long.MAX_VALUE);
                ptr += crossSegmentSettings.size();
                crossSegmentSettings.free();
            }
            this.writeOverallStatus(true);
        }
        if (this.hasPaddedLastBlock) {
            this.raf.pwrite(this.offsetPaddedLastBlock, paddedLastBlock, 0, paddedLastBlock.length);
        }
        if (persistent) {
            for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : this.segments) {
                if (logMINOR) {
                    Logger.minor(this, "Clearing status for " + splitFileInserterSegmentStorage);
                }
                splitFileInserterSegmentStorage.storeStatus(true);
            }
            if (this.crossSegments != null) {
                for (SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage : this.crossSegments) {
                    if (logMINOR) {
                        Logger.minor(this, "Clearing status for " + splitFileInserterCrossSegmentStorage);
                    }
                    splitFileInserterCrossSegmentStorage.storeStatus();
                }
            }
        }
        for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : this.segments) {
            splitFileInserterSegmentStorage.clearKeys();
        }
        this.status = Status.NOT_STARTED;
        int totalCrossCheckBlocks = crossCheckBlocks * this.segments.length;
        this.topRequiredBlocks = topRequiredBlocks + this.totalDataBlocks + totalCrossCheckBlocks;
        this.topTotalBlocks = topTotalBlocks + this.totalDataBlocks + totalCrossCheckBlocks + totalCheckBlocks;
    }

    public SplitFileInserterStorage(LockableRandomAccessBuffer raf, LockableRandomAccessBuffer originalData, SplitFileInserterStorageCallback callback, Random random, MemoryLimitedJobRunner memoryLimitedJobRunner, PersistentJobRunner jobRunner, Ticker ticker, KeysFetchingLocally keysFetching, FilenameGenerator persistentFG, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ChecksumFailedException, ResumeFailedException {
        int i;
        int i2;
        this.persistent = true;
        this.callback = callback;
        this.ticker = ticker;
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        this.jobRunner = jobRunner;
        this.random = random;
        this.raf = raf;
        this.rafLength = raf.size();
        RAFInputStream ois = new RAFInputStream(raf, 0L, this.rafLength);
        DataInputStream dis = new DataInputStream(ois);
        long magic = dis.readLong();
        if (magic != 5560326343234641381L) {
            throw new StorageFormatException("Bad magic");
        }
        int checksumType = dis.readInt();
        try {
            this.checker = ChecksumChecker.create(checksumType);
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad checksum type");
        }
        InputStream is = this.checker.checksumReaderWithLength(ois, new ArrayBucketFactory(), 0x100000L);
        dis = new DataInputStream(is);
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        LockableRandomAccessBuffer rafOrig = BucketTools.restoreRAFFrom(dis, persistentFG, persistentFileTracker, masterKey);
        if (originalData == null) {
            this.originalData = rafOrig;
        } else {
            if (!originalData.equals(rafOrig)) {
                throw new StorageFormatException("Original data restored from different filename! Expected " + originalData + " but restored " + rafOrig);
            }
            this.originalData = originalData;
        }
        this.totalDataBlocks = dis.readInt();
        if (this.totalDataBlocks <= 0) {
            throw new StorageFormatException("Bad total data blocks " + this.totalDataBlocks);
        }
        this.totalCheckBlocks = dis.readInt();
        if (this.totalCheckBlocks <= 0) {
            throw new StorageFormatException("Bad total data blocks " + this.totalCheckBlocks);
        }
        try {
            this.splitfileType = Metadata.SplitfileAlgorithm.getByCode(dis.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad splitfile type");
        }
        try {
            this.codec = FECCodec.getInstance(this.splitfileType);
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad splitfile codec type");
        }
        this.dataLength = dis.readLong();
        if (this.dataLength <= 0L) {
            throw new StorageFormatException("Bad data length");
        }
        if (this.dataLength != originalData.size()) {
            throw new ResumeFailedException("Original data size is " + originalData.size() + " should be " + this.dataLength);
        }
        if ((this.dataLength + 32768L - 1L) / 32768L != (long)this.totalDataBlocks) {
            throw new StorageFormatException("Data blocks " + this.totalDataBlocks + " not compatible with size " + this.dataLength);
        }
        this.decompressedLength = dis.readLong();
        if (this.decompressedLength <= 0L) {
            throw new StorageFormatException("Bogus decompressed length");
        }
        this.isMetadata = dis.readBoolean();
        short atype = dis.readShort();
        if (atype == -1) {
            this.archiveType = null;
        } else {
            this.archiveType = ArchiveManager.ARCHIVE_TYPE.getArchiveType(atype);
            if (this.archiveType == null) {
                throw new StorageFormatException("Unknown archive type " + atype);
            }
        }
        try {
            this.clientMetadata = ClientMetadata.construct(dis);
        }
        catch (MetadataParseException e) {
            throw new StorageFormatException("Failed to read MIME type: " + e);
        }
        short codec = dis.readShort();
        if (codec == -1) {
            this.compressionCodec = null;
        } else {
            this.compressionCodec = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(codec);
            if (this.compressionCodec == null) {
                throw new StorageFormatException("Unknown compression codec ID " + codec);
            }
        }
        int segmentCount = dis.readInt();
        if (segmentCount <= 0) {
            throw new StorageFormatException("Bad segment count");
        }
        this.segmentSize = dis.readInt();
        if (this.segmentSize <= 0) {
            throw new StorageFormatException("Bad segment size");
        }
        this.checkSegmentSize = dis.readInt();
        if (this.checkSegmentSize <= 0) {
            throw new StorageFormatException("Bad check segment size");
        }
        this.crossCheckBlocks = dis.readInt();
        if (this.crossCheckBlocks < 0) {
            throw new StorageFormatException("Bad cross-check block count");
        }
        if (this.segmentSize + this.checkSegmentSize + this.crossCheckBlocks > 256) {
            throw new StorageFormatException("Must be no more than 256 blocks per segment");
        }
        this.splitfileCryptoAlgorithm = dis.readByte();
        if (!Metadata.isValidSplitfileCryptoAlgorithm(this.splitfileCryptoAlgorithm)) {
            throw new StorageFormatException("Invalid splitfile crypto algorithm " + this.splitfileCryptoAlgorithm);
        }
        if (dis.readBoolean()) {
            this.splitfileCryptoKey = new byte[32];
            dis.readFully(this.splitfileCryptoKey);
        } else {
            this.splitfileCryptoKey = null;
        }
        this.keyLength = dis.readInt();
        if (this.keyLength < SplitFileInserterSegmentStorage.getKeyLength(this)) {
            throw new StorageFormatException("Invalid key length " + this.keyLength + " should be at least " + SplitFileInserterSegmentStorage.getKeyLength(this));
        }
        int compatMode = dis.readInt();
        if (compatMode < 0 || compatMode > InsertContext.CompatibilityMode.values().length) {
            throw new StorageFormatException("Invalid compatibility mode " + compatMode);
        }
        this.cmode = InsertContext.CompatibilityMode.values()[compatMode];
        this.deductBlocksFromSegments = dis.readInt();
        if (this.deductBlocksFromSegments < 0 || this.deductBlocksFromSegments > segmentCount) {
            throw new StorageFormatException("Bad deductBlocksFromSegments");
        }
        this.maxRetries = dis.readInt();
        if (this.maxRetries < -1) {
            throw new StorageFormatException("Bad maxRetries");
        }
        this.consecutiveRNFsCountAsSuccess = dis.readInt();
        if (this.consecutiveRNFsCountAsSuccess < 0) {
            throw new StorageFormatException("Bad consecutiveRNFsCountAsSuccess");
        }
        this.specifySplitfileKeyInMetadata = dis.readBoolean();
        if (dis.readBoolean()) {
            this.hashThisLayerOnly = new byte[32];
            dis.readFully(this.hashThisLayerOnly);
        } else {
            this.hashThisLayerOnly = null;
        }
        this.topDontCompress = dis.readBoolean();
        this.topRequiredBlocks = dis.readInt();
        this.topTotalBlocks = dis.readInt();
        this.origDataSize = dis.readLong();
        this.origCompressedDataSize = dis.readLong();
        this.hashes = HashResult.readHashes(dis);
        dis.close();
        this.hasPaddedLastBlock = this.dataLength % 32768L != 0L;
        this.segments = new SplitFileInserterSegmentStorage[segmentCount];
        this.randomSegmentIterator = new RandomArrayIterator<SplitFileInserterSegmentStorage>(this.segments);
        this.crossSegments = this.crossCheckBlocks != 0 ? new SplitFileInserterCrossSegmentStorage[segmentCount] : null;
        is = this.checker.checksumReaderWithLength(ois, new ArrayBucketFactory(), 0x100000L);
        dis = new DataInputStream(is);
        this.offsetPaddedLastBlock = this.hasPaddedLastBlock ? this.readOffset(dis, this.rafLength, "offsetPaddedLastBlock") : 0L;
        this.offsetOverallStatus = this.readOffset(dis, this.rafLength, "offsetOverallStatus");
        this.overallStatusLength = dis.readInt();
        if (this.overallStatusLength < 0) {
            throw new StorageFormatException("Negative overall status length");
        }
        if (this.overallStatusLength < FailureCodeTracker.getFixedLength(true)) {
            throw new StorageFormatException("Bad overall status length");
        }
        if (this.crossSegments != null) {
            this.offsetCrossSegmentBlocks = new long[this.crossSegments.length];
            for (int i22 = 0; i22 < this.crossSegments.length; ++i22) {
                this.offsetCrossSegmentBlocks[i22] = this.readOffset(dis, this.rafLength, "cross-segment block offset");
            }
        } else {
            this.offsetCrossSegmentBlocks = null;
        }
        this.offsetSegmentCheckBlocks = new long[segmentCount];
        for (i2 = 0; i2 < segmentCount; ++i2) {
            this.offsetSegmentCheckBlocks[i2] = this.readOffset(dis, this.rafLength, "segment check block offset");
        }
        this.offsetSegmentStatus = new long[segmentCount];
        for (i2 = 0; i2 < segmentCount; ++i2) {
            this.offsetSegmentStatus[i2] = this.readOffset(dis, this.rafLength, "segment status offset");
        }
        if (this.crossSegments != null) {
            this.offsetCrossSegmentStatus = new long[this.crossSegments.length];
            for (i2 = 0; i2 < this.crossSegments.length; ++i2) {
                this.offsetCrossSegmentStatus[i2] = this.readOffset(dis, this.rafLength, "cross-segment status offset");
            }
        } else {
            this.offsetCrossSegmentStatus = null;
        }
        this.offsetSegmentKeys = new long[segmentCount];
        for (i2 = 0; i2 < segmentCount; ++i2) {
            this.offsetSegmentKeys[i2] = this.readOffset(dis, this.rafLength, "segment keys offset");
        }
        dis.close();
        this.underlyingOffsetDataSegments = new long[segmentCount];
        is = this.checker.checksumReaderWithLength(ois, new ArrayBucketFactory(), 0x100000L);
        dis = new DataInputStream(is);
        long blocks = 0L;
        for (i = 0; i < segmentCount; ++i) {
            this.segments[i] = new SplitFileInserterSegmentStorage(this, dis, i, this.keyLength, this.splitfileCryptoAlgorithm, this.splitfileCryptoKey, random, this.maxRetries, this.consecutiveRNFsCountAsSuccess, keysFetching);
            this.underlyingOffsetDataSegments[i] = blocks * 32768L;
            blocks += (long)this.segments[i].dataBlockCount;
            assert (this.underlyingOffsetDataSegments[i] < this.dataLength);
        }
        dis.close();
        if (blocks != (long)this.totalDataBlocks) {
            throw new StorageFormatException("Total data blocks should be " + this.totalDataBlocks + " but is " + blocks);
        }
        if (this.crossSegments != null) {
            is = this.checker.checksumReaderWithLength(ois, new ArrayBucketFactory(), 0x100000L);
            dis = new DataInputStream(is);
            for (i = 0; i < this.crossSegments.length; ++i) {
                this.crossSegments[i] = new SplitFileInserterCrossSegmentStorage(this, dis, i);
            }
            dis.close();
        }
        ois.close();
        ois = new RAFInputStream(raf, this.offsetOverallStatus, this.rafLength - this.offsetOverallStatus);
        dis = new DataInputStream(this.checker.checksumReaderWithLength(ois, new ArrayBucketFactory(), 0x100000L));
        this.errors = new FailureCodeTracker(true, dis);
        dis.close();
        for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : this.segments) {
            splitFileInserterSegmentStorage.readStatus();
        }
        if (this.crossSegments != null) {
            for (SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage : this.crossSegments) {
                splitFileInserterCrossSegmentStorage.readStatus();
            }
        }
        this.computeStatus();
    }

    private void computeStatus() {
        this.status = Status.STARTED;
        if (this.crossSegments != null) {
            for (SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage : this.crossSegments) {
                if (splitFileInserterCrossSegmentStorage.isFinishedEncoding()) continue;
                return;
            }
            this.status = Status.ENCODED_CROSS_SEGMENTS;
        }
        for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : this.segments) {
            if (splitFileInserterSegmentStorage.isFinishedEncoding()) continue;
            return;
        }
        this.status = Status.ENCODED;
    }

    private long readOffset(DataInputStream dis, long rafLength, String error) throws IOException, StorageFormatException {
        long l = dis.readLong();
        if (l < 0L) {
            throw new StorageFormatException("Negative " + error);
        }
        if (l > rafLength) {
            throw new StorageFormatException("Too big " + error);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOverallStatus(boolean force) throws IOException {
        byte[] buf;
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (!this.persistent) {
                return;
            }
            if (!force && !this.overallStatusDirty) {
                return;
            }
            buf = this.encodeOverallStatus();
            assert (buf.length == this.overallStatusLength);
        }
        this.raf.pwrite(this.offsetOverallStatus, buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encodeOverallStatus() {
        ArrayBucket bucket = new ArrayBucket();
        try {
            OutputStream os = bucket.getOutputStream();
            PrependLengthOutputStream cos = this.checker.checksumWriterWithLength(os, new ArrayBucketFactory());
            DataOutputStream dos = new DataOutputStream(cos);
            SplitFileInserterStorage splitFileInserterStorage = this;
            synchronized (splitFileInserterStorage) {
                this.errors.writeFixedLengthTo(dos);
                this.overallStatusDirty = false;
            }
            dos.close();
            os.close();
            return bucket.toByteArray();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private Bucket encodeSegmentSettings() {
        ArrayBucket bucket = new ArrayBucket();
        try {
            OutputStream os = bucket.getOutputStream();
            PrependLengthOutputStream cos = this.checker.checksumWriterWithLength(os, new ArrayBucketFactory());
            DataOutputStream dos = new DataOutputStream(cos);
            for (SplitFileInserterSegmentStorage segment : this.segments) {
                segment.writeFixedSettings(dos);
            }
            dos.close();
            os.close();
            return bucket;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private Bucket encodeCrossSegmentSettings(BucketFactory bf) throws IOException {
        if (this.crossSegments == null) {
            return new NullBucket();
        }
        RandomAccessBucket bucket = bf.makeBucket(-1L);
        OutputStream os = bucket.getOutputStream();
        PrependLengthOutputStream cos = this.checker.checksumWriterWithLength(os, new ArrayBucketFactory());
        DataOutputStream dos = new DataOutputStream(cos);
        for (SplitFileInserterCrossSegmentStorage segment : this.crossSegments) {
            segment.writeFixedSettings(dos);
        }
        dos.close();
        os.close();
        return bucket;
    }

    private byte[] encodeHeader() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(5560326343234641381L);
            dos.writeInt(this.checker.getChecksumTypeID());
            PrependLengthOutputStream os = this.checker.checksumWriterWithLength(baos, new ArrayBucketFactory());
            dos = new DataOutputStream(os);
            dos.writeInt(1);
            this.originalData.storeTo(dos);
            dos.writeInt(this.totalDataBlocks);
            dos.writeInt(this.totalCheckBlocks);
            dos.writeShort(this.splitfileType.code);
            dos.writeLong(this.dataLength);
            dos.writeLong(this.decompressedLength);
            dos.writeBoolean(this.isMetadata);
            if (this.archiveType == null) {
                dos.writeShort(-1);
            } else {
                dos.writeShort(this.archiveType.metadataID);
            }
            this.clientMetadata.writeTo(dos);
            if (this.compressionCodec == null) {
                dos.writeShort(-1);
            } else {
                dos.writeShort(this.compressionCodec.metadataID);
            }
            dos.writeInt(this.segments.length);
            dos.writeInt(this.segmentSize);
            dos.writeInt(this.checkSegmentSize);
            dos.writeInt(this.crossCheckBlocks);
            dos.writeByte(this.splitfileCryptoAlgorithm);
            dos.writeBoolean(this.splitfileCryptoKey != null);
            if (this.splitfileCryptoKey != null) {
                assert (this.splitfileCryptoKey.length == 32);
                dos.write(this.splitfileCryptoKey);
            }
            dos.writeInt(this.keyLength);
            dos.writeInt(this.cmode.ordinal());
            dos.writeInt(this.deductBlocksFromSegments);
            dos.writeInt(this.maxRetries);
            dos.writeInt(this.consecutiveRNFsCountAsSuccess);
            dos.writeBoolean(this.specifySplitfileKeyInMetadata);
            dos.writeBoolean(this.hashThisLayerOnly != null);
            if (this.hashThisLayerOnly != null) {
                assert (this.hashThisLayerOnly.length == 32);
                dos.write(this.hashThisLayerOnly);
            }
            dos.writeBoolean(this.topDontCompress);
            dos.writeInt(this.topRequiredBlocks);
            dos.writeInt(this.topTotalBlocks);
            dos.writeLong(this.origDataSize);
            dos.writeLong(this.origCompressedDataSize);
            HashResult.write(this.hashes, dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private byte[] encodeOffsets() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PrependLengthOutputStream os = this.checker.checksumWriterWithLength(baos, new ArrayBucketFactory());
            DataOutputStream dos = new DataOutputStream(os);
            if (this.hasPaddedLastBlock) {
                dos.writeLong(this.offsetPaddedLastBlock);
            }
            dos.writeLong(this.offsetOverallStatus);
            dos.writeInt(this.overallStatusLength);
            if (this.crossSegments != null) {
                for (long l : this.offsetCrossSegmentBlocks) {
                    dos.writeLong(l);
                }
            }
            for (long l : this.offsetSegmentCheckBlocks) {
                dos.writeLong(l);
            }
            for (long l : this.offsetSegmentStatus) {
                dos.writeLong(l);
            }
            if (this.crossSegments != null) {
                for (long l : this.offsetCrossSegmentStatus) {
                    dos.writeLong(l);
                }
            }
            for (long l : this.offsetSegmentKeys) {
                dos.writeLong(l);
            }
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void allocateCrossDataBlock(SplitFileInserterCrossSegmentStorage segment, Random xsRandom) {
        int blockNum;
        SplitFileInserterSegmentStorage seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = xsRandom.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossDataBlock(segment, xsRandom);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossDataBlock(segment, xsRandom)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private void allocateCrossCheckBlock(SplitFileInserterCrossSegmentStorage segment, Random xsRandom) {
        int blockNum;
        SplitFileInserterSegmentStorage seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = xsRandom.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossCheckBlock(segment, xsRandom, segment.getAllocatedCrossCheckBlocks());
            if (blockNum < 0) continue;
            segment.addCheckBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossCheckBlock(segment, xsRandom, segment.getAllocatedCrossCheckBlocks())) < 0) continue;
            segment.addCheckBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private SplitFileInserterSegmentStorage[] makeSegments(int segmentSize, int segCount, int dataBlocks, int crossCheckBlocks, int deductBlocksFromSegments, boolean persistent, InsertContext.CompatibilityMode cmode, Random random, KeysFetchingLocally keysFetching, int consecutiveRNFsCountAsSuccess) {
        SplitFileInserterSegmentStorage[] segments = new SplitFileInserterSegmentStorage[segCount];
        if (segCount == 1) {
            int checkBlocks = this.codec.getCheckBlocks(dataBlocks + crossCheckBlocks, cmode);
            segments[0] = new SplitFileInserterSegmentStorage(this, 0, persistent, dataBlocks, checkBlocks, crossCheckBlocks, this.keyLength, this.splitfileCryptoAlgorithm, this.splitfileCryptoKey, random, this.maxRetries, consecutiveRNFsCountAsSuccess, keysFetching);
        } else {
            int j = 0;
            int segNo = 0;
            int data = segmentSize;
            int check = this.codec.getCheckBlocks(data + crossCheckBlocks, cmode);
            int i = segmentSize;
            while (true) {
                this.underlyingOffsetDataSegments[segNo] = (long)j * 32768L;
                if (i > dataBlocks) {
                    i = dataBlocks;
                }
                if (data > i - j) {
                    assert (segNo == segCount - 1);
                    data = i - j;
                    check = this.codec.getCheckBlocks(data + crossCheckBlocks, cmode);
                }
                j = i;
                segments[segNo] = new SplitFileInserterSegmentStorage(this, segNo, persistent, data, check, crossCheckBlocks, this.keyLength, this.splitfileCryptoAlgorithm, this.splitfileCryptoKey, random, this.maxRetries, consecutiveRNFsCountAsSuccess, keysFetching);
                if (deductBlocksFromSegments != 0 && logMINOR) {
                    Logger.minor(this, "INSERTING: Segment " + segNo + " of " + segCount + " : " + data + " data blocks " + check + " check blocks");
                }
                ++segNo;
                if (i == dataBlocks) break;
                if (segCount - segNo == deductBlocksFromSegments) {
                    --data;
                }
                i += data;
            }
            assert (segNo == segCount);
        }
        return segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean startSegments = this.crossSegments == null;
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (this.status == Status.NOT_STARTED) {
                this.status = Status.STARTED;
            }
            if (this.status == Status.ENCODED_CROSS_SEGMENTS) {
                startSegments = true;
            }
            if (this.status == Status.ENCODED) {
                return;
            }
            if (this.status == Status.FAILED || this.status == Status.GENERATING_METADATA || this.status == Status.SUCCEEDED) {
                return;
            }
        }
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            segment.checkKeys();
        }
        Logger.normal(this, "Starting splitfile, " + this.countEncodedSegments() + "/" + this.segments.length + " segments encoded on " + this);
        if (this.crossSegments != null) {
            Logger.normal(this, "Starting splitfile, " + this.countEncodedCrossSegments() + "/" + this.crossSegments.length + " cross-segments encoded on " + this);
        }
        if (startSegments) {
            this.startSegmentEncode();
        } else {
            this.startCrossSegmentEncode();
        }
    }

    public int countEncodedSegments() {
        int total = 0;
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            if (!segment.hasEncoded()) continue;
            ++total;
        }
        return total;
    }

    public int countEncodedCrossSegments() {
        int total = 0;
        for (SplitFileInserterCrossSegmentStorage segment : this.crossSegments) {
            if (!segment.isFinishedEncoding()) continue;
            ++total;
        }
        return total;
    }

    private void startSegmentEncode() {
        short prio = this.callback.getPriorityClass();
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            segment.startEncode(prio);
        }
    }

    private void startCrossSegmentEncode() {
        short prio = this.callback.getPriorityClass();
        for (SplitFileInserterCrossSegmentStorage segment : this.crossSegments) {
            segment.startEncode(prio);
        }
    }

    public void onFinishedEncoding(SplitFileInserterCrossSegmentStorage completed) {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                Object object = SplitFileInserterStorage.this.cooldownLock;
                synchronized (object) {
                    SplitFileInserterStorage.this.noBlocksToSend = false;
                }
                SplitFileInserterStorage.this.callback.encodingProgress();
                if (SplitFileInserterStorage.this.maybeFail()) {
                    return true;
                }
                if (SplitFileInserterStorage.this.allFinishedCrossEncoding()) {
                    SplitFileInserterStorage.this.onCompletedCrossSegmentEncode();
                }
                return false;
            }
        });
    }

    private boolean allFinishedCrossEncoding() {
        for (SplitFileInserterCrossSegmentStorage segment : this.crossSegments) {
            if (segment.isFinishedEncoding()) continue;
            return false;
        }
        return true;
    }

    public void onFinishedEncoding(final SplitFileInserterSegmentStorage completed) {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                Object object = SplitFileInserterStorage.this.cooldownLock;
                synchronized (object) {
                    SplitFileInserterStorage.this.noBlocksToSend = false;
                }
                completed.storeStatus(true);
                SplitFileInserterStorage.this.callback.encodingProgress();
                if (SplitFileInserterStorage.this.maybeFail()) {
                    return true;
                }
                if (SplitFileInserterStorage.this.allFinishedEncoding()) {
                    SplitFileInserterStorage.this.onCompletedSegmentEncode();
                }
                return false;
            }
        });
    }

    private boolean allFinishedEncoding() {
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            if (segment.isFinishedEncoding()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletedCrossSegmentEncode() {
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (this.status == Status.ENCODED_CROSS_SEGMENTS) {
                return;
            }
            if (this.status != Status.STARTED) {
                Logger.error(this, "Wrong state " + (Object)((Object)this.status) + " for " + this, (Throwable)new Exception("error"));
                return;
            }
            this.status = Status.ENCODED_CROSS_SEGMENTS;
        }
        this.startSegmentEncode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletedSegmentEncode() {
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (this.status == Status.ENCODED) {
                return;
            }
            if (this.status != Status.ENCODED_CROSS_SEGMENTS && (this.crossSegments != null || this.status != Status.STARTED)) {
                Logger.error(this, "Wrong state " + (Object)((Object)this.status) + " for " + this, (Throwable)new Exception("error"));
                return;
            }
            this.status = Status.ENCODED;
        }
        this.callback.onFinishedEncode();
    }

    public void onHasKeys(SplitFileInserterSegmentStorage splitFileInserterSegmentStorage) {
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            if (segment.hasKeys()) continue;
            return;
        }
        this.onHasKeys();
    }

    private void onHasKeys() {
        this.callback.onHasKeys();
    }

    OutputStream writeChecksummedTo(final long fileOffset, final int length) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        OutputStream cos = this.checker.checksumWriter(baos);
        return new FilterOutputStream(cos){

            @Override
            public void close() throws IOException {
                this.out.close();
                byte[] buf = baos.toByteArray();
                if (buf.length != length) {
                    throw new IllegalStateException("Wrote wrong number of bytes: " + buf.length + " should be " + length);
                }
                SplitFileInserterStorage.this.raf.pwrite(fileOffset, buf, 0, length);
            }
        };
    }

    long segmentStatusOffset(int segNo) {
        return this.offsetSegmentStatus[segNo];
    }

    long crossSegmentStatusOffset(int segNo) {
        return this.offsetCrossSegmentStatus[segNo];
    }

    public boolean hasSplitfileKey() {
        return this.splitfileCryptoKey != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckBlock(int segNo, int checkBlockNo, byte[] buf) throws IOException {
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (this.status == Status.ENCODED || this.status == Status.ENCODED_CROSS_SEGMENTS) {
                throw new IllegalStateException("Already encoded!?");
            }
        }
        assert (segNo >= 0 && segNo < this.crossSegments.length);
        assert (checkBlockNo >= 0 && checkBlockNo < this.crossCheckBlocks);
        assert (buf.length == 32768);
        long offset = this.offsetCrossSegmentBlocks[segNo] + (long)(checkBlockNo * 32768);
        this.raf.pwrite(offset, buf, 0, buf.length);
    }

    public byte[] readCheckBlock(int segNo, int checkBlockNo) throws IOException {
        assert (segNo >= 0 && segNo < this.crossSegments.length);
        assert (checkBlockNo >= 0 && checkBlockNo < this.crossCheckBlocks);
        long offset = this.offsetCrossSegmentBlocks[segNo] + (long)(checkBlockNo * 32768);
        byte[] buf = new byte[32768];
        this.raf.pread(offset, buf, 0, buf.length);
        return buf;
    }

    LockableRandomAccessBuffer.RAFLock lockRAF() throws IOException {
        return this.raf.lockOpen();
    }

    LockableRandomAccessBuffer.RAFLock lockUnderlying() throws IOException {
        return this.originalData.lockOpen();
    }

    public byte[] readSegmentDataBlock(int segNo, int blockNo) throws IOException {
        assert (segNo >= 0 && segNo < this.segments.length);
        assert (blockNo >= 0 && blockNo < this.segments[segNo].dataBlockCount);
        byte[] buf = new byte[32768];
        if (this.hasPaddedLastBlock && segNo == this.segments.length - 1 && blockNo == this.segments[segNo].dataBlockCount - 1) {
            this.raf.pread(this.offsetPaddedLastBlock, buf, 0, buf.length);
            return buf;
        }
        long offset = this.underlyingOffsetDataSegments[segNo] + (long)(blockNo * 32768);
        assert (offset < this.dataLength);
        assert (offset + (long)buf.length <= this.dataLength);
        this.originalData.pread(offset, buf, 0, buf.length);
        return buf;
    }

    public void writeSegmentCheckBlock(int segNo, int checkBlockNo, byte[] buf) throws IOException {
        assert (segNo >= 0 && segNo < this.segments.length);
        assert (checkBlockNo >= 0 && checkBlockNo < this.segments[segNo].checkBlockCount);
        assert (buf.length == 32768);
        long offset = this.offsetSegmentCheckBlocks[segNo] + (long)(checkBlockNo * 32768);
        this.raf.pwrite(offset, buf, 0, buf.length);
    }

    public byte[] readSegmentCheckBlock(int segNo, int checkBlockNo) throws IOException {
        assert (segNo >= 0 && segNo < this.segments.length);
        assert (checkBlockNo >= 0 && checkBlockNo < this.segments[segNo].checkBlockCount);
        byte[] buf = new byte[32768];
        long offset = this.offsetSegmentCheckBlocks[segNo] + (long)(checkBlockNo * 32768);
        this.raf.pread(offset, buf, 0, buf.length);
        return buf;
    }

    Metadata encodeMetadata() throws IOException, SplitFileInserterSegmentStorage.MissingKeyException {
        ClientCHK[] dataKeys = new ClientCHK[this.totalDataBlocks + this.crossCheckBlocks * this.segments.length];
        ClientCHK[] checkKeys = new ClientCHK[this.totalCheckBlocks];
        int dataPtr = 0;
        int checkPtr = 0;
        for (int segNo = 0; segNo < this.segments.length; ++segNo) {
            int i;
            SplitFileInserterSegmentStorage segment = this.segments[segNo];
            for (i = 0; i < segment.dataBlockCount + segment.crossCheckBlockCount; ++i) {
                dataKeys[dataPtr++] = segment.readKey(i);
            }
            for (i = 0; i < segment.checkBlockCount; ++i) {
                checkKeys[checkPtr++] = segment.readKey(i + segment.dataBlockCount + segment.crossCheckBlockCount);
            }
        }
        assert (dataPtr == dataKeys.length);
        assert (checkPtr == checkKeys.length);
        return new Metadata(this.splitfileType, dataKeys, checkKeys, this.segmentSize, this.checkSegmentSize, this.deductBlocksFromSegments, this.clientMetadata, this.dataLength, this.archiveType, this.compressionCodec, this.decompressedLength, this.isMetadata, this.hashes, this.hashThisLayerOnly, this.origDataSize, this.origCompressedDataSize, this.topRequiredBlocks, this.topTotalBlocks, this.topDontCompress, this.cmode, this.splitfileCryptoAlgorithm, this.splitfileCryptoKey, this.specifySplitfileKeyInMetadata, this.crossCheckBlocks);
    }

    void innerWriteSegmentKey(int segNo, int blockNo, byte[] buf) throws IOException {
        assert (buf.length == SplitFileInserterSegmentStorage.getKeyLength(this));
        assert (segNo >= 0 && segNo < this.segments.length);
        assert (blockNo >= 0 && blockNo < this.segments[segNo].totalBlockCount);
        long fileOffset = this.offsetSegmentKeys[segNo] + (long)(this.keyLength * blockNo);
        if (logDEBUG) {
            Logger.debug(this, "Writing key for block " + blockNo + " for segment " + segNo + " of " + this + " to " + fileOffset);
        }
        this.raf.pwrite(fileOffset, buf, 0, buf.length);
    }

    byte[] innerReadSegmentKey(int segNo, int blockNo) throws IOException {
        byte[] buf = new byte[this.keyLength];
        long fileOffset = this.offsetSegmentKeys[segNo] + (long)(this.keyLength * blockNo);
        if (logDEBUG) {
            Logger.debug(this, "Reading key for block " + blockNo + " for segment " + segNo + " of " + this + " to " + fileOffset);
        }
        this.raf.pread(fileOffset, buf, 0, buf.length);
        return buf;
    }

    public int totalCrossCheckBlocks() {
        return this.segments.length * this.crossCheckBlocks;
    }

    public void segmentSucceeded(final SplitFileInserterSegmentStorage completedSegment) {
        if (logMINOR) {
            Logger.minor(this, "Succeeded segment " + completedSegment + " for " + this.callback);
        }
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                if (logMINOR) {
                    Logger.minor(this, "Succeeding segment " + completedSegment + " for " + SplitFileInserterStorage.this.callback);
                }
                if (SplitFileInserterStorage.this.maybeFail()) {
                    return true;
                }
                if (SplitFileInserterStorage.this.allSegmentsSucceeded()) {
                    4 var2_2 = this;
                    synchronized (var2_2) {
                        assert (SplitFileInserterStorage.this.failing == null);
                        if (SplitFileInserterStorage.this.hasFinished()) {
                            return false;
                        }
                        SplitFileInserterStorage.this.status = Status.GENERATING_METADATA;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Generating metadata...");
                    }
                    try {
                        Metadata metadata = SplitFileInserterStorage.this.encodeMetadata();
                        4 var3_6 = this;
                        synchronized (var3_6) {
                            SplitFileInserterStorage.this.status = Status.SUCCEEDED;
                        }
                        SplitFileInserterStorage.this.callback.onSucceeded(metadata);
                    }
                    catch (IOException e) {
                        InsertException e1 = new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR);
                        4 var4_10 = this;
                        synchronized (var4_10) {
                            SplitFileInserterStorage.this.failing = e1;
                            SplitFileInserterStorage.this.status = Status.FAILED;
                        }
                        SplitFileInserterStorage.this.callback.onFailed(e1);
                    }
                    catch (SplitFileInserterSegmentStorage.MissingKeyException e) {
                        InsertException e1 = new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, "Missing keys", null);
                        4 var4_11 = this;
                        synchronized (var4_11) {
                            SplitFileInserterStorage.this.failing = e1;
                            SplitFileInserterStorage.this.status = Status.FAILED;
                        }
                        SplitFileInserterStorage.this.callback.onFailed(e1);
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Not all segments succeeded for " + this);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeFail() {
        if (this.allSegmentsCompletedOrFailed()) {
            InsertException e = null;
            SplitFileInserterStorage splitFileInserterStorage = this;
            synchronized (splitFileInserterStorage) {
                if (this.failing == null) {
                    return false;
                }
                e = this.failing;
                if (this.hasFinished()) {
                    if (logMINOR) {
                        Logger.minor(this, "Maybe fail returning true because already finished");
                    }
                    return true;
                }
                this.status = Status.FAILED;
            }
            if (logMINOR) {
                Logger.minor(this, "Maybe fail returning true with error " + e);
            }
            this.callback.onFailed(e);
            return true;
        }
        return false;
    }

    private boolean allSegmentsCompletedOrFailed() {
        for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : this.segments) {
            if (splitFileInserterSegmentStorage.hasCompletedOrFailed()) continue;
            return false;
        }
        if (this.crossSegments != null) {
            for (SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage : this.crossSegments) {
                if (splitFileInserterCrossSegmentStorage.hasCompletedOrFailed()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allSegmentsSucceeded() {
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            if (!segment.hasSucceeded()) {
                return false;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Succeeded " + segment);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailure(InsertException e) {
        this.errors.inc(e.getMode());
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            this.overallStatusDirty = true;
            this.lazyWriteMetadata();
        }
    }

    public void failOnDiskError(IOException e) {
        this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null));
    }

    public void failFatalErrorInBlock() {
        this.fail(new InsertException(InsertException.InsertExceptionMode.FATAL_ERRORS_IN_BLOCKS, this.errors, null));
    }

    public void failTooManyRetriesInBlock() {
        this.fail(new InsertException(InsertException.InsertExceptionMode.TOO_MANY_RETRIES_IN_BLOCKS, this.errors, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(final InsertException e) {
        SplitFileInserterStorage splitFileInserterStorage = this;
        synchronized (splitFileInserterStorage) {
            if (this.status == Status.SUCCEEDED || this.status == Status.FAILED || this.status == Status.GENERATING_METADATA) {
                Logger.error(this, "Already finished (" + (Object)((Object)this.status) + ") but failing with " + e + " (" + this + ")", (Throwable)e);
                return;
            }
            if (this.failing != null) {
                return;
            }
            this.failing = e;
        }
        if (e.mode == InsertException.InsertExceptionMode.BUCKET_ERROR || e.mode == InsertException.InsertExceptionMode.INTERNAL_ERROR) {
            Logger.error(this, "Failing: " + e + " for " + this, (Throwable)e);
        } else {
            Logger.normal(this, "Failing: " + e + " for " + this, (Throwable)e);
        }
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                boolean allDone = true;
                for (SplitFileInserterSegmentStorage splitFileInserterSegmentStorage : SplitFileInserterStorage.this.segments) {
                    if (splitFileInserterSegmentStorage.cancel()) continue;
                    allDone = false;
                }
                if (SplitFileInserterStorage.this.crossSegments != null) {
                    for (SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage : SplitFileInserterStorage.this.crossSegments) {
                        if (splitFileInserterCrossSegmentStorage.cancel()) continue;
                        allDone = false;
                    }
                }
                if (allDone) {
                    5 var3_3 = this;
                    synchronized (var3_3) {
                        if (SplitFileInserterStorage.this.hasFinished()) {
                            return false;
                        }
                        SplitFileInserterStorage.this.status = Status.FAILED;
                    }
                    SplitFileInserterStorage.this.callback.onFailed(e);
                    return true;
                }
                return false;
            }
        });
    }

    public synchronized boolean hasFinished() {
        return this.status == Status.SUCCEEDED || this.status == Status.FAILED;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void lazyWriteMetadata() {
        if (!this.persistent) {
            return;
        }
        if (LAZY_WRITE_METADATA_DELAY != 0L) {
            this.ticker.queueTimedJob(this.wrapLazyWriteMetadata, "Write metadata for splitfile", LAZY_WRITE_METADATA_DELAY, false, true);
        } else {
            this.jobRunner.queueNormalOrDrop(this.writeMetadataJob);
        }
    }

    protected synchronized boolean isFinishing() {
        return this.failing != null || this.status == Status.FAILED || this.status == Status.SUCCEEDED || this.status == Status.GENERATING_METADATA;
    }

    void onShutdown(ClientContext context) {
        this.writeMetadataJob.run(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preadChecksummed(long fileOffset, byte[] buf, int offset, int length) throws IOException, ChecksumFailedException {
        byte[] checksumBuf = new byte[this.checker.checksumLength()];
        LockableRandomAccessBuffer.RAFLock lock = this.raf.lockOpen();
        try {
            this.raf.pread(fileOffset, buf, offset, length);
            this.raf.pread(fileOffset + (long)length, checksumBuf, 0, this.checker.checksumLength());
        }
        finally {
            lock.unlock();
        }
        if (!this.checker.checkChecksum(buf, offset, length, checksumBuf)) {
            Arrays.fill(buf, offset, offset + length, (byte)0);
            throw new ChecksumFailedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] preadChecksummedWithLength(long fileOffset) throws IOException, ChecksumFailedException, StorageFormatException {
        byte[] buf;
        int length;
        byte[] checksumBuf = new byte[this.checker.checksumLength()];
        LockableRandomAccessBuffer.RAFLock lock = this.raf.lockOpen();
        byte[] lengthBuf = new byte[8];
        try {
            this.raf.pread(fileOffset, lengthBuf, 0, lengthBuf.length);
            long len = new DataInputStream(new ByteArrayInputStream(lengthBuf)).readLong();
            if (len + fileOffset > this.rafLength || len > Integer.MAX_VALUE || len < 0L) {
                throw new StorageFormatException("Bogus length " + len);
            }
            length = (int)len;
            buf = new byte[length];
            this.raf.pread(fileOffset + (long)lengthBuf.length, buf, 0, length);
            this.raf.pread(fileOffset + (long)length + (long)lengthBuf.length, checksumBuf, 0, this.checker.checksumLength());
        }
        finally {
            lock.unlock();
        }
        if (!this.checker.checkChecksum(buf, 0, length, checksumBuf)) {
            Arrays.fill(buf, 0, length, (byte)0);
            throw new ChecksumFailedException();
        }
        return buf;
    }

    public long getOffsetSegmentStatus(int segNo) {
        return this.offsetSegmentStatus[segNo];
    }

    LockableRandomAccessBuffer getRAF() {
        return this.raf;
    }

    public void onResume(ClientContext context) throws ResumeFailedException {
        if (this.crossSegments != null && this.status != Status.ENCODED_CROSS_SEGMENTS) {
            this.startCrossSegmentEncode();
        } else {
            this.startSegmentEncode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileInserterSegmentStorage.BlockInsert chooseBlock() {
        Object object = this.cooldownLock;
        synchronized (object) {
            SplitFileInserterStorage splitFileInserterStorage = this;
            synchronized (splitFileInserterStorage) {
                if (this.status == Status.FAILED || this.status == Status.SUCCEEDED || this.status == Status.GENERATING_METADATA || this.failing != null) {
                    return null;
                }
            }
            this.randomSegmentIterator.reset(this.random);
            while (this.randomSegmentIterator.hasNext()) {
                SplitFileInserterSegmentStorage segment = this.randomSegmentIterator.next();
                SplitFileInserterSegmentStorage.BlockInsert ret = segment.chooseBlock();
                if (ret == null) continue;
                this.noBlocksToSend = false;
                return ret;
            }
            this.noBlocksToSend = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noBlocksToSend() {
        Object object = this.cooldownLock;
        synchronized (object) {
            return this.noBlocksToSend;
        }
    }

    public long countAllKeys() {
        long total = 0L;
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            total += (long)segment.totalBlockCount;
        }
        return total;
    }

    public long countSendableKeys() {
        long total = 0L;
        for (SplitFileInserterSegmentStorage segment : this.segments) {
            total += (long)segment.countSendableKeys();
        }
        return total;
    }

    public int getTotalBlockCount() {
        return this.totalDataBlocks + this.totalCheckBlocks + this.crossCheckBlocks * this.segments.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCooldown() {
        Object object = this.cooldownLock;
        synchronized (object) {
            this.noBlocksToSend = false;
        }
        this.callback.clearCooldown();
    }

    public long getWakeupTime(ClientContext context, long now) {
        if (this.hasFinished()) {
            return -1L;
        }
        if (this.noBlocksToSend()) {
            return Long.MAX_VALUE;
        }
        return 0L;
    }

    static {
        Logger.registerClass(SplitFileInserterStorage.class);
        LAZY_WRITE_METADATA_DELAY = TimeUnit.MINUTES.toMillis(5L);
    }

    static enum Status {
        NOT_STARTED,
        STARTED,
        ENCODED_CROSS_SEGMENTS,
        ENCODED,
        GENERATING_METADATA,
        SUCCEEDED,
        FAILED;

    }
}

