/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.ConfigException;
import freenet.config.InvalidConfigValueException;
import freenet.node.NodeClientCore;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.support.HTMLNode;
import freenet.support.Logger;

public abstract class BandwidthManipulator {
    protected final NodeClientCore core;
    protected final Config config;

    public BandwidthManipulator(NodeClientCore core, Config config) {
        this.config = config;
        this.core = core;
    }

    protected void setBandwidthLimit(String limit, boolean setOutputLimit) throws InvalidConfigValueException {
        String limitType = setOutputLimit ? "outputBandwidthLimit" : "inputBandwidthLimit";
        try {
            this.config.get("node").set(limitType, limit);
            Logger.normal(this, "The " + limitType + " has been set to " + limit);
        }
        catch (ConfigException e) {
            if (e instanceof InvalidConfigValueException) {
                throw (InvalidConfigValueException)e;
            }
            Logger.error(this, "Should not happen, please report!" + e, (Throwable)e);
        }
    }

    protected HTMLNode parseErrorBox(HTMLNode parent, PageHelper helper, String message) {
        HTMLNode infoBox = helper.getInfobox("infobox-warning", WizardL10n.l10n("bandwidthErrorSettingTitle"), parent, null, false);
        infoBox.addChild("p", message);
        return infoBox;
    }

    protected BandwidthLimit getCurrentBandwidthLimitsOrNull() {
        if (!this.config.get("node").getOption("outputBandwidthLimit").isDefault()) {
            return new BandwidthLimit(this.core.node.getInputBandwidthLimit(), this.core.node.getOutputBandwidthLimit(), "bandwidthCurrent", false);
        }
        return null;
    }

    protected BandwidthLimit detectBandwidthLimits() {
        int upstreamBytes;
        int downstreamBytes;
        FredPluginBandwidthIndicator bwIndicator = this.core.node.ipDetector.getBandwidthIndicator();
        if (bwIndicator == null) {
            Logger.normal(this, "The node does not have a bandwidthIndicator.");
            return new BandwidthLimit(-3L, -3L, "bandwidthDetected", false);
        }
        int downstreamBits = bwIndicator.getDownstreamMaxBitRate();
        int upstreamBits = bwIndicator.getUpstramMaxBitRate();
        Logger.normal(this, "bandwidthIndicator reports downstream " + downstreamBits + " bits/s and upstream " + upstreamBits + " bits/s.");
        int KiB = 8192;
        if (downstreamBits < 0) {
            downstreamBytes = -1;
        } else if (downstreamBits < 65536) {
            System.err.println("Detected downstream of " + downstreamBits + " bits/s is nonsensically slow, ignoring.");
            downstreamBytes = -1;
        } else {
            downstreamBytes = downstreamBits / 8;
        }
        if (upstreamBits < 0) {
            upstreamBytes = -1;
        } else if (upstreamBits < 8192) {
            System.err.println("Detected upstream of " + upstreamBits + " bits/s is nonsensically slow, ignoring.");
            upstreamBytes = -1;
        } else {
            upstreamBytes = upstreamBits / 8;
        }
        return new BandwidthLimit(downstreamBytes, upstreamBytes, "bandwidthDetected", false);
    }

    protected void setWizardComplete() {
        try {
            this.config.get("fproxy").set("hasCompletedWizard", true);
            this.config.store();
        }
        catch (ConfigException e) {
            Logger.error(this, e.getMessage(), (Throwable)e);
        }
    }
}

