/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.FetchContext;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FeedMessage;
import freenet.clients.http.SecurityLevelsToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.config.EnumerableOptionCallback;
import freenet.config.FreenetFilePersistentConfig;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.ECDH;
import freenet.crypt.MasterSecret;
import freenet.crypt.PersistentRandomSource;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IOStatisticCollector;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.TrafficClass;
import freenet.io.comm.UdpSocketHandler;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.node.Announcer;
import freenet.node.CHKInsertSender;
import freenet.node.DNSRequester;
import freenet.node.DarknetPeerNode;
import freenet.node.DatabaseKey;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.InsertTag;
import freenet.node.Location;
import freenet.node.LocationManager;
import freenet.node.LoggingConfigHandler;
import freenet.node.MasterKeys;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.NodeClientCore;
import freenet.node.NodeCrypto;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeDispatcher;
import freenet.node.NodeGetPubkey;
import freenet.node.NodeIPDetector;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.NodeToNodeMessageListener;
import freenet.node.OpennetDisabledException;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PacketSender;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerTooOldException;
import freenet.node.ProgramDirectory;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.node.RequestSender;
import freenet.node.RequestTag;
import freenet.node.RequestTracker;
import freenet.node.SSKInsertSender;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.SeedServerTestPeerNode;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.TimeSkewDetectorCallback;
import freenet.node.UptimeEstimator;
import freenet.node.Version;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.node.stats.DataStoreInstanceType;
import freenet.node.stats.DataStoreKeyType;
import freenet.node.stats.DataStoreStats;
import freenet.node.stats.DataStoreType;
import freenet.node.stats.NotAvailNodeStoreStats;
import freenet.node.stats.StoreCallbackStats;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.JVMVersionAlert;
import freenet.node.useralerts.MeaningfulNodeNameUserAlert;
import freenet.node.useralerts.NotEnoughNiceLevelsUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.TimeSkewDetectedUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.PluginDownLoaderOfficialHTTPS;
import freenet.pluginmanager.PluginManager;
import freenet.store.BlockMetadata;
import freenet.store.CHKStore;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.NullFreenetStore;
import freenet.store.PubkeyStore;
import freenet.store.RAMFreenetStore;
import freenet.store.SSKStore;
import freenet.store.SlashdotStore;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.store.caching.CachingFreenetStore;
import freenet.store.caching.CachingFreenetStoreTracker;
import freenet.store.saltedhash.ResizablePersistentIntBuffer;
import freenet.store.saltedhash.SaltedHashFreenetStore;
import freenet.support.Executor;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.JVMVersion;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.PrioritizedTicker;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.Ticker;
import freenet.support.TokenBucket;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.ShortCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.math.MersenneTwister;
import freenet.support.transport.ip.HostnameSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class Node
implements TimeSkewDetectorCallback {
    volatile CHKStore oldCHK;
    volatile PubkeyStore oldPK;
    volatile SSKStore oldSSK;
    volatile CHKStore oldCHKCache;
    volatile PubkeyStore oldPKCache;
    volatile SSKStore oldSSKCache;
    volatile CHKStore oldCHKClientCache;
    volatile PubkeyStore oldPKClientCache;
    volatile SSKStore oldSSKClientCache;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static MeaningfulNodeNameUserAlert nodeNameUserAlert;
    private static TimeSkewDetectedUserAlert timeSkewDetectedUserAlert;
    private DatabaseKey databaseKey;
    private MasterKeys keys;
    public final NodeStats nodeStats;
    public final PersistentConfig config;
    static File logDir;
    static long maxLogSize;
    public static LoggingConfigHandler logConfigHandler;
    public static final int PACKETS_IN_BLOCK = 32;
    public static final int PACKET_SIZE = 1024;
    public static final double DECREMENT_AT_MIN_PROB = 0.25;
    public static final double DECREMENT_AT_MAX_PROB = 0.5;
    public static final long KEEPALIVE_INTERVAL;
    public static final long MAX_PEER_INACTIVITY;
    public static final int HANDSHAKE_TIMEOUT;
    public static final int MIN_TIME_BETWEEN_HANDSHAKE_SENDS;
    public static final int RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS;
    public static final int MIN_TIME_BETWEEN_VERSION_PROBES;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_PROBES;
    public static final int MIN_TIME_BETWEEN_VERSION_SENDS;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_SENDS;
    public static final int MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS;
    public static final int RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS;
    public static final int MIN_BURSTING_HANDSHAKE_BURST_SIZE = 1;
    public static final int RANDOMIZED_BURSTING_HANDSHAKE_BURST_SIZE = 3;
    public static final long ALARM_TIME;
    static final long MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS;
    static final long MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS;
    public static final int SYMMETRIC_KEY_LENGTH = 32;
    private final ProgramDirectory storeDir;
    private String storeType;
    private boolean storeUseSlotFilters;
    private boolean storeSaltHashResizeOnStart;
    static final long MIN_STORE_SIZE = 0x2000000L;
    static final long DEFAULT_STORE_SIZE = 0x2000000L;
    static final long MIN_CLIENT_CACHE_SIZE = 0L;
    static final long DEFAULT_CLIENT_CACHE_SIZE = 0xA00000L;
    static final long MIN_SLASHDOT_CACHE_SIZE = 0L;
    static final long DEFAULT_SLASHDOT_CACHE_SIZE = 0xA00000L;
    public static final int sizePerKey = 34988;
    private long maxTotalKeys;
    long maxCacheKeys;
    long maxStoreKeys;
    private long maxTotalDatastoreSize;
    private boolean storeForceBigShrinks;
    private final SemiOrderedShutdownHook shutdownHook;
    private CHKStore chkDatastore;
    private SSKStore sskDatastore;
    private PubkeyStore pubKeyDatastore;
    private String clientCacheType;
    private boolean clientCacheAwaitingPassword;
    private boolean databaseAwaitingPassword;
    long maxClientCacheKeys;
    private long maxTotalClientCacheSize;
    private CHKStore chkDatacache;
    private SSKStore sskDatacache;
    private PubkeyStore pubKeyDatacache;
    private CHKStore chkClientcache;
    private SSKStore sskClientcache;
    private PubkeyStore pubKeyClientcache;
    private long maxSlashdotCacheSize;
    private int maxSlashdotCacheKeys;
    static final long PURGE_INTERVAL;
    private CHKStore chkSlashdotcache;
    private SlashdotStore<CHKBlock> chkSlashdotcacheStore;
    private SSKStore sskSlashdotcache;
    private SlashdotStore<SSKBlock> sskSlashdotcacheStore;
    private PubkeyStore pubKeySlashdotcache;
    private SlashdotStore<DSAPublicKey> pubKeySlashdotcacheStore;
    private boolean useSlashdotCache;
    private boolean writeLocalToDatastore;
    final NodeGetPubkey getPubKey;
    public final FetchContext arkFetcherContext;
    public final NodeIPDetector ipDetector;
    boolean disableProbabilisticHTLs;
    public final RequestTracker tracker;
    public long swapIdentifier;
    private String myName;
    public final LocationManager lm;
    public final PeerManager peers;
    final ProgramDirectory nodeDir;
    final ProgramDirectory cfgDir;
    final ProgramDirectory userDir;
    final ProgramDirectory runDir;
    final ProgramDirectory pluginDir;
    final File masterKeysFile;
    final File extraPeerDataDir;
    private volatile boolean hasPanicked;
    public final RandomSource random;
    public final SecureRandom secureRandom;
    public final Random fastWeakRandom;
    final MessageCore usm;
    NodeCrypto darknetCrypto;
    private boolean showFriendsVisibilityAlert;
    private final NodeCryptoConfig opennetCryptoConfig;
    OpennetManager opennet;
    private volatile boolean isAllowedToConnectToSeednodes;
    private int maxOpennetPeers;
    private boolean acceptSeedConnections;
    private boolean passOpennetRefsThroughDarknet;
    public final Executor executor;
    public final PacketSender ps;
    public final PrioritizedTicker ticker;
    final DNSRequester dnsr;
    final NodeDispatcher dispatcher;
    public final UptimeEstimator uptime;
    public final TokenBucket outputThrottle;
    public boolean throttleLocalData;
    private int outputBandwidthLimit;
    private int inputBandwidthLimit;
    boolean inputLimitDefault;
    final boolean enableARKs;
    final boolean enablePerNodeFailureTables;
    final boolean enableULPRDataPropagation;
    final boolean enableSwapping;
    private volatile boolean publishOurPeersLocation;
    private volatile boolean routeAccordingToOurPeersLocation;
    boolean enableSwapQueueing;
    boolean enablePacketCoalescing;
    public static final short DEFAULT_MAX_HTL = 18;
    private short maxHTL;
    private boolean skipWrapperWarning;
    private int maxPacketSize;
    public static final boolean IGNORE_LOW_BACKOFF_DEFAULT = false;
    public static final long LOW_BACKOFF;
    public static final boolean PREFER_INSERT_DEFAULT = false;
    public static final boolean FORK_ON_CACHEABLE_DEFAULT = true;
    public final IOStatisticCollector collector;
    public static final int N2N_MESSAGE_TYPE_FPROXY = 1;
    public static final int N2N_MESSAGE_TYPE_DIFFNODEREF = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_USERALERT = 1;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_ACCEPTED = 3;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_REJECTED = 4;
    public static final int N2N_TEXT_MESSAGE_TYPE_BOOKMARK = 5;
    public static final int N2N_TEXT_MESSAGE_TYPE_DOWNLOAD = 6;
    public static final int EXTRA_PEER_DATA_TYPE_N2NTM = 1;
    public static final int EXTRA_PEER_DATA_TYPE_PEER_NOTE = 2;
    public static final int EXTRA_PEER_DATA_TYPE_QUEUED_TO_SEND_N2NM = 3;
    public static final int EXTRA_PEER_DATA_TYPE_BOOKMARK = 4;
    public static final int EXTRA_PEER_DATA_TYPE_DOWNLOAD = 5;
    public static final int PEER_NOTE_TYPE_PRIVATE_DARKNET_COMMENT = 1;
    public final long lastBootID;
    public final long bootID;
    public final long startupTime;
    private SimpleToadletServer toadlets;
    public final NodeClientCore clientCore;
    final FailureTable failureTable;
    public int lastVersion;
    public final NodeUpdateManager nodeUpdater;
    public final SecurityLevels securityLevels;
    public final PluginManager pluginManager;
    public final InetAddress localhostAddress;
    public final FreenetInetAddress fLocalhostAddress;
    private static NodeStarter nodeStarter;
    private boolean hasStarted;
    private boolean isStopping = false;
    static final int MIN_UPTIME_STORE_KEY = 40;
    private volatile boolean isPRNGReady = false;
    private boolean storePreallocate;
    private boolean enableRoutedPing;
    private static final int minimumBandwidth = 4096;
    private TrafficClass trafficClass;
    private final Object writeNodeFileSync = new Object();
    private final UserAlert masterPasswordUserAlert = new UserAlert(){
        final long creationTime = System.currentTimeMillis();

        @Override
        public String anchor() {
            return "password";
        }

        @Override
        public String dismissButtonText() {
            return null;
        }

        @Override
        public long getUpdatedTime() {
            return this.creationTime;
        }

        @Override
        public FCPMessage getFCPMessage() {
            return new FeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime());
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode content = new HTMLNode("div");
            SecurityLevelsToadlet.generatePasswordFormPage(false, Node.this.clientCore.getToadletContainer(), content, false, false, false, null, null);
            return content;
        }

        @Override
        public short getPriorityClass() {
            return 1;
        }

        @Override
        public String getShortText() {
            return NodeL10n.getBase().getString("SecurityLevels.enterPassword");
        }

        @Override
        public String getText() {
            return NodeL10n.getBase().getString("SecurityLevels.enterPassword");
        }

        @Override
        public String getTitle() {
            return NodeL10n.getBase().getString("SecurityLevels.enterPassword");
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            Node node = Node.this;
            synchronized (node) {
                return Node.this.clientCacheAwaitingPassword || Node.this.databaseAwaitingPassword;
            }
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public void onDismiss() {
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return false;
        }

        @Override
        public boolean userCanDismiss() {
            return false;
        }
    };
    private long cachingFreenetStoreMaxSize;
    private long cachingFreenetStorePeriod;
    private CachingFreenetStoreTracker cachingFreenetStoreTracker;
    private static boolean jvmHasGCJCharConversionBug;
    long timeLastDumpedHits;
    final boolean decrementAtMax;
    final boolean decrementAtMin;
    static final int SIGNATURE_PARAMETER_LENGTH = 32;
    private Map<Integer, NodeToNodeMessageListener> n2nmListeners = new HashMap<Integer, NodeToNodeMessageListener>();
    private NodeToNodeMessageListener diffNoderefListener = new NodeToNodeMessageListener(){

        @Override
        public void handleMessage(byte[] data, boolean fromDarknet, PeerNode src, int type) {
            Logger.normal(this, "Received differential node reference node to node message from " + src.getPeer());
            SimpleFieldSet fs = null;
            try {
                fs = new SimpleFieldSet(new String(data, "UTF-8"), false, true, false);
            }
            catch (IOException e) {
                Logger.error(this, "IOException while parsing node to node message data", (Throwable)e);
                return;
            }
            if (fs.get("n2nType") != null) {
                fs.removeValue("n2nType");
            }
            try {
                src.processDiffNoderef(fs);
            }
            catch (FSParseException e) {
                Logger.error(this, "FSParseException while parsing node to node message data", (Throwable)e);
                return;
            }
        }
    };
    private NodeToNodeMessageListener fproxyN2NMListener = new NodeToNodeMessageListener(){

        @Override
        public void handleMessage(byte[] data, boolean fromDarknet, PeerNode src, int type) {
            if (!fromDarknet) {
                Logger.error(this, "Got N2NTM from non-darknet node ?!?!?!: from " + src);
                return;
            }
            DarknetPeerNode darkSource = (DarknetPeerNode)src;
            Logger.normal(this, "Received N2NTM from '" + darkSource.getPeer() + "'");
            SimpleFieldSet fs = null;
            try {
                fs = new SimpleFieldSet(new String(data, "UTF-8"), false, true, false);
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            catch (IOException e) {
                Logger.error(this, "IOException while parsing node to node message data", (Throwable)e);
                return;
            }
            fs.putOverwrite("n2nType", Integer.toString(type));
            fs.putOverwrite("receivedTime", Long.toString(System.currentTimeMillis()));
            fs.putOverwrite("receivedAs", "nodeToNodeMessage");
            int fileNumber = darkSource.writeNewExtraPeerDataFile(fs, 1);
            if (fileNumber == -1) {
                Logger.error(this, "Failed to write N2NTM to extra peer data file for peer " + darkSource.getPeer());
            }
            try {
                Node.this.handleNodeToNodeTextMessageSimpleFieldSet(fs, darkSource, fileNumber);
            }
            catch (FSParseException e) {
                throw new Error(e);
            }
        }
    };
    private volatile Object statsSync = new Object();
    private long totalPayloadSent;
    private SimpleUserAlert alertMTUTooSmall;
    public final RequestClient nonPersistentClientBulk = new RequestClientBuilder().build();
    public final RequestClient nonPersistentClientRT = new RequestClientBuilder().realTime().build();
    private UserAlert visibilityAlert = new SimpleUserAlert(true, this.l10n("pleaseSetPeersVisibilityAlertTitle"), this.l10n("pleaseSetPeersVisibilityAlert"), this.l10n("pleaseSetPeersVisibilityAlert"), 1){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDismiss() {
            Node node = Node.this;
            synchronized (node) {
                Node.this.showFriendsVisibilityAlert = false;
            }
            Node.this.config.store();
            Node.this.unregisterFriendsVisibilityAlert();
        }
    };

    private <T extends StorableBlock> void migrateOldStore(StoreCallback<T> old, StoreCallback<T> newStore, boolean canReadClientCache) {
        FreenetStore<T> store = old.getStore();
        if (store instanceof RAMFreenetStore) {
            RAMFreenetStore ramstore = (RAMFreenetStore)store;
            try {
                ramstore.migrateTo(newStore, canReadClientCache);
            }
            catch (IOException e) {
                Logger.error(this, "Caught migrating old store: " + e, (Throwable)e);
            }
            ramstore.clear();
        } else if (store instanceof SaltedHashFreenetStore) {
            Logger.error(this, "Migrating from from a saltedhashstore not fully supported yet: will not keep old keys");
        }
    }

    public <T extends StorableBlock> void closeOldStore(StoreCallback<T> old) {
        FreenetStore<T> store = old.getStore();
        if (store instanceof SaltedHashFreenetStore) {
            SaltedHashFreenetStore saltstore = (SaltedHashFreenetStore)store;
            saltstore.close();
            saltstore.destruct();
        }
    }

    public TrafficClass getTrafficClass() {
        return this.trafficClass;
    }

    public static int getMinimumBandwidth() {
        return 4096;
    }

    private InvalidConfigValueException lowBandwidthLimit(int limit) {
        return new InvalidConfigValueException(this.l10n("bandwidthMinimum", new String[]{"limit", "minimum"}, new String[]{Integer.toString(limit), Integer.toString(4096)}));
    }

    public void startProbe(byte htl, long uid, Type type, Listener listener) {
        this.dispatcher.probe.start(htl, uid, type, listener);
    }

    private void readNodeFile(String filename) throws IOException {
        String verString;
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
        br.close();
        String[] udp = fs.getAll("physical.udp");
        if (udp != null && udp.length > 0) {
            for (String udpAddr : udp) {
                Peer p;
                try {
                    p = new Peer(udpAddr, false, true);
                }
                catch (HostnameSyntaxException e) {
                    Logger.error(this, "Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    System.err.println("Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    continue;
                }
                catch (PeerParseException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                if (p.getPort() != this.getDarknetPortNumber()) continue;
                this.ipDetector.setOldIPAddress(p.getFreenetAddress());
                break;
            }
        }
        this.darknetCrypto.readCrypto(fs);
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        String loc = fs.get("location");
        double locD = Location.getLocation(loc);
        if (locD == -1.0) {
            throw new IOException("Invalid location: " + loc);
        }
        this.lm.setLocation(locD);
        this.myName = fs.get("myName");
        if (this.myName == null) {
            this.myName = this.newName();
        }
        if ((verString = fs.get("version")) == null) {
            Logger.error(this, "No version!");
            System.err.println("No version!");
        } else {
            this.lastVersion = Version.getArbitraryBuildNumber(verString, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeStore(String val) throws InvalidConfigValueException {
        String suffix = this.getStoreSuffix();
        if (val.equals("salt-hash")) {
            try {
                this.initSaltHashFS(suffix, true, null);
            }
            catch (NodeInitException e) {
                Logger.error(this, "Unable to create new store", (Throwable)e);
                System.err.println("Unable to create new store: " + e);
                e.printStackTrace();
                throw new InvalidConfigValueException("Unable to create new store: " + e);
            }
        } else {
            this.initRAMFS();
        }
        Node node = this;
        synchronized (node) {
            this.storeType = val;
        }
    }

    private String newName() {
        return "Freenet node with no name #" + this.random.nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNodeFile() {
        Object object = this.writeNodeFileSync;
        synchronized (object) {
            this.writeNodeFile(this.nodeDir.file("node-" + this.getDarknetPortNumber()), this.nodeDir.file("node-" + this.getDarknetPortNumber() + ".bak"));
        }
    }

    public void writeOpennetFile() {
        OpennetManager om = this.opennet;
        if (om != null) {
            om.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeFile(File orig, File backup) {
        SimpleFieldSet fs = this.darknetCrypto.exportPrivateFieldSet();
        if (orig.exists()) {
            backup.delete();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(backup);
            fs.writeTo(fos);
            fos.close();
            fos = null;
            FileUtil.renameTo(backup, orig);
        }
        catch (IOException ioe) {
            try {
                Logger.error(this, "IOE :" + ioe.getMessage(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                Closer.close(fos);
                throw throwable;
            }
            Closer.close(fos);
            return;
        }
        Closer.close(fos);
    }

    private void initNodeFileSettings() {
        Logger.normal(this, "Creating new node file from scratch");
        this.darknetCrypto.initCrypto();
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        this.myName = this.newName();
    }

    public static void main(String[] args) throws IOException {
        NodeStarter.main(args);
    }

    public boolean isUsingWrapper() {
        return nodeStarter != null && WrapperManager.isControlledByNativeWrapper();
    }

    public NodeStarter getNodeStarter() {
        return nodeStarter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node(PersistentConfig config, RandomSource r, RandomSource weakRandom, LoggingConfigHandler lc, NodeStarter ns, Executor executor) throws NodeInitException {
        long memoryLimit;
        File f;
        this.shutdownHook = SemiOrderedShutdownHook.get();
        String tmp = "Initializing Node using Freenet Build #" + Version.buildNumber() + " r" + Version.cvsRevision() + " and freenet-ext Build #" + NodeStarter.extBuildNumber + " r" + NodeStarter.extRevisionNumber + " with " + System.getProperty("java.vendor") + " JVM version " + System.getProperty("java.version") + " running on " + System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version");
        this.fixCertsFiles();
        Logger.normal(this, tmp);
        System.out.println(tmp);
        this.collector = new IOStatisticCollector();
        this.executor = executor;
        nodeStarter = ns;
        if (logConfigHandler != lc) {
            logConfigHandler = lc;
        }
        this.getPubKey = new NodeGetPubkey(this);
        this.startupTime = System.currentTimeMillis();
        SimpleFieldSet oldConfig = config.getSimpleFieldSet();
        final SubConfig nodeConfig = config.createSubConfig("node");
        SubConfig installConfig = config.createSubConfig("node.install");
        int sortOrder = 0;
        this.userDir = this.setupProgramDir(installConfig, "userDir", ".", "Node.userDir", "Node.userDirLong", nodeConfig);
        this.cfgDir = this.setupProgramDir(installConfig, "cfgDir", this.getUserDir().toString(), "Node.cfgDir", "Node.cfgDirLong", nodeConfig);
        this.nodeDir = this.setupProgramDir(installConfig, "nodeDir", this.getUserDir().toString(), "Node.nodeDir", "Node.nodeDirLong", nodeConfig);
        this.runDir = this.setupProgramDir(installConfig, "runDir", this.getUserDir().toString(), "Node.runDir", "Node.runDirLong", nodeConfig);
        this.pluginDir = this.setupProgramDir(installConfig, "pluginDir", this.userDir().file("plugins").toString(), "Node.pluginDir", "Node.pluginDirLong", nodeConfig);
        nodeConfig.register("l10n", Locale.getDefault().getLanguage().toLowerCase(), sortOrder++, false, true, "Node.l10nLanguage", "Node.l10nLanguageLong", new L10nCallback());
        try {
            new NodeL10n(BaseL10n.LANGUAGE.mapToLanguage(nodeConfig.getString("l10n")), this.getCfgDir());
        }
        catch (MissingResourceException e) {
            try {
                new NodeL10n(BaseL10n.LANGUAGE.mapToLanguage(nodeConfig.getOption("l10n").getDefault()), this.getCfgDir());
            }
            catch (MissingResourceException e1) {
                new NodeL10n(BaseL10n.LANGUAGE.mapToLanguage(BaseL10n.LANGUAGE.getDefault().shortCode), this.getCfgDir());
            }
        }
        SubConfig fproxyConfig = config.createSubConfig("fproxy");
        try {
            this.toadlets = new SimpleToadletServer(fproxyConfig, new ArrayBucketFactory(), executor, this);
            fproxyConfig.finishedInitialization();
            this.toadlets.start();
        }
        catch (IOException e4) {
            Logger.error(this, "Could not start web interface: " + e4, (Throwable)e4);
            System.err.println("Could not start web interface: " + e4);
            e4.printStackTrace();
            throw new NodeInitException(18, "Could not start FProxy: " + e4);
        }
        catch (InvalidConfigValueException e4) {
            System.err.println("Invalid config value, cannot start web interface: " + e4);
            e4.printStackTrace();
            throw new NodeInitException(18, "Could not start FProxy: " + e4);
        }
        NativeThread entropyGatheringThread = new NativeThread(new Runnable(){
            long tLastAdded = -1L;
            static final int EXTEND_BY = 3600000;

            private void recurse(File f) {
                if (Node.this.isPRNGReady) {
                    return;
                }
                this.extendTimeouts();
                File[] subDirs = f.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.exists() && pathname.canRead() && pathname.isDirectory();
                    }
                });
                if (subDirs != null) {
                    for (File currentDir : subDirs) {
                        this.recurse(currentDir);
                    }
                }
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Node.this.isPRNGReady) {
                    return;
                }
                System.out.println("Not enough entropy available.");
                System.out.println("Trying to gather entropy (randomness) by reading the disk...");
                if (File.separatorChar == '/') {
                    if (new File("/dev/hwrng").exists()) {
                        System.out.println("/dev/hwrng exists - have you installed rng-tools?");
                    } else {
                        System.out.println("You should consider installing a better random number generator e.g. haveged.");
                    }
                }
                this.extendTimeouts();
                for (File root : File.listRoots()) {
                    if (Node.this.isPRNGReady) {
                        return;
                    }
                    this.recurse(root);
                }
            }

            private void extendTimeouts() {
                long target;
                long now = System.currentTimeMillis();
                if (now - this.tLastAdded < 1800000L) {
                    return;
                }
                for (target = this.tLastAdded + 3600000L; target < now; target += 3600000L) {
                }
                long extend = target - now;
                assert (extend < Integer.MAX_VALUE);
                assert (extend > 0L);
                WrapperManager.signalStarting((int)((int)extend));
                this.tLastAdded = now;
            }
        }, "Entropy Gathering Thread", NativeThread.MIN_PRIORITY, true);
        if (r == null) {
            Util.mdProviders.size();
            Rijndael.getProviderName();
            File seed = this.userDir.file("prng.seed");
            FileUtil.setOwnerRW(seed);
            entropyGatheringThread.start();
            this.random = new Yarrow(seed);
            ECDH.blockingInit();
        } else {
            this.random = r;
        }
        this.secureRandom = NodeStarter.getGlobalSecureRandom();
        this.isPRNGReady = true;
        this.toadlets.getStartupToadlet().setIsPRNGReady();
        if (weakRandom == null) {
            byte[] buffer = new byte[16];
            this.random.nextBytes(buffer);
            this.fastWeakRandom = new MersenneTwister(buffer);
        } else {
            this.fastWeakRandom = weakRandom;
        }
        nodeNameUserAlert = new MeaningfulNodeNameUserAlert(this);
        this.config = config;
        this.lm = new LocationManager(this.random, this);
        try {
            this.localhostAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e3) {
            throw new Error(e3);
        }
        this.fLocalhostAddress = new FreenetInetAddress(this.localhostAddress);
        this.securityLevels = new SecurityLevels(this, config);
        nodeConfig.register("masterKeyFile", "master.keys", sortOrder++, true, true, "Node.masterKeyFile", "Node.masterKeyFileLong", new StringCallback(){

            @Override
            public String get() {
                if (Node.this.masterKeysFile == null) {
                    return "none";
                }
                return Node.this.masterKeysFile.getPath();
            }

            @Override
            public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
                throw new InvalidConfigValueException("Node.masterKeyFile cannot be changed on the fly, you must shutdown, wipe the old file and reconfigure");
            }
        });
        String value = nodeConfig.getString("masterKeyFile");
        if (value.equalsIgnoreCase("none")) {
            f = null;
        } else {
            f = new File(value);
            if (!(!f.exists() || f.canWrite() && f.canRead())) {
                throw new NodeInitException(30, "Cannot read from and write to master keys file " + f);
            }
        }
        this.masterKeysFile = f;
        FileUtil.setOwnerRW(this.masterKeysFile);
        nodeConfig.register("showFriendsVisibilityAlert", false, sortOrder++, true, false, "Node.showFriendsVisibilityAlert", "Node.showFriendsVisibilityAlert", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.showFriendsVisibilityAlert;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                4 var2_2 = this;
                synchronized (var2_2) {
                    if (val == Node.this.showFriendsVisibilityAlert) {
                        return;
                    }
                    if (val.booleanValue()) {
                        return;
                    }
                }
                Node.this.unregisterFriendsVisibilityAlert();
            }
        });
        this.showFriendsVisibilityAlert = nodeConfig.getBoolean("showFriendsVisibilityAlert");
        byte[] clientCacheKey = null;
        MasterSecret persistentSecret = null;
        for (int i = 0; i < 2; ++i) {
            try {
                this.keys = this.securityLevels.physicalThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM ? MasterKeys.createRandom(this.secureRandom) : MasterKeys.read(this.masterKeysFile, this.secureRandom, "");
                clientCacheKey = this.keys.clientCacheMasterKey;
                persistentSecret = this.keys.getPersistentMasterSecret();
                this.databaseKey = this.keys.createDatabaseKey(this.secureRandom);
                if (this.securityLevels.getPhysicalThreatLevel() != SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) break;
                System.err.println("Physical threat level is set to HIGH but no password, resetting to NORMAL - probably timing glitch");
                this.securityLevels.resetPhysicalThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL);
                break;
            }
            catch (MasterKeysWrongPasswordException e) {
                break;
            }
            catch (MasterKeysFileSizeException e) {
                System.err.println("Impossible: master keys file " + this.masterKeysFile + " too " + e.sizeToString() + "! Deleting to enable startup, but you will lose your client cache.");
                this.masterKeysFile.delete();
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        this.bootID = this.random.nextLong();
        File bootIDFile = this.runDir.file("bootID");
        int BOOT_FILE_LENGTH = 16;
        long oldBootID = -1L;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(bootIDFile, "rw");
            if (raf.length() < (long)BOOT_FILE_LENGTH) {
                oldBootID = -1L;
            } else {
                byte[] buf = new byte[BOOT_FILE_LENGTH];
                raf.readFully(buf);
                String s = new String(buf, "ISO-8859-1");
                try {
                    oldBootID = Fields.bytesToLong(HexUtil.hexToBytes(s));
                }
                catch (NumberFormatException e) {
                    oldBootID = -1L;
                }
                raf.seek(0L);
            }
            String s = HexUtil.bytesToHex(Fields.longToBytes(this.bootID));
            byte[] buf = s.getBytes("ISO-8859-1");
            if (buf.length != BOOT_FILE_LENGTH) {
                System.err.println("Not 16 bytes for boot ID " + this.bootID + " - WTF??");
            }
            raf.write(buf);
        }
        catch (IOException e) {
            try {
                oldBootID = -1L;
            }
            catch (Throwable throwable) {
                Closer.close(raf);
                throw throwable;
            }
            Closer.close(raf);
        }
        Closer.close(raf);
        this.lastBootID = oldBootID;
        nodeConfig.register("disableProbabilisticHTLs", false, sortOrder++, true, false, "Node.disablePHTLS", "Node.disablePHTLSLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.disableProbabilisticHTLs;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.disableProbabilisticHTLs = val;
            }
        });
        this.disableProbabilisticHTLs = nodeConfig.getBoolean("disableProbabilisticHTLs");
        nodeConfig.register("maxHTL", (short)18, sortOrder++, true, false, "Node.maxHTL", "Node.maxHTLLong", new ShortCallback(){

            @Override
            public Short get() {
                return Node.this.maxHTL;
            }

            @Override
            public void set(Short val) throws InvalidConfigValueException {
                if (val < 0) {
                    throw new InvalidConfigValueException("Impossible max HTL");
                }
                Node.this.maxHTL = val;
            }
        }, false);
        this.maxHTL = nodeConfig.getShort("maxHTL");
        class TrafficClassCallback
        extends StringCallback
        implements EnumerableOptionCallback {
            TrafficClassCallback() {
            }

            @Override
            public String get() {
                return Node.this.trafficClass.name();
            }

            @Override
            public void set(String tcName) throws InvalidConfigValueException, NodeNeedRestartException {
                try {
                    Node.this.trafficClass = TrafficClass.fromNameOrValue(tcName);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
                throw new NodeNeedRestartException("TrafficClass cannot change on the fly");
            }

            @Override
            public String[] getPossibleValues() {
                ArrayList<String> array = new ArrayList<String>();
                for (TrafficClass tc : TrafficClass.values()) {
                    array.add(tc.name());
                }
                return array.toArray(new String[0]);
            }
        }
        nodeConfig.register("trafficClass", TrafficClass.getDefault().name(), sortOrder++, true, false, "Node.trafficClass", "Node.trafficClassLong", new TrafficClassCallback());
        String trafficClassValue = nodeConfig.getString("trafficClass");
        try {
            this.trafficClass = TrafficClass.fromNameOrValue(trafficClassValue);
        }
        catch (IllegalArgumentException e) {
            Logger.error(this, "Invalid trafficClass:" + trafficClassValue + " resetting the value to default.", (Throwable)e);
            this.trafficClass = TrafficClass.getDefault();
        }
        this.decrementAtMax = this.random.nextDouble() <= 0.5;
        this.decrementAtMin = this.random.nextDouble() <= 0.25;
        this.usm = new MessageCore(executor);
        this.ipDetector = new NodeIPDetector(this);
        sortOrder = this.ipDetector.registerConfigs(nodeConfig, sortOrder);
        nodeConfig.register("enableARKs", true, sortOrder++, true, false, "Node.enableARKs", "Node.enableARKsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enableARKs;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableARKs = nodeConfig.getBoolean("enableARKs");
        nodeConfig.register("enablePerNodeFailureTables", true, sortOrder++, true, false, "Node.enablePerNodeFailureTables", "Node.enablePerNodeFailureTablesLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enablePerNodeFailureTables;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.enablePerNodeFailureTables = nodeConfig.getBoolean("enablePerNodeFailureTables");
        nodeConfig.register("enableULPRDataPropagation", true, sortOrder++, true, false, "Node.enableULPRDataPropagation", "Node.enableULPRDataPropagationLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enableULPRDataPropagation;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableULPRDataPropagation = nodeConfig.getBoolean("enableULPRDataPropagation");
        nodeConfig.register("enableSwapping", true, sortOrder++, true, false, "Node.enableSwapping", "Node.enableSwappingLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enableSwapping;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableSwapping = nodeConfig.getBoolean("enableSwapping");
        nodeConfig.register("publishOurPeersLocation", true, sortOrder++, true, false, "Node.publishOurPeersLocation", "Node.publishOurPeersLocationLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.publishOurPeersLocation;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.publishOurPeersLocation = val;
            }
        });
        this.publishOurPeersLocation = nodeConfig.getBoolean("publishOurPeersLocation");
        nodeConfig.register("routeAccordingToOurPeersLocation", true, sortOrder++, true, false, "Node.routeAccordingToOurPeersLocation", "Node.routeAccordingToOurPeersLocation", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.routeAccordingToOurPeersLocation;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.routeAccordingToOurPeersLocation = val;
            }
        });
        this.routeAccordingToOurPeersLocation = nodeConfig.getBoolean("routeAccordingToOurPeersLocation");
        nodeConfig.register("enableSwapQueueing", true, sortOrder++, true, false, "Node.enableSwapQueueing", "Node.enableSwapQueueingLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enableSwapQueueing;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.enableSwapQueueing = val;
            }
        });
        this.enableSwapQueueing = nodeConfig.getBoolean("enableSwapQueueing");
        nodeConfig.register("enablePacketCoalescing", true, sortOrder++, true, false, "Node.enablePacketCoalescing", "Node.enablePacketCoalescingLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.enablePacketCoalescing;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.enablePacketCoalescing = val;
            }
        });
        this.enablePacketCoalescing = nodeConfig.getBoolean("enablePacketCoalescing");
        if (oldConfig != null && "-1".equals(oldConfig.get("node.listenPort"))) {
            throw new NodeInitException(9, "Your freenet.ini file is corrupted! 'listenPort=-1'");
        }
        NodeCryptoConfig darknetConfig = new NodeCryptoConfig(nodeConfig, sortOrder++, false, this.securityLevels);
        sortOrder += 3;
        this.darknetCrypto = new NodeCrypto(this, false, darknetConfig, this.startupTime, this.enableARKs);
        this.dnsr = new DNSRequester(this);
        this.ps = new PacketSender(this);
        this.ticker = new PrioritizedTicker(executor, this.getDarknetPortNumber());
        if (executor instanceof PooledExecutor) {
            ((PooledExecutor)executor).setTicker(this.ticker);
        }
        Logger.normal(Node.class, "Creating node...");
        this.shutdownHook.addEarlyJob(new Thread(){

            @Override
            public void run() {
                if (Node.this.opennet != null) {
                    Node.this.opennet.stop(false);
                }
            }
        });
        this.shutdownHook.addEarlyJob(new Thread(){

            @Override
            public void run() {
                Node.this.darknetCrypto.stop();
            }
        });
        nodeConfig.register("outputBandwidthLimit", "15K", sortOrder++, false, true, "Node.outBWLimit", "Node.outBWLimitLong", new IntCallback(){

            @Override
            public Integer get() {
                return Node.this.outputBandwidthLimit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Integer obwLimit) throws InvalidConfigValueException {
                Node.this.checkOutputBandwidthLimit(obwLimit);
                try {
                    Node.this.outputThrottle.changeNanosAndBucketSize(TimeUnit.SECONDS.toNanos(1L) / (long)obwLimit.intValue(), obwLimit / 2);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.outputBandwidthLimit = obwLimit;
                }
            }
        });
        int obwLimit = nodeConfig.getInt("outputBandwidthLimit");
        if (obwLimit < 4096) {
            obwLimit = 4096;
            Logger.normal(Node.class, "Output bandwidth was lower than minimum bandwidth. Increased to minimum bandwidth.");
        }
        this.outputBandwidthLimit = obwLimit;
        try {
            this.checkOutputBandwidthLimit(this.outputBandwidthLimit);
        }
        catch (InvalidConfigValueException e) {
            throw new NodeInitException(26, e.getMessage());
        }
        int bucketSize = obwLimit / 2;
        bucketSize = Math.max(bucketSize, 2048);
        try {
            this.outputThrottle = new TokenBucket(bucketSize, TimeUnit.SECONDS.toNanos(1L) / (long)obwLimit, obwLimit / 2);
        }
        catch (IllegalArgumentException e) {
            throw new NodeInitException(26, e.getMessage());
        }
        nodeConfig.register("inputBandwidthLimit", "-1", sortOrder++, false, true, "Node.inBWLimit", "Node.inBWLimitLong", new IntCallback(){

            @Override
            public Integer get() {
                if (Node.this.inputLimitDefault) {
                    return -1;
                }
                return Node.this.inputBandwidthLimit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Integer ibwLimit) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.checkInputBandwidthLimit(ibwLimit);
                    if (ibwLimit == -1) {
                        Node.this.inputLimitDefault = true;
                        ibwLimit = Node.this.outputBandwidthLimit * 4;
                    } else {
                        Node.this.inputLimitDefault = false;
                    }
                    Node.this.inputBandwidthLimit = ibwLimit;
                }
            }
        });
        int ibwLimit = nodeConfig.getInt("inputBandwidthLimit");
        if (ibwLimit == -1) {
            this.inputLimitDefault = true;
            ibwLimit = obwLimit * 4;
        } else if (ibwLimit < 4096) {
            ibwLimit = 4096;
            Logger.normal(Node.class, "Input bandwidth was lower than minimum bandwidth. Increased to minimum bandwidth.");
        }
        this.inputBandwidthLimit = ibwLimit;
        try {
            this.checkInputBandwidthLimit(this.inputBandwidthLimit);
        }
        catch (InvalidConfigValueException e) {
            throw new NodeInitException(26, e.getMessage());
        }
        nodeConfig.register("throttleLocalTraffic", false, sortOrder++, true, false, "Node.throttleLocalTraffic", "Node.throttleLocalTrafficLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.throttleLocalData;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.throttleLocalData = val;
            }
        });
        this.throttleLocalData = nodeConfig.getBoolean("throttleLocalTraffic");
        String s = "Testnet mode DISABLED. You may have some level of anonymity. :)\nNote that this version of Freenet is still a very early alpha, and may well have numerous bugs and design flaws.\nIn particular: YOU ARE WIDE OPEN TO YOUR IMMEDIATE PEERS! They can eavesdrop on your requests with relatively little difficulty at present (correlation attacks etc).";
        Logger.normal(this, s);
        System.err.println(s);
        File nodeFile = this.nodeDir.file("node-" + this.getDarknetPortNumber());
        File nodeFileBackup = this.nodeDir.file("node-" + this.getDarknetPortNumber() + ".bak");
        try {
            this.readNodeFile(nodeFile.getPath());
        }
        catch (IOException e) {
            try {
                System.err.println("Trying to read node file backup ...");
                this.readNodeFile(nodeFileBackup.getPath());
            }
            catch (IOException e1) {
                if (nodeFile.exists() || nodeFileBackup.exists()) {
                    System.err.println("No node file or cannot read, (re)initialising crypto etc");
                    System.err.println(e1.toString());
                    e1.printStackTrace();
                    System.err.println("After:");
                    System.err.println(e.toString());
                    e.printStackTrace();
                } else {
                    System.err.println("Creating new cryptographic keys...");
                }
                this.initNodeFileSettings();
            }
        }
        this.peers = new PeerManager(this, this.shutdownHook);
        this.tracker = new RequestTracker(this.peers, this.ticker);
        this.dispatcher = new NodeDispatcher(this);
        this.usm.setDispatcher(this.dispatcher);
        this.uptime = new UptimeEstimator(this.runDir, this.ticker, this.darknetCrypto.identityHash);
        this.failureTable = new FailureTable(this);
        this.nodeStats = new NodeStats(this, sortOrder, config.createSubConfig("node.load"), obwLimit, ibwLimit, this.lastVersion);
        this.clientCore = new NodeClientCore(this, config, nodeConfig, installConfig, this.getDarknetPortNumber(), sortOrder, oldConfig, fproxyConfig, this.toadlets, this.databaseKey, persistentSecret);
        this.toadlets.setCore(this.clientCore);
        if (JVMVersion.isTooOld()) {
            this.clientCore.alerts.register(new JVMVersionAlert());
        }
        if (this.showFriendsVisibilityAlert) {
            this.registerFriendsVisibilityAlert();
        }
        System.out.println("Initializing Node Updater");
        try {
            this.nodeUpdater = NodeUpdateManager.maybeCreate(this, config);
        }
        catch (InvalidConfigValueException e) {
            e.printStackTrace();
            throw new NodeInitException(21, "Could not create Updater: " + e);
        }
        SubConfig opennetConfig = config.createSubConfig("node.opennet");
        opennetConfig.register("connectToSeednodes", true, 0, true, false, "Node.withAnnouncement", "Node.withAnnouncementLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.isAllowedToConnectToSeednodes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (this.get().equals(val)) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.isAllowedToConnectToSeednodes = val;
                    if (Node.this.opennet != null) {
                        throw new NodeNeedRestartException(Node.this.l10n("connectToSeednodesCannotBeChangedMustDisableOpennetOrReboot"));
                    }
                }
            }
        });
        this.isAllowedToConnectToSeednodes = opennetConfig.getBoolean("connectToSeednodes");
        opennetConfig.register("enabled", false, 0, true, true, "Node.opennetEnabled", "Node.opennetEnabledLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.opennet != null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                OpennetManager o;
                Node node = Node.this;
                synchronized (node) {
                    if (val == (Node.this.opennet != null)) {
                        return;
                    }
                    if (val.booleanValue()) {
                        try {
                            o = Node.this.opennet = new OpennetManager(Node.this, Node.this.opennetCryptoConfig, System.currentTimeMillis(), Node.this.isAllowedToConnectToSeednodes);
                        }
                        catch (NodeInitException e) {
                            Node.this.opennet = null;
                            throw new InvalidConfigValueException(e.getMessage());
                        }
                    } else {
                        o = Node.this.opennet;
                        Node.this.opennet = null;
                    }
                }
                if (val.booleanValue()) {
                    o.start();
                } else {
                    o.stop(true);
                }
                Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
            }
        });
        boolean opennetEnabled = opennetConfig.getBoolean("enabled");
        opennetConfig.register("maxOpennetPeers", 85, 1, true, false, "Node.maxOpennetPeers", "Node.maxOpennetPeersLong", new IntCallback(){

            @Override
            public Integer get() {
                return Node.this.maxOpennetPeers;
            }

            @Override
            public void set(Integer inputMaxOpennetPeers) throws InvalidConfigValueException {
                if (inputMaxOpennetPeers < 0) {
                    throw new InvalidConfigValueException(Node.this.l10n("mustBePositive"));
                }
                if (inputMaxOpennetPeers > 85) {
                    throw new InvalidConfigValueException(Node.this.l10n("maxOpennetPeersMustBeTwentyOrLess", "maxpeers", Integer.toString(85)));
                }
                Node.this.maxOpennetPeers = inputMaxOpennetPeers;
            }
        }, false);
        this.maxOpennetPeers = opennetConfig.getInt("maxOpennetPeers");
        if (this.maxOpennetPeers > 85) {
            Logger.error(this, "maxOpennetPeers may not be over 85");
            this.maxOpennetPeers = 85;
        }
        this.opennetCryptoConfig = new NodeCryptoConfig(opennetConfig, 2, true, this.securityLevels);
        this.opennet = opennetEnabled ? new OpennetManager(this, this.opennetCryptoConfig, System.currentTimeMillis(), this.isAllowedToConnectToSeednodes) : null;
        this.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.HIGH || newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    OpennetManager om;
                    Node node = Node.this;
                    synchronized (node) {
                        om = Node.this.opennet;
                        if (om != null) {
                            Node.this.opennet = null;
                        }
                    }
                    if (om != null) {
                        om.stop(true);
                        Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
                    }
                } else if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.NORMAL || newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                    OpennetManager o = null;
                    Node node = Node.this;
                    synchronized (node) {
                        if (Node.this.opennet == null) {
                            try {
                                o = Node.this.opennet = new OpennetManager(Node.this, Node.this.opennetCryptoConfig, System.currentTimeMillis(), Node.this.isAllowedToConnectToSeednodes);
                            }
                            catch (NodeInitException e) {
                                Node.this.opennet = null;
                                Logger.error(this, "UNABLE TO ENABLE OPENNET: " + e, (Throwable)e);
                                Node.this.clientCore.alerts.register(new SimpleUserAlert(false, Node.this.l10n("enableOpennetFailedTitle"), Node.this.l10n("enableOpennetFailed", "message", e.getLocalizedMessage()), Node.this.l10n("enableOpennetFailed", "message", e.getLocalizedMessage()), 1));
                            }
                        }
                    }
                    if (o != null) {
                        o.start();
                        Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
                    }
                }
                Node.this.config.store();
            }
        });
        opennetConfig.register("acceptSeedConnections", false, 2, true, true, "Node.acceptSeedConnectionsShort", "Node.acceptSeedConnections", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.acceptSeedConnections;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.acceptSeedConnections = val;
            }
        });
        this.acceptSeedConnections = opennetConfig.getBoolean("acceptSeedConnections");
        if (this.acceptSeedConnections && this.opennet != null) {
            this.opennet.crypto.socket.getAddressTracker().setHugeTracker();
        }
        opennetConfig.finishedInitialization();
        nodeConfig.register("passOpennetPeersThroughDarknet", true, sortOrder++, true, false, "Node.passOpennetPeersThroughDarknet", "Node.passOpennetPeersThroughDarknetLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.passOpennetRefsThroughDarknet;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.passOpennetRefsThroughDarknet = val;
                }
            }
        });
        this.passOpennetRefsThroughDarknet = nodeConfig.getBoolean("passOpennetPeersThroughDarknet");
        this.extraPeerDataDir = this.userDir.file("extra-peer-data-" + this.getDarknetPortNumber());
        if (!(this.extraPeerDataDir.exists() && this.extraPeerDataDir.isDirectory() || this.extraPeerDataDir.mkdir())) {
            String msg = "Could not find or create extra peer data directory";
            throw new NodeInitException(15, msg);
        }
        nodeConfig.register("name", this.myName, sortOrder++, false, true, "Node.nodeName", "Node.nodeNameLong", new NodeNameCallback());
        this.myName = nodeConfig.getString("name");
        nodeConfig.register("storeForceBigShrinks", false, sortOrder++, true, false, "Node.forceBigShrink", "Node.forceBigShrinkLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.storeForceBigShrinks;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.storeForceBigShrinks = val;
                }
            }
        });
        nodeConfig.register("storeType", "ram", sortOrder++, true, true, "Node.storeType", "Node.storeTypeLong", new StoreTypeCallback());
        this.storeType = nodeConfig.getString("storeType");
        nodeConfig.register("storeSize", 0x2000000L, sortOrder++, false, true, "Node.storeSize", "Node.storeSizeLong", new LongCallback(){

            @Override
            public Long get() {
                return Node.this.maxTotalDatastoreSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long storeSize) throws InvalidConfigValueException {
                if (storeSize < 0x2000000L) {
                    throw new InvalidConfigValueException(Node.this.l10n("invalidStoreSize"));
                }
                long newMaxStoreKeys = storeSize / 34988L;
                if (newMaxStoreKeys == Node.this.maxTotalKeys) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.maxTotalDatastoreSize = storeSize;
                    Node.this.maxTotalKeys = newMaxStoreKeys;
                    Node.this.maxStoreKeys = Node.this.maxTotalKeys / 2L;
                    Node.this.maxCacheKeys = Node.this.maxTotalKeys - Node.this.maxStoreKeys;
                }
                try {
                    Node.this.chkDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.chkDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeyDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeyDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                }
                catch (IOException e) {
                    Logger.error(this, "Caught " + e + " resizing the datastore", (Throwable)e);
                    System.err.println("Caught " + e + " resizing the datastore");
                    e.printStackTrace();
                }
                Node.this.nodeStats.avgStoreCHKLocation.changeMaxReports((int)Node.this.maxStoreKeys);
                Node.this.nodeStats.avgCacheCHKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
                Node.this.nodeStats.avgSlashdotCacheCHKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
                Node.this.nodeStats.avgClientCacheCHKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
                Node.this.nodeStats.avgStoreSSKLocation.changeMaxReports((int)Node.this.maxStoreKeys);
                Node.this.nodeStats.avgCacheSSKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
                Node.this.nodeStats.avgSlashdotCacheSSKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
                Node.this.nodeStats.avgClientCacheSSKLocation.changeMaxReports((int)Node.this.maxCacheKeys);
            }
        }, true);
        this.maxTotalDatastoreSize = nodeConfig.getLong("storeSize");
        if (this.maxTotalDatastoreSize < 0x2000000L && !this.storeType.equals("ram")) {
            throw new NodeInitException(13, "Store size too small");
        }
        this.maxTotalKeys = this.maxTotalDatastoreSize / 34988L;
        nodeConfig.register("storeUseSlotFilters", true, sortOrder++, true, false, "Node.storeUseSlotFilters", "Node.storeUseSlotFiltersLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.storeUseSlotFilters;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.storeUseSlotFilters = val;
                }
                throw new NodeNeedRestartException("Need to restart to change storeUseSlotFilters");
            }
        });
        this.storeUseSlotFilters = nodeConfig.getBoolean("storeUseSlotFilters");
        nodeConfig.register("storeSaltHashSlotFilterPersistenceTime", 300000, sortOrder++, true, false, "Node.storeSaltHashSlotFilterPersistenceTime", "Node.storeSaltHashSlotFilterPersistenceTimeLong", new IntCallback(){

            @Override
            public Integer get() {
                return ResizablePersistentIntBuffer.getPersistenceTime();
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < -1) {
                    throw new InvalidConfigValueException(Node.this.l10n("slotFilterPersistenceTimeError"));
                }
                ResizablePersistentIntBuffer.setPersistenceTime(val);
            }
        }, false);
        nodeConfig.register("storeSaltHashResizeOnStart", false, sortOrder++, true, false, "Node.storeSaltHashResizeOnStart", "Node.storeSaltHashResizeOnStartLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.storeSaltHashResizeOnStart;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.storeSaltHashResizeOnStart = val;
            }
        });
        this.storeSaltHashResizeOnStart = nodeConfig.getBoolean("storeSaltHashResizeOnStart");
        this.storeDir = this.setupProgramDir(installConfig, "storeDir", this.userDir().file("datastore").getPath(), "Node.storeDirectory", "Node.storeDirectoryLong", nodeConfig);
        installConfig.finishedInitialization();
        String suffix = this.getStoreSuffix();
        this.maxStoreKeys = this.maxTotalKeys / 2L;
        this.maxCacheKeys = this.maxTotalKeys - this.maxStoreKeys;
        nodeConfig.register("storePreallocate", true, sortOrder++, true, true, "Node.storePreallocate", "Node.storePreallocateLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.storePreallocate;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.storePreallocate = val;
                if (Node.this.storeType.equals("salt-hash")) {
                    this.setPreallocate(Node.this.chkDatastore, val);
                    this.setPreallocate(Node.this.chkDatacache, val);
                    this.setPreallocate(Node.this.pubKeyDatastore, val);
                    this.setPreallocate(Node.this.pubKeyDatacache, val);
                    this.setPreallocate(Node.this.sskDatastore, val);
                    this.setPreallocate(Node.this.sskDatacache, val);
                }
            }

            private void setPreallocate(StoreCallback<?> datastore, boolean val) {
                FreenetStore<?> store = datastore.getStore();
                if (store instanceof SaltedHashFreenetStore) {
                    ((SaltedHashFreenetStore)store).setPreallocate(val);
                }
            }
        });
        this.storePreallocate = nodeConfig.getBoolean("storePreallocate");
        if (File.separatorChar == '/' && System.getProperty("os.name").toLowerCase().indexOf("mac os") < 0) {
            this.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

                @Override
                public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                    try {
                        if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                            nodeConfig.set("storePreallocate", false);
                        } else {
                            nodeConfig.set("storePreallocate", true);
                        }
                    }
                    catch (NodeNeedRestartException nodeNeedRestartException) {
                    }
                    catch (InvalidConfigValueException invalidConfigValueException) {
                        // empty catch block
                    }
                }
            });
        }
        this.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
                    33 var3_3 = this;
                    synchronized (var3_3) {
                        Node.this.clientCacheAwaitingPassword = false;
                        Node.this.databaseAwaitingPassword = false;
                    }
                    try {
                        Node.this.killMasterKeysFile();
                        Node.this.clientCore.clientLayerPersister.disableWrite();
                        Node.this.clientCore.clientLayerPersister.waitForNotWriting();
                        Node.this.clientCore.clientLayerPersister.deleteAllFiles();
                    }
                    catch (IOException e) {
                        Node.this.masterKeysFile.delete();
                        Logger.error(this, "Unable to securely delete " + Node.this.masterKeysFile);
                        System.err.println(NodeL10n.getBase().getString("SecurityLevels.cantDeletePasswordFile", "filename", Node.this.masterKeysFile.getAbsolutePath()));
                        Node.this.clientCore.alerts.register(new SimpleUserAlert(true, NodeL10n.getBase().getString("SecurityLevels.cantDeletePasswordFileTitle"), NodeL10n.getBase().getString("SecurityLevels.cantDeletePasswordFile"), NodeL10n.getBase().getString("SecurityLevels.cantDeletePasswordFileTitle"), 0));
                    }
                }
                if (oldLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM && newLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) {
                    try {
                        MasterKeys keys;
                        33 var4_7 = this;
                        synchronized (var4_7) {
                            keys = Node.this.keys;
                        }
                        keys.changePassword(Node.this.masterKeysFile, "", Node.this.secureRandom);
                    }
                    catch (IOException e) {
                        Logger.error(this, "Unable to create encryption keys file: " + Node.this.masterKeysFile + " : " + e, (Throwable)e);
                        System.err.println("Unable to create encryption keys file: " + Node.this.masterKeysFile + " : " + e);
                        e.printStackTrace();
                    }
                }
            }
        });
        if (this.securityLevels.physicalThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            try {
                this.killMasterKeysFile();
            }
            catch (IOException e) {
                String msg = "Unable to securely delete old master.keys file when switching to MAXIMUM seclevel!!";
                System.err.println(msg);
                throw new NodeInitException(30, msg);
            }
        }
        long defaultCacheSize = (memoryLimit = NodeStarter.getMemoryLimitBytes()) == Long.MAX_VALUE || memoryLimit < 0L ? 0x100000L : (memoryLimit <= 0x8000000L ? 0L : Math.min(0x100000L, (memoryLimit - 0x8000000L) / 180L));
        nodeConfig.register("cachingFreenetStoreMaxSize", defaultCacheSize, sortOrder++, true, false, "Node.cachingFreenetStoreMaxSize", "Node.cachingFreenetStoreMaxSizeLong", new LongCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.cachingFreenetStoreMaxSize;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < 0L) {
                    throw new InvalidConfigValueException(Node.this.l10n("invalidMemoryCacheSize"));
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.cachingFreenetStoreMaxSize = val;
                }
                throw new NodeNeedRestartException("Caching Maximum Size cannot be changed on the fly");
            }
        }, true);
        this.cachingFreenetStoreMaxSize = nodeConfig.getLong("cachingFreenetStoreMaxSize");
        if (this.cachingFreenetStoreMaxSize < 0L) {
            throw new NodeInitException(30, this.l10n("invalidMemoryCacheSize"));
        }
        nodeConfig.register("cachingFreenetStorePeriod", "300k", sortOrder++, true, false, "Node.cachingFreenetStorePeriod", "Node.cachingFreenetStorePeriod", new LongCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.cachingFreenetStorePeriod;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.cachingFreenetStorePeriod = val;
                }
                throw new NodeNeedRestartException("Caching Period cannot be changed on the fly");
            }
        }, true);
        this.cachingFreenetStorePeriod = nodeConfig.getLong("cachingFreenetStorePeriod");
        if (this.cachingFreenetStoreMaxSize > 0L && this.cachingFreenetStorePeriod > 0L) {
            this.cachingFreenetStoreTracker = new CachingFreenetStoreTracker(this.cachingFreenetStoreMaxSize, this.cachingFreenetStorePeriod, this.ticker);
        }
        boolean shouldWriteConfig = false;
        if (this.storeType.equals("bdb-index")) {
            System.err.println("Old format Berkeley DB datastore detected.");
            System.err.println("This datastore format is no longer supported.");
            System.err.println("The old datastore will be securely deleted.");
            this.storeType = "salt-hash";
            shouldWriteConfig = true;
            this.deleteOldBDBIndexStoreFiles();
        }
        if (this.storeType.equals("salt-hash")) {
            this.initRAMFS();
            this.initSaltHashFS(suffix, false, null);
        } else {
            this.initRAMFS();
        }
        if (this.databaseAwaitingPassword) {
            this.createPasswordUserAlert();
        }
        nodeConfig.register("clientCacheType", "ram", sortOrder++, true, true, "Node.clientCacheType", "Node.clientCacheTypeLong", new ClientCacheTypeCallback());
        this.clientCacheType = nodeConfig.getString("clientCacheType");
        nodeConfig.register("clientCacheSize", 0xA00000L, sortOrder++, false, true, "Node.clientCacheSize", "Node.clientCacheSizeLong", new LongCallback(){

            @Override
            public Long get() {
                return Node.this.maxTotalClientCacheSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long storeSize) throws InvalidConfigValueException {
                if (storeSize < 0L) {
                    throw new InvalidConfigValueException(Node.this.l10n("invalidStoreSize"));
                }
                long newMaxStoreKeys = storeSize / 34988L;
                if (newMaxStoreKeys == Node.this.maxClientCacheKeys) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.maxTotalClientCacheSize = storeSize;
                    Node.this.maxClientCacheKeys = newMaxStoreKeys;
                }
                try {
                    Node.this.chkClientcache.setMaxKeys(Node.this.maxClientCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeyClientcache.setMaxKeys(Node.this.maxClientCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskClientcache.setMaxKeys(Node.this.maxClientCacheKeys, Node.this.storeForceBigShrinks);
                }
                catch (IOException e) {
                    Logger.error(this, "Caught " + e + " resizing the clientcache", (Throwable)e);
                    System.err.println("Caught " + e + " resizing the clientcache");
                    e.printStackTrace();
                }
            }
        }, true);
        this.maxTotalClientCacheSize = nodeConfig.getLong("clientCacheSize");
        if (this.maxTotalClientCacheSize < 0L) {
            throw new NodeInitException(13, "Client cache size too small");
        }
        this.maxClientCacheKeys = this.maxTotalClientCacheSize / 34988L;
        boolean startedClientCache = false;
        if (this.clientCacheType.equals("salt-hash")) {
            if (clientCacheKey == null) {
                System.err.println("Cannot open client-cache, it is passworded");
                this.setClientCacheAwaitingPassword();
            } else {
                this.initSaltHashClientCacheFS(suffix, false, clientCacheKey);
                startedClientCache = true;
            }
        } else if (this.clientCacheType.equals("none")) {
            this.initNoClientCacheFS();
            startedClientCache = true;
        } else {
            this.initRAMClientCacheFS();
            startedClientCache = true;
        }
        if (!startedClientCache) {
            this.initRAMClientCacheFS();
        }
        if (!this.clientCore.loadedDatabase() && this.databaseKey != null) {
            try {
                this.lateSetupDatabase(this.databaseKey);
            }
            catch (MasterKeysWrongPasswordException e2) {
                System.err.println("Impossible: " + e2);
                e2.printStackTrace();
            }
            catch (MasterKeysFileSizeException e2) {
                System.err.println("Impossible: " + e2);
                e2.printStackTrace();
            }
            catch (IOException e2) {
                System.err.println("Unable to load database: " + e2);
                e2.printStackTrace();
            }
        }
        nodeConfig.register("useSlashdotCache", true, sortOrder++, true, false, "Node.useSlashdotCache", "Node.useSlashdotCacheLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.useSlashdotCache;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.useSlashdotCache = val;
            }
        });
        this.useSlashdotCache = nodeConfig.getBoolean("useSlashdotCache");
        nodeConfig.register("writeLocalToDatastore", false, sortOrder++, true, false, "Node.writeLocalToDatastore", "Node.writeLocalToDatastoreLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Node.this.writeLocalToDatastore;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.writeLocalToDatastore = val;
            }
        });
        this.writeLocalToDatastore = nodeConfig.getBoolean("writeLocalToDatastore");
        this.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW && Node.this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    Node.this.writeLocalToDatastore = true;
                } else {
                    Node.this.writeLocalToDatastore = false;
                }
            }
        });
        this.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW && Node.this.securityLevels.getNetworkThreatLevel() == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                    Node.this.writeLocalToDatastore = true;
                } else {
                    Node.this.writeLocalToDatastore = false;
                }
            }
        });
        nodeConfig.register("slashdotCacheLifetime", TimeUnit.MINUTES.toMillis(30L), sortOrder++, true, false, "Node.slashdotCacheLifetime", "Node.slashdotCacheLifetimeLong", new LongCallback(){

            @Override
            public Long get() {
                return Node.this.chkSlashdotcacheStore.getLifetime();
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < 0L) {
                    throw new InvalidConfigValueException("Must be positive!");
                }
                Node.this.chkSlashdotcacheStore.setLifetime(val);
                Node.this.pubKeySlashdotcacheStore.setLifetime(val);
                Node.this.sskSlashdotcacheStore.setLifetime(val);
            }
        }, false);
        long slashdotCacheLifetime = nodeConfig.getLong("slashdotCacheLifetime");
        nodeConfig.register("slashdotCacheSize", 0xA00000L, sortOrder++, false, true, "Node.slashdotCacheSize", "Node.slashdotCacheSizeLong", new LongCallback(){

            @Override
            public Long get() {
                return Node.this.maxSlashdotCacheSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Long storeSize) throws InvalidConfigValueException {
                if (storeSize < 0L) {
                    throw new InvalidConfigValueException(Node.this.l10n("invalidStoreSize"));
                }
                int newMaxStoreKeys = (int)Math.min(storeSize / 34988L, Integer.MAX_VALUE);
                if (newMaxStoreKeys == Node.this.maxSlashdotCacheKeys) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.maxSlashdotCacheSize = storeSize;
                    Node.this.maxSlashdotCacheKeys = newMaxStoreKeys;
                }
                try {
                    Node.this.chkSlashdotcache.setMaxKeys(Node.this.maxSlashdotCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeySlashdotcache.setMaxKeys(Node.this.maxSlashdotCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskSlashdotcache.setMaxKeys(Node.this.maxSlashdotCacheKeys, Node.this.storeForceBigShrinks);
                }
                catch (IOException e) {
                    Logger.error(this, "Caught " + e + " resizing the slashdotcache", (Throwable)e);
                    System.err.println("Caught " + e + " resizing the slashdotcache");
                    e.printStackTrace();
                }
            }
        }, true);
        this.maxSlashdotCacheSize = nodeConfig.getLong("slashdotCacheSize");
        if (this.maxSlashdotCacheSize < 0L) {
            throw new NodeInitException(13, "Slashdot cache size too small");
        }
        this.maxSlashdotCacheKeys = (int)Math.min(this.maxSlashdotCacheSize / 34988L, Integer.MAX_VALUE);
        this.chkSlashdotcache = new CHKStore();
        this.chkSlashdotcacheStore = new SlashdotStore<CHKBlock>(this.chkSlashdotcache, this.maxSlashdotCacheKeys, slashdotCacheLifetime, PURGE_INTERVAL, this.ticker, this.clientCore.tempBucketFactory);
        this.pubKeySlashdotcache = new PubkeyStore();
        this.pubKeySlashdotcacheStore = new SlashdotStore<DSAPublicKey>(this.pubKeySlashdotcache, this.maxSlashdotCacheKeys, slashdotCacheLifetime, PURGE_INTERVAL, this.ticker, this.clientCore.tempBucketFactory);
        this.getPubKey.setLocalSlashdotcache(this.pubKeySlashdotcache);
        this.sskSlashdotcache = new SSKStore(this.getPubKey);
        this.sskSlashdotcacheStore = new SlashdotStore<SSKBlock>(this.sskSlashdotcache, this.maxSlashdotCacheKeys, slashdotCacheLifetime, PURGE_INTERVAL, this.ticker, this.clientCore.tempBucketFactory);
        this.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    Node.this.useSlashdotCache = false;
                } else if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    Node.this.useSlashdotCache = true;
                }
            }
        });
        nodeConfig.register("skipWrapperWarning", false, sortOrder++, true, false, "Node.skipWrapperWarning", "Node.skipWrapperWarningLong", new BooleanCallback(){

            @Override
            public void set(Boolean value) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.skipWrapperWarning = value;
            }

            @Override
            public Boolean get() {
                return Node.this.skipWrapperWarning;
            }
        });
        this.skipWrapperWarning = nodeConfig.getBoolean("skipWrapperWarning");
        nodeConfig.register("maxPacketSize", 1280, sortOrder++, true, true, "Node.maxPacketSize", "Node.maxPacketSizeLong", new IntCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.maxPacketSize;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node node = Node.this;
                synchronized (node) {
                    if (val == Node.this.maxPacketSize) {
                        return;
                    }
                    if (val < 576) {
                        throw new InvalidConfigValueException("Must be over 576");
                    }
                    if (val > 1492) {
                        throw new InvalidConfigValueException("Larger than ethernet frame size unlikely to work!");
                    }
                    Node.this.maxPacketSize = val;
                }
                Node.this.updateMTU();
            }
        }, true);
        this.maxPacketSize = nodeConfig.getInt("maxPacketSize");
        nodeConfig.register("enableRoutedPing", false, sortOrder++, true, false, "Node.enableRoutedPing", "Node.enableRoutedPingLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.enableRoutedPing;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.enableRoutedPing = val;
                }
            }
        });
        this.enableRoutedPing = nodeConfig.getBoolean("enableRoutedPing");
        this.updateMTU();
        nodeConfig.finishedInitialization();
        if (shouldWriteConfig) {
            config.store();
        }
        this.writeNodeFile();
        Logger.normal(this, "Initializing Plugin Manager");
        System.out.println("Initializing Plugin Manager");
        this.pluginManager = new PluginManager(this, this.lastVersion);
        this.shutdownHook.addEarlyJob(new NativeThread("Shutdown plugins", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                Node.this.pluginManager.stop(TimeUnit.SECONDS.toMillis(30L));
            }
        });
        WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(2L)));
        FetchContext ctx = this.clientCore.makeClient((short)0, true, false).getFetchContext();
        ctx.allowSplitfiles = false;
        ctx.dontEnterImplicitArchives = true;
        ctx.maxArchiveRestarts = 0;
        ctx.maxMetadataSize = 256;
        ctx.maxNonSplitfileRetries = 10;
        ctx.maxOutputLength = 4096L;
        ctx.maxRecursionLevel = 2;
        ctx.maxTempLength = 4096L;
        this.arkFetcherContext = ctx;
        this.registerNodeToNodeMessageListener(1, this.fproxyN2NMListener);
        this.registerNodeToNodeMessageListener(2, this.diffNoderefListener);
        if (this.toadlets.isEnabled()) {
            this.toadlets.finishStart();
            this.toadlets.createFproxy();
            this.toadlets.removeStartupToadlet();
        }
        Logger.normal(this, "Node constructor completed");
        System.out.println("Node constructor completed");
    }

    private void deleteOldBDBIndexStoreFiles() {
        File[] list;
        File dbDir = this.storeDir.file("database-" + this.getDarknetPortNumber());
        FileUtil.removeAll(dbDir);
        File dir = this.storeDir.dir();
        for (File f : list = dir.listFiles()) {
            String name = f.getName();
            if (!f.isFile() || !name.toLowerCase().matches("((chk)|(ssk)|(pubkey))-[0-9]*\\.((store)|(cache))(\\.((keys)|(lru)))?")) continue;
            System.out.println("Deleting old datastore file \"" + f + "\"");
            try {
                FileUtil.secureDelete(f);
            }
            catch (IOException e) {
                System.err.println("Failed to delete old datastore file \"" + f + "\": " + e);
                e.printStackTrace();
            }
        }
    }

    private void fixCertsFiles() {
        File certs = new File("startssl.pem");
        this.fixCertsFile(certs);
        if (FileUtil.detectedOS.isWindows) {
            certs = new File("updater", "startssl.pem");
            this.fixCertsFile(certs);
        }
    }

    private void fixCertsFile(File certs) {
        long oldLength = certs.exists() ? certs.length() : -1L;
        try {
            File tmpFile = File.createTempFile("startssl.pem", ".tmp", new File("."));
            PluginDownLoaderOfficialHTTPS.writeCertsTo(tmpFile);
            if (FileUtil.renameTo(tmpFile, certs)) {
                long newLength = certs.length();
                if (newLength != oldLength) {
                    System.err.println("Updated " + certs + " so that update scripts will work");
                }
            } else if (certs.length() != tmpFile.length()) {
                System.err.println("Cannot update " + certs + " : last-resort update scripts (in particular update.cmd on Windows) may not work");
                File manual = new File("startssl.pem.new");
                manual.delete();
                if (tmpFile.renameTo(manual)) {
                    System.err.println("Please delete " + certs + " and rename " + manual + " over it");
                } else {
                    tmpFile.delete();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ProgramDirectory setupProgramDir(SubConfig installConfig, String cfgKey, String defaultValue, String shortdesc, String longdesc, String moveErrMsg, SubConfig oldConfig) throws NodeInitException {
        ProgramDirectory dir = new ProgramDirectory(moveErrMsg);
        int sortOrder = ProgramDirectory.nextOrder();
        installConfig.register(cfgKey, defaultValue, sortOrder, true, true, shortdesc, longdesc, dir.getStringCallback());
        String dirName = installConfig.getString(cfgKey);
        try {
            dir.move(dirName);
        }
        catch (IOException e) {
            throw new NodeInitException(15, "could not set up directory: " + longdesc);
        }
        return dir;
    }

    protected ProgramDirectory setupProgramDir(SubConfig installConfig, String cfgKey, String defaultValue, String shortdesc, String longdesc, SubConfig oldConfig) throws NodeInitException {
        return this.setupProgramDir(installConfig, cfgKey, defaultValue, shortdesc, longdesc, null, oldConfig);
    }

    public void lateSetupDatabase(DatabaseKey databaseKey) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        if (this.clientCore.loadedDatabase()) {
            return;
        }
        System.out.println("Starting late database initialisation");
        try {
            if (!this.clientCore.lateInitDatabase(databaseKey)) {
                this.failLateInitDatabase();
            }
        }
        catch (NodeInitException e) {
            this.failLateInitDatabase();
        }
    }

    private void failLateInitDatabase() {
        System.err.println("Failed late initialisation of database, closing...");
    }

    public void killMasterKeysFile() throws IOException {
        MasterKeys.killMasterKeys(this.masterKeysFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientCacheAwaitingPassword() {
        this.createPasswordUserAlert();
        Node node = this;
        synchronized (node) {
            this.clientCacheAwaitingPassword = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDatabaseAwaitingPassword() {
        Node node = this;
        synchronized (node) {
            this.databaseAwaitingPassword = true;
        }
    }

    private void createPasswordUserAlert() {
        this.clientCore.alerts.register(this.masterPasswordUserAlert);
    }

    private void initRAMClientCacheFS() {
        this.chkClientcache = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
        this.pubKeyClientcache = new PubkeyStore();
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
        this.sskClientcache = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskClientcache, (int)Math.min(Integer.MAX_VALUE, this.maxClientCacheKeys));
    }

    private void initNoClientCacheFS() {
        this.chkClientcache = new CHKStore();
        new NullFreenetStore<CHKBlock>(this.chkClientcache);
        this.pubKeyClientcache = new PubkeyStore();
        new NullFreenetStore<DSAPublicKey>(this.pubKeyClientcache);
        this.sskClientcache = new SSKStore(this.getPubKey);
        new NullFreenetStore<SSKBlock>(this.sskClientcache);
    }

    private String getStoreSuffix() {
        return "-" + this.getDarknetPortNumber();
    }

    private void finishInitSaltHashFS(String suffix, NodeClientCore clientCore) {
        if (clientCore.alerts == null) {
            throw new NullPointerException();
        }
        this.chkDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.chkDatacache.getStore().setUserAlertManager(clientCore.alerts);
        this.pubKeyDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.pubKeyDatacache.getStore().setUserAlertManager(clientCore.alerts);
        this.sskDatastore.getStore().setUserAlertManager(clientCore.alerts);
        this.sskDatacache.getStore().setUserAlertManager(clientCore.alerts);
    }

    private void initRAMFS() {
        this.chkDatastore = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.chkDatacache = new CHKStore();
        new RAMFreenetStore<CHKBlock>(this.chkDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
        this.pubKeyDatastore = new PubkeyStore();
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.pubKeyDatacache = new PubkeyStore();
        this.getPubKey.setDataStore(this.pubKeyDatastore, this.pubKeyDatacache);
        new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
        this.sskDatastore = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
        this.sskDatacache = new SSKStore(this.getPubKey);
        new RAMFreenetStore<SSKBlock>(this.sskDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
    }

    private void initSaltHashFS(final String suffix, boolean dontResizeOnStart, byte[] masterKey) throws NodeInitException {
        try {
            final CHKStore chkDatastore = new CHKStore();
            final FreenetStore<CHKBlock> chkDataFS = this.makeStore("CHK", true, chkDatastore, dontResizeOnStart, masterKey);
            final CHKStore chkDatacache = new CHKStore();
            final FreenetStore<CHKBlock> chkCacheFS = this.makeStore("CHK", false, chkDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)chkCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)chkDataFS.getUnderlyingStore());
            final PubkeyStore pubKeyDatastore = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyDataFS = this.makeStore("PUBKEY", true, pubKeyDatastore, dontResizeOnStart, masterKey);
            final PubkeyStore pubKeyDatacache = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyCacheFS = this.makeStore("PUBKEY", false, pubKeyDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)pubkeyCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)pubkeyDataFS.getUnderlyingStore());
            final SSKStore sskDatastore = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskDataFS = this.makeStore("SSK", true, sskDatastore, dontResizeOnStart, masterKey);
            final SSKStore sskDatacache = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskCacheFS = this.makeStore("SSK", false, sskDatacache, dontResizeOnStart, masterKey);
            ((SaltedHashFreenetStore)sskCacheFS.getUnderlyingStore()).setAltStore((SaltedHashFreenetStore)sskDataFS.getUnderlyingStore());
            boolean delay = chkDataFS.start(this.ticker, false) | chkCacheFS.start(this.ticker, false) | pubkeyDataFS.start(this.ticker, false) | pubkeyCacheFS.start(this.ticker, false) | sskDataFS.start(this.ticker, false) | sskCacheFS.start(this.ticker, false);
            if (delay) {
                System.err.println("Delayed init of datastore");
                this.initRAMFS();
                final MigrateOldStoreData migrate = new MigrateOldStoreData(false);
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Starting delayed init of datastore");
                        try {
                            chkDataFS.start(Node.this.ticker, true);
                            chkCacheFS.start(Node.this.ticker, true);
                            pubkeyDataFS.start(Node.this.ticker, true);
                            pubkeyCacheFS.start(Node.this.ticker, true);
                            sskDataFS.start(Node.this.ticker, true);
                            sskCacheFS.start(Node.this.ticker, true);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to start datastore: " + e, (Throwable)e);
                            System.err.println("Failed to start datastore: " + e);
                            e.printStackTrace();
                            return;
                        }
                        Node.this.chkDatastore = chkDatastore;
                        Node.this.chkDatacache = chkDatacache;
                        Node.this.pubKeyDatastore = pubKeyDatastore;
                        Node.this.pubKeyDatacache = pubKeyDatacache;
                        Node.this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                        Node.this.sskDatastore = sskDatastore;
                        Node.this.sskDatacache = sskDatacache;
                        Node.this.finishInitSaltHashFS(suffix, Node.this.clientCore);
                        System.err.println("Finishing delayed init of datastore");
                        migrate.run();
                    }
                }, "Start store", 0L, true, false);
            } else {
                this.chkDatastore = chkDatastore;
                this.chkDatacache = chkDatacache;
                this.pubKeyDatastore = pubKeyDatastore;
                this.pubKeyDatacache = pubKeyDatacache;
                this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                this.sskDatastore = sskDatastore;
                this.sskDatacache = sskDatacache;
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        Node.this.chkDatastore = chkDatastore;
                        Node.this.chkDatacache = chkDatacache;
                        Node.this.pubKeyDatastore = pubKeyDatastore;
                        Node.this.pubKeyDatacache = pubKeyDatacache;
                        Node.this.getPubKey.setDataStore(pubKeyDatastore, pubKeyDatacache);
                        Node.this.sskDatastore = sskDatastore;
                        Node.this.sskDatacache = sskDatacache;
                        Node.this.finishInitSaltHashFS(suffix, Node.this.clientCore);
                    }
                }, "Start store", 0L, true, false);
            }
        }
        catch (IOException e) {
            System.err.println("Could not open store: " + e);
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
    }

    private void initSaltHashClientCacheFS(String suffix, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws NodeInitException {
        try {
            final CHKStore chkClientcache = new CHKStore();
            final FreenetStore<CHKBlock> chkDataFS = this.makeClientcache("CHK", true, chkClientcache, dontResizeOnStart, clientCacheMasterKey);
            final PubkeyStore pubKeyClientcache = new PubkeyStore();
            final FreenetStore<DSAPublicKey> pubkeyDataFS = this.makeClientcache("PUBKEY", true, pubKeyClientcache, dontResizeOnStart, clientCacheMasterKey);
            final SSKStore sskClientcache = new SSKStore(this.getPubKey);
            final FreenetStore<SSKBlock> sskDataFS = this.makeClientcache("SSK", true, sskClientcache, dontResizeOnStart, clientCacheMasterKey);
            boolean delay = chkDataFS.start(this.ticker, false) | pubkeyDataFS.start(this.ticker, false) | sskDataFS.start(this.ticker, false);
            if (delay) {
                System.err.println("Delayed init of client-cache");
                this.initRAMClientCacheFS();
                final MigrateOldStoreData migrate = new MigrateOldStoreData(true);
                this.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Starting delayed init of client-cache");
                        try {
                            chkDataFS.start(Node.this.ticker, true);
                            pubkeyDataFS.start(Node.this.ticker, true);
                            sskDataFS.start(Node.this.ticker, true);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to start client-cache: " + e, (Throwable)e);
                            System.err.println("Failed to start client-cache: " + e);
                            e.printStackTrace();
                            return;
                        }
                        Node.this.chkClientcache = chkClientcache;
                        Node.this.pubKeyClientcache = pubKeyClientcache;
                        Node.this.getPubKey.setLocalDataStore(pubKeyClientcache);
                        Node.this.sskClientcache = sskClientcache;
                        System.err.println("Finishing delayed init of client-cache");
                        migrate.run();
                    }
                }, "Migrate store", 0L, true, false);
            } else {
                this.chkClientcache = chkClientcache;
                this.pubKeyClientcache = pubKeyClientcache;
                this.getPubKey.setLocalDataStore(pubKeyClientcache);
                this.sskClientcache = sskClientcache;
            }
        }
        catch (IOException e) {
            System.err.println("Could not open store: " + e);
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
    }

    private <T extends StorableBlock> FreenetStore<T> makeClientcache(String type, boolean isStore, StoreCallback<T> cb, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws IOException {
        FreenetStore<T> store = this.makeStore(type, "clientcache", this.maxClientCacheKeys, cb, dontResizeOnStart, clientCacheMasterKey);
        return store;
    }

    private <T extends StorableBlock> FreenetStore<T> makeStore(String type, boolean isStore, StoreCallback<T> cb, boolean dontResizeOnStart, byte[] clientCacheMasterKey) throws IOException {
        String store = isStore ? "store" : "cache";
        long maxKeys = isStore ? this.maxStoreKeys : this.maxCacheKeys;
        return this.makeStore(type, store, maxKeys, cb, dontResizeOnStart, clientCacheMasterKey);
    }

    private <T extends StorableBlock> FreenetStore<T> makeStore(String type, String store, long maxKeys, StoreCallback<T> cb, boolean lateStart, byte[] clientCacheMasterKey) throws IOException {
        Logger.normal(this, "Initializing " + type + " Data" + store);
        System.out.println("Initializing " + type + " Data" + store + " (" + this.maxStoreKeys + " keys)");
        SaltedHashFreenetStore<T> fs = SaltedHashFreenetStore.construct(this.getStoreDir(), type + "-" + store, cb, this.random, maxKeys, this.storeUseSlotFilters, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart && !lateStart, lateStart ? this.ticker : null, clientCacheMasterKey);
        cb.setStore(fs);
        if (this.cachingFreenetStoreMaxSize > 0L) {
            return new CachingFreenetStore<T>(cb, fs, this.cachingFreenetStoreTracker);
        }
        return fs;
    }

    public void start(boolean noSwaps) throws NodeInitException {
        this.peers.tryReadPeers(this.nodeDir.file("peers-" + this.getDarknetPortNumber()).getPath(), this.darknetCrypto, null, false, false);
        this.peers.updatePMUserAlert();
        this.dispatcher.start(this.nodeStats);
        this.dnsr.start();
        this.peers.start();
        this.nodeStats.start();
        this.uptime.start();
        this.failureTable.start();
        this.darknetCrypto.start();
        if (this.opennet != null) {
            this.opennet.start();
        }
        this.ps.start(this.nodeStats);
        this.ticker.start();
        this.scheduleVersionTransition();
        this.usm.start(this.ticker);
        if (this.isUsingWrapper()) {
            Logger.normal(this, "Using wrapper correctly: " + nodeStarter);
            System.out.println("Using wrapper correctly: " + nodeStarter);
        } else {
            Logger.error(this, "NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
            System.out.println("NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
        }
        Logger.normal(this, "Freenet 0.7.5 Build #" + Version.buildNumber() + " r" + Version.cvsRevision());
        System.out.println("Freenet 0.7.5 Build #" + Version.buildNumber() + " r" + Version.cvsRevision());
        Logger.normal(this, "FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        System.out.println("FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        this.ipDetector.start();
        this.lm.start();
        try {
            Logger.normal(this, "Starting the node updater");
            this.nodeUpdater.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeInitException(21, "Could not start Updater: " + e);
        }
        this.checkForEvilJVMBugs();
        if (!NativeThread.HAS_ENOUGH_NICE_LEVELS) {
            this.clientCore.alerts.register(new NotEnoughNiceLevelsUserAlert());
        }
        this.clientCore.start(this.config);
        this.tracker.startDeadUIDChecker();
        if (this.config instanceof FreenetFilePersistentConfig) {
            FreenetFilePersistentConfig cfg = (FreenetFilePersistentConfig)this.config;
            cfg.finishedInit(this.ticker);
            cfg.setHasNodeStarted();
        }
        this.config.store();
        this.peers.readExtraPeerData();
        Logger.normal(this, "Started node");
        this.hasStarted = true;
    }

    private void scheduleVersionTransition() {
        long transition;
        long now = System.currentTimeMillis();
        if (now < (transition = Version.transitionTime())) {
            this.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    Logger.OSThread.logPID(this);
                    for (PeerNode pn : Node.this.peers.myPeers()) {
                        pn.updateVersionRoutablity();
                    }
                }
            }, transition - now);
        }
    }

    private void checkForEvilJVMBugs() {
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmSpecVendor = System.getProperty("java.specification.vendor", "");
        String javaVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        boolean isOpenJDK = false;
        if (logMINOR) {
            Logger.minor(this, "JVM vendor: " + jvmVendor + ", JVM name: " + jvmName + ", JVM version: " + javaVersion + ", OS name: " + osName + ", OS version: " + osVersion);
        }
        if (jvmName.startsWith("OpenJDK ")) {
            isOpenJDK = true;
        }
        if (!isOpenJDK && (jvmVendor.startsWith("Sun ") || jvmVendor.startsWith("Oracle ")) || jvmVendor.startsWith("The FreeBSD Foundation") && (jvmSpecVendor.startsWith("Sun ") || jvmSpecVendor.startsWith("Oracle ")) || jvmVendor.startsWith("Apple ")) {
            boolean is150 = javaVersion.startsWith("1.5.0_");
            boolean is160 = javaVersion.startsWith("1.6.0_");
            if (is150 || is160) {
                String[] split = javaVersion.split("_");
                String secondPart = split[1];
                if (secondPart.indexOf("-") != -1) {
                    split = secondPart.split("-");
                    secondPart = split[0];
                }
                int subver = Integer.parseInt(secondPart);
                Logger.minor(this, "JVM version: " + javaVersion + " subver: " + subver + " from " + secondPart);
            }
        } else if (!jvmVendor.startsWith("Apple ") && !jvmVendor.startsWith("\"Apple ") && !isOpenJDK && jvmVendor.startsWith("Free Software Foundation")) {
            try {
                javaVersion = System.getProperty("java.version").split(" ")[0].replaceAll("[.]", "");
                int jvmVersionInt = Integer.parseInt(javaVersion);
                if (jvmVersionInt <= 422 && jvmVersionInt >= 100) {
                    jvmHasGCJCharConversionBug = true;
                }
            }
            catch (Throwable t) {
                Logger.error(this, "GCJ version check is broken!", t);
            }
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("usingGCJTitle"), this.l10n("usingGCJ"), this.l10n("usingGCJTitle"), 2));
        }
        if (!this.isUsingWrapper() && !this.skipWrapperWarning) {
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("notUsingWrapperTitle"), this.l10n("notUsingWrapper"), this.l10n("notUsingWrapperShort"), 2));
        }
    }

    public static boolean checkForGCJCharConversionBug() {
        return jvmHasGCJCharConversionBug;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("Node." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("Node." + key, pattern, value);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("Node." + key, pattern, value);
    }

    public SimpleFieldSet exportVolatileFieldSet() {
        return this.nodeStats.exportVolatileFieldSet();
    }

    public int routedPing(double loc2, byte[] pubKeyHash) {
        long uid = this.random.nextLong();
        int initialX = this.random.nextInt();
        Message m = DMT.createFNPRoutedPing(uid, loc2, this.maxHTL, initialX, pubKeyHash);
        Logger.normal(this, "Message: " + m);
        this.dispatcher.handleRouted(m, null);
        MessageFilter mf1 = MessageFilter.create().setField("uid", uid).setType(DMT.FNPRoutedPong).setTimeout(5000L);
        try {
            m = this.usm.waitFor(mf1, null);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "Disconnected in waiting for pong");
            return -1;
        }
        if (m == null) {
            return -1;
        }
        if (m.getSpec() == DMT.FNPRoutedRejected) {
            return -1;
        }
        return m.getInt("counter") - initialX;
    }

    private KeyBlock makeRequestLocal(Key key, long uid, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean offersOnly) {
        KeyBlock kb = null;
        if (key instanceof NodeCHK) {
            kb = this.fetch(key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, null);
        } else if (key instanceof NodeSSK) {
            NodeSSK sskKey = (NodeSSK)key;
            DSAPublicKey pubKey = sskKey.getPubKey();
            if (pubKey == null) {
                pubKey = this.getPubKey.getKey(sskKey.getPubKeyHash(), canReadClientCache, offersOnly, null);
                if (logMINOR) {
                    Logger.minor(this, "Fetched pubkey: " + pubKey);
                }
                try {
                    sskKey.setPubKey(pubKey);
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Error setting pubkey: " + e, (Throwable)e);
                }
            }
            if (pubKey != null) {
                if (logMINOR) {
                    Logger.minor(this, "Got pubkey: " + pubKey);
                }
                kb = this.fetch(sskKey, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
            } else if (logMINOR) {
                Logger.minor(this, "Not found because no pubkey: " + uid);
            }
        } else {
            throw new IllegalStateException("Unknown key type: " + key.getClass());
        }
        if (kb != null) {
            if (this.clientCore != null && this.clientCore.requestStarters != null) {
                if (kb instanceof CHKBlock) {
                    this.clientCore.requestStarters.chkFetchSchedulerBulk.tripPendingKey(kb);
                    this.clientCore.requestStarters.chkFetchSchedulerRT.tripPendingKey(kb);
                } else {
                    this.clientCore.requestStarters.sskFetchSchedulerBulk.tripPendingKey(kb);
                    this.clientCore.requestStarters.sskFetchSchedulerRT.tripPendingKey(kb);
                }
            }
            this.failureTable.onFound(kb);
            return kb;
        }
        return null;
    }

    public Object makeRequestSender(Key key, short htl, long uid, RequestTag tag, PeerNode source, boolean localOnly, boolean ignoreStore, boolean offersOnly, boolean canReadClientCache, boolean canWriteClientCache, boolean realTimeFlag) {
        RequestSender sender;
        KeyBlock kb;
        boolean canWriteDatastore = this.canWriteDatastoreRequest(htl);
        if (logMINOR) {
            Logger.minor(this, "makeRequestSender(" + key + ',' + htl + ',' + uid + ',' + source + ") on " + this.getDarknetPortNumber());
        }
        if (!ignoreStore && (kb = this.makeRequestLocal(key, uid, canReadClientCache, canWriteClientCache, canWriteDatastore, offersOnly)) != null) {
            return kb;
        }
        if (localOnly) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Not in store locally");
        }
        RequestSender requestSender = sender = key instanceof NodeCHK ? this.tracker.getTransferringRequestSenderByKey((NodeCHK)key, realTimeFlag) : null;
        if (sender != null) {
            if (logMINOR) {
                Logger.minor(this, "Data already being transferred: " + sender);
            }
            sender.setTransferCoalesced();
            tag.setSender(sender, true);
            return sender;
        }
        if (htl == 0) {
            if (logMINOR) {
                Logger.minor(this, "No HTL");
            }
            return null;
        }
        sender = new RequestSender(key, null, htl, uid, tag, this, source, offersOnly, canWriteClientCache, canWriteDatastore, realTimeFlag);
        tag.setSender(sender, false);
        sender.start();
        if (logMINOR) {
            Logger.minor(this, "Created new sender: " + sender);
        }
        return sender;
    }

    boolean canWriteDatastoreRequest(short htl) {
        return htl <= this.maxHTL - 2;
    }

    boolean canWriteDatastoreInsert(short htl) {
        return htl <= this.maxHTL - 3;
    }

    public KeyBlock fetch(Key key, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        if (key instanceof NodeSSK) {
            return this.fetch((NodeSSK)key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, forULPR, meta);
        }
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, false, canReadClientCache, canWriteClientCache, canWriteDatastore, forULPR, meta);
        }
        throw new IllegalArgumentException();
    }

    public SSKBlock fetch(NodeSSK key, boolean dontPromote, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        boolean ignoreOldBlocks;
        SSKBlock block;
        double loc = key.toNormalizedDouble();
        double dist = Location.distance(this.lm.getLocation(), loc);
        if (canReadClientCache) {
            try {
                block = this.sskClientcache.fetch(key, dontPromote || !canWriteClientCache, canReadClientCache, forULPR, false, meta);
                if (block != null) {
                    this.nodeStats.avgClientCacheSSKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestClientCacheSSKSuccess) {
                        this.nodeStats.furthestClientCacheSSKSuccess = dist;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "Found key " + key + " in client-cache");
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from client cache: " + e, (Throwable)e);
            }
        }
        if (forULPR || this.useSlashdotCache || canReadClientCache) {
            try {
                block = this.sskSlashdotcache.fetch(key, dontPromote, canReadClientCache, forULPR, false, meta);
                if (block != null) {
                    this.nodeStats.avgSlashdotCacheSSKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestSlashdotCacheSSKSuccess) {
                        this.nodeStats.furthestSlashdotCacheSSKSuccess = dist;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "Found key " + key + " in slashdot-cache");
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from slashdot/ULPR cache: " + e, (Throwable)e);
            }
        }
        boolean bl = ignoreOldBlocks = !this.writeLocalToDatastore;
        if (canReadClientCache) {
            ignoreOldBlocks = false;
        }
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            SSKStore store;
            this.nodeStats.avgRequestLocation.report(loc);
            SSKBlock block2 = this.sskDatastore.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldSSK) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgStoreSSKSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreSSKSuccess) {
                    this.nodeStats.furthestStoreSSKSuccess = dist;
                }
                if (logDEBUG) {
                    Logger.debug(this, "Found key " + key + " in store");
                }
                return block2;
            }
            block2 = this.sskDatacache.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldSSKCache) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, canReadClientCache, forULPR, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgCacheSSKSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheSSKSuccess) {
                    this.nodeStats.furthestCacheSSKSuccess = dist;
                }
                if (logDEBUG) {
                    Logger.debug(this, "Found key " + key + " in cache");
                }
            }
            return block2;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, (Throwable)e);
            return null;
        }
    }

    public CHKBlock fetch(NodeCHK key, boolean dontPromote, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, BlockMetadata meta) {
        boolean ignoreOldBlocks;
        CHKBlock block;
        double loc = key.toNormalizedDouble();
        double dist = Location.distance(this.lm.getLocation(), loc);
        if (canReadClientCache) {
            try {
                block = this.chkClientcache.fetch(key, dontPromote || !canWriteClientCache, false, meta);
                if (block != null) {
                    this.nodeStats.avgClientCacheCHKSuccess.report(loc);
                    if (dist > this.nodeStats.furthestClientCacheCHKSuccess) {
                        this.nodeStats.furthestClientCacheCHKSuccess = dist;
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from client cache: " + e, (Throwable)e);
            }
        }
        if (forULPR || this.useSlashdotCache || canReadClientCache) {
            try {
                block = this.chkSlashdotcache.fetch(key, dontPromote, false, meta);
                if (block != null) {
                    this.nodeStats.avgSlashdotCacheCHKSucess.report(loc);
                    if (dist > this.nodeStats.furthestSlashdotCacheCHKSuccess) {
                        this.nodeStats.furthestSlashdotCacheCHKSuccess = dist;
                    }
                    return block;
                }
            }
            catch (IOException e) {
                Logger.error(this, "Could not read from slashdot/ULPR cache: " + e, (Throwable)e);
            }
        }
        boolean bl = ignoreOldBlocks = !this.writeLocalToDatastore;
        if (canReadClientCache) {
            ignoreOldBlocks = false;
        }
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            CHKStore store;
            this.nodeStats.avgRequestLocation.report(loc);
            CHKBlock block2 = this.chkDatastore.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldCHK) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgStoreCHKSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreCHKSuccess) {
                    this.nodeStats.furthestStoreCHKSuccess = dist;
                }
                return block2;
            }
            block2 = this.chkDatacache.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            if (block2 == null && (store = this.oldCHKCache) != null) {
                block2 = store.fetch(key, dontPromote || !canWriteDatastore, ignoreOldBlocks, meta);
            }
            if (block2 != null) {
                this.nodeStats.avgCacheCHKSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheCHKSuccess) {
                    this.nodeStats.furthestCacheCHKSuccess = dist;
                }
            }
            return block2;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, (Throwable)e);
            return null;
        }
    }

    CHKStore getChkDatacache() {
        return this.chkDatacache;
    }

    CHKStore getChkDatastore() {
        return this.chkDatastore;
    }

    SSKStore getSskDatacache() {
        return this.sskDatacache;
    }

    SSKStore getSskDatastore() {
        return this.sskDatastore;
    }

    CHKStore getChkSlashdotCache() {
        return this.chkSlashdotcache;
    }

    CHKStore getChkClientCache() {
        return this.chkClientcache;
    }

    SSKStore getSskSlashdotCache() {
        return this.sskSlashdotcache;
    }

    SSKStore getSskClientCache() {
        return this.sskClientcache;
    }

    public Map<DataStoreInstanceType, DataStoreStats> getDataStoreStats() {
        LinkedHashMap<DataStoreInstanceType, DataStoreStats> map = new LinkedHashMap<DataStoreInstanceType, DataStoreStats>();
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.STORE), new StoreCallbackStats(this.chkDatastore, this.nodeStats.chkStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.CACHE), new StoreCallbackStats(this.chkDatacache, this.nodeStats.chkCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.SLASHDOT), new StoreCallbackStats(this.chkSlashdotcache, this.nodeStats.chkSlashDotCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.CHK, DataStoreType.CLIENT), new StoreCallbackStats(this.chkClientcache, this.nodeStats.chkClientCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.STORE), new StoreCallbackStats(this.sskDatastore, this.nodeStats.sskStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.CACHE), new StoreCallbackStats(this.sskDatacache, this.nodeStats.sskCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.SLASHDOT), new StoreCallbackStats(this.sskSlashdotcache, this.nodeStats.sskSlashDotCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.SSK, DataStoreType.CLIENT), new StoreCallbackStats(this.sskClientcache, this.nodeStats.sskClientCacheStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.STORE), new StoreCallbackStats(this.pubKeyDatastore, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.CACHE), new StoreCallbackStats(this.pubKeyDatacache, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.SLASHDOT), new StoreCallbackStats(this.pubKeySlashdotcache, new NotAvailNodeStoreStats()));
        map.put(new DataStoreInstanceType(DataStoreKeyType.PUB_KEY, DataStoreType.CLIENT), new StoreCallbackStats(this.pubKeyClientcache, new NotAvailNodeStoreStats()));
        return map;
    }

    public long getMaxTotalKeys() {
        return this.maxTotalKeys;
    }

    public void dumpStoreHits() {
        long now = System.currentTimeMillis();
        if (now - this.timeLastDumpedHits <= 5000L) {
            return;
        }
        this.timeLastDumpedHits = now;
        Logger.minor(this, "Distribution of hits and misses over stores:\nCHK Datastore: " + this.chkDatastore.hits() + '/' + (this.chkDatastore.hits() + this.chkDatastore.misses()) + '/' + this.chkDatastore.keyCount() + "\nCHK Datacache: " + this.chkDatacache.hits() + '/' + (this.chkDatacache.hits() + this.chkDatacache.misses()) + '/' + this.chkDatacache.keyCount() + "\nSSK Datastore: " + this.sskDatastore.hits() + '/' + (this.sskDatastore.hits() + this.sskDatastore.misses()) + '/' + this.sskDatastore.keyCount() + "\nSSK Datacache: " + this.sskDatacache.hits() + '/' + (this.sskDatacache.hits() + this.sskDatacache.misses()) + '/' + this.sskDatacache.keyCount());
    }

    public void storeShallow(CHKBlock block, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) {
        this.store(block, false, canWriteClientCache, canWriteDatastore, forULPR);
    }

    public void store(KeyBlock block, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) throws KeyCollisionException {
        if (block instanceof CHKBlock) {
            this.store((CHKBlock)block, deep, canWriteClientCache, canWriteDatastore, forULPR);
        } else if (block instanceof SSKBlock) {
            this.store((SSKBlock)block, deep, false, canWriteClientCache, canWriteDatastore, forULPR);
        } else {
            throw new IllegalArgumentException("Unknown keytype ");
        }
    }

    private void store(CHKBlock block, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) {
        try {
            double loc = block.getKey().toNormalizedDouble();
            if (canWriteClientCache) {
                this.chkClientcache.put(block, false);
                this.nodeStats.avgClientCacheCHKLocation.report(loc);
            }
            if ((forULPR || this.useSlashdotCache) && !canWriteDatastore && !this.writeLocalToDatastore) {
                this.chkSlashdotcache.put(block, false);
                this.nodeStats.avgSlashdotCacheCHKLocation.report(loc);
            }
            if (canWriteDatastore || this.writeLocalToDatastore) {
                if (deep) {
                    this.chkDatastore.put(block, !canWriteDatastore);
                    this.nodeStats.avgStoreCHKLocation.report(loc);
                }
                this.chkDatacache.put(block, !canWriteDatastore);
                this.nodeStats.avgCacheCHKLocation.report(loc);
            }
            if (canWriteDatastore || forULPR || this.useSlashdotCache) {
                this.failureTable.onFound(block);
            }
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, (Throwable)e);
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.chkFetchSchedulerBulk.tripPendingKey(block);
            this.clientCore.requestStarters.chkFetchSchedulerRT.tripPendingKey(block);
        }
    }

    public void storeInsert(SSKBlock block, boolean deep, boolean overwrite, boolean canWriteClientCache, boolean canWriteDatastore) throws KeyCollisionException {
        this.store(block, deep, overwrite, canWriteClientCache, canWriteDatastore, false);
    }

    public void storeShallow(SSKBlock block, boolean canWriteClientCache, boolean canWriteDatastore, boolean fromULPR) throws KeyCollisionException {
        this.store(block, false, canWriteClientCache, canWriteDatastore, fromULPR);
    }

    public void store(SSKBlock block, boolean deep, boolean overwrite, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR) throws KeyCollisionException {
        try {
            double loc = block.getKey().toNormalizedDouble();
            this.getPubKey.cacheKey(block.getKey().getPubKeyHash(), block.getKey().getPubKey(), deep, canWriteClientCache, canWriteDatastore, forULPR || this.useSlashdotCache, this.writeLocalToDatastore);
            if (canWriteClientCache) {
                this.sskClientcache.put(block, overwrite, false);
                this.nodeStats.avgClientCacheSSKLocation.report(loc);
            }
            if ((forULPR || this.useSlashdotCache) && !canWriteDatastore && !this.writeLocalToDatastore) {
                this.sskSlashdotcache.put(block, overwrite, false);
                this.nodeStats.avgSlashdotCacheSSKLocation.report(loc);
            }
            if (canWriteDatastore || this.writeLocalToDatastore) {
                if (deep) {
                    this.sskDatastore.put(block, overwrite, !canWriteDatastore);
                    this.nodeStats.avgStoreSSKLocation.report(loc);
                }
                this.sskDatacache.put(block, overwrite, !canWriteDatastore);
                this.nodeStats.avgCacheSSKLocation.report(loc);
            }
            if (canWriteDatastore || forULPR || this.useSlashdotCache) {
                this.failureTable.onFound(block);
            }
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, (Throwable)e);
        }
        catch (KeyCollisionException e) {
            throw e;
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.sskFetchSchedulerBulk.tripPendingKey(block);
            this.clientCore.requestStarters.sskFetchSchedulerRT.tripPendingKey(block);
        }
    }

    public short decrementHTL(PeerNode source, short htl) {
        if (source != null) {
            return source.decrementHTL(htl);
        }
        if (htl >= this.maxHTL) {
            htl = this.maxHTL;
        }
        if (htl <= 0) {
            return 0;
        }
        if (htl == this.maxHTL) {
            if (this.decrementAtMax || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        if (htl == 1) {
            if (this.decrementAtMin || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        htl = (short)(htl - 1);
        return htl;
    }

    public CHKInsertSender makeInsertSender(NodeCHK key, short htl, long uid, InsertTag tag, PeerNode source, byte[] headers, PartiallyReceivedBlock prb, boolean fromStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        if (logMINOR) {
            Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        }
        CHKInsertSender is = null;
        is = new CHKInsertSender(key, uid, tag, headers, htl, source, this, prb, fromStore, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        is.start();
        return is;
    }

    public SSKInsertSender makeInsertSender(SSKBlock block, short htl, long uid, InsertTag tag, PeerNode source, boolean fromStore, boolean canWriteClientCache, boolean canWriteDatastore, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        NodeSSK key = block.getKey();
        if (key.getPubKey() == null) {
            throw new IllegalArgumentException("No pub key when inserting");
        }
        this.getPubKey.cacheKey(key.getPubKeyHash(), key.getPubKey(), false, canWriteClientCache, canWriteDatastore, false, this.writeLocalToDatastore);
        Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        SSKInsertSender is = null;
        is = new SSKInsertSender(block, uid, tag, htl, source, this, fromStore, canWriteClientCache, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
        is.start();
        return is;
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getStatus());
        } else {
            sb.append("No peers yet");
        }
        sb.append(this.tracker.getNumTransferringRequestSenders());
        sb.append('\n');
        return sb.toString();
    }

    public String getTMCIPeerList() {
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getTMCIPeerList());
        } else {
            sb.append("No peers yet");
        }
        return sb.toString();
    }

    public ClientKeyBlock fetchKey(ClientKey key, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws KeyVerifyException {
        if (key instanceof ClientCHK) {
            return this.fetch((ClientCHK)key, canReadClientCache, canWriteClientCache, canWriteDatastore);
        }
        if (key instanceof ClientSSK) {
            return this.fetch((ClientSSK)key, canReadClientCache, canWriteClientCache, canWriteDatastore);
        }
        throw new IllegalStateException("Don't know what to do with " + key);
    }

    public ClientKeyBlock fetch(ClientSSK clientSSK, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws SSKVerifyException {
        DSAPublicKey key = clientSSK.getPubKey();
        if (key == null) {
            key = this.getPubKey.getKey(clientSSK.pubKeyHash, canReadClientCache, false, null);
        }
        if (key == null) {
            return null;
        }
        clientSSK.setPublicKey(key);
        SSKBlock block = this.fetch((NodeSSK)clientSSK.getNodeKey(true), false, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
        if (block == null) {
            if (logMINOR) {
                Logger.minor(this, "Could not find key for " + clientSSK);
            }
            return null;
        }
        this.getPubKey.cacheKey(clientSSK.pubKeyHash, key, false, canWriteClientCache, canWriteDatastore, false, this.writeLocalToDatastore);
        return ClientSSKBlock.construct(block, clientSSK);
    }

    private ClientKeyBlock fetch(ClientCHK clientCHK, boolean canReadClientCache, boolean canWriteClientCache, boolean canWriteDatastore) throws CHKVerifyException {
        CHKBlock block = this.fetch(clientCHK.getNodeCHK(), false, canReadClientCache, canWriteClientCache, canWriteDatastore, false, null);
        if (block == null) {
            return null;
        }
        return new ClientCHKBlock(block, clientCHK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int reason) {
        try {
            this.park();
            System.out.println("Goodbye.");
            System.out.println(reason);
        }
        finally {
            System.exit(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(String reason) {
        try {
            this.park();
            System.out.println("Goodbye. from " + this + " (" + reason + ')');
        }
        finally {
            System.exit(0);
        }
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void park() {
        Node node = this;
        synchronized (node) {
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        try {
            Message msg = DMT.createFNPDisconnect(false, false, -1, new ShortBuffer(new byte[0]));
            this.peers.localBroadcast(msg, true, false, this.peers.ctrDisconn);
        }
        catch (Throwable t) {
            try {
                Logger.error(this, "Failed to tell peers we are going down: " + t, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.config.store();
        if (this.random instanceof PersistentRandomSource) {
            ((PersistentRandomSource)((Object)this.random)).write_seed(true);
        }
    }

    public NodeUpdateManager getNodeUpdater() {
        return this.nodeUpdater;
    }

    public DarknetPeerNode[] getDarknetConnections() {
        return this.peers.getDarknetPeers();
    }

    public boolean addPeerConnection(PeerNode pn) {
        boolean retval = this.peers.addPeer(pn);
        this.peers.writePeersUrgent(pn.isOpennet());
        return retval;
    }

    public void removePeerConnection(PeerNode pn) {
        this.peers.disconnectAndRemove(pn, true, false, false);
    }

    public void onConnectedPeer() {
        if (logMINOR) {
            Logger.minor(this, "onConnectedPeer()");
        }
        this.ipDetector.onConnectedPeer();
    }

    public int getFNPPort() {
        return this.getDarknetPortNumber();
    }

    public boolean isOudated() {
        return this.peers.isOutdated();
    }

    public synchronized void registerNodeToNodeMessageListener(int type, NodeToNodeMessageListener listener) {
        this.n2nmListeners.put(type, listener);
    }

    public void receivedNodeToNodeMessage(Message m, PeerNode src) {
        int type = (Integer)m.getObject("nodeToNodeMessageType");
        ShortBuffer messageData = (ShortBuffer)m.getObject("nodeToNodeMessageData");
        this.receivedNodeToNodeMessage(src, type, messageData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNodeToNodeMessage(PeerNode src, int type, ShortBuffer messageData, boolean partingMessage) {
        boolean fromDarknet = src instanceof DarknetPeerNode;
        NodeToNodeMessageListener listener = null;
        Node node = this;
        synchronized (node) {
            listener = this.n2nmListeners.get(type);
        }
        if (listener == null) {
            Logger.error(this, "Unknown n2nm ID: " + type + " - discarding packet length " + messageData.getLength());
            return;
        }
        listener.handleMessage(messageData.getData(), fromDarknet, src, type);
    }

    public void handleNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        if (logMINOR) {
            Logger.minor(this, "Got node to node message: \n" + fs);
        }
        int overallType = fs.getInt("n2nType");
        fs.removeValue("n2nType");
        if (overallType == 1) {
            this.handleFproxyNodeToNodeTextMessageSimpleFieldSet(fs, source, fileNumber);
        } else {
            Logger.error(this, "Received unknown node to node message type '" + overallType + "' from " + source.getPeer());
        }
    }

    private void handleFproxyNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        int type = fs.getInt("type");
        if (type == 1) {
            source.handleFproxyN2NTM(fs, fileNumber);
        } else if (type == 2) {
            source.handleFproxyFileOffer(fs, fileNumber);
        } else if (type == 3) {
            source.handleFproxyFileOfferAccepted(fs, fileNumber);
        } else if (type == 4) {
            source.handleFproxyFileOfferRejected(fs, fileNumber);
        } else if (type == 5) {
            source.handleFproxyBookmarkFeed(fs, fileNumber);
        } else if (type == 6) {
            source.handleFproxyDownloadFeed(fs, fileNumber);
        } else {
            Logger.error(this, "Received unknown fproxy node to node message sub-type '" + type + "' from " + source.getPeer());
        }
    }

    public String getMyName() {
        return this.myName;
    }

    public MessageCore getUSM() {
        return this.usm;
    }

    public LocationManager getLocationManager() {
        return this.lm;
    }

    public int getSwaps() {
        return LocationManager.swaps;
    }

    public int getNoSwaps() {
        return LocationManager.noSwaps;
    }

    public int getStartedSwaps() {
        return LocationManager.startedSwaps;
    }

    public int getSwapsRejectedAlreadyLocked() {
        return LocationManager.swapsRejectedAlreadyLocked;
    }

    public int getSwapsRejectedNowhereToGo() {
        return LocationManager.swapsRejectedNowhereToGo;
    }

    public int getSwapsRejectedRateLimit() {
        return LocationManager.swapsRejectedRateLimit;
    }

    public int getSwapsRejectedRecognizedID() {
        return LocationManager.swapsRejectedRecognizedID;
    }

    public PeerNode[] getPeerNodes() {
        return this.peers.myPeers();
    }

    public PeerNode[] getConnectedPeers() {
        return this.peers.connectedPeers();
    }

    public PeerNode getPeerNode(String nodeIdentifier) {
        for (PeerNode pn : this.peers.myPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String identity = pn.getIdentityString();
            if (pn instanceof DarknetPeerNode) {
                DarknetPeerNode dpn = (DarknetPeerNode)pn;
                String name = dpn.myName;
                if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
                return pn;
            }
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier)) continue;
            return pn;
        }
        return null;
    }

    public boolean isHasStarted() {
        return this.hasStarted;
    }

    public void queueRandomReinsert(KeyBlock block) {
        this.clientCore.queueRandomReinsert(block);
    }

    public String getExtraPeerDataDir() {
        return this.extraPeerDataDir.getPath();
    }

    public boolean noConnectedPeers() {
        return !this.peers.anyConnectedPeers();
    }

    public double getLocation() {
        return this.lm.getLocation();
    }

    public double getLocationChangeSession() {
        return this.lm.getLocChangeSession();
    }

    public int getAverageOutgoingSwapTime() {
        return this.lm.getAverageSwapTime();
    }

    public long getSendSwapInterval() {
        return this.lm.getSendSwapInterval();
    }

    public int getNumberOfRemotePeerLocationsSeenInSwaps() {
        return this.lm.numberOfRemotePeerLocationsSeenInSwaps;
    }

    public boolean isAdvancedModeEnabled() {
        if (this.clientCore == null) {
            return false;
        }
        return this.clientCore.isAdvancedModeEnabled();
    }

    public boolean isFProxyJavascriptEnabled() {
        return this.clientCore.isFProxyJavascriptEnabled();
    }

    public int getNumARKFetchers() {
        int x = 0;
        for (PeerNode p : this.peers.myPeers()) {
            if (!p.isFetchingARK()) continue;
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentPayload(int len) {
        Object object = this.statsSync;
        synchronized (object) {
            this.totalPayloadSent += (long)len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPayloadSent() {
        Object object = this.statsSync;
        synchronized (object) {
            return this.totalPayloadSent;
        }
    }

    public void setName(String key) throws InvalidConfigValueException, NodeNeedRestartException {
        this.config.get("node").getOption("name").setValue(key);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public int getUnclaimedFIFOSize() {
        return this.usm.getUnclaimedFIFOSize();
    }

    public void connectToSeednode(SeedServerTestPeerNode node) throws OpennetDisabledException, FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        this.peers.addPeer(node, false, false);
    }

    public void connect(Node node, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        this.peers.connect(node.darknetCrypto.exportPublicFieldSet(), this.darknetCrypto.packetMangler, trust, visibility);
    }

    public short maxHTL() {
        return this.maxHTL;
    }

    public int getDarknetPortNumber() {
        return this.darknetCrypto.portNumber;
    }

    public synchronized int getOutputBandwidthLimit() {
        return this.outputBandwidthLimit;
    }

    public synchronized int getInputBandwidthLimit() {
        if (this.inputLimitDefault) {
            return this.outputBandwidthLimit * 4;
        }
        return this.inputBandwidthLimit;
    }

    public synchronized long getStoreSize() {
        return this.maxTotalDatastoreSize;
    }

    @Override
    public synchronized void setTimeSkewDetectedUserAlert() {
        if (timeSkewDetectedUserAlert == null) {
            timeSkewDetectedUserAlert = new TimeSkewDetectedUserAlert();
            this.clientCore.alerts.register(timeSkewDetectedUserAlert);
        }
    }

    public File getNodeDir() {
        return this.nodeDir.dir();
    }

    public File getCfgDir() {
        return this.cfgDir.dir();
    }

    public File getUserDir() {
        return this.userDir.dir();
    }

    public File getRunDir() {
        return this.runDir.dir();
    }

    public File getStoreDir() {
        return this.storeDir.dir();
    }

    public File getPluginDir() {
        return this.pluginDir.dir();
    }

    public ProgramDirectory nodeDir() {
        return this.nodeDir;
    }

    public ProgramDirectory cfgDir() {
        return this.cfgDir;
    }

    public ProgramDirectory userDir() {
        return this.userDir;
    }

    public ProgramDirectory runDir() {
        return this.runDir;
    }

    public ProgramDirectory storeDir() {
        return this.storeDir;
    }

    public ProgramDirectory pluginDir() {
        return this.pluginDir;
    }

    public DarknetPeerNode createNewDarknetNode(SimpleFieldSet fs, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        return new DarknetPeerNode(fs, this, this.darknetCrypto, false, trust, visibility);
    }

    public OpennetPeerNode createNewOpennetNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new OpennetPeerNode(fs, this, this.opennet.crypto, this.opennet, false);
    }

    public SeedServerTestPeerNode createNewSeedServerTestPeerNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new SeedServerTestPeerNode(fs, this, this.opennet.crypto, true);
    }

    public OpennetPeerNode addNewOpennetNode(SimpleFieldSet fs, OpennetManager.ConnectionType connectionType) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            return null;
        }
        return this.opennet.addNewOpennetNode(fs, connectionType, false);
    }

    public byte[] getOpennetPubKeyHash() {
        return this.opennet.crypto.ecdsaPubKeyHash;
    }

    public byte[] getDarknetPubKeyHash() {
        return this.darknetCrypto.ecdsaPubKeyHash;
    }

    public synchronized boolean isOpennetEnabled() {
        return this.opennet != null;
    }

    public SimpleFieldSet exportDarknetPublicFieldSet() {
        return this.darknetCrypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportOpennetPublicFieldSet() {
        return this.opennet.crypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportDarknetPrivateFieldSet() {
        return this.darknetCrypto.exportPrivateFieldSet();
    }

    public SimpleFieldSet exportOpennetPrivateFieldSet() {
        return this.opennet.crypto.exportPrivateFieldSet();
    }

    public synchronized boolean dontDetect() {
        if (!this.darknetCrypto.getBindTo().isRealInternetAddress(false, true, false)) {
            return false;
        }
        return this.opennet == null || !this.opennet.crypto.getBindTo().isRealInternetAddress(false, true, false);
    }

    public int getOpennetFNPPort() {
        if (this.opennet == null) {
            return -1;
        }
        return this.opennet.crypto.portNumber;
    }

    public OpennetManager getOpennet() {
        return this.opennet;
    }

    public synchronized boolean passOpennetRefsThroughDarknet() {
        return this.passOpennetRefsThroughDarknet;
    }

    public Set<ForwardPort> getPublicInterfacePorts() {
        NodeCrypto crypto;
        HashSet<ForwardPort> set = new HashSet<ForwardPort>();
        set.add(new ForwardPort("darknet", false, 17, this.darknetCrypto.portNumber));
        if (this.opennet != null && (crypto = this.opennet.crypto) != null) {
            set.add(new ForwardPort("opennet", false, 17, crypto.portNumber));
        }
        return set;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.usm.getStartedTime();
    }

    public synchronized UdpSocketHandler[] getPacketSocketHandlers() {
        if (this.opennet != null) {
            return new UdpSocketHandler[]{this.darknetCrypto.socket, this.opennet.crypto.socket};
        }
        return new UdpSocketHandler[]{this.darknetCrypto.socket};
    }

    public int getMaxOpennetPeers() {
        return this.maxOpennetPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddedValidIP() {
        Announcer announcer;
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om != null && (announcer = om.announcer) != null) {
            announcer.maybeSendAnnouncement();
        }
    }

    public boolean isSeednode() {
        return this.acceptSeedConnections;
    }

    public boolean wantAnonAuth(boolean isOpennet) {
        if (isOpennet) {
            return this.opennet != null && this.acceptSeedConnections;
        }
        return false;
    }

    public boolean wantAnonAuthChangeIP(boolean isOpennet) {
        return !isOpennet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean opennetDefinitelyPortForwarded() {
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om == null) {
            return false;
        }
        NodeCrypto crypto = om.crypto;
        if (crypto == null) {
            return false;
        }
        return crypto.definitelyPortForwarded();
    }

    public boolean darknetDefinitelyPortForwarded() {
        if (this.darknetCrypto == null) {
            return false;
        }
        return this.darknetCrypto.definitelyPortForwarded();
    }

    public boolean hasKey(Key key, boolean canReadClientCache, boolean forULPR) {
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, true, canReadClientCache, false, false, forULPR, null) != null;
        }
        return this.fetch((NodeSSK)key, true, canReadClientCache, false, false, forULPR, null) != null;
    }

    public void setLocation(double loc) {
        this.lm.setLocation(loc);
    }

    public boolean peersWantKey(Key key) {
        return this.failureTable.peersWantKey(key, null);
    }

    public void setDispatcherHook(NodeDispatcher.NodeDispatcherCallback cb) {
        this.dispatcher.setHook(cb);
    }

    public boolean shallWePublishOurPeersLocation() {
        return this.publishOurPeersLocation;
    }

    public boolean shallWeRouteAccordingToOurPeersLocation(int htl) {
        return this.routeAccordingToOurPeersLocation && htl > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterPassword(String password, boolean inFirstTimeWizard) throws AlreadySetPasswordException, MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        MasterKeys k;
        Node node = this;
        synchronized (node) {
            if (this.keys != null) {
                this.keys.changePassword(this.masterKeysFile, password, this.secureRandom);
                return;
            }
            this.keys = MasterKeys.read(this.masterKeysFile, this.secureRandom, password);
            this.databaseKey = this.keys.createDatabaseKey(this.secureRandom);
            k = this.keys;
        }
        this.setPasswordInner(k, inFirstTimeWizard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasswordInner(MasterKeys keys, boolean inFirstTimeWizard) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException {
        MasterSecret secret = keys.getPersistentMasterSecret();
        this.clientCore.setupMasterSecret(secret);
        boolean wantClientCache = false;
        boolean wantDatabase = false;
        Node node = this;
        synchronized (node) {
            wantClientCache = this.clientCacheAwaitingPassword;
            wantDatabase = this.databaseAwaitingPassword;
            this.databaseAwaitingPassword = false;
        }
        if (wantClientCache) {
            this.activatePasswordedClientCache(keys);
        }
        if (wantDatabase) {
            this.lateSetupDatabase(keys.createDatabaseKey(this.secureRandom));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activatePasswordedClientCache(MasterKeys keys) {
        Node node = this;
        synchronized (node) {
            if (this.clientCacheType.equals("ram")) {
                System.err.println("RAM client cache cannot be passworded!");
                return;
            }
            if (!this.clientCacheType.equals("salt-hash")) {
                System.err.println("Unknown client cache type, cannot activate passworded store: " + this.clientCacheType);
                return;
            }
        }
        MigrateOldStoreData migrate = new MigrateOldStoreData(true);
        String suffix = this.getStoreSuffix();
        try {
            this.initSaltHashClientCacheFS(suffix, true, keys.clientCacheMasterKey);
        }
        catch (NodeInitException e) {
            Logger.error(this, "Unable to activate passworded client cache", (Throwable)e);
            System.err.println("Unable to activate passworded client cache: " + e);
            e.printStackTrace();
            return;
        }
        Node node2 = this;
        synchronized (node2) {
            this.clientCacheAwaitingPassword = false;
        }
        this.executor.execute(migrate, "Migrate data from previous store");
    }

    public void changeMasterPassword(String oldPassword, String newPassword, boolean inFirstTimeWizard) throws MasterKeysWrongPasswordException, MasterKeysFileSizeException, IOException, AlreadySetPasswordException {
        if (this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            Logger.error(this, "Changing password while physical threat level is at MAXIMUM???");
        }
        if (this.masterKeysFile.exists()) {
            this.keys.changePassword(this.masterKeysFile, newPassword, this.secureRandom);
            this.setPasswordInner(this.keys, inFirstTimeWizard);
        } else {
            this.setMasterPassword(newPassword, inFirstTimeWizard);
        }
    }

    public synchronized File getMasterPasswordFile() {
        return this.masterKeysFile;
    }

    boolean hasPanicked() {
        return this.hasPanicked;
    }

    public void panic() {
        this.hasPanicked = true;
        this.clientCore.clientLayerPersister.panic();
        this.clientCore.clientLayerPersister.killAndWaitForNotRunning();
        try {
            MasterKeys.killMasterKeys(this.getMasterPasswordFile());
        }
        catch (IOException e) {
            System.err.println("Unable to wipe master passwords key file!");
            System.err.println("Please delete " + this.getMasterPasswordFile() + " to ensure that nobody can recover your old downloads.");
        }
    }

    public void finishPanic() {
        WrapperManager.restart();
        System.exit(0);
    }

    public boolean awaitingPassword() {
        if (this.clientCacheAwaitingPassword) {
            return true;
        }
        return this.databaseAwaitingPassword;
    }

    public boolean wantEncryptedDatabase() {
        return this.securityLevels.getPhysicalThreatLevel() != SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW;
    }

    public boolean wantNoPersistentDatabase() {
        return this.securityLevels.getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM;
    }

    public boolean hasDatabase() {
        return !this.clientCore.clientLayerPersister.isKilledOrNotLoaded();
    }

    public String getDatabasePath() throws IOException {
        return this.clientCore.clientLayerPersister.getWriteFilename().toString();
    }

    public boolean shouldStoreDeep(Key key, PeerNode source, PeerNode[] routedTo) {
        double myLoc = this.getLocation();
        double target = key.toNormalizedDouble();
        double myDist = Location.distance(myLoc, target);
        if (logMINOR) {
            Logger.minor(this, "Should store for " + key + " ?");
        }
        if (source != null && !source.isLowUptime() && Location.distance(source, target) < myDist) {
            if (logMINOR) {
                Logger.minor(this, "Not storing because source is closer to target for " + key + " : " + source);
            }
            return false;
        }
        for (PeerNode pn : routedTo) {
            if (Location.distance(pn, target) < myDist && !pn.isLowUptime()) {
                if (logMINOR) {
                    Logger.minor(this, "Not storing because peer " + pn + " is closer to target for " + key + " his loc " + pn.getLocation() + " my loc " + myLoc + " target is " + target);
                }
                return false;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Should store maybe, peer " + pn + " loc = " + pn.getLocation() + " my loc is " + myLoc + " target is " + target + " low uptime is " + pn.isLowUptime());
        }
        if (logMINOR) {
            Logger.minor(this, "Should store returning true for " + key + " target=" + target + " myLoc=" + myLoc + " peers: " + routedTo.length);
        }
        return true;
    }

    public boolean getWriteLocalToDatastore() {
        return this.writeLocalToDatastore;
    }

    public boolean getUseSlashdotCache() {
        return this.useSlashdotCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVisibilityAlert() {
        Node node = this;
        synchronized (node) {
            if (this.showFriendsVisibilityAlert) {
                return;
            }
            this.showFriendsVisibilityAlert = true;
        }
        this.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                Node.this.config.store();
            }
        }, 0L);
        this.registerFriendsVisibilityAlert();
    }

    private void registerFriendsVisibilityAlert() {
        if (this.clientCore == null || this.clientCore.alerts == null) {
            this.getTicker().queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    Node.this.registerFriendsVisibilityAlert();
                }
            }, 0L);
            return;
        }
        this.clientCore.alerts.register(this.visibilityAlert);
    }

    private void unregisterFriendsVisibilityAlert() {
        this.clientCore.alerts.unregister(this.visibilityAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumMTU() {
        int detected;
        int mtu;
        Node node = this;
        synchronized (node) {
            mtu = this.maxPacketSize;
        }
        if (this.ipDetector != null && (detected = this.ipDetector.getMinimumDetectedMTU()) < mtu) {
            return detected;
        }
        return mtu;
    }

    public void updateMTU() {
        this.darknetCrypto.socket.calculateMaxPacketSize();
        OpennetManager om = this.opennet;
        if (om != null) {
            om.crypto.socket.calculateMaxPacketSize();
        }
    }

    public static boolean isTestnetEnabled() {
        return false;
    }

    public MersenneTwister createRandom() {
        byte[] buf = new byte[16];
        this.random.nextBytes(buf);
        return new MersenneTwister(buf);
    }

    public boolean enableNewLoadManagement(boolean realTimeFlag) {
        NodeStats stats = this.nodeStats;
        if (stats == null) {
            Logger.error(this, "Calling enableNewLoadManagement before Node constructor completes! FIX THIS!", (Throwable)new Exception("error"));
            return false;
        }
        return stats.enableNewLoadManagement(realTimeFlag);
    }

    public boolean enableRoutedPing() {
        return this.enableRoutedPing;
    }

    public boolean updateIsUrgent() {
        OpennetManager om = this.getOpennet();
        if (om != null && om.announcer != null && om.announcer.isWaitingForUpdater()) {
            return true;
        }
        return this.peers.getPeerNodeStatusSize(3, true) > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPluginStoreKey(String storeIdentifier) {
        DatabaseKey key;
        Node node = this;
        synchronized (node) {
            key = this.databaseKey;
        }
        if (key != null) {
            return key.getPluginStoreKey(storeIdentifier);
        }
        return null;
    }

    private void checkOutputBandwidthLimit(int obwLimit) throws InvalidConfigValueException {
        if (obwLimit <= 0) {
            throw new InvalidConfigValueException(this.l10n("bwlimitMustBePositive"));
        }
        if (obwLimit < 4096) {
            throw this.lowBandwidthLimit(obwLimit);
        }
    }

    private void checkInputBandwidthLimit(int ibwLimit) throws InvalidConfigValueException {
        if (ibwLimit == -1) {
            return;
        }
        if (ibwLimit <= 1) {
            throw new InvalidConfigValueException(this.l10n("bandwidthLimitMustBePositiveOrMinusOne"));
        }
        if (ibwLimit < 4096) {
            throw this.lowBandwidthLimit(ibwLimit);
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    DatabaseKey getDatabaseKey() {
        return this.databaseKey;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        KEEPALIVE_INTERVAL = TimeUnit.SECONDS.toMillis(7L);
        MAX_PEER_INACTIVITY = TimeUnit.SECONDS.toMillis(35L);
        HANDSHAKE_TIMEOUT = (int)TimeUnit.MILLISECONDS.toMillis(4800L);
        MIN_TIME_BETWEEN_HANDSHAKE_SENDS = HANDSHAKE_TIMEOUT * 2;
        RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_VERSION_PROBES = HANDSHAKE_TIMEOUT * 4;
        RANDOMIZED_TIME_BETWEEN_VERSION_PROBES = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_VERSION_SENDS = HANDSHAKE_TIMEOUT * 4;
        RANDOMIZED_TIME_BETWEEN_VERSION_SENDS = HANDSHAKE_TIMEOUT * 2;
        MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = HANDSHAKE_TIMEOUT * 24;
        RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = HANDSHAKE_TIMEOUT * 36;
        ALARM_TIME = TimeUnit.MINUTES.toMillis(1L);
        MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS = TimeUnit.MILLISECONDS.toMillis(900L);
        MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS = TimeUnit.MILLISECONDS.toMillis(1000L);
        PURGE_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
        LOW_BACKOFF = TimeUnit.SECONDS.toMillis(30L);
        jvmHasGCJCharConversionBug = false;
    }

    public static class AlreadySetPasswordException
    extends Exception {
        private static final long serialVersionUID = -7328456475029374032L;
    }

    private static class L10nCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private L10nCallback() {
        }

        @Override
        public String get() {
            return NodeL10n.getBase().getSelectedLanguage().fullName;
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (val == null || this.get().equalsIgnoreCase(val)) {
                return;
            }
            try {
                NodeL10n.getBase().setLanguage(BaseL10n.LANGUAGE.mapToLanguage(val));
            }
            catch (MissingResourceException e) {
                throw new InvalidConfigValueException(e.getLocalizedMessage());
            }
            PluginManager.setLanguage(NodeL10n.getBase().getSelectedLanguage());
        }

        @Override
        public String[] getPossibleValues() {
            return BaseL10n.LANGUAGE.valuesWithFullNames();
        }
    }

    private class ClientCacheTypeCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private ClientCacheTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            Node node = Node.this;
            synchronized (node) {
                return Node.this.clientCacheType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            boolean found = false;
            for (String string : this.getPossibleValues()) {
                if (!string.equals(val)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidConfigValueException("Invalid store type");
            }
            ClientCacheTypeCallback clientCacheTypeCallback = this;
            synchronized (clientCacheTypeCallback) {
                String suffix = Node.this.getStoreSuffix();
                if (val.equals("salt-hash")) {
                    byte[] key;
                    try {
                        Node node = Node.this;
                        synchronized (node) {
                            if (Node.this.keys == null) {
                                throw new MasterKeysWrongPasswordException();
                            }
                            key = ((Node)Node.this).keys.clientCacheMasterKey;
                            Node.this.clientCacheType = val;
                        }
                    }
                    catch (MasterKeysWrongPasswordException masterKeysWrongPasswordException) {
                        Node.this.setClientCacheAwaitingPassword();
                        throw new InvalidConfigValueException("You must enter the password");
                    }
                    try {
                        Node.this.initSaltHashClientCacheFS(suffix, true, key);
                    }
                    catch (NodeInitException nodeInitException) {
                        Logger.error(this, "Unable to create new store", (Throwable)nodeInitException);
                        System.err.println("Unable to create new store: " + nodeInitException);
                        nodeInitException.printStackTrace();
                        throw new InvalidConfigValueException("Unable to create new store: " + nodeInitException);
                    }
                }
                if (val.equals("ram")) {
                    Node.this.initRAMClientCacheFS();
                } else {
                    Node.this.initNoClientCacheFS();
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.clientCacheType = val;
                }
            }
        }

        @Override
        public String[] getPossibleValues() {
            return new String[]{"salt-hash", "ram", "none"};
        }
    }

    private class StoreTypeCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private StoreTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            Node node = Node.this;
            synchronized (node) {
                return Node.this.storeType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            String type;
            boolean found = false;
            for (String p : this.getPossibleValues()) {
                if (!p.equals(val)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidConfigValueException("Invalid store type");
            }
            Object object = Node.this;
            synchronized (object) {
                type = Node.this.storeType;
            }
            if (type.equals("ram")) {
                object = this;
                synchronized (object) {
                    Node.this.makeStore(val);
                }
            }
            object = Node.this;
            synchronized (object) {
                Node.this.storeType = val;
            }
            throw new NodeNeedRestartException("Store type cannot be changed on the fly");
        }

        @Override
        public String[] getPossibleValues() {
            return new String[]{"salt-hash", "ram"};
        }
    }

    public class NodeNameCallback
    extends StringCallback {
        NodeNameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get() {
            String name;
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                name = Node.this.myName;
            }
            if (name.startsWith("Node id|") || name.equals("MyFirstFreenetNode") || name.startsWith("Freenet node with no name #")) {
                Node.this.clientCore.alerts.register(nodeNameUserAlert);
            } else {
                Node.this.clientCore.alerts.unregister(nodeNameUserAlert);
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (val.length() > 128) {
                throw new InvalidConfigValueException("The given node name is too long (" + val + ')');
            }
            if ("".equals(val)) {
                val = "~none~";
            }
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                Node.this.myName = val;
            }
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.putSingle("myName", Node.this.myName);
            Node.this.peers.locallyBroadcastDiffNodeRef(fs, true, false);
            this.get();
        }
    }

    public class MigrateOldStoreData
    implements Runnable {
        private final boolean clientCache;

        public MigrateOldStoreData(boolean clientCache) {
            this.clientCache = clientCache;
            if (clientCache) {
                Node.this.oldCHKClientCache = Node.this.chkClientcache;
                Node.this.oldPKClientCache = Node.this.pubKeyClientcache;
                Node.this.oldSSKClientCache = Node.this.sskClientcache;
            } else {
                Node.this.oldCHK = Node.this.chkDatastore;
                Node.this.oldPK = Node.this.pubKeyDatastore;
                Node.this.oldSSK = Node.this.sskDatastore;
                Node.this.oldCHKCache = Node.this.chkDatastore;
                Node.this.oldPKCache = Node.this.pubKeyDatastore;
                Node.this.oldSSKCache = Node.this.sskDatastore;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.err.println("Migrating old " + (this.clientCache ? "client cache" : "datastore"));
            if (this.clientCache) {
                StoreCallback old;
                Node.this.migrateOldStore(Node.this.oldCHKClientCache, Node.this.chkClientcache, true);
                Node node = Node.this;
                synchronized (node) {
                    old = Node.this.oldCHKClientCache;
                    Node.this.oldCHKClientCache = null;
                }
                Node.this.closeOldStore(old);
                Node.this.migrateOldStore(Node.this.oldPKClientCache, Node.this.pubKeyClientcache, true);
                node = Node.this;
                synchronized (node) {
                    old = Node.this.oldPKClientCache;
                    Node.this.oldPKClientCache = null;
                }
                Node.this.closeOldStore(old);
                Node.this.migrateOldStore(Node.this.oldSSKClientCache, Node.this.sskClientcache, true);
                node = Node.this;
                synchronized (node) {
                    old = Node.this.oldSSKClientCache;
                    Node.this.oldSSKClientCache = null;
                }
                Node.this.closeOldStore(old);
            } else {
                Node.this.migrateOldStore(Node.this.oldCHK, Node.this.chkDatastore, false);
                Node.this.oldCHK = null;
                Node.this.migrateOldStore(Node.this.oldPK, Node.this.pubKeyDatastore, false);
                Node.this.oldPK = null;
                Node.this.migrateOldStore(Node.this.oldSSK, Node.this.sskDatastore, false);
                Node.this.oldSSK = null;
                Node.this.migrateOldStore(Node.this.oldCHKCache, Node.this.chkDatacache, false);
                Node.this.oldCHKCache = null;
                Node.this.migrateOldStore(Node.this.oldPKCache, Node.this.pubKeyDatacache, false);
                Node.this.oldPKCache = null;
                Node.this.migrateOldStore(Node.this.oldSSKCache, Node.this.sskDatacache, false);
                Node.this.oldSSKCache = null;
            }
            System.err.println("Finished migrating old " + (this.clientCache ? "client cache" : "datastore"));
        }
    }
}

