/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.fcp.ClientPut;
import freenet.clients.http.ConfigToadlet;
import freenet.clients.http.PageMaker;
import freenet.clients.http.QueueToadlet;
import freenet.clients.http.Toadlet;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.l10n.BaseL10n;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginBaseL10n;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginFCPMessageHandler;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.pluginmanager.FredPluginThemed;
import freenet.pluginmanager.NotFoundPluginHTTPException;
import freenet.pluginmanager.OfficialPlugins;
import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginDownLoaderFile;
import freenet.pluginmanager.PluginDownLoaderFreenet;
import freenet.pluginmanager.PluginDownLoaderOfficialFreenet;
import freenet.pluginmanager.PluginDownLoaderOfficialHTTPS;
import freenet.pluginmanager.PluginDownLoaderURL;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginHandler;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.SerialExecutor;
import freenet.support.Ticker;
import freenet.support.api.BooleanCallback;
import freenet.support.api.HTTPRequest;
import freenet.support.api.StringArrCallback;
import freenet.support.io.Closer;
import freenet.support.io.NativeThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;

public class PluginManager {
    private final HashMap<String, FredPlugin> toadletList;
    private final OfficialPlugins officialPlugins = new OfficialPlugins();
    private final Set<PluginProgress> startingPlugins = new HashSet<PluginProgress>();
    private final ArrayList<PluginInfoWrapper> pluginWrappers;
    private final HashMap<String, PluginLoadFailedUserAlert> pluginsFailedLoad;
    final Node node;
    private final NodeClientCore core;
    SubConfig pmconfig;
    private boolean logMINOR;
    private boolean logDEBUG;
    private final HighLevelSimpleClient client;
    private static PluginManager selfinstance = null;
    private PageMaker.THEME fproxyTheme;
    private final SerialExecutor executor;
    private boolean alwaysLoadOfficialPluginsFromCentralServer = false;
    static final short PRIO = 1;
    private final boolean enabled;
    private boolean started;
    private boolean stopping;
    private String[] toStart;
    private final Object pluginLoadSyncObject = new Object();
    public final RequestClient singleUpdaterRequestClient = new RequestClientBuilder().build();

    public PluginManager(Node node, int lastVersion) {
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
        this.toadletList = new HashMap();
        this.pluginWrappers = new ArrayList();
        this.pluginsFailedLoad = new HashMap();
        this.node = node;
        this.core = node.clientCore;
        if (this.logMINOR) {
            Logger.minor(this, "Starting Plugin Manager");
        }
        if (this.logDEBUG) {
            Logger.debug(this, "Initialize Plugin Manager config");
        }
        this.client = this.core.makeClient((short)1, true, false);
        this.executor = new SerialExecutor(NativeThread.NORM_PRIORITY);
        this.executor.start(node.executor, "PM callback executor");
        this.pmconfig = node.config.createSubConfig("pluginmanager");
        this.pmconfig.register("enabled", true, 0, true, true, "PluginManager.enabled", "PluginManager.enabledLong", new BooleanCallback(){

            @Override
            public synchronized Boolean get() {
                return PluginManager.this.enabled;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (PluginManager.this.enabled != val) {
                    throw new NodeNeedRestartException(PluginManager.l10n("changePluginManagerEnabledInConfig"));
                }
            }
        });
        this.enabled = this.pmconfig.getBoolean("enabled");
        this.pmconfig.register("loadplugin", null, 0, true, false, "PluginManager.loadedOnStartup", "PluginManager.loadedOnStartupLong", new StringArrCallback(){

            @Override
            public String[] get() {
                return PluginManager.this.getConfigLoadString();
            }

            @Override
            public void set(String[] val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException(NodeL10n.getBase().getString("PluginManager.cannotSetOnceLoaded"));
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        });
        this.toStart = this.pmconfig.getStringArr("loadplugin");
        if (lastVersion < 1237 && this.contains(this.toStart, "XMLLibrarian") && !this.contains(this.toStart, "Library")) {
            this.toStart = Arrays.copyOf(this.toStart, this.toStart.length + 1);
            this.toStart[this.toStart.length - 1] = "Library";
            System.err.println("Loading Library plugin, replaces XMLLibrarian, when upgrading from pre-1237");
        }
        if (this.contains(this.toStart, "KeyExplorer")) {
            for (int i = 0; i < this.toStart.length; ++i) {
                if (!"KeyExplorer".equals(this.toStart[i])) continue;
                this.toStart[i] = "KeyUtils";
            }
            System.err.println("KeyExplorer plugin renamed to KeyUtils");
        }
        this.pmconfig.register("alwaysLoadOfficialPluginsFromCentralServer", false, 0, false, false, "PluginManager.alwaysLoadPluginsFromCentralServer", "PluginManager.alwaysLoadPluginsFromCentralServerLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return PluginManager.this.alwaysLoadOfficialPluginsFromCentralServer;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                PluginManager.this.alwaysLoadOfficialPluginsFromCentralServer = val;
            }
        });
        this.alwaysLoadOfficialPluginsFromCentralServer = this.pmconfig.getBoolean("alwaysLoadOfficialPluginsFromCentralServer");
        if (node.lastVersion <= 1437) {
            this.alwaysLoadOfficialPluginsFromCentralServer = false;
        }
        this.pmconfig.finishedInitialization();
        this.fproxyTheme = PageMaker.THEME.themeFromName(node.config.get("fproxy").getString("css"));
        selfinstance = this;
    }

    private boolean contains(String[] array, String string) {
        for (String s : array) {
            if (!string.equals(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Config config) {
        if (!this.enabled) {
            return;
        }
        if (this.toStart == null) {
            ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
            synchronized (arrayList) {
                this.started = true;
                return;
            }
        }
        final Semaphore startingPlugins = new Semaphore(0);
        for (final String name : this.toStart) {
            this.core.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.startPluginAuto(name, false);
                    startingPlugins.release();
                }
            });
        }
        this.core.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                startingPlugins.acquireUninterruptibly(PluginManager.this.toStart.length);
                ArrayList arrayList = PluginManager.this.pluginWrappers;
                synchronized (arrayList) {
                    PluginManager.this.started = true;
                    PluginManager.access$302(PluginManager.this, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long maxWaitTime) {
        ArrayList<PluginInfoWrapper> wrappers;
        if (!this.enabled) {
            return;
        }
        ArrayList<PluginProgress> matches = new ArrayList<PluginProgress>();
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            this.stopping = true;
            Iterator<PluginProgress> iterator = this.startingPlugins.iterator();
            while (iterator.hasNext()) {
                PluginProgress progress2 = iterator.next();
                matches.add(progress2);
                iterator.remove();
            }
        }
        for (PluginProgress pluginProgress : matches) {
            pluginProgress.kill();
        }
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            wrappers = new ArrayList<PluginInfoWrapper>(this.pluginWrappers);
        }
        for (PluginInfoWrapper pi : wrappers) {
            pi.startShutdownPlugin(this, false);
        }
        long l = System.currentTimeMillis();
        long deadline = l + maxWaitTime;
        while (true) {
            String list;
            int delta;
            if ((delta = (int)(deadline - l)) <= 0) {
                list = PluginManager.pluginList(wrappers);
                Logger.error(this, "Plugins still shutting down at timeout:\n" + list);
                System.err.println("Plugins still shutting down at timeout:\n" + list);
                continue;
            }
            ListIterator<PluginInfoWrapper> it = wrappers.listIterator();
            while (it.hasNext()) {
                PluginInfoWrapper pi = (PluginInfoWrapper)it.next();
                System.out.println("Waiting for plugin to finish shutting down: " + pi.getFilename());
                if (!pi.finishShutdownPlugin(this, delta, false)) continue;
                it.remove();
            }
            if (wrappers.isEmpty()) {
                Logger.normal(this, "All plugins unloaded");
                System.out.println("All plugins unloaded");
                return;
            }
            list = PluginManager.pluginList(wrappers);
            Logger.error(this, "Plugins still shutting down:\n" + list);
            System.err.println("Plugins still shutting down:\n" + list);
        }
    }

    private static String pluginList(ArrayList<PluginInfoWrapper> wrappers) {
        StringBuffer sb = new StringBuffer();
        for (PluginInfoWrapper pi : wrappers) {
            sb.append(pi.getFilename());
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getConfigLoadString() {
        ArrayList<String> v = new ArrayList<String>();
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            if (!this.started) {
                return this.toStart;
            }
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                v.add(pi.getFilename());
            }
            v.addAll(this.pluginsFailedLoad.keySet());
        }
        return v.toArray(new String[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PluginProgress> getStartingPlugins() {
        Set<PluginProgress> set = this.startingPlugins;
        synchronized (set) {
            return new HashSet<PluginProgress>(this.startingPlugins);
        }
    }

    public PluginInfoWrapper startPluginAuto(String pluginname, boolean store) {
        OfficialPlugins.OfficialPluginDescription desc = this.isOfficialPlugin(pluginname);
        if (desc != null) {
            return this.startPluginOfficial(pluginname, store, desc, false, false);
        }
        try {
            new FreenetURI(pluginname);
            return this.startPluginFreenet(pluginname, store);
        }
        catch (MalformedURLException malformedURLException) {
            File[] roots;
            for (File f : roots = File.listRoots()) {
                if (!pluginname.startsWith(f.getName()) || !new File(pluginname).exists()) continue;
                return this.startPluginFile(pluginname, store);
            }
            return this.startPluginURL(pluginname, store);
        }
    }

    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store, boolean force, boolean forceHTTPS) {
        return this.startPluginOfficial(pluginname, store, this.officialPlugins.get(pluginname), force, forceHTTPS);
    }

    public PluginInfoWrapper startPluginOfficial(String pluginname, boolean store, OfficialPlugins.OfficialPluginDescription desc, boolean force, boolean forceHTTPS) {
        if (this.alwaysLoadOfficialPluginsFromCentralServer && !force || force && forceHTTPS) {
            return this.realStartPlugin(new PluginDownLoaderOfficialHTTPS(), pluginname, store, desc.alwaysFetchLatestVersion);
        }
        return this.realStartPlugin(new PluginDownLoaderOfficialFreenet(this.client, this.node, false), pluginname, store, desc.alwaysFetchLatestVersion);
    }

    public PluginInfoWrapper startPluginFile(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderFile(), filename, store, false);
    }

    public PluginInfoWrapper startPluginURL(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderURL(), filename, store, false);
    }

    public PluginInfoWrapper startPluginFreenet(String filename, boolean store) {
        return this.realStartPlugin(new PluginDownLoaderFreenet(this.client, this.node, false), filename, store, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginInfoWrapper realStartPlugin(PluginDownLoader<?> pdl, final String filename, final boolean store, boolean ignoreOld) {
        Set<PluginProgress> set;
        if (!this.enabled) {
            throw new IllegalStateException("Plugins disabled");
        }
        if (filename.trim().length() == 0) {
            return null;
        }
        PluginProgress pluginProgress = new PluginProgress(filename, pdl);
        Set<PluginProgress> set2 = this.startingPlugins;
        synchronized (set2) {
            this.startingPlugins.add(pluginProgress);
        }
        Logger.normal(this, "Loading plugin: " + filename);
        PluginInfoWrapper pi = null;
        try {
            FredPlugin plug = this.loadPlugin(pdl, filename, pluginProgress, ignoreOld);
            if (plug == null) {
                PluginInfoWrapper pluginInfoWrapper = null;
                return pluginInfoWrapper;
            }
            pluginProgress.setProgress(PluginProgress.PROGRESS_STATE.STARTING);
            pi = new PluginInfoWrapper(this.node, plug, filename, pdl.isOfficialPluginLoader());
            PluginHandler.startPlugin(this, pi);
            set = this.pluginWrappers;
            synchronized (set) {
                this.pluginWrappers.add(pi);
                this.pluginsFailedLoad.remove(filename);
            }
            Logger.normal(this, "Plugin loaded: " + filename);
        }
        catch (PluginNotFoundException e) {
            PluginDownLoaderFreenet retry;
            PluginDownLoaderFreenet downloader;
            Logger.normal(this, "Loading plugin failed (" + filename + ')', (Throwable)e);
            boolean stillTrying = false;
            if (pdl instanceof PluginDownLoaderOfficialFreenet) {
                downloader = (PluginDownLoaderOfficialFreenet)pdl;
                if (!(downloader.fatalFailure() || ((PluginDownLoaderOfficialFreenet)downloader).desperate || this.twoCopiesInStartingPlugins(filename))) {
                    retry = new PluginDownLoaderOfficialFreenet(this.client, this.node, true);
                    stillTrying = true;
                    this.node.getTicker().queueTimedJob(new Runnable((PluginDownLoaderOfficialFreenet)retry, filename, store){
                        final /* synthetic */ PluginDownLoaderOfficialFreenet val$retry;
                        final /* synthetic */ String val$filename;
                        final /* synthetic */ boolean val$store;
                        {
                            this.val$retry = pluginDownLoaderOfficialFreenet;
                            this.val$filename = string;
                            this.val$store = bl;
                        }

                        @Override
                        public void run() {
                            PluginManager.this.realStartPlugin(this.val$retry, this.val$filename, this.val$store, true);
                        }
                    }, 0L);
                }
            } else if (pdl instanceof PluginDownLoaderFreenet && !(downloader = (PluginDownLoaderFreenet)pdl).fatalFailure() && !downloader.desperate && !this.twoCopiesInStartingPlugins(filename)) {
                retry = new PluginDownLoaderFreenet(this.client, this.node, true);
                stillTrying = true;
                this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        PluginManager.this.realStartPlugin(retry, filename, store, true);
                    }
                }, 0L);
            }
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl instanceof PluginDownLoaderOfficialHTTPS || pdl instanceof PluginDownLoaderOfficialFreenet, pdl instanceof PluginDownLoaderOfficialFreenet, stillTrying, e);
            PluginLoadFailedUserAlert oldAlert = null;
            ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
            synchronized (arrayList) {
                oldAlert = this.pluginsFailedLoad.put(filename, newAlert);
            }
            this.core.alerts.register(newAlert);
            this.core.alerts.unregister(oldAlert);
        }
        catch (UnsupportedClassVersionError e) {
            Logger.error(this, "Could not load plugin " + filename + " : " + e, (Throwable)e);
            System.err.println("Could not load plugin " + filename + " : " + e);
            e.printStackTrace();
            System.err.println("Plugin " + filename + " appears to require a later JVM");
            Logger.error(this, "Plugin " + filename + " appears to require a later JVM");
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl instanceof PluginDownLoaderOfficialHTTPS || pdl instanceof PluginDownLoaderOfficialFreenet, pdl instanceof PluginDownLoaderOfficialFreenet, false, PluginManager.l10n("pluginReqNewerJVMTitle", "name", filename));
            PluginLoadFailedUserAlert oldAlert = null;
            ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
            synchronized (arrayList) {
                oldAlert = this.pluginsFailedLoad.put(filename, newAlert);
            }
            this.core.alerts.register(newAlert);
            this.core.alerts.unregister(oldAlert);
        }
        catch (Throwable e) {
            Logger.error(this, "Could not load plugin " + filename + " : " + e, e);
            System.err.println("Could not load plugin " + filename + " : " + e);
            e.printStackTrace();
            System.err.println("Plugin " + filename + " is broken, but we want to retry after next startup");
            Logger.error(this, "Plugin " + filename + " is broken, but we want to retry after next startup");
            PluginLoadFailedUserAlert newAlert = new PluginLoadFailedUserAlert(filename, pdl instanceof PluginDownLoaderOfficialHTTPS || pdl instanceof PluginDownLoaderOfficialFreenet, pdl instanceof PluginDownLoaderOfficialFreenet, false, e);
            PluginLoadFailedUserAlert oldAlert = null;
            ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
            synchronized (arrayList) {
                oldAlert = this.pluginsFailedLoad.put(filename, newAlert);
            }
            this.core.alerts.register(newAlert);
            this.core.alerts.unregister(oldAlert);
        }
        finally {
            Set<PluginProgress> e = this.startingPlugins;
            synchronized (e) {
                this.startingPlugins.remove(pluginProgress);
            }
        }
        set = this;
        synchronized (set) {
            if (store) {
                this.core.storeConfig();
            }
        }
        if (pi != null) {
            this.node.nodeUpdater.startPluginUpdater(filename);
        }
        return pi;
    }

    private synchronized boolean twoCopiesInStartingPlugins(String filename) {
        int count = 0;
        for (PluginProgress progress : this.startingPlugins) {
            if (!filename.equals(progress.name) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    void register(PluginInfoWrapper pi) {
        FredPlugin plug = pi.getPlugin();
        if (pi.isPproxyPlugin()) {
            this.registerToadlet(plug);
        }
        if (pi.isConfigurablePlugin()) {
            boolean pluginIsTryingToHijackNodeConfig = false;
            for (SubConfig subconfig : this.node.config.getConfigs()) {
                if (!pi.getPluginClassName().equals(subconfig.getPrefix())) continue;
                pluginIsTryingToHijackNodeConfig = true;
                break;
            }
            if (pluginIsTryingToHijackNodeConfig) {
                Logger.warning(this, "The plugin loaded from " + pi.getFilename() + " is attempting to hijack a node configuration page; refusing to register its ConfigToadlet");
            } else {
                ConfigToadlet toadlet = pi.getConfigToadlet();
                this.core.getToadletContainer().register(toadlet, "FProxyToadlet.categoryConfig", ((Toadlet)toadlet).path(), true, "ConfigToadlet." + pi.getPluginClassName() + ".label", "ConfigToadlet." + pi.getPluginClassName() + ".tooltip", true, null, (FredPluginL10n)((Object)pi.getPlugin()));
            }
        }
        if (pi.isIPDetectorPlugin()) {
            this.node.ipDetector.registerIPDetectorPlugin((FredPluginIPDetector)((Object)plug));
        }
        if (pi.isPortForwardPlugin()) {
            this.node.ipDetector.registerPortForwardPlugin((FredPluginPortForward)((Object)plug));
        }
        if (pi.isBandwidthIndicator()) {
            this.node.ipDetector.registerBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)plug));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRunningLoads(String filename, PluginProgress exceptFor) {
        Logger.normal(this, "Cancelling loads for plugin " + filename);
        ArrayList<PluginProgress> matches = null;
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            Iterator<PluginProgress> i = this.startingPlugins.iterator();
            while (i.hasNext()) {
                PluginProgress progress = i.next();
                if (progress == exceptFor || !filename.equals(progress.name)) continue;
                if (matches == null) {
                    matches = new ArrayList<PluginProgress>();
                }
                matches.add(progress);
                i.remove();
            }
        }
        if (matches == null) {
            return;
        }
        for (PluginProgress progress : matches) {
            progress.kill();
        }
    }

    static String l10n(String key) {
        return NodeL10n.getBase().getString("PluginManager." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("PluginManager." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("PluginManager." + key, patterns, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerToadlet(FredPlugin pl) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            this.toadletList.put(pl.getClass().getName(), pl);
        }
        Logger.normal(this, "Added HTTP handler for /plugins/" + pl.getClass().getName() + '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(PluginInfoWrapper pi) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            if (!this.stopping && !this.pluginWrappers.remove(pi)) {
                return;
            }
        }
        this.core.storeConfig();
    }

    public void removeCachedCopy(String pluginSpecification) {
        File[] cachedFiles;
        if (pluginSpecification == null) {
            Logger.warning(this, "Can't remove null from cache. Ignoring");
            return;
        }
        int lastSlash = pluginSpecification.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = pluginSpecification.lastIndexOf(92);
        }
        File pluginDirectory = this.node.getPluginDir();
        String pluginFilename = lastSlash == -1 ? (pluginSpecification.toLowerCase().endsWith(".jar") ? pluginSpecification : pluginSpecification + ".jar") : pluginSpecification.substring(lastSlash + 1);
        if (this.logDEBUG) {
            Logger.minor(this, "Delete plugin - plugname: " + pluginSpecification + " filename: " + pluginFilename, (Throwable)new Exception("debug"));
        }
        for (File cachedFile : cachedFiles = this.getPreviousInstances(pluginDirectory, pluginFilename)) {
            if (cachedFile.delete() || !this.logMINOR) continue;
            Logger.minor(this, "Can't delete file " + cachedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPluginToadlet(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                this.toadletList.remove(pi.getPluginClassName());
                Logger.normal(this, "Removed HTTP handler for /plugins/" + pi.getPluginClassName() + '/', (Throwable)new Exception("debug"));
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Plugin", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                for (String target : targets) {
                    this.toadletList.remove(target);
                    Logger.normal(this, "Removed HTTP symlink: " + target + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToadletSymlinks(PluginInfoWrapper pi) {
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            String rm = null;
            try {
                String[] targets = pi.getPluginToadletSymlinks();
                if (targets == null) {
                    return;
                }
                String[] arr$ = targets;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String target;
                    rm = target = arr$[i$];
                    this.toadletList.remove(target);
                    pi.removePluginToadletSymlink(target);
                    Logger.normal(this, "Removed HTTP symlink: " + target + " => /plugins/" + pi.getPluginClassName() + '/');
                }
            }
            catch (Throwable ex) {
                Logger.error(this, "removing Toadlet-link: " + rm, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpPlugins() {
        StringBuilder out = new StringBuilder();
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                out.append(pi.toString());
                out.append('\n');
            }
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PluginInfoWrapper> getPlugins() {
        TreeSet<PluginInfoWrapper> out = new TreeSet<PluginInfoWrapper>();
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                out.add(pi);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public PluginInfoWrapper getPluginInfo(String plugname) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(plugname) && !pi.getFilename().equals(plugname)) continue;
                return pi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInfoWrapper getPluginInfoByClassName(String pluginClassName) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (PluginInfoWrapper piw : this.pluginWrappers) {
                if (!piw.getPluginClassName().equals(pluginClassName)) continue;
                return piw;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInfoWrapper getPluginInfoByFileName(String pluginFileName) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (PluginInfoWrapper piw : this.pluginWrappers) {
                if (!piw.getFilename().equals(pluginFileName)) continue;
                return piw;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FredPluginFCP getFCPPlugin(String plugname) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.isFCPPlugin() || !pi.getPluginClassName().equals(plugname) || pi.isStopping()) continue;
                return (FredPluginFCP)((Object)pi.plug);
            }
        }
        return null;
    }

    public FredPluginFCPMessageHandler.ServerSideFCPMessageHandler getPluginFCPServer(String pluginClassName) throws PluginNotFoundException {
        PluginInfoWrapper piw = this.getPluginInfoByClassName(pluginClassName);
        if (piw != null && piw.isFCPServerPlugin()) {
            return piw.getFCPServerPlugin();
        }
        throw new PluginNotFoundException(pluginClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPluginLoaded(String plugname) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(plugname) && !pi.getFilename().equals(plugname)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPluginLoadedOrLoadingOrWantLoad(String plugname) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size(); ++i) {
                PluginInfoWrapper pi = this.pluginWrappers.get(i);
                if (!pi.getFilename().equals(plugname)) continue;
                return true;
            }
        }
        if (this.pluginsFailedLoad.containsKey(plugname)) {
            return true;
        }
        for (PluginProgress prog : this.startingPlugins) {
            if (!prog.name.equals(plugname)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPGet(String plugin, HTTPRequest request) throws PluginHTTPException {
        FredPlugin handler = null;
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            handler = this.toadletList.get(plugin);
        }
        if (!(handler instanceof FredPluginHTTP)) {
            throw new NotFoundPluginHTTPException("Plugin not loaded!", "/plugins");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
        try {
            String string = ((FredPluginHTTP)((Object)handler)).handleHTTPGet(request);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleHTTPPost(String plugin, HTTPRequest request) throws PluginHTTPException {
        FredPlugin handler = null;
        HashMap<String, FredPlugin> hashMap = this.toadletList;
        synchronized (hashMap) {
            handler = this.toadletList.get(plugin);
        }
        if (handler == null) {
            throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader pluginClassLoader = handler.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(pluginClassLoader);
        try {
            if (handler instanceof FredPluginHTTP) {
                String string = ((FredPluginHTTP)((Object)handler)).handleHTTPPost(request);
                return string;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        throw new NotFoundPluginHTTPException("Plugin '" + plugin + "' not found!", "/plugins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPlugin(String name, long maxWaitTime, boolean reloading) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (!pi.getThreadName().equals(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime, reloading);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPluginByFilename(String name, long maxWaitTime, boolean reloading) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (!pi.getFilename().equals(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime, reloading);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPluginByClass(String name, long maxWaitTime) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (!pi.getPluginClassName().equals(name)) continue;
                found = true;
                break;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPlugin(FredPlugin plugin, long maxWaitTime) {
        PluginInfoWrapper pi = null;
        boolean found = false;
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (int i = 0; i < this.pluginWrappers.size() && !found; ++i) {
                pi = this.pluginWrappers.get(i);
                if (pi.plug != plugin) continue;
                found = true;
            }
        }
        if (found) {
            pi.stopPlugin(this, maxWaitTime, false);
        }
    }

    public OfficialPlugins.OfficialPluginDescription getOfficialPlugin(String name) {
        return this.officialPlugins.get(name);
    }

    public Collection<OfficialPlugins.OfficialPluginDescription> getOfficialPlugins() {
        return this.officialPlugins.getAll();
    }

    public List<OfficialPlugins.OfficialPluginDescription> findAvailablePlugins() {
        ArrayList<OfficialPlugins.OfficialPluginDescription> availablePlugins = new ArrayList<OfficialPlugins.OfficialPluginDescription>();
        availablePlugins.addAll(this.officialPlugins.getAll());
        return availablePlugins;
    }

    public OfficialPlugins.OfficialPluginDescription isOfficialPlugin(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        List<OfficialPlugins.OfficialPluginDescription> availablePlugins = this.findAvailablePlugins();
        for (OfficialPlugins.OfficialPluginDescription desc : availablePlugins) {
            if (!desc.name.equals(name)) continue;
            return desc;
        }
        return null;
    }

    public File getPluginFilename(String pluginName) {
        File pluginDirectory = this.node.getPluginDir();
        if (pluginDirectory.exists() && !pluginDirectory.isDirectory() || !pluginDirectory.exists() && !pluginDirectory.mkdirs()) {
            return null;
        }
        return new File(pluginDirectory, pluginName + ".jar");
    }

    /*
     * Exception decompiling
     */
    private FredPlugin loadPlugin(PluginDownLoader<?> pdl, String name, PluginProgress progress, boolean ignoreOld) throws PluginNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File[] getPreviousInstances(File pluginDirectory, final String filename) {
        File[] cachedFiles = pluginDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(filename);
            }
        });
        Arrays.sort(cachedFiles, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, this.extractTimestamp(file2.getName()) - this.extractTimestamp(file1.getName())));
            }

            private long extractTimestamp(String filename) {
                int lastIndexOfDash = filename.lastIndexOf(".jar-");
                if (lastIndexOfDash == -1) {
                    return 0L;
                }
                try {
                    return Long.parseLong(filename.substring(lastIndexOfDash + 5));
                }
                catch (NumberFormatException nfe1) {
                    return 0L;
                }
            }
        });
        return cachedFiles;
    }

    private String getFileDigest(File file, String digest) throws PluginNotFoundException {
        String result;
        int BUFFERSIZE = 4096;
        MessageDigest hash = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        boolean wasFromDigest256Pool = false;
        try {
            if ("SHA-256".equals(digest)) {
                hash = SHA256.getMessageDigest();
                wasFromDigest256Pool = true;
            } else {
                hash = MessageDigest.getInstance(digest);
            }
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            int len = 0;
            byte[] buffer = new byte[4096];
            while ((len = bis.read(buffer)) > -1) {
                hash.update(buffer, 0, len);
            }
            result = HexUtil.bytesToHex(hash.digest());
            if (wasFromDigest256Pool) {
                SHA256.returnMessageDigest(hash);
            }
        }
        catch (Exception e) {
            try {
                throw new PluginNotFoundException("Error while computing hash '" + digest + "' of the downloaded plugin: " + e, e);
            }
            catch (Throwable throwable) {
                Closer.close(bis);
                Closer.close(fis);
                throw throwable;
            }
        }
        Closer.close(bis);
        Closer.close(fis);
        return result;
    }

    Ticker getTicker() {
        return this.node.getTicker();
    }

    static String getOfficialPluginLocalisedName(String pluginName) {
        return PluginManager.l10n("pluginName." + pluginName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFProxyTheme(final PageMaker.THEME cssName) {
        this.fproxyTheme = cssName;
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                pi.pr.getPageMaker().setTheme(cssName);
                if (!pi.isThemedPlugin()) continue;
                final FredPluginThemed plug = (FredPluginThemed)((Object)pi.plug);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            plug.setTheme(cssName);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Cought Trowable in Callback", t);
                        }
                    }
                }, "Callback");
            }
        }
    }

    public static void setLanguage(BaseL10n.LANGUAGE lang) {
        if (selfinstance == null) {
            return;
        }
        selfinstance.setPluginLanguage(lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPluginLanguage(BaseL10n.LANGUAGE lang) {
        ArrayList<PluginInfoWrapper> arrayList = this.pluginWrappers;
        synchronized (arrayList) {
            for (PluginInfoWrapper pi : this.pluginWrappers) {
                Object plug;
                if (pi.isL10nPlugin()) {
                    plug = (FredPluginL10n)((Object)pi.plug);
                    this.executor.execute(new Runnable((FredPluginL10n)plug, lang){
                        final /* synthetic */ FredPluginL10n val$plug;
                        final /* synthetic */ BaseL10n.LANGUAGE val$lang;
                        {
                            this.val$plug = fredPluginL10n;
                            this.val$lang = lANGUAGE;
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$plug.setLanguage(this.val$lang);
                            }
                            catch (Throwable t) {
                                Logger.error(this, "Cought Trowable in Callback", t);
                            }
                        }
                    }, "Callback");
                    continue;
                }
                if (!pi.isBaseL10nPlugin()) continue;
                plug = (FredPluginBaseL10n)((Object)pi.plug);
                this.executor.execute(new Runnable((FredPluginBaseL10n)plug, lang){
                    final /* synthetic */ FredPluginBaseL10n val$plug;
                    final /* synthetic */ BaseL10n.LANGUAGE val$lang;
                    {
                        this.val$plug = fredPluginBaseL10n;
                        this.val$lang = lANGUAGE;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$plug.setLanguage(this.val$lang);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Cought Trowable in Callback", t);
                        }
                    }
                }, "Callback");
            }
        }
    }

    public PageMaker.THEME getFProxyTheme() {
        return this.fproxyTheme;
    }

    public boolean loadOfficialPluginsFromWeb() {
        return this.alwaysLoadOfficialPluginsFromCentralServer;
    }

    public void unregisterPlugin(PluginInfoWrapper wrapper, FredPlugin plug, boolean reloading) {
        this.unregisterPluginToadlet(wrapper);
        if (wrapper.isConfigurablePlugin()) {
            this.core.getToadletContainer().unregister(wrapper.getConfigToadlet());
        }
        if (wrapper.isIPDetectorPlugin()) {
            this.node.ipDetector.unregisterIPDetectorPlugin((FredPluginIPDetector)((Object)plug));
        }
        if (wrapper.isPortForwardPlugin()) {
            this.node.ipDetector.unregisterPortForwardPlugin((FredPluginPortForward)((Object)plug));
        }
        if (wrapper.isBandwidthIndicator()) {
            this.node.ipDetector.unregisterBandwidthIndicatorPlugin((FredPluginBandwidthIndicator)((Object)plug));
        }
        if (!reloading) {
            this.node.nodeUpdater.stopPluginUpdater(wrapper.getFilename());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static /* synthetic */ String[] access$302(PluginManager x0, String[] x1) {
        x0.toStart = x1;
        return x1;
    }

    public static class PluginProgress {
        private long startingTime = System.currentTimeMillis();
        private PROGRESS_STATE pluginProgress;
        private String name;
        private int total;
        private int minSuccessful;
        private int current;
        private boolean finalisedTotal;
        private int failed;
        private int fatallyFailed;
        private final PluginDownLoader<?> loader;

        PluginProgress(String name, PluginDownLoader<?> pdl) {
            this.name = name;
            this.pluginProgress = PROGRESS_STATE.DOWNLOADING;
            this.loader = pdl;
        }

        public void kill() {
            this.loader.tryCancel();
        }

        public long getTime() {
            return System.currentTimeMillis() - this.startingTime;
        }

        public String getName() {
            return this.name;
        }

        public PROGRESS_STATE getProgress() {
            return this.pluginProgress;
        }

        void setProgress(PROGRESS_STATE state) {
            this.pluginProgress = state;
        }

        public String toString() {
            return "PluginProgress[name=" + this.name + ",startingTime=" + this.startingTime + ",progress=" + (Object)((Object)this.pluginProgress) + "]";
        }

        public String toLocalisedString() {
            if (this.pluginProgress == PROGRESS_STATE.DOWNLOADING && this.total > 0) {
                return NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.downloading") + " : " + (double)this.current * 100.0 / (double)this.total + "%";
            }
            if (this.pluginProgress == PROGRESS_STATE.DOWNLOADING) {
                return NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.downloading");
            }
            if (this.pluginProgress == PROGRESS_STATE.STARTING) {
                return NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.starting");
            }
            return this.toString();
        }

        public HTMLNode toLocalisedHTML() {
            if (this.pluginProgress == PROGRESS_STATE.DOWNLOADING && this.total > 0) {
                return QueueToadlet.createProgressCell(false, true, ClientPut.COMPRESS_STATE.WORKING, this.current, this.failed, this.fatallyFailed, this.minSuccessful, this.total, this.finalisedTotal, false);
            }
            if (this.pluginProgress == PROGRESS_STATE.DOWNLOADING) {
                return new HTMLNode("td", NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.downloading"));
            }
            if (this.pluginProgress == PROGRESS_STATE.STARTING) {
                return new HTMLNode("td", NodeL10n.getBase().getString("PproxyToadlet.startingPluginStatus.starting"));
            }
            return new HTMLNode("td", this.toString());
        }

        public void setDownloadProgress(int minSuccess, int current, int total, int failed, int fatallyFailed, boolean finalised) {
            this.pluginProgress = PROGRESS_STATE.DOWNLOADING;
            this.total = total;
            this.current = current;
            this.minSuccessful = minSuccess;
            this.failed = failed;
            this.fatallyFailed = fatallyFailed;
            this.finalisedTotal = finalised;
        }

        public void setDownloading() {
            this.pluginProgress = PROGRESS_STATE.DOWNLOADING;
        }

        public boolean isOfficialPlugin() {
            return this.loader.isOfficialPluginLoader();
        }

        public String getLocalisedPluginName() {
            String pluginName = this.getName();
            if (this.isOfficialPlugin()) {
                return PluginManager.getOfficialPluginLocalisedName(pluginName);
            }
            return pluginName;
        }

        static enum PROGRESS_STATE {
            DOWNLOADING,
            STARTING;

        }
    }

    class PluginLoadFailedUserAlert
    extends AbstractUserAlert {
        final String filename;
        final String message;
        final boolean official;
        final boolean officialFromFreenet;
        final boolean stillTryingOverFreenet;

        public PluginLoadFailedUserAlert(String filename, boolean official, boolean officialFromFreenet, boolean stillTryingOverFreenet, String message) {
            this.filename = filename;
            this.official = official;
            this.message = message;
            this.officialFromFreenet = officialFromFreenet;
            this.stillTryingOverFreenet = stillTryingOverFreenet;
        }

        public PluginLoadFailedUserAlert(String filename, boolean official, boolean officialFromFreenet, boolean stillTryingOverFreenet, Throwable e) {
            this.filename = filename;
            this.official = official;
            this.stillTryingOverFreenet = stillTryingOverFreenet;
            String msg = e instanceof PluginNotFoundException ? e.getMessage() : e.getClass() + ": " + e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            this.message = msg;
            this.officialFromFreenet = officialFromFreenet;
        }

        @Override
        public String dismissButtonText() {
            return PluginManager.l10n("deleteFailedPluginButton");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDismiss() {
            ArrayList arrayList = PluginManager.this.pluginWrappers;
            synchronized (arrayList) {
                PluginManager.this.pluginsFailedLoad.remove(this.filename);
            }
            PluginManager.this.node.executor.execute(new Runnable(){

                @Override
                public void run() {
                    PluginManager.this.cancelRunningLoads(PluginLoadFailedUserAlert.this.filename, null);
                }
            });
        }

        @Override
        public String anchor() {
            return "pluginfailed:" + this.filename;
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode div = new HTMLNode("div");
            HTMLNode p = div.addChild("p");
            p.addChild("#", PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message}));
            if (this.stillTryingOverFreenet) {
                div.addChild("p", PluginManager.l10n("pluginLoadingFailedStillTryingOverFreenet"));
            }
            if (this.official) {
                p = div.addChild("p");
                if (this.officialFromFreenet) {
                    p.addChild("#", PluginManager.l10n("officialPluginLoadFailedSuggestTryAgainFreenet"));
                } else {
                    p.addChild("#", PluginManager.l10n("officialPluginLoadFailedSuggestTryAgainHTTPS"));
                }
                HTMLNode reloadForm = div.addChild("form", new String[]{"action", "method"}, new String[]{"/plugins/", "post"});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", PluginManager.this.node.clientCore.formPassword});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "plugin-name", this.filename});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "pluginSource", "https"});
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", PluginManager.l10n("officialPluginLoadFailedTryAgain")});
                if (!this.stillTryingOverFreenet) {
                    reloadForm = div.addChild("form", new String[]{"action", "method"}, new String[]{"/plugins/", "post"});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", PluginManager.this.node.clientCore.formPassword});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "plugin-name", this.filename});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "pluginSource", "freenet"});
                    reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", PluginManager.l10n("officialPluginLoadFailedTryAgainFreenet")});
                }
            }
            return div;
        }

        @Override
        public short getPriorityClass() {
            return 1;
        }

        @Override
        public String getShortText() {
            return PluginManager.l10n("pluginLoadingFailedShort", "name", this.filename);
        }

        @Override
        public String getText() {
            return PluginManager.this.l10n("pluginLoadingFailedWithMessage", new String[]{"name", "message"}, new String[]{this.filename, this.message});
        }

        @Override
        public String getTitle() {
            return PluginManager.l10n("pluginLoadingFailedTitle");
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            boolean success;
            ArrayList arrayList = PluginManager.this.pluginWrappers;
            synchronized (arrayList) {
                success = PluginManager.this.pluginsFailedLoad.containsKey(this.filename);
            }
            if (!success) {
                ((PluginManager)PluginManager.this).core.alerts.unregister(this);
            }
            return success;
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        @Override
        public boolean userCanDismiss() {
            return true;
        }
    }
}

