/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.EndListPeersMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PeerMessage;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.SimpleFieldSet;

public class ListPeersMessage
extends FCPMessage {
    final boolean withMetadata;
    final boolean withVolatile;
    final String identifier;
    static final String NAME = "ListPeers";

    public ListPeersMessage(SimpleFieldSet fs) {
        this.withMetadata = fs.getBoolean("WithMetadata", false);
        this.withVolatile = fs.getBoolean("WithVolatile", false);
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PeerNode[] nodes;
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ListPeers requires full access", this.identifier, false);
        }
        for (PeerNode pn : nodes = node.getPeerNodes()) {
            handler.outputHandler.queue(new PeerMessage(pn, this.withMetadata, this.withVolatile, this.identifier));
        }
        handler.outputHandler.queue(new EndListPeersMessage(this.identifier));
    }
}

