/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.io.WritableToDataOutputStream;
import freenet.io.comm.Peer;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.support.BitArray;
import freenet.support.Buffer;
import freenet.support.ShortBuffer;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Serializer {
    public static final String VERSION = "$Id: Serializer.java,v 1.5 2005/09/15 18:16:04 amphibian Exp $";
    public static final int MAX_BITARRAY_SIZE = 16384;
    public static final int MAX_ARRAY_LENGTH = 4092;

    public static List<Object> readListFromDataInputStream(Class<?> elementType, DataInput dis) throws IOException {
        LinkedList<Object> ret = new LinkedList<Object>();
        int length = dis.readInt();
        for (int x = 0; x < length; ++x) {
            ret.add(Serializer.readFromDataInputStream(elementType, dis));
        }
        return ret;
    }

    public static Object readFromDataInputStream(Class<?> type, DataInput dis) throws IOException {
        if (type.equals(Boolean.class)) {
            byte bool = dis.readByte();
            switch (bool) {
                case 1: {
                    return Boolean.TRUE;
                }
                case 0: {
                    return Boolean.FALSE;
                }
            }
            throw new IOException("Boolean is non boolean value: " + bool);
        }
        if (type.equals(Byte.class)) {
            return dis.readByte();
        }
        if (type.equals(Short.class)) {
            return dis.readShort();
        }
        if (type.equals(Integer.class)) {
            return dis.readInt();
        }
        if (type.equals(Long.class)) {
            return dis.readLong();
        }
        if (type.equals(Double.class)) {
            return dis.readDouble();
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(dis.readFloat());
        }
        if (type.equals(String.class)) {
            int length = dis.readInt();
            if (length < 0 || length > 4092) {
                throw new IOException("Invalid string length: " + length);
            }
            StringBuilder sb = new StringBuilder(length);
            for (int x = 0; x < length; ++x) {
                sb.append(dis.readChar());
            }
            return sb.toString();
        }
        if (type.equals(Buffer.class)) {
            return new Buffer(dis);
        }
        if (type.equals(ShortBuffer.class)) {
            return new ShortBuffer(dis);
        }
        if (type.equals(Peer.class)) {
            return new Peer(dis);
        }
        if (type.equals(BitArray.class)) {
            return new BitArray(dis, 16384);
        }
        if (type.equals(NodeCHK.class)) {
            return Key.read(dis);
        }
        if (type.equals(NodeSSK.class)) {
            return Key.read(dis);
        }
        if (type.equals(Key.class)) {
            return Key.read(dis);
        }
        if (type.equals(double[].class)) {
            double[] array = new double[dis.readByte() & 0xFF];
            for (int i = 0; i < array.length; ++i) {
                array[i] = dis.readDouble();
            }
            return array;
        }
        if (type.equals(float[].class)) {
            short length = dis.readShort();
            if (length < 0 || length > 1023) {
                throw new IOException("Invalid flat array length: " + length);
            }
            float[] array = new float[length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = dis.readFloat();
            }
            return array;
        }
        throw new RuntimeException("Unrecognised field type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToDataOutputStream(Object object, DataOutputStream dos) throws IOException {
        Class<?> type = object.getClass();
        if (type.equals(Long.class)) {
            dos.writeLong((Long)object);
        } else if (type.equals(Boolean.class)) {
            dos.writeBoolean((Boolean)object);
        } else if (type.equals(Integer.class)) {
            dos.writeInt((Integer)object);
        } else if (type.equals(Short.class)) {
            dos.writeShort(((Short)object).shortValue());
        } else if (type.equals(Double.class)) {
            dos.writeDouble((Double)object);
        } else if (type.equals(Float.class)) {
            dos.writeFloat(((Float)object).floatValue());
        } else if (WritableToDataOutputStream.class.isAssignableFrom(type)) {
            ((WritableToDataOutputStream)object).writeToDataOutputStream(dos);
        } else if (type.equals(String.class)) {
            String s = (String)object;
            dos.writeInt(s.length());
            for (int x = 0; x < s.length(); ++x) {
                dos.writeChar(s.charAt(x));
            }
        } else if (type.equals(LinkedList.class)) {
            LinkedList ll;
            LinkedList linkedList = ll = (LinkedList)object;
            synchronized (linkedList) {
                dos.writeInt(ll.size());
                for (Object o : ll) {
                    Serializer.writeToDataOutputStream(o, dos);
                }
            }
        } else if (type.equals(Byte.class)) {
            dos.write(((Byte)object).byteValue());
        } else if (type.equals(double[].class)) {
            double[] array = (double[])object;
            if (array.length > 255) {
                throw new IllegalArgumentException("Cannot serialize an array of more than 255 doubles; attempted to serialize " + array.length + ".");
            }
            dos.writeByte(array.length);
            for (double element : array) {
                dos.writeDouble(element);
            }
        } else if (type.equals(float[].class)) {
            dos.writeShort(((float[])object).length);
            for (float element : (float[])object) {
                dos.writeFloat(element);
            }
        } else {
            throw new RuntimeException("Unrecognised field type: " + type);
        }
    }

    public static int length(Class<?> type, int maxStringLength) {
        if (type.equals(Long.class)) {
            return 8;
        }
        if (type.equals(Boolean.class)) {
            return 1;
        }
        if (type.equals(Integer.class)) {
            return 4;
        }
        if (type.equals(Short.class)) {
            return 2;
        }
        if (type.equals(Double.class)) {
            return 8;
        }
        if (WritableToDataOutputStream.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Unknown length for " + type);
        }
        if (type.equals(String.class)) {
            return 4 + maxStringLength * 2;
        }
        if (type.equals(LinkedList.class)) {
            throw new IllegalArgumentException("Unknown length for LinkedList");
        }
        if (type.equals(Byte.class)) {
            return 1;
        }
        throw new RuntimeException("Unrecognised field type: " + type);
    }
}

