/*
 * Decompiled with CFR 0.152.
 */
package com.coi.tools.os.win;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibException
extends Exception {
    private static final long serialVersionUID = 3257002172494721080L;
    private static final HashMap<String, ResourceBundle> messageResourceBundles = new HashMap();
    private int libErr;
    private int osErr;
    private String libErrString;
    private String osErrString;
    private ArrayList<String> args = new ArrayList();

    public static void addResourceBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (messageResourceBundles.containsKey(string)) {
            return;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        messageResourceBundles.put(string, resourceBundle);
    }

    public NativeLibException() {
    }

    public NativeLibException(String string) {
        super(string);
    }

    public NativeLibException(Throwable throwable) {
        super(throwable);
    }

    public NativeLibException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public NativeLibException(int n, int n2, String string, String string2) {
        this.libErr = n;
        this.osErr = n2;
        this.libErrString = string;
        this.osErrString = string2;
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.libErrString != null) {
            stringBuffer.append(this.getLocalizedLibMessage());
            bl = true;
        } else if (this.libErr != 0) {
            if (bl) {
                stringBuffer.append("\n");
            }
            bl = true;
            stringBuffer.append(this.getMsg("libErrNumber." + Integer.toString(this.libErr)));
        }
        if (this.osErr != 0) {
            if (bl) {
                stringBuffer.append("\n");
            }
            bl = true;
            stringBuffer.append(this.getMsg("libInternal.OsErrNumPraefix")).append(Integer.toString(this.osErr));
        }
        if (this.osErrString != null) {
            if (bl) {
                stringBuffer.append("\n");
            }
            bl = true;
            stringBuffer.append(this.getMsg("libInternal.OsErrStringPraefix")).append(this.getOsMessage());
        }
        if (stringBuffer.length() > 0) {
            return this.reviseMsgWithArgs(stringBuffer.toString());
        }
        return null;
    }

    public int getLibErr() {
        return this.libErr;
    }

    public String getLibMessage() {
        return this.libErrString;
    }

    public String getLocalizedLibMessage() {
        return this.getMsg(this.libErrString);
    }

    public int getOsErr() {
        return this.osErr;
    }

    public String getOsMessage() {
        return this.osErrString;
    }

    public void addArgument(String string) {
        this.args.add(string);
    }

    public ArrayList<String> getArguments() {
        return this.args;
    }

    public String reviseMsgWithArgs(String string) {
        for (int i = 0; i < this.args.size(); ++i) {
            String string2 = "{" + Integer.toString(i) + "}";
            string = NativeLibException.replaceString(string, string2, this.args.get(i));
        }
        return string;
    }

    private String getMsg(String string) {
        Iterator<ResourceBundle> iterator = messageResourceBundles.values().iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next().getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return string;
    }

    private static String replaceString(String string, String string2, String string3) {
        if (string.indexOf(string2) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string.indexOf(string2);
            int n3 = string2.length();
            while (n2 >= 0) {
                if (n2 > 0) {
                    stringBuffer.append(string.substring(n, n2));
                }
                stringBuffer.append(string3);
                n = n2 + n3;
                n2 = string.indexOf(string2, n);
            }
            if (string.length() > n) {
                stringBuffer.append(string.substring(n));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    static {
        NativeLibException.addResourceBundle("com.coi.tools.os.win.resources.NativeLibErr");
    }
}

