/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

public final class PrimitiveCodec {
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;

    public static final int readInt(byte[] buffer, int offset) {
        return buffer[offset += 3] & 0xFF | (buffer[--offset] & 0xFF) << 8 | (buffer[--offset] & 0xFF) << 16 | buffer[--offset] << 24;
    }

    public static final void writeInt(byte[] buffer, int offset, int val) {
        buffer[offset += 3] = (byte)val;
        buffer[--offset] = (byte)(val >>= 8);
        buffer[--offset] = (byte)(val >>= 8);
        buffer[--offset] = (byte)(val >> 8);
    }

    public static final void writeLong(byte[] buffer, long val) {
        PrimitiveCodec.writeLong(buffer, 0, val);
    }

    public static final void writeLong(byte[] buffer, int offset, long val) {
        for (int i = 0; i < 8; ++i) {
            buffer[offset++] = (byte)(val >> (7 - i) * 8);
        }
    }

    public static final long readLong(byte[] buffer, int offset) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret = (ret << 8) + (long)(buffer[offset++] & 0xFF);
        }
        return ret;
    }
}

