/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.NotSupportedException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;

public class InMemoryObjectContainer
extends LocalObjectContainer {
    private boolean _closed = false;
    private final MemoryFile _memoryFile;
    private int _length = 0;

    protected InMemoryObjectContainer(Configuration config, ObjectContainerBase parent, MemoryFile memoryFile) throws OldFormatException {
        super(config, parent);
        this._memoryFile = memoryFile;
        this.open();
    }

    public InMemoryObjectContainer(Configuration config, MemoryFile memoryFile) {
        this(config, null, memoryFile);
    }

    @Override
    protected final void openImpl() throws OldFormatException {
        byte[] bytes = this._memoryFile.getBytes();
        if (bytes == null || bytes.length == 0) {
            this._memoryFile.setBytes(new byte[this._memoryFile.getInitialSize()]);
            this.configureNewFile();
            this.commitTransaction();
            this.writeHeader(false, false);
        } else {
            this._length = bytes.length;
            this.readThis();
        }
    }

    @Override
    public void backup(String path) throws NotSupportedException {
        throw new NotSupportedException();
    }

    @Override
    public void blockSize(int size) {
    }

    @Override
    protected void freeInternalResources() {
    }

    @Override
    protected void shutdownDataStorage() {
        if (!this._closed) {
            byte[] temp = new byte[this._length];
            System.arraycopy(this._memoryFile.getBytes(), 0, temp, 0, this._length);
            this._memoryFile.setBytes(temp);
        }
        this._closed = true;
        this.dropReferences();
    }

    protected void dropReferences() {
    }

    @Override
    public void copy(int oldAddress, int oldAddressOffset, int newAddress, int newAddressOffset, int length) {
        int fullNewAddress = newAddress + newAddressOffset;
        this.ensureMemoryFileSize(fullNewAddress + length);
        byte[] bytes = this._memoryFile.getBytes();
        System.arraycopy(bytes, oldAddress + oldAddressOffset, bytes, fullNewAddress, length);
    }

    @Override
    public long fileLength() {
        return this._length;
    }

    @Override
    public String fileName() {
        return "Memory File";
    }

    @Override
    protected boolean hasShutDownHook() {
        return false;
    }

    @Override
    public final boolean needsLockFileThread() {
        return false;
    }

    @Override
    public void readBytes(byte[] bytes, int address, int length) {
        try {
            System.arraycopy(this._memoryFile.getBytes(), address, bytes, 0, length);
        }
        catch (Exception e) {
            Exceptions4.throwRuntimeException(13, e);
        }
    }

    @Override
    public void readBytes(byte[] bytes, int address, int addressOffset, int length) {
        this.readBytes(bytes, address + addressOffset, length);
    }

    @Override
    public void syncFiles() {
    }

    @Override
    public void writeBytes(ByteArrayBuffer buffer, int address, int addressOffset) {
        int fullAddress = address + addressOffset;
        int length = buffer.length();
        this.ensureMemoryFileSize(fullAddress + length);
        System.arraycopy(buffer._buffer, 0, this._memoryFile.getBytes(), fullAddress, length);
    }

    private void ensureMemoryFileSize(int last) {
        if (last < this._length) {
            return;
        }
        byte[] bytes = this._memoryFile.getBytes();
        if (last < bytes.length) {
            this._length = last;
            return;
        }
        int increment = this._memoryFile.getIncrementSizeBy();
        while (last > increment + bytes.length) {
            increment <<= 1;
        }
        byte[] newBytes = new byte[bytes.length + increment];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        this._memoryFile.setBytes(newBytes);
        this._length = newBytes.length;
    }

    @Override
    public void overwriteDeletedBytes(int a_address, int a_length) {
    }

    @Override
    public void reserve(int byteCount) {
        throw new NotSupportedException();
    }

    @Override
    public byte blockSize() {
        return 1;
    }
}

