/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.FetchException;
import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.DownloadRequestStatus;
import freenet.clients.fcp.FCPClientRequestClient;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.GetFailedMessage;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.ListPersistentRequestsMessage;
import freenet.clients.fcp.PersistentRequestRoot;
import freenet.clients.fcp.PutFailedMessage;
import freenet.clients.fcp.RequestCompletionCallback;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.RequestStatusCache;
import freenet.clients.fcp.UploadRequestStatus;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PersistentRequestClient {
    final PersistentRequestRoot root;
    final String name;
    private transient FCPConnectionHandler currentConnection;
    private final List<ClientRequest> runningPersistentRequests;
    private final List<ClientRequest> completedUnackedRequests;
    private final Map<String, ClientRequest> clientRequestsByIdentifier;
    public final boolean isGlobalQueue;
    transient boolean watchGlobal;
    transient int watchGlobalVerbosityMask;
    private transient LinkedList<PersistentRequestClient> clientsWatching;
    private final Object clientsWatchingLock = new Object();
    private RequestClient lowLevelClient;
    private RequestClient lowLevelClientRT;
    private transient List<RequestCompletionCallback> completionCallbacks;
    private final transient RequestStatusCache statusCache;
    final ClientRequest.Persistence persistence;
    private static volatile boolean logMINOR;

    public PersistentRequestClient(String name2, FCPConnectionHandler handler, boolean isGlobalQueue, RequestCompletionCallback cb, ClientRequest.Persistence persistence, PersistentRequestRoot root) {
        this.name = name2;
        if (this.name == null) {
            throw new NullPointerException();
        }
        this.currentConnection = handler;
        boolean forever = persistence == ClientRequest.Persistence.FOREVER;
        this.runningPersistentRequests = new ArrayList<ClientRequest>();
        this.completedUnackedRequests = new ArrayList<ClientRequest>();
        this.clientRequestsByIdentifier = new HashMap<String, ClientRequest>();
        this.isGlobalQueue = isGlobalQueue;
        this.persistence = persistence;
        assert (persistence == ClientRequest.Persistence.FOREVER || persistence == ClientRequest.Persistence.REBOOT);
        this.watchGlobalVerbosityMask = Integer.MAX_VALUE;
        this.lowLevelClient = new FCPClientRequestClient(this, forever, false);
        this.lowLevelClientRT = new FCPClientRequestClient(this, forever, true);
        this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        if (cb != null) {
            this.completionCallbacks.add(cb);
        }
        if (persistence == ClientRequest.Persistence.FOREVER) {
            assert (root != null);
            this.root = root;
        } else {
            this.root = null;
        }
        this.statusCache = isGlobalQueue ? new RequestStatusCache() : null;
    }

    public synchronized FCPConnectionHandler getConnection() {
        return this.currentConnection;
    }

    public synchronized void setConnection(FCPConnectionHandler handler) {
        this.currentConnection = handler;
    }

    public synchronized void onLostConnection(FCPConnectionHandler handler) {
        handler.freeDDAJobs();
        if (this.currentConnection == handler) {
            this.currentConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedClientRequest(ClientRequest get) {
        if (logMINOR) {
            Logger.minor(this, "Finished client request", (Throwable)new Exception("debug"));
        }
        assert (get.persistence == this.persistence);
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            if (this.runningPersistentRequests.remove(get)) {
                this.completedUnackedRequests.add(get);
            }
        }
        if (this.statusCache != null) {
            if (get instanceof ClientGet) {
                Bucket shadow;
                ClientGet download = (ClientGet)get;
                GetFailedMessage msg = download.getFailureMessage();
                FetchException.FetchExceptionMode failureCode = null;
                String shortFailMessage = null;
                String longFailMessage = null;
                if (msg != null) {
                    failureCode = msg.code;
                    shortFailMessage = msg.getShortFailedMessage();
                    longFailMessage = msg.getLongFailedMessage();
                }
                if ((shadow = ((ClientGet)get).getBucket()) != null) {
                    shadow = shadow.createShadow();
                }
                this.statusCache.finishedDownload(get.identifier, get.hasSucceeded(), ((ClientGet)get).getDataSize(), ((ClientGet)get).getMIMEType(), failureCode, longFailMessage, shortFailMessage, shadow, download.filterData());
            } else if (get instanceof ClientPutBase) {
                ClientPutBase upload = (ClientPutBase)get;
                PutFailedMessage msg = upload.getFailureMessage();
                InsertException.InsertExceptionMode failureCode = null;
                String shortFailMessage = null;
                String longFailMessage = null;
                if (msg != null) {
                    failureCode = msg.code;
                    shortFailMessage = msg.getShortFailedMessage();
                    longFailMessage = msg.getLongFailedMessage();
                }
                this.statusCache.finishedUpload(upload.getIdentifier(), upload.hasSucceeded(), upload.getGeneratedURI(), failureCode, shortFailMessage, longFailMessage);
            } else assert (false);
        }
    }

    public void queuePendingMessagesOnConnectionRestartAsync(FCPConnectionOutputHandler outputHandler, ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            ListPersistentRequestsMessage.PersistentListJob job = new ListPersistentRequestsMessage.PersistentListJob(this, outputHandler, context, null){

                @Override
                void complete(ClientContext context) {
                }
            };
            job.run(context);
        } else {
            ListPersistentRequestsMessage.TransientListJob job = new ListPersistentRequestsMessage.TransientListJob(this, outputHandler, context, null){

                @Override
                void complete(ClientContext context) {
                }
            };
            job.run(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuePendingMessagesOnConnectionRestart(FCPConnectionOutputHandler outputHandler, String listRequestIdentifier, int offset, int max) {
        Object[] reqs;
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            reqs = this.completedUnackedRequests.toArray();
        }
        int i = 0;
        for (i = offset; i < Math.min(reqs.length, offset + max); ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            ((ClientRequest)reqs[i]).sendPendingMessages(outputHandler, listRequestIdentifier, false, false);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuePendingMessagesFromRunningRequests(FCPConnectionOutputHandler outputHandler, String listRequestIdentifier, int offset, int max) {
        Object[] reqs;
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            reqs = this.runningPersistentRequests.toArray();
        }
        int i = 0;
        for (i = offset; i < Math.min(reqs.length, offset + max); ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            req.sendPendingMessages(outputHandler, listRequestIdentifier, false, false);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ClientRequest cg) throws IdentifierCollisionException {
        assert (cg.persistence == this.persistence);
        if (logMINOR) {
            Logger.minor(this, "Registering " + cg.getIdentifier());
        }
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            String ident = cg.getIdentifier();
            ClientRequest old = this.clientRequestsByIdentifier.get(ident);
            if (old != null && old != cg) {
                throw new IdentifierCollisionException();
            }
            if (cg.hasFinished()) {
                this.completedUnackedRequests.add(cg);
            } else {
                this.runningPersistentRequests.add(cg);
            }
            this.clientRequestsByIdentifier.put(ident, cg);
        }
        if (this.statusCache != null) {
            if (cg instanceof ClientGet) {
                this.statusCache.addDownload((DownloadRequestStatus)cg.getStatus());
            } else if (cg instanceof ClientPutBase) {
                this.statusCache.addUpload((UploadRequestStatus)cg.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeByIdentifier(String identifier, boolean kill, FCPServer server, ClientContext context) {
        ClientRequest req;
        if (logMINOR) {
            Logger.minor(this, "removeByIdentifier(" + identifier + ',' + kill + ')');
        }
        if (this.statusCache != null) {
            this.statusCache.removeByIdentifier(identifier);
        }
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            req = this.clientRequestsByIdentifier.get(identifier);
            boolean removedFromRunning = false;
            if (req == null) {
                for (ClientRequest r : this.completedUnackedRequests) {
                    if (!r.getIdentifier().equals(identifier)) continue;
                    req = r;
                    this.completedUnackedRequests.remove(r);
                    Logger.error(this, "Found completed unacked request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                    break;
                }
                if (req == null) {
                    for (ClientRequest r : this.runningPersistentRequests) {
                        if (!r.getIdentifier().equals(identifier)) continue;
                        req = r;
                        this.runningPersistentRequests.remove(r);
                        removedFromRunning = true;
                        Logger.error(this, "Found running request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                        break;
                    }
                }
                if (req == null) {
                    return false;
                }
            } else {
                removedFromRunning = this.runningPersistentRequests.remove(req);
                if (!removedFromRunning && !this.completedUnackedRequests.remove(req)) {
                    Logger.error(this, "Removing " + identifier + ": in clientRequestsByIdentifier but not in running/completed maps!");
                    return false;
                }
            }
            this.clientRequestsByIdentifier.remove(identifier);
        }
        if (kill) {
            if (logMINOR) {
                Logger.minor(this, "Killing request " + req);
            }
            req.cancel(context);
        }
        req.requestWasRemoved(context);
        RequestCompletionCallback[] callbacks = null;
        PersistentRequestClient persistentRequestClient2 = this;
        synchronized (persistentRequestClient2) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (PersistentRequestClient persistentRequestClient3 : callbacks) {
                persistentRequestClient3.onRemove(req);
            }
        }
        return true;
    }

    public boolean hasPersistentRequests() {
        return !this.runningPersistentRequests.isEmpty() || !this.completedUnackedRequests.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentRequests(List<ClientRequest> v, boolean onlyForever) {
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                if (req == null) {
                    Logger.error(this, "Request is null on runningPersistentRequests for " + this + " - database corruption??");
                    continue;
                }
                if (!req.isPersistentForever() && onlyForever) continue;
                v.add(req);
            }
            v.addAll(this.completedUnackedRequests);
        }
    }

    private void addPersistentRequestStatus(List<RequestStatus> status, boolean onlyForever) {
        ArrayList<ClientRequest> reqs = new ArrayList<ClientRequest>();
        this.addPersistentRequests(reqs, onlyForever);
        for (ClientRequest req : reqs) {
            try {
                status.add(req.getStatus());
            }
            catch (Throwable t) {
                Logger.error(this, "BROKEN REQUEST LOADING PERSISTENT REQUEST STATUS: " + t, t);
            }
        }
    }

    public void addPersistentRequestStatus(List<RequestStatus> status) {
        this.statusCache.addTo(status);
    }

    public boolean setWatchGlobal(boolean enabled, int verbosityMask, FCPServer server) {
        if (this.isGlobalQueue) {
            Logger.error(this, "Set watch global on global queue!: " + this, (Throwable)new Exception("debug"));
            return false;
        }
        if (server.globalForeverClient == null) {
            return false;
        }
        if (this.watchGlobal && !enabled) {
            server.globalRebootClient.unwatch(this);
            server.globalForeverClient.unwatch(this);
            this.watchGlobal = false;
        } else if (enabled && !this.watchGlobal) {
            server.globalRebootClient.watch(this);
            server.globalForeverClient.watch(this);
            FCPConnectionHandler connHandler = this.getConnection();
            if (connHandler != null) {
                if (this.persistence == ClientRequest.Persistence.REBOOT) {
                    server.globalRebootClient.queuePendingMessagesOnConnectionRestartAsync(connHandler.outputHandler, server.core.clientContext);
                } else {
                    server.globalForeverClient.queuePendingMessagesOnConnectionRestartAsync(connHandler.outputHandler, server.core.clientContext);
                }
            }
            this.watchGlobal = true;
        }
        this.watchGlobalVerbosityMask = verbosityMask;
        return true;
    }

    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel) {
        this.queueClientRequestMessage(msg, verbosityLevel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel, boolean useGlobalMask) {
        if (useGlobalMask && (verbosityLevel & this.watchGlobalVerbosityMask) != verbosityLevel) {
            return;
        }
        FCPConnectionHandler conn = this.getConnection();
        if (conn != null) {
            conn.outputHandler.queue(msg);
        }
        if (!this.isGlobalQueue) return;
        PersistentRequestClient[] persistentRequestClientArray = this.clientsWatchingLock;
        synchronized (this.clientsWatchingLock) {
            if (this.clientsWatching == null) return;
            PersistentRequestClient[] clients = this.clientsWatching.toArray(new PersistentRequestClient[this.clientsWatching.size()]);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            if (clients == null) return;
            persistentRequestClientArray = clients;
            int n = persistentRequestClientArray.length;
            int n2 = 0;
            while (n2 < n) {
                PersistentRequestClient client = persistentRequestClientArray[n2];
                if (client.persistence == this.persistence) {
                    client.queueClientRequestMessage(msg, verbosityLevel, true);
                }
                ++n2;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwatch(PersistentRequestClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        Object object = this.clientsWatchingLock;
        synchronized (object) {
            if (this.clientsWatching != null) {
                this.clientsWatching.remove(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(PersistentRequestClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        Object object = this.clientsWatchingLock;
        synchronized (object) {
            if (this.clientsWatching == null) {
                this.clientsWatching = new LinkedList();
            }
            this.clientsWatching.add(client);
        }
    }

    public synchronized ClientRequest getRequest(String identifier) {
        ClientRequest req = this.clientRequestsByIdentifier.get(identifier);
        return req;
    }

    public String toString() {
        return super.toString() + ':' + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccess(ClientRequest req) {
        assert (req.persistence == this.persistence);
        RequestCompletionCallback[] callbacks = null;
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (PersistentRequestClient persistentRequestClient2 : callbacks) {
                persistentRequestClient2.notifySuccess(req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(ClientRequest req) {
        assert (req.persistence == this.persistence);
        RequestCompletionCallback[] callbacks = null;
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (PersistentRequestClient persistentRequestClient2 : callbacks) {
                persistentRequestClient2.notifyFailure(req);
            }
        }
    }

    public synchronized void addRequestCompletionCallback(RequestCompletionCallback cb) {
        if (this.completionCallbacks == null) {
            this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        }
        this.completionCallbacks.add(cb);
    }

    public synchronized void removeRequestCompletionCallback(RequestCompletionCallback cb) {
        if (this.completionCallbacks != null) {
            this.completionCallbacks.remove(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ClientContext context) {
        HashSet<ClientRequest> toKill = new HashSet<ClientRequest>();
        if (this.statusCache != null) {
            this.statusCache.clear();
        }
        PersistentRequestClient persistentRequestClient = this;
        synchronized (persistentRequestClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                toKill.add(req);
            }
            this.runningPersistentRequests.clear();
            for (ClientRequest req : this.completedUnackedRequests) {
                toKill.add(req);
            }
            this.completedUnackedRequests.clear();
            for (ClientRequest req : this.clientRequestsByIdentifier.values()) {
                toKill.add(req);
            }
            this.clientRequestsByIdentifier.clear();
        }
    }

    public ClientGet getCompletedRequest(FreenetURI key) {
        for (int i = 0; i < this.completedUnackedRequests.size(); ++i) {
            ClientGet getter;
            ClientRequest req = this.completedUnackedRequests.get(i);
            if (!(req instanceof ClientGet) || !(getter = (ClientGet)req).getURI().equals(key)) continue;
            return getter;
        }
        return null;
    }

    public RequestStatusCache getRequestStatusCache() {
        return this.statusCache;
    }

    public void updateRequestStatusCache() {
        this.updateRequestStatusCache(this.statusCache);
    }

    private void updateRequestStatusCache(RequestStatusCache cache) {
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            System.out.println("Loading cache of request statuses...");
            ArrayList<RequestStatus> statuses = new ArrayList<RequestStatus>();
            this.addPersistentRequestStatus(statuses, true);
            for (RequestStatus status : statuses) {
                if (status instanceof DownloadRequestStatus) {
                    cache.addDownload((DownloadRequestStatus)status);
                    continue;
                }
                cache.addUpload((UploadRequestStatus)status);
            }
        }
    }

    public RequestClient lowLevelClient(boolean realTime) {
        if (realTime) {
            return this.lowLevelClientRT;
        }
        return this.lowLevelClient;
    }

    public void addPersistentRequesters(List<ClientRequester> requesters) {
        for (ClientRequest req : this.runningPersistentRequests) {
            requesters.add(req.getClientRequest());
        }
        for (ClientRequest req : this.completedUnackedRequests) {
            requesters.add(req.getClientRequest());
        }
    }

    public void resume(ClientRequest clientRequest) {
        if (clientRequest.hasFinished()) {
            this.completedUnackedRequests.add(clientRequest);
        } else {
            this.runningPersistentRequests.add(clientRequest);
        }
        String identifier = clientRequest.identifier;
        if (this.clientRequestsByIdentifier.get(identifier) != null) {
            if (clientRequest != this.clientRequestsByIdentifier.get(identifier)) {
                throw new IllegalArgumentException("Adding new client request " + clientRequest + " with same name \"" + identifier + "\" as " + this.clientRequestsByIdentifier.get(identifier));
            }
            Logger.error(this, "Adding the same identifier twice: " + identifier);
            return;
        }
        this.clientRequestsByIdentifier.put(identifier, clientRequest);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

