/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.BulkTransmitter;
import freenet.l10n.NodeL10n;
import freenet.node.ConfigurablePersister;
import freenet.node.HourlyStats;
import freenet.node.Location;
import freenet.node.MemoryChecker;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodePinger;
import freenet.node.NodeStarter;
import freenet.node.OpennetManager;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.Persistable;
import freenet.node.Persister;
import freenet.node.RequestTracker;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.SeedClientPeerNode;
import freenet.node.TimeSkewDetectorCallback;
import freenet.node.UIDTag;
import freenet.node.stats.StatsNotAvailableException;
import freenet.node.stats.StoreLocationStats;
import freenet.store.StoreCallback;
import freenet.support.HTMLNode;
import freenet.support.Histogram2;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.StringCounter;
import freenet.support.TimeUtil;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.DecayingKeyspaceAverage;
import freenet.support.math.RunningAverage;
import freenet.support.math.TimeDecayingRunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NodeStats
implements Persistable,
BlockTransmitter.BlockTimeCallback {
    public static final long DEFAULT_SUB_MAX_PING_TIME = TimeUnit.MILLISECONDS.toMillis(700L);
    public static final long DEFAULT_MAX_PING_TIME = TimeUnit.MILLISECONDS.toMillis(1500L);
    public static final long MAX_THROTTLE_DELAY_RT = TimeUnit.SECONDS.toMillis(2L);
    public static final long MAX_THROTTLE_DELAY_BULK = TimeUnit.SECONDS.toMillis(10L);
    public static final long SUB_MAX_THROTTLE_DELAY_RT = TimeUnit.SECONDS.toMillis(1L);
    public static final long SUB_MAX_THROTTLE_DELAY_BULK = TimeUnit.SECONDS.toMillis(5L);
    public static final long MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD = MAX_THROTTLE_DELAY_BULK;
    public static final long MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD = DEFAULT_MAX_PING_TIME;
    public static final long MAX_BWLIMIT_DELAY_TIME_ALERT_DELAY = TimeUnit.MINUTES.toMillis(10L);
    public static final long MAX_NODE_AVERAGE_PING_TIME_ALERT_DELAY = TimeUnit.MINUTES.toMillis(10L);
    public static final long MAX_INTERREQUEST_TIME = TimeUnit.SECONDS.toMillis(10L);
    private final RequestsByLocation incomingRequests = new RequestsByLocation(10);
    private final RequestsByLocation outgoingLocalRequests = new RequestsByLocation(10);
    private final RequestsByLocation outgoingRequests = new RequestsByLocation(10);
    private volatile long subMaxPingTime;
    private volatile long maxPingTime;
    final Node node;
    private MemoryChecker myMemoryChecker;
    public final PeerManager peers;
    final RandomSource hardRandom;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private long firstBwlimitDelayTimeThresholdBreak;
    private long firstNodeAveragePingTimeThresholdBreak;
    public boolean bwlimitDelayAlertRelevant;
    public boolean nodeAveragePingAlertRelevant;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingOverall;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingCHKRequestRT;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingSSKRequestRT;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingCHKInsertRT;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingSSKInsertRT;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingCHKRequestBulk;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingSSKRequestBulk;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingCHKInsertBulk;
    public final BootstrappingDecayingRunningAverage pInstantRejectIncomingSSKInsertBulk;
    private boolean ignoreLocalVsRemoteBandwidthLiability;
    private final RunningAverage throttledPacketSendAverage;
    private final RunningAverage throttledPacketSendAverageRT;
    private final RunningAverage throttledPacketSendAverageBulk;
    final TimeDecayingRunningAverage remoteChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage remoteSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage remoteChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage remoteSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage remoteChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage localChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage localSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage localChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage localSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage localChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage localSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage localChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage localSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkOfferReplyBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskOfferReplyBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkOfferReplyBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskOfferReplyBytesReceivedAverage;
    final TrivialRunningAverage globalFetchPSuccess;
    final TrivialRunningAverage chkLocalFetchPSuccess;
    final TrivialRunningAverage chkRemoteFetchPSuccess;
    final TrivialRunningAverage sskLocalFetchPSuccess;
    final TrivialRunningAverage sskRemoteFetchPSuccess;
    final TrivialRunningAverage blockTransferPSuccessRT;
    final TrivialRunningAverage blockTransferPSuccessBulk;
    final TrivialRunningAverage blockTransferPSuccessLocal;
    final TrivialRunningAverage blockTransferFailTimeout;
    final TrivialRunningAverage successfulLocalCHKFetchTimeAverageRT;
    final TrivialRunningAverage unsuccessfulLocalCHKFetchTimeAverageRT;
    final TrivialRunningAverage localCHKFetchTimeAverageRT;
    final TrivialRunningAverage successfulLocalCHKFetchTimeAverageBulk;
    final TrivialRunningAverage unsuccessfulLocalCHKFetchTimeAverageBulk;
    final TrivialRunningAverage localCHKFetchTimeAverageBulk;
    final TrivialRunningAverage successfulLocalSSKFetchTimeAverageRT;
    final TrivialRunningAverage unsuccessfulLocalSSKFetchTimeAverageRT;
    final TrivialRunningAverage localSSKFetchTimeAverageRT;
    final TrivialRunningAverage successfulLocalSSKFetchTimeAverageBulk;
    final TrivialRunningAverage unsuccessfulLocalSSKFetchTimeAverageBulk;
    final TrivialRunningAverage localSSKFetchTimeAverageBulk;
    public final Histogram2 chkSuccessRatesByLocation;
    private long previous_input_stat;
    private long previous_output_stat;
    private long previous_io_stat_time;
    private long last_input_stat;
    private long last_output_stat;
    private long last_io_stat_time;
    private final Object ioStatSync = new Object();
    private long nextNodeIOStatsUpdateTime = -1L;
    private static final long nodeIOStatsUpdateInterval = 2000L;
    public final RunningAverage routingMissDistanceLocal;
    public final RunningAverage routingMissDistanceRemote;
    public final RunningAverage routingMissDistanceOverall;
    public final RunningAverage routingMissDistanceBulk;
    public final RunningAverage routingMissDistanceRT;
    public final RunningAverage backedOffPercent;
    public final DecayingKeyspaceAverage avgCacheCHKLocation;
    public final DecayingKeyspaceAverage avgSlashdotCacheCHKLocation;
    public final DecayingKeyspaceAverage avgStoreCHKLocation;
    public final DecayingKeyspaceAverage avgStoreCHKSuccess;
    public double furthestCacheCHKSuccess = 0.0;
    public double furthestClientCacheCHKSuccess = 0.0;
    public double furthestSlashdotCacheCHKSuccess = 0.0;
    public double furthestStoreCHKSuccess = 0.0;
    public double furthestStoreSSKSuccess = 0.0;
    public double furthestCacheSSKSuccess = 0.0;
    public double furthestClientCacheSSKSuccess = 0.0;
    public double furthestSlashdotCacheSSKSuccess = 0.0;
    protected final Persister persister;
    protected final DecayingKeyspaceAverage avgRequestLocation;
    public final ThreadGroup rootThreadGroup;
    private int threadLimit;
    final NodePinger nodePinger;
    final StringCounter preemptiveRejectReasons;
    final StringCounter localPreemptiveRejectReasons;
    private int aggressiveGCModificator = -1;
    private long nextPeerManagerUserAlertStatsUpdateTime = -1L;
    private static final long peerManagerUserAlertStatsUpdateInterval = 1000L;
    final Hashtable<String, TrivialRunningAverage> avgMandatoryBackoffTimesRT;
    final Hashtable<String, TrivialRunningAverage> avgMandatoryBackoffTimesBulk;
    final Hashtable<String, TrivialRunningAverage> avgRoutingBackoffTimesRT;
    final Hashtable<String, TrivialRunningAverage> avgRoutingBackoffTimesBulk;
    final Hashtable<String, TrivialRunningAverage> avgTransferBackoffTimesRT;
    final Hashtable<String, TrivialRunningAverage> avgTransferBackoffTimesBulk;
    final Hashtable<String, TrivialRunningAverage> avgDatabaseJobExecutionTimes;
    public final DecayingKeyspaceAverage avgClientCacheCHKLocation;
    public final DecayingKeyspaceAverage avgCacheCHKSuccess;
    public final DecayingKeyspaceAverage avgSlashdotCacheCHKSucess;
    public final DecayingKeyspaceAverage avgClientCacheCHKSuccess;
    public final DecayingKeyspaceAverage avgStoreSSKLocation;
    public final DecayingKeyspaceAverage avgCacheSSKLocation;
    public final DecayingKeyspaceAverage avgSlashdotCacheSSKLocation;
    public final DecayingKeyspaceAverage avgClientCacheSSKLocation;
    public final DecayingKeyspaceAverage avgCacheSSKSuccess;
    public final DecayingKeyspaceAverage avgSlashdotCacheSSKSuccess;
    public final DecayingKeyspaceAverage avgClientCacheSSKSuccess;
    public final DecayingKeyspaceAverage avgStoreSSKSuccess;
    private volatile boolean enableNewLoadManagementRT;
    private volatile boolean enableNewLoadManagementBulk;
    static final long CHECK_THROTTLE_TIME;
    private static final long MAX_PEER_QUEUE_BYTES = 0x400000L;
    private static final long MAX_PEER_QUEUE_TIME;
    private long lastAcceptedRequest = -1L;
    static final double DEFAULT_OVERHEAD = 0.7;
    static final long DEFAULT_ONLY_PERIOD;
    static final long DEFAULT_TRANSITION_PERIOD;
    static final double MIN_NON_OVERHEAD = 0.5;
    static final int BANDWIDTH_LIABILITY_LIMIT_SECONDS_BULK = 120;
    static final int BANDWIDTH_LIABILITY_LIMIT_SECONDS_REALTIME = 60;
    static final int TRANSFER_IN_OUT_OVERHEAD = 256;
    static final int TRANSFER_OUT_IN_OVERHEAD = 256;
    private final Object serializeShouldRejectRequest = new Object();
    static final double ONE_PEER_MAX_PEERS_EQUIVALENT = 2.0;
    static final boolean SEND_LOAD_STATS_NOTICES = true;
    private final DecimalFormat fix3p3pct = new DecimalFormat("##0.000%");
    private final NumberFormat thousandPoint = NumberFormat.getInstance();
    private long chkRequestSentBytes;
    private long chkRequestRcvdBytes;
    private long sskRequestSentBytes;
    private long sskRequestRcvdBytes;
    private long chkInsertSentBytes;
    private long chkInsertRcvdBytes;
    private long sskInsertSentBytes;
    private long sskInsertRcvdBytes;
    private long offeredKeysSenderRcvdBytes;
    private long offeredKeysSenderSentBytes;
    private long offerKeysRcvdBytes;
    private long offerKeysSentBytes;
    ByteCounter sendOffersCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.offerKeysRcvdBytes = NodeStats.this.offerKeysRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.offerKeysSentBytes = NodeStats.this.offerKeysSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long swappingRcvdBytes;
    private long swappingSentBytes;
    private long totalAuthBytesSent;
    private long resendBytesSent;
    public final ByteCounter resendByteCounter = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.resendBytesSent = NodeStats.this.resendBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
            Logger.error(this, "Payload sent in resendByteCounter????", (Throwable)new Exception("error"));
        }
    };
    private long uomBytesSent;
    private long announceBytesSent;
    private long announceBytesPayload;
    public final ByteCounter announceByteCounter = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.announceBytesSent = NodeStats.this.announceBytesSent + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentPayload(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.announceBytesPayload = NodeStats.this.announceBytesPayload + (long)x;
            }
        }
    };
    private long routingStatusBytesSent;
    ByteCounter setRoutingStatusCtr = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
            Logger.error(this, "Routing status sender received bytes: " + x + " - isn't that impossible?");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routingStatusBytesSent = NodeStats.this.routingStatusBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long networkColoringReceivedBytesCounter;
    private long networkColoringSentBytesCounter;
    private long pingBytesReceived;
    private long pingBytesSent;
    public ByteCounter sskRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskRequestRcvdBytes = NodeStats.this.sskRequestRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskRequestSentBytes = NodeStats.this.sskRequestSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    public ByteCounter chkRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkRequestRcvdBytes = NodeStats.this.chkRequestRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkRequestSentBytes = NodeStats.this.chkRequestSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    public ByteCounter sskInsertCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskInsertRcvdBytes = NodeStats.this.sskInsertRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskInsertSentBytes = NodeStats.this.sskInsertSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    public ByteCounter chkInsertCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkInsertRcvdBytes = NodeStats.this.chkInsertRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkInsertSentBytes = NodeStats.this.chkInsertSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long probeRequestSentBytes;
    private long probeRequestRcvdBytes;
    public ByteCounter probeRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.probeRequestRcvdBytes = NodeStats.this.probeRequestRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.probeRequestSentBytes = NodeStats.this.probeRequestSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long routedMessageBytesRcvd;
    private long routedMessageBytesSent;
    public ByteCounter routedMessageCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routedMessageBytesRcvd = NodeStats.this.routedMessageBytesRcvd + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routedMessageBytesSent = NodeStats.this.routedMessageBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long disconnBytesReceived;
    private long disconnBytesSent;
    private long initialMessagesBytesReceived;
    private long initialMessagesBytesSent;
    ByteCounter initialMessagesCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.initialMessagesBytesReceived = NodeStats.this.initialMessagesBytesReceived + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.initialMessagesBytesSent = NodeStats.this.initialMessagesBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long changedIPBytesReceived;
    private long changedIPBytesSent;
    ByteCounter changedIPCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.changedIPBytesReceived = NodeStats.this.changedIPBytesReceived + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.changedIPBytesSent = NodeStats.this.changedIPBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long nodeToNodeRcvdBytes;
    private long nodeToNodeSentBytes;
    final ByteCounter nodeToNodeCounter = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.nodeToNodeRcvdBytes = NodeStats.this.nodeToNodeRcvdBytes + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.nodeToNodeSentBytes = NodeStats.this.nodeToNodeSentBytes + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long allocationNoticesCounterBytesReceived;
    private long allocationNoticesCounterBytesSent;
    final ByteCounter allocationNoticesCounter = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.allocationNoticesCounterBytesReceived = NodeStats.this.allocationNoticesCounterBytesReceived + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.allocationNoticesCounterBytesSent = NodeStats.this.allocationNoticesCounterBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long foafCounterBytesReceived;
    private long foafCounterBytesSent;
    final ByteCounter foafCounter = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.foafCounterBytesReceived = NodeStats.this.foafCounterBytesReceived + (long)x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.foafCounterBytesSent = NodeStats.this.foafCounterBytesSent + (long)x;
            }
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private long notificationOnlySentBytes;
    private HourlyStats hourlyStatsRT;
    private HourlyStats hourlyStatsBulk;
    private int totalAnnouncements;
    private int totalAnnounceForwards;
    private final HashSet<Long> runningAnnouncements = new HashSet();
    private static final int MAX_ANNOUNCEMENTS = 100;
    private RunningAverage nlmDelayRTLocal = new TrivialRunningAverage();
    private RunningAverage nlmDelayRTRemote = new TrivialRunningAverage();
    private RunningAverage nlmDelayBulkLocal = new TrivialRunningAverage();
    private RunningAverage nlmDelayBulkRemote = new TrivialRunningAverage();
    private Object slotTimeoutsSync = new Object();
    private long fatalTimeoutsInWaitLocal;
    private long fatalTimeoutsInWaitRemote;
    private long allocatedSlotLocal;
    private long allocatedSlotRemote;
    final RunningAverage[] REJECT_STATS_AVERAGERS;
    private final Runnable noisyRejectStatsUpdater = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] byArray = NodeStats.this.noisyRejectStats;
                synchronized (byArray) {
                    for (int i = 0; i < NodeStats.this.REJECT_STATS_AVERAGERS.length; ++i) {
                        int result;
                        RunningAverage r = NodeStats.this.REJECT_STATS_AVERAGERS[i];
                        if (r.countReports() < (long)NodeStats.this.minReportsNoisyRejectStats) {
                            result = -1;
                        } else {
                            double noisy = r.currentValue() * 100.0;
                            if (NodeStats.this.rejectStatsFuzz > 0.0) {
                                noisy = NodeStats.this.randomNoise(noisy, NodeStats.this.rejectStatsFuzz);
                            }
                            if (noisy < 0.0) {
                                result = 0;
                            }
                            result = noisy > 100.0 ? 100 : (int)((byte)noisy);
                        }
                        ((NodeStats)NodeStats.this).noisyRejectStats[i] = result;
                    }
                }
            }
            finally {
                NodeStats.this.node.ticker.queueTimedJob(this, NodeStats.this.rejectStatsUpdateInterval);
            }
        }
    };
    private final int minReportsNoisyRejectStats;
    private final long rejectStatsUpdateInterval;
    private final double rejectStatsFuzz;
    private final byte[] noisyRejectStats;

    NodeStats(Node node, int sortOrder, SubConfig statsConfig, int obwLimit, int ibwLimit, int lastVersion) throws NodeInitException {
        int defaultThreadLimit;
        this.node = node;
        this.peers = node.peers;
        this.hardRandom = node.random;
        this.routingMissDistanceLocal = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.routingMissDistanceRemote = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.routingMissDistanceOverall = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.routingMissDistanceBulk = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.routingMissDistanceRT = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.backedOffPercent = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.preemptiveRejectReasons = new StringCounter();
        this.localPreemptiveRejectReasons = new StringCounter();
        this.pInstantRejectIncomingOverall = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingCHKRequestRT = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingSSKRequestRT = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingCHKInsertRT = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingSSKInsertRT = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingCHKRequestBulk = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingSSKRequestBulk = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingCHKInsertBulk = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.pInstantRejectIncomingSSKInsertBulk = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 1000, null);
        this.REJECT_STATS_AVERAGERS = new RunningAverage[]{this.pInstantRejectIncomingCHKRequestBulk, this.pInstantRejectIncomingSSKRequestBulk, this.pInstantRejectIncomingCHKInsertBulk, this.pInstantRejectIncomingSSKInsertBulk};
        this.noisyRejectStats = new byte[4];
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        this.rootThreadGroup = tg;
        this.throttledPacketSendAverage = new BootstrappingDecayingRunningAverage(0.0, 0.0, 9.223372036854776E18, 100, null);
        this.throttledPacketSendAverageRT = new BootstrappingDecayingRunningAverage(0.0, 0.0, 9.223372036854776E18, 100, null);
        this.throttledPacketSendAverageBulk = new BootstrappingDecayingRunningAverage(0.0, 0.0, 9.223372036854776E18, 100, null);
        this.nodePinger = new NodePinger(node);
        this.previous_input_stat = 0L;
        this.previous_output_stat = 0L;
        this.previous_io_stat_time = 1L;
        this.last_input_stat = 0L;
        this.last_output_stat = 0L;
        this.last_io_stat_time = 3L;
        long memoryLimit = NodeStarter.getMemoryLimitMB();
        System.out.println("Memory is " + memoryLimit + "MB");
        if (memoryLimit > 0L && memoryLimit < 100L) {
            defaultThreadLimit = 200;
            System.out.println("Severe memory pressure, setting 200 thread limit. Freenet may not work well!");
        } else if (memoryLimit > 0L && memoryLimit < 128L) {
            defaultThreadLimit = 300;
            System.out.println("Moderate memory pressure, setting 300 thread limit. Increase your memory limit in wrapper.conf if possible.");
        } else if (memoryLimit > 0L && memoryLimit < 192L) {
            defaultThreadLimit = 400;
            System.out.println("Setting 400 thread limit due to <=192MB memory limit. This should be enough but more memory is better.");
        } else {
            System.out.println("Setting standard 500 thread limit. This should be enough for most nodes but more memory is usually a good thing.");
            defaultThreadLimit = 500;
        }
        statsConfig.register("threadLimit", defaultThreadLimit, sortOrder++, true, true, "NodeStat.threadLimit", "NodeStat.threadLimitLong", new IntCallback(){

            @Override
            public Integer get() {
                return NodeStats.this.threadLimit;
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                if (val < 100) {
                    throw new InvalidConfigValueException(NodeStats.this.l10n("valueTooLow"));
                }
                NodeStats.this.threadLimit = val;
            }
        }, false);
        this.threadLimit = statsConfig.getInt("threadLimit");
        statsConfig.register("aggressiveGC", this.aggressiveGCModificator, sortOrder++, true, false, "NodeStat.aggressiveGC", "NodeStat.aggressiveGCLong", new IntCallback(){

            @Override
            public Integer get() {
                return NodeStats.this.aggressiveGCModificator;
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                Logger.normal(this, "Changing aggressiveGCModificator to " + val);
                NodeStats.this.aggressiveGCModificator = val;
            }
        }, false);
        this.aggressiveGCModificator = statsConfig.getInt("aggressiveGC");
        this.myMemoryChecker = new MemoryChecker(node.getTicker(), this.aggressiveGCModificator);
        statsConfig.register("memoryChecker", true, sortOrder++, true, false, "NodeStat.memCheck", "NodeStat.memCheckLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeStats.this.myMemoryChecker.isRunning();
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                if (val.booleanValue()) {
                    NodeStats.this.myMemoryChecker.start();
                } else {
                    NodeStats.this.myMemoryChecker.terminate();
                }
            }
        });
        if (statsConfig.getBoolean("memoryChecker")) {
            this.myMemoryChecker.start();
        }
        statsConfig.register("ignoreLocalVsRemoteBandwidthLiability", false, sortOrder++, true, false, "NodeStat.ignoreLocalVsRemoteBandwidthLiability", "NodeStat.ignoreLocalVsRemoteBandwidthLiabilityLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                NodeStats nodeStats = NodeStats.this;
                synchronized (nodeStats) {
                    return NodeStats.this.ignoreLocalVsRemoteBandwidthLiability;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                NodeStats nodeStats = NodeStats.this;
                synchronized (nodeStats) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = val;
                }
            }
        });
        this.ignoreLocalVsRemoteBandwidthLiability = statsConfig.getBoolean("ignoreLocalVsRemoteBandwidthLiability");
        statsConfig.register("maxPingTime", DEFAULT_MAX_PING_TIME, sortOrder++, true, true, "NodeStat.maxPingTime", "NodeStat.maxPingTimeLong", new LongCallback(){

            @Override
            public Long get() {
                return NodeStats.this.maxPingTime;
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeStats.this.maxPingTime = val;
            }
        }, false);
        this.maxPingTime = statsConfig.getLong("maxPingTime");
        statsConfig.register("subMaxPingTime", DEFAULT_SUB_MAX_PING_TIME, sortOrder++, true, true, "NodeStat.subMaxPingTime", "NodeStat.subMaxPingTimeLong", new LongCallback(){

            @Override
            public Long get() {
                return NodeStats.this.subMaxPingTime;
            }

            @Override
            public void set(Long val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeStats.this.subMaxPingTime = val;
            }
        }, false);
        this.subMaxPingTime = statsConfig.getLong("subMaxPingTime");
        node.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = true;
                }
                if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = false;
                }
            }
        });
        statsConfig.register("enableNewLoadManagementRT", false, sortOrder++, true, false, "Node.enableNewLoadManagementRT", "Node.enableNewLoadManagementRTLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeStats.this.enableNewLoadManagementRT;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeStats.this.enableNewLoadManagementRT = val;
            }
        });
        this.enableNewLoadManagementRT = statsConfig.getBoolean("enableNewLoadManagementRT");
        statsConfig.register("enableNewLoadManagementBulk", false, sortOrder++, true, false, "Node.enableNewLoadManagementBulk", "Node.enableNewLoadManagementBulkLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return NodeStats.this.enableNewLoadManagementBulk;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeStats.this.enableNewLoadManagementBulk = val;
            }
        });
        this.enableNewLoadManagementBulk = statsConfig.getBoolean("enableNewLoadManagementBulk");
        if (node.lastVersion <= 1455 && (this.enableNewLoadManagementRT || this.enableNewLoadManagementBulk)) {
            this.enableNewLoadManagementRT = false;
            this.enableNewLoadManagementBulk = false;
            System.err.println("Turning off NLM when upgrading from pre-1455. The load stats messages aren't being sent at the moment so it won't work anyway.");
            statsConfig.config.store();
        }
        this.persister = new ConfigurablePersister(this, statsConfig, "nodeThrottleFile", "node-throttle.dat", sortOrder++, true, false, "NodeStat.statsPersister", "NodeStat.statsPersisterLong", node.ticker, node.getRunDir());
        SimpleFieldSet throttleFS = this.persister.read();
        if (logMINOR) {
            Logger.minor(this, "Read throttleFS:\n" + throttleFS);
        }
        this.localChkFetchBytesSentAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localSskFetchBytesSentAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localChkInsertBytesSentAverage = new TimeDecayingRunningAverage(32768.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2048.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(34816.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2048.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(1024.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkFetchBytesSentAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskFetchBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkInsertBytesSentAverage = new TimeDecayingRunningAverage(66560.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(34292.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("RemoteSskInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkFetchBytesSentAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskFetchBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkInsertBytesSentAverage = new TimeDecayingRunningAverage(66560.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkOfferReplyBytesSentAverage = new TimeDecayingRunningAverage(33268.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("successfulChkOfferReplyBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskOfferReplyBytesSentAverage = new TimeDecayingRunningAverage(3072.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("successfulSskOfferReplyBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(34292.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("SuccessfulSskInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkOfferReplyBytesReceivedAverage = new TimeDecayingRunningAverage(33268.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("successfulChkOfferReplyBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskOfferReplyBytesReceivedAverage = new TimeDecayingRunningAverage(3072.0, 180000L, 0.0, 204800.0, throttleFS == null ? null : throttleFS.subset("successfulSskOfferReplyBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.globalFetchPSuccess = new TrivialRunningAverage();
        this.chkLocalFetchPSuccess = new TrivialRunningAverage();
        this.chkRemoteFetchPSuccess = new TrivialRunningAverage();
        this.sskLocalFetchPSuccess = new TrivialRunningAverage();
        this.sskRemoteFetchPSuccess = new TrivialRunningAverage();
        this.blockTransferPSuccessRT = new TrivialRunningAverage();
        this.blockTransferPSuccessBulk = new TrivialRunningAverage();
        this.blockTransferPSuccessLocal = new TrivialRunningAverage();
        this.blockTransferFailTimeout = new TrivialRunningAverage();
        this.successfulLocalCHKFetchTimeAverageRT = new TrivialRunningAverage();
        this.unsuccessfulLocalCHKFetchTimeAverageRT = new TrivialRunningAverage();
        this.localCHKFetchTimeAverageRT = new TrivialRunningAverage();
        this.successfulLocalCHKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.unsuccessfulLocalCHKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.localCHKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.successfulLocalSSKFetchTimeAverageRT = new TrivialRunningAverage();
        this.unsuccessfulLocalSSKFetchTimeAverageRT = new TrivialRunningAverage();
        this.localSSKFetchTimeAverageRT = new TrivialRunningAverage();
        this.successfulLocalSSKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.unsuccessfulLocalSSKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.localSSKFetchTimeAverageBulk = new TrivialRunningAverage();
        this.chkSuccessRatesByLocation = new Histogram2(10, 1.0);
        double nodeLoc = node.lm.getLocation();
        this.avgCacheCHKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageCacheCHKLocation"));
        this.avgStoreCHKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageStoreCHKLocation"));
        this.avgSlashdotCacheCHKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageSlashdotCacheCHKLocation"));
        this.avgClientCacheCHKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageClientCacheCHKLocation"));
        this.avgCacheCHKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageCacheCHKSuccessLocation"));
        this.avgSlashdotCacheCHKSucess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageSlashdotCacheCHKSuccessLocation"));
        this.avgClientCacheCHKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageClientCacheCHKSuccessLocation"));
        this.avgStoreCHKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageStoreCHKSuccessLocation"));
        this.avgRequestLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageRequestLocation"));
        this.avgCacheSSKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageCacheSSKLocation"));
        this.avgStoreSSKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageStoreSSKLocation"));
        this.avgSlashdotCacheSSKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageSlashdotCacheSSKLocation"));
        this.avgClientCacheSSKLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageClientCacheSSKLocation"));
        this.avgCacheSSKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageCacheSSKSuccessLocation"));
        this.avgSlashdotCacheSSKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageSlashdotCacheSSKSuccessLocation"));
        this.avgClientCacheSSKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageClientCacheSSKSuccessLocation"));
        this.avgStoreSSKSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageStoreSSKSuccessLocation"));
        this.hourlyStatsRT = new HourlyStats(node);
        this.hourlyStatsBulk = new HourlyStats(node);
        this.avgMandatoryBackoffTimesRT = new Hashtable();
        this.avgMandatoryBackoffTimesBulk = new Hashtable();
        this.avgRoutingBackoffTimesRT = new Hashtable();
        this.avgRoutingBackoffTimesBulk = new Hashtable();
        this.avgTransferBackoffTimesRT = new Hashtable();
        this.avgTransferBackoffTimesBulk = new Hashtable();
        this.avgDatabaseJobExecutionTimes = new Hashtable();
        if (!NodeStarter.isTestingVM()) {
            this.minReportsNoisyRejectStats = 200;
            this.rejectStatsUpdateInterval = TimeUnit.MINUTES.toMillis(10L);
            this.rejectStatsFuzz = 10.0;
        } else {
            this.minReportsNoisyRejectStats = 1;
            this.rejectStatsUpdateInterval = TimeUnit.SECONDS.toMillis(10L);
            this.rejectStatsFuzz = -1.0;
        }
        statsConfig.finishedInitialization();
    }

    protected String l10n(String key) {
        return NodeL10n.getBase().getString("NodeStats." + key);
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("NodeStats." + key, patterns, values);
    }

    public void start() throws NodeInitException {
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                NodeStats.this.nodePinger.start();
            }
        }, "Starting NodePinger");
        this.persister.start();
        this.noisyRejectStatsUpdater.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RejectReason shouldRejectRequest(boolean canAcceptAnyway, boolean isInsert, boolean isSSK, boolean isLocal, boolean isOfferReply, PeerNode source, boolean hasInStore, boolean preferInsert, boolean realTimeFlag, UIDTag tag) {
        Object object = this.serializeShouldRejectRequest;
        synchronized (object) {
            double nonOverheadFraction;
            long now;
            block26: {
                if (logMINOR) {
                    this.dumpByteCostAverages();
                }
                if (source != null && source.isDisconnecting()) {
                    return new RejectReason("disconnecting", false);
                }
                int threadCount = this.getActiveThreadCount();
                if (this.threadLimit < threadCount) {
                    this.rejected(">threadLimit", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                    return new RejectReason(">threadLimit (" + threadCount + '/' + this.threadLimit + ')', false);
                }
                now = System.currentTimeMillis();
                nonOverheadFraction = this.getNonOverheadFraction(now);
                double pingTime = this.nodePinger.averagePingTime();
                NodeStats nodeStats = this;
                synchronized (nodeStats) {
                    double x;
                    block25: {
                        if (!(pingTime > (double)this.maxPingTime)) break block25;
                        if (now - this.lastAcceptedRequest > MAX_INTERREQUEST_TIME && canAcceptAnyway) {
                            if (logMINOR) {
                                Logger.minor(this, "Accepting request anyway (take one every 10 secs to keep bwlimitDelayTime updated)");
                            }
                            break block26;
                        } else {
                            this.rejected(">MAX_PING_TIME", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                            return new RejectReason(">MAX_PING_TIME (" + TimeUtil.formatTime((long)pingTime, 2, true) + ')', false);
                        }
                    }
                    if (pingTime > (double)this.subMaxPingTime && this.randomLessThan(x = (pingTime - (double)this.subMaxPingTime) / (double)(this.maxPingTime - this.subMaxPingTime), preferInsert)) {
                        this.rejected(">SUB_MAX_PING_TIME", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                        return new RejectReason(">SUB_MAX_PING_TIME (" + TimeUtil.formatTime((long)pingTime, 2, true) + ')', false);
                    }
                }
            }
            int transfersPerInsert = this.outwardTransfersPerInsert();
            RunningRequestsSnapshot requestsSnapshot = new RunningRequestsSnapshot(this.node.tracker, this.ignoreLocalVsRemoteBandwidthLiability, transfersPerInsert, realTimeFlag);
            if (logMINOR) {
                requestsSnapshot.log();
            }
            long limit = this.getLimitSeconds(realTimeFlag);
            if (hasInStore) {
                limit += 10L;
                if (logMINOR) {
                    Logger.minor(this, "Maybe accepting extra request due to it being in datastore (limit now " + limit + "s)...");
                }
            }
            int peers = this.node.peers.countConnectedPeers();
            RunningRequestsSnapshot peerRequestsSnapshot = new RunningRequestsSnapshot(this.node.tracker, source, false, this.ignoreLocalVsRemoteBandwidthLiability, transfersPerInsert, realTimeFlag);
            if (logMINOR) {
                peerRequestsSnapshot.log(source);
            }
            int maxTransfersOutUpperLimit = this.getMaxTransfersUpperLimit(realTimeFlag, nonOverheadFraction);
            int maxTransfersOutLowerLimit = (int)Math.max(1.0, this.getLowerLimit(maxTransfersOutUpperLimit, peers));
            int maxTransfersOutPeerLimit = (int)Math.max(1.0, this.getPeerLimit(source, maxTransfersOutUpperLimit - maxTransfersOutLowerLimit, false, transfersPerInsert, realTimeFlag, peers, peerRequestsSnapshot.expectedTransfersOutCHKSR + peerRequestsSnapshot.expectedTransfersOutSSKSR));
            int maxOutputTransfers = this.calculateMaxTransfersOut(source, realTimeFlag, nonOverheadFraction, maxTransfersOutUpperLimit);
            String ret = this.checkBandwidthLiability(this.getOutputBandwidthUpperLimit(limit, nonOverheadFraction), requestsSnapshot, peerRequestsSnapshot, false, limit, source, isLocal, isSSK, isInsert, isOfferReply, hasInStore, transfersPerInsert, realTimeFlag, maxOutputTransfers, maxTransfersOutPeerLimit, tag);
            if (ret != null) {
                return new RejectReason(ret, true);
            }
            ret = this.checkBandwidthLiability(this.getInputBandwidthUpperLimit(limit), requestsSnapshot, peerRequestsSnapshot, true, limit, source, isLocal, isSSK, isInsert, isOfferReply, hasInStore, transfersPerInsert, realTimeFlag, maxOutputTransfers, maxTransfersOutPeerLimit, tag);
            if (ret != null) {
                return new RejectReason(ret, true);
            }
            ret = this.checkMaxOutputTransfers(maxOutputTransfers, maxTransfersOutUpperLimit, maxTransfersOutLowerLimit, maxTransfersOutPeerLimit, requestsSnapshot, peerRequestsSnapshot, isLocal, realTimeFlag, isInsert, isSSK, isOfferReply, tag);
            if (ret != null) {
                return new RejectReason(ret, true);
            }
            if (source != null) {
                if (source.getMessageQueueLengthBytes() > 0x400000L) {
                    this.rejected(">MAX_PEER_QUEUE_BYTES", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                    return new RejectReason("Too many message bytes queued for peer", false);
                }
                if (source.getProbableSendQueueTime() > MAX_PEER_QUEUE_TIME) {
                    this.rejected(">MAX_PEER_QUEUE_TIME", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                    return new RejectReason("Peer's queue will take too long to transfer", false);
                }
            }
            NodeStats nodeStats = this;
            synchronized (nodeStats) {
                if (logMINOR) {
                    Logger.minor(this, "Accepting request? (isSSK=" + isSSK + ")");
                }
                this.lastAcceptedRequest = now;
            }
            this.accepted(isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
            if (tag != null) {
                tag.setAccepted();
            }
            return null;
        }
    }

    private int getLimitSeconds(boolean realTimeFlag) {
        return realTimeFlag ? 60 : 120;
    }

    public int calculateMaxTransfersOut(PeerNode peer, boolean realTime, double nonOverheadFraction, int maxTransfersOutUpperLimit) {
        if (peer == null) {
            return Integer.MAX_VALUE;
        }
        return Math.min(maxTransfersOutUpperLimit, peer.calculateMaxTransfersOut(this.getAcceptableBlockTime(realTime), nonOverheadFraction));
    }

    private int getAcceptableBlockTime(boolean realTime) {
        return realTime ? 2 : 15;
    }

    public double getLowerLimit(double upperLimit, int peerCount) {
        return upperLimit / 2.0;
    }

    public int outwardTransfersPerInsert() {
        return 1;
    }

    private double getInputBandwidthUpperLimit(long limit) {
        return (long)this.node.getInputBandwidthLimit() * limit;
    }

    private double getNonOverheadFraction(long now) {
        long[] total = this.node.collector.getTotalIO();
        long totalSent = total[0];
        long totalOverhead = this.getSentOverhead();
        long uptime = this.node.getUptime();
        double totalCouldSend = Math.max((double)totalSent, (double)((long)this.node.getOutputBandwidthLimit() * uptime) / 1000.0);
        double nonOverheadFraction = (totalCouldSend - (double)totalOverhead) / totalCouldSend;
        long timeFirstAnyConnections = this.peers.timeFirstAnyConnections;
        if (timeFirstAnyConnections > 0L) {
            long time = now - timeFirstAnyConnections;
            if (time < DEFAULT_ONLY_PERIOD) {
                nonOverheadFraction = 0.7;
                if (logMINOR) {
                    Logger.minor(this, "Adjusted non-overhead fraction: " + nonOverheadFraction);
                }
            } else if (time < DEFAULT_ONLY_PERIOD + DEFAULT_TRANSITION_PERIOD) {
                nonOverheadFraction = ((double)(time -= DEFAULT_ONLY_PERIOD) * nonOverheadFraction + (double)(DEFAULT_TRANSITION_PERIOD - time) * 0.7) / (double)DEFAULT_TRANSITION_PERIOD;
                if (logMINOR) {
                    Logger.minor(this, "Adjusted non-overhead fraction: " + nonOverheadFraction);
                }
            }
        }
        if (nonOverheadFraction < 0.5) {
            Logger.warning(this, "Non-overhead fraction is " + nonOverheadFraction + " - assuming this is self-inflicted and using default");
            nonOverheadFraction = 0.5;
        }
        if (nonOverheadFraction > 1.0) {
            Logger.error(this, "Non-overhead fraction is >1.0!!!");
            return 1.0;
        }
        return nonOverheadFraction;
    }

    private double getOutputBandwidthUpperLimit(long limit, double nonOverheadFraction) {
        double outputAvailablePerSecond = (double)this.node.getOutputBandwidthLimit() * nonOverheadFraction;
        return outputAvailablePerSecond * (double)limit;
    }

    private int getMaxTransfersUpperLimit(boolean realTime, double nonOverheadFraction) {
        double outputAvailablePerSecond = (double)this.node.getOutputBandwidthLimit() * nonOverheadFraction;
        return (int)Math.max(1.0, (double)this.getAcceptableBlockTime(realTime) * outputAvailablePerSecond / 1024.0);
    }

    private String checkBandwidthLiability(double bandwidthAvailableOutputUpperLimit, RunningRequestsSnapshot requestsSnapshot, RunningRequestsSnapshot peerRequestsSnapshot, boolean input, long limit, PeerNode source, boolean isLocal, boolean isSSK, boolean isInsert, boolean isOfferReply, boolean hasInStore, int transfersPerInsert, boolean realTimeFlag, int maxOutputTransfers, int maxOutputTransfersPeerLimit, UIDTag tag) {
        String name = input ? "Input" : "Output";
        int peers = this.node.peers.countConnectedPeers();
        double bandwidthAvailableOutputLowerLimit = this.getLowerLimit(bandwidthAvailableOutputUpperLimit, peers);
        double bandwidthLiabilityOutput = requestsSnapshot.calculate(this.ignoreLocalVsRemoteBandwidthLiability, input);
        double thisAllocation = this.getPeerLimit(source, bandwidthAvailableOutputUpperLimit - bandwidthAvailableOutputLowerLimit, input, transfersPerInsert, realTimeFlag, peers, peerRequestsSnapshot.calculateSR(this.ignoreLocalVsRemoteBandwidthLiability, input));
        if (source != null) {
            if (!input) {
                source.onSetMaxOutputTransfers(realTimeFlag, maxOutputTransfers);
                source.onSetMaxOutputTransfersPeerLimit(realTimeFlag, maxOutputTransfersPeerLimit);
            }
            source.onSetPeerAllocation(input, (int)thisAllocation, transfersPerInsert, maxOutputTransfers, realTimeFlag);
        }
        if (bandwidthLiabilityOutput > bandwidthAvailableOutputUpperLimit) {
            Logger.warning(this, "Above upper limit. Not rejecting as this can occasionally happen due to reassigns: upper limit " + bandwidthAvailableOutputUpperLimit + " usage is " + bandwidthLiabilityOutput);
        }
        if (bandwidthLiabilityOutput > bandwidthAvailableOutputLowerLimit) {
            double peerUsedBytes;
            if (logMINOR) {
                Logger.minor(this, "Allocation (" + name + ") for " + source + " is " + thisAllocation + " total usage is " + bandwidthLiabilityOutput + " of lower limit" + bandwidthAvailableOutputLowerLimit + " upper limit is " + bandwidthAvailableOutputUpperLimit + " for " + name);
            }
            if ((peerUsedBytes = this.getPeerBandwidthLiability(peerRequestsSnapshot, source, isSSK, transfersPerInsert, input)) > thisAllocation) {
                this.rejected(name + " bandwidth liability: fairness between peers", isLocal, isInsert, isSSK, isOfferReply, realTimeFlag);
                return name + " bandwidth liability: fairness between peers (peer " + source + " used " + peerUsedBytes + " allowed " + thisAllocation + ")";
            }
        } else if (logMINOR) {
            Logger.minor(this, "Total usage is " + bandwidthLiabilityOutput + " below lower limit " + bandwidthAvailableOutputLowerLimit + " for " + name);
        }
        return null;
    }

    private String checkMaxOutputTransfers(int maxOutputTransfers, int maxTransfersOutUpperLimit, int maxTransfersOutLowerLimit, int maxTransfersOutPeerLimit, RunningRequestsSnapshot requestsSnapshot, RunningRequestsSnapshot peerRequestsSnapshot, boolean isLocal, boolean realTime, boolean isInsert, boolean isSSK, boolean isOfferReply, UIDTag tag) {
        if (logMINOR) {
            Logger.minor(this, "Max transfers: congestion control limit " + maxOutputTransfers + " upper " + maxTransfersOutUpperLimit + " lower " + maxTransfersOutLowerLimit + " peer " + maxTransfersOutPeerLimit + " " + (realTime ? "(rt)" : "(bulk)"));
        }
        int peerOutTransfers = peerRequestsSnapshot.totalOutTransfers();
        int totalOutTransfers = requestsSnapshot.totalOutTransfers();
        if (peerOutTransfers > maxOutputTransfers && !isLocal) {
            this.rejected("TooManyTransfers: Congestion control", isLocal, isInsert, isSSK, isOfferReply, realTime);
            return "TooManyTransfers: Congestion control";
        }
        if (totalOutTransfers <= maxTransfersOutLowerLimit) {
            return null;
        }
        if (peerOutTransfers <= maxTransfersOutPeerLimit) {
            return null;
        }
        this.rejected("TooManyTransfers: Fair sharing between peers", isLocal, isInsert, isSSK, isOfferReply, realTime);
        return "TooManyTransfers: Fair sharing between peers";
    }

    private double getPeerLimit(PeerNode source, double totalGuaranteedBandwidth, boolean input, int transfersPerInsert, boolean realTimeFlag, int peers, double sourceRestarted) {
        double totalAllocation = totalGuaranteedBandwidth;
        double localAllocation = totalAllocation * 0.5;
        double thisAllocation = source == null ? localAllocation : (totalAllocation -= localAllocation) / (double)peers;
        if (logMINOR && sourceRestarted != 0.0) {
            Logger.minor(this, "Allocation is " + thisAllocation + " source restarted is " + sourceRestarted);
        }
        return thisAllocation - sourceRestarted;
    }

    private double getPeerBandwidthLiability(RunningRequestsSnapshot requestsSnapshot, PeerNode source, boolean ignoreLocalVsRemote, int transfersOutPerInsert, boolean input) {
        return requestsSnapshot.calculate(this.ignoreLocalVsRemoteBandwidthLiability, input);
    }

    private boolean randomLessThan(double x, boolean preferInsert) {
        if (preferInsert) {
            for (int i = 0; i < 3; ++i) {
                if (!(this.hardRandom.nextDouble() >= x)) continue;
                return false;
            }
            return true;
        }
        return this.hardRandom.nextDouble() < x;
    }

    private void rejected(String reason, boolean isLocal, boolean isInsert, boolean isSSK, boolean isOfferReply, boolean isRealTime) {
        reason = reason + " " + (isRealTime ? " (rt)" : " (bulk)");
        if (logMINOR) {
            Logger.minor(this, "Rejecting (local=" + isLocal + ") isSSK=" + isSSK + " isInsert=" + isInsert + " : " + reason);
        }
        if (!isLocal) {
            this.preemptiveRejectReasons.inc(reason);
        } else {
            this.localPreemptiveRejectReasons.inc(reason);
        }
        if (!isLocal && !isOfferReply) {
            this.pInstantRejectIncomingOverall.report(1.0);
            this.getRejectedTracker(isRealTime, isSSK, isInsert).report(1.0);
        }
    }

    private void accepted(boolean isLocal, boolean isInsert, boolean isSSK, boolean isOfferReply, boolean realTimeFlag) {
        if (!isLocal && !isOfferReply) {
            this.pInstantRejectIncomingOverall.report(0.0);
            this.getRejectedTracker(realTimeFlag, isSSK, isInsert).report(0.0);
        }
    }

    private BootstrappingDecayingRunningAverage getRejectedTracker(boolean isRealTime, boolean isSSK, boolean isInsert) {
        if (isRealTime) {
            if (isSSK) {
                return isInsert ? this.pInstantRejectIncomingSSKInsertRT : this.pInstantRejectIncomingSSKRequestRT;
            }
            return isInsert ? this.pInstantRejectIncomingCHKInsertRT : this.pInstantRejectIncomingCHKRequestRT;
        }
        if (isSSK) {
            return isInsert ? this.pInstantRejectIncomingSSKInsertBulk : this.pInstantRejectIncomingSSKRequestBulk;
        }
        return isInsert ? this.pInstantRejectIncomingCHKInsertBulk : this.pInstantRejectIncomingCHKRequestBulk;
    }

    private RunningAverage getThrottle(boolean isLocal, boolean isInsert, boolean isSSK, boolean isSent) {
        if (isLocal) {
            if (isInsert) {
                if (isSSK) {
                    return isSent ? this.localSskInsertBytesSentAverage : this.localSskInsertBytesReceivedAverage;
                }
                return isSent ? this.localChkInsertBytesSentAverage : this.localChkInsertBytesReceivedAverage;
            }
            if (isSSK) {
                return isSent ? this.localSskFetchBytesSentAverage : this.localSskFetchBytesReceivedAverage;
            }
            return isSent ? this.localChkFetchBytesSentAverage : this.localChkFetchBytesReceivedAverage;
        }
        if (isInsert) {
            if (isSSK) {
                return isSent ? this.remoteSskInsertBytesSentAverage : this.remoteSskInsertBytesReceivedAverage;
            }
            return isSent ? this.remoteChkInsertBytesSentAverage : this.remoteChkInsertBytesReceivedAverage;
        }
        if (isSSK) {
            return isSent ? this.remoteSskFetchBytesSentAverage : this.remoteSskFetchBytesReceivedAverage;
        }
        return isSent ? this.remoteChkFetchBytesSentAverage : this.remoteChkFetchBytesReceivedAverage;
    }

    private void dumpByteCostAverages() {
        Logger.minor(this, "Byte cost averages: REMOTE: CHK insert " + this.remoteChkInsertBytesSentAverage.currentValue() + '/' + this.remoteChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.remoteSskInsertBytesSentAverage.currentValue() + '/' + this.remoteSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.remoteChkFetchBytesSentAverage.currentValue() + '/' + this.remoteChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.remoteSskFetchBytesSentAverage.currentValue() + '/' + this.remoteSskFetchBytesReceivedAverage.currentValue());
        Logger.minor(this, "Byte cost averages: LOCAL: CHK insert " + this.localChkInsertBytesSentAverage.currentValue() + '/' + this.localChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.localSskInsertBytesSentAverage.currentValue() + '/' + this.localSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.localChkFetchBytesSentAverage.currentValue() + '/' + this.localChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.localSskFetchBytesSentAverage.currentValue() + '/' + this.localSskFetchBytesReceivedAverage.currentValue());
        Logger.minor(this, "Byte cost averages: SUCCESSFUL: CHK insert " + this.successfulChkInsertBytesSentAverage.currentValue() + '/' + this.successfulChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.successfulSskInsertBytesSentAverage.currentValue() + '/' + this.successfulSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.successfulChkFetchBytesSentAverage.currentValue() + '/' + this.successfulChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.successfulSskFetchBytesSentAverage.currentValue() + '/' + this.successfulSskFetchBytesReceivedAverage.currentValue() + " CHK offer reply " + this.successfulChkOfferReplyBytesSentAverage.currentValue() + '/' + this.successfulChkOfferReplyBytesReceivedAverage.currentValue() + " SSK offer reply " + this.successfulSskOfferReplyBytesSentAverage.currentValue() + '/' + this.successfulSskOfferReplyBytesReceivedAverage.currentValue());
    }

    public double getBwlimitDelayTimeRT() {
        return this.throttledPacketSendAverageRT.currentValue();
    }

    public double getBwlimitDelayTimeBulk() {
        return this.throttledPacketSendAverageBulk.currentValue();
    }

    public double getBwlimitDelayTime() {
        return this.throttledPacketSendAverage.currentValue();
    }

    public double getNodeAveragePingTime() {
        return this.nodePinger.averagePingTime();
    }

    public int getOpennetSizeEstimate(long timestamp) {
        if (this.node.opennet == null) {
            return 0;
        }
        return this.node.opennet.getNetworkSizeEstimate(timestamp);
    }

    public int getDarknetSizeEstimate(long timestamp) {
        return this.node.lm.getNetworkSizeEstimate(timestamp);
    }

    public Object[] getKnownLocations(long timestamp) {
        return this.node.lm.getKnownLocations(timestamp);
    }

    public double pRejectIncomingInstantly() {
        return this.pInstantRejectIncomingOverall.currentValue();
    }

    public double pRejectIncomingInstantlyCHKRequestRT() {
        return this.pInstantRejectIncomingCHKRequestRT.currentValue();
    }

    public double pRejectIncomingInstantlyCHKInsertRT() {
        return this.pInstantRejectIncomingCHKInsertRT.currentValue();
    }

    public double pRejectIncomingInstantlySSKRequestRT() {
        return this.pInstantRejectIncomingSSKRequestRT.currentValue();
    }

    public double pRejectIncomingInstantlySSKInsertRT() {
        return this.pInstantRejectIncomingSSKInsertRT.currentValue();
    }

    public double pRejectIncomingInstantlyCHKRequestBulk() {
        return this.pInstantRejectIncomingCHKRequestBulk.currentValue();
    }

    public double pRejectIncomingInstantlyCHKInsertBulk() {
        return this.pInstantRejectIncomingCHKInsertBulk.currentValue();
    }

    public double pRejectIncomingInstantlySSKRequestBulk() {
        return this.pInstantRejectIncomingSSKRequestBulk.currentValue();
    }

    public double pRejectIncomingInstantlySSKInsertBulk() {
        return this.pInstantRejectIncomingSSKInsertBulk.currentValue();
    }

    public void maybeUpdatePeerManagerUserAlertStats(long now) {
        if (now > this.nextPeerManagerUserAlertStatsUpdateTime) {
            if (this.getBwlimitDelayTime() > (double)MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD) {
                if (this.firstBwlimitDelayTimeThresholdBreak == 0L) {
                    this.firstBwlimitDelayTimeThresholdBreak = now;
                }
            } else {
                this.firstBwlimitDelayTimeThresholdBreak = 0L;
            }
            this.bwlimitDelayAlertRelevant = this.firstBwlimitDelayTimeThresholdBreak != 0L && now - this.firstBwlimitDelayTimeThresholdBreak >= MAX_BWLIMIT_DELAY_TIME_ALERT_DELAY;
            if (this.getNodeAveragePingTime() > (double)(2L * this.maxPingTime)) {
                if (this.firstNodeAveragePingTimeThresholdBreak == 0L) {
                    this.firstNodeAveragePingTimeThresholdBreak = now;
                }
            } else {
                this.firstNodeAveragePingTimeThresholdBreak = 0L;
            }
            this.nodeAveragePingAlertRelevant = this.firstNodeAveragePingTimeThresholdBreak != 0L && now - this.firstNodeAveragePingTimeThresholdBreak >= MAX_NODE_AVERAGE_PING_TIME_ALERT_DELAY;
            if (logDEBUG) {
                Logger.debug(this, "mUPMUAS: " + now + ": " + this.getBwlimitDelayTime() + " >? " + MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD + " since " + this.firstBwlimitDelayTimeThresholdBreak + " (" + this.bwlimitDelayAlertRelevant + ") " + this.getNodeAveragePingTime() + " >? " + MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD + " since " + this.firstNodeAveragePingTimeThresholdBreak + " (" + this.nodeAveragePingAlertRelevant + ')');
            }
            this.nextPeerManagerUserAlertStatsUpdateTime = now + 1000L;
        }
    }

    @Override
    public SimpleFieldSet persistThrottlesToFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("RemoteChkFetchBytesSentAverage", this.remoteChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteSskFetchBytesSentAverage", this.remoteSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteChkInsertBytesSentAverage", this.remoteChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteSskInsertBytesSentAverage", this.remoteSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteChkFetchBytesReceivedAverage", this.remoteChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteSskFetchBytesReceivedAverage", this.remoteSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteChkInsertBytesReceivedAverage", this.remoteChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteSskInsertBytesReceivedAverage", this.remoteSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalChkFetchBytesSentAverage", this.localChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("LocalSskFetchBytesSentAverage", this.localSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("LocalChkInsertBytesSentAverage", this.localChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("LocalSskInsertBytesSentAverage", this.localSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("LocalChkFetchBytesReceivedAverage", this.localChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalSskFetchBytesReceivedAverage", this.localSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalChkInsertBytesReceivedAverage", this.localChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalSskInsertBytesReceivedAverage", this.localSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkFetchBytesSentAverage", this.successfulChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskFetchBytesSentAverage", this.successfulSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkInsertBytesSentAverage", this.successfulChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskInsertBytesSentAverage", this.successfulSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkOfferReplyBytesSentAverage", this.successfulChkOfferReplyBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskOfferReplyBytesSentAverage", this.successfulSskOfferReplyBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkFetchBytesReceivedAverage", this.successfulChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskFetchBytesReceivedAverage", this.successfulSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkInsertBytesReceivedAverage", this.successfulChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskInsertBytesReceivedAverage", this.successfulSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkOfferReplyBytesReceivedAverage", this.successfulChkOfferReplyBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskOfferReplyBytesReceivedAverage", this.successfulSskOfferReplyBytesReceivedAverage.exportFieldSet(true));
        fs.put("AverageCacheCHKLocation", this.avgCacheCHKLocation.exportFieldSet(true));
        fs.put("AverageStoreCHKLocation", this.avgStoreCHKLocation.exportFieldSet(true));
        fs.put("AverageSlashdotCacheCHKLocation", this.avgSlashdotCacheCHKLocation.exportFieldSet(true));
        fs.put("AverageClientCacheCHKLocation", this.avgClientCacheCHKLocation.exportFieldSet(true));
        fs.put("AverageCacheCHKSuccessLocation", this.avgCacheCHKSuccess.exportFieldSet(true));
        fs.put("AverageSlashdotCacheCHKSuccessLocation", this.avgSlashdotCacheCHKSucess.exportFieldSet(true));
        fs.put("AverageClientCacheCHKSuccessLocation", this.avgClientCacheCHKSuccess.exportFieldSet(true));
        fs.put("AverageStoreCHKSuccessLocation", this.avgStoreCHKSuccess.exportFieldSet(true));
        fs.put("AverageCacheSSKLocation", this.avgCacheSSKLocation.exportFieldSet(true));
        fs.put("AverageStoreSSKLocation", this.avgStoreSSKLocation.exportFieldSet(true));
        fs.put("AverageSlashdotCacheSSKLocation", this.avgSlashdotCacheSSKLocation.exportFieldSet(true));
        fs.put("AverageClientCacheSSKLocation", this.avgClientCacheSSKLocation.exportFieldSet(true));
        fs.put("AverageCacheSSKSuccessLocation", this.avgCacheSSKSuccess.exportFieldSet(true));
        fs.put("AverageSlashdotCacheSSKSuccessLocation", this.avgSlashdotCacheSSKSuccess.exportFieldSet(true));
        fs.put("AverageClientCacheSSKSuccessLocation", this.avgClientCacheSSKSuccess.exportFieldSet(true));
        fs.put("AverageStoreSSKSuccessLocation", this.avgStoreSSKSuccess.exportFieldSet(true));
        fs.put("AverageRequestLocation", this.avgRequestLocation.exportFieldSet(true));
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateNodeIOStats(long now) {
        if (now > this.nextNodeIOStatsUpdateTime) {
            long indiff;
            long outdiff;
            long[] io_stats = this.node.collector.getTotalIO();
            Object object = this.ioStatSync;
            synchronized (object) {
                this.previous_output_stat = this.last_output_stat;
                this.previous_input_stat = this.last_input_stat;
                this.previous_io_stat_time = this.last_io_stat_time;
                this.last_output_stat = io_stats[0];
                this.last_input_stat = io_stats[1];
                this.last_io_stat_time = now;
                outdiff = this.last_output_stat - this.previous_output_stat;
                indiff = this.last_input_stat - this.previous_input_stat;
            }
            if (logMINOR) {
                Logger.minor(this, "Last 2 seconds: input: " + indiff + " output: " + outdiff);
            }
            this.nextNodeIOStatsUpdateTime = now + 2000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNodeIOStats() {
        long[] result = new long[6];
        Object object = this.ioStatSync;
        synchronized (object) {
            result[0] = this.previous_output_stat;
            result[1] = this.previous_input_stat;
            result[2] = this.previous_io_stat_time;
            result[3] = this.last_output_stat;
            result[4] = this.last_input_stat;
            result[5] = this.last_io_stat_time;
        }
        return result;
    }

    public void waitUntilNotOverloaded(boolean isInsert) {
        while (this.threadLimit < this.getActiveThreadCount()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getActiveThreadCount() {
        return this.rootThreadGroup.activeCount() - this.node.executor.getWaitingThreadsCount();
    }

    public int[] getActiveThreadsByPriority() {
        return this.node.executor.runningThreads();
    }

    public int[] getWaitingThreadsByPriority() {
        return this.node.executor.waitingThreads();
    }

    public int getThreadLimit() {
        return this.threadLimit;
    }

    public Thread[] getThreads() {
        Thread[] threads;
        int count = 0;
        do {
            count = Math.max(this.rootThreadGroup.activeCount(), count);
            threads = new Thread[count * 2 + 50];
            this.rootThreadGroup.enumerate(threads);
        } while (threads[threads.length - 1] != null);
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportVolatileFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        long now = System.currentTimeMillis();
        fs.put("isUsingWrapper", this.node.isUsingWrapper());
        long nodeUptimeSeconds = 0L;
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            fs.put("startupTime", this.node.startupTime);
            nodeUptimeSeconds = (now - this.node.startupTime) / 1000L;
            if (nodeUptimeSeconds == 0L) {
                nodeUptimeSeconds = 1L;
            }
            fs.put("uptimeSeconds", nodeUptimeSeconds);
        }
        fs.put("averagePingTime", this.getNodeAveragePingTime());
        fs.put("bwlimitDelayTime", this.getBwlimitDelayTime());
        fs.put("bwlimitDelayTimeRT", this.getBwlimitDelayTimeRT());
        fs.put("bwlimitDelayTimeBulk", this.getBwlimitDelayTimeBulk());
        fs.put("opennetSizeEstimateSession", this.getOpennetSizeEstimate(-1L));
        fs.put("networkSizeEstimateSession", this.getDarknetSizeEstimate(-1L));
        for (int t = 1; t < 7; ++t) {
            int hour = t * 24;
            long limit = now - TimeUnit.DAYS.toMillis(t);
            fs.put("opennetSizeEstimate" + hour + "hourRecent", this.getOpennetSizeEstimate(limit));
            fs.put("networkSizeEstimate" + hour + "hourRecent", this.getDarknetSizeEstimate(limit));
        }
        fs.put("routingMissDistanceLocal", this.routingMissDistanceLocal.currentValue());
        fs.put("routingMissDistanceRemote", this.routingMissDistanceRemote.currentValue());
        fs.put("routingMissDistanceOverall", this.routingMissDistanceOverall.currentValue());
        fs.put("routingMissDistanceBulk", this.routingMissDistanceBulk.currentValue());
        fs.put("routingMissDistanceRT", this.routingMissDistanceRT.currentValue());
        fs.put("backedOffPercent", this.backedOffPercent.currentValue());
        fs.put("pInstantReject", this.pRejectIncomingInstantly());
        fs.put("unclaimedFIFOSize", this.node.usm.getUnclaimedFIFOSize());
        fs.put("RAMBucketPoolSize", this.node.clientCore.tempBucketFactory.getRamUsed());
        PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
        int numberOfSeedServers = 0;
        int numberOfSeedClients = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (peerNodeStatus.isSeedServer()) {
                ++numberOfSeedServers;
            }
            if (!peerNodeStatus.isSeedClient()) continue;
            ++numberOfSeedClients;
        }
        int numberOfConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 1);
        int numberOfRoutingBackedOff = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 2);
        int numberOfTooNew = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 3);
        int numberOfTooOld = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 4);
        int numberOfDisconnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 5);
        int numberOfNeverConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 6);
        int numberOfDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 7);
        int numberOfBursting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 8);
        int numberOfListening = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 9);
        int numberOfListenOnly = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 10);
        int numberOfSimpleConnected = numberOfConnected + numberOfRoutingBackedOff;
        int numberOfNotConnected = numberOfTooNew + numberOfTooOld + numberOfDisconnected + numberOfNeverConnected + numberOfDisabled + numberOfBursting + numberOfListening + numberOfListenOnly;
        fs.put("numberOfSeedServers", numberOfSeedServers);
        fs.put("numberOfSeedClients", numberOfSeedClients);
        fs.put("numberOfConnected", numberOfConnected);
        fs.put("numberOfRoutingBackedOff", numberOfRoutingBackedOff);
        fs.put("numberOfTooNew", numberOfTooNew);
        fs.put("numberOfTooOld", numberOfTooOld);
        fs.put("numberOfDisconnected", numberOfDisconnected);
        fs.put("numberOfNeverConnected", numberOfNeverConnected);
        fs.put("numberOfDisabled", numberOfDisabled);
        fs.put("numberOfBursting", numberOfBursting);
        fs.put("numberOfListening", numberOfListening);
        fs.put("numberOfListenOnly", numberOfListenOnly);
        fs.put("numberOfSimpleConnected", numberOfSimpleConnected);
        fs.put("numberOfNotConnected", numberOfNotConnected);
        fs.put("numberOfTransferringRequestSenders", this.node.tracker.getNumTransferringRequestSenders());
        fs.put("numberOfARKFetchers", this.node.getNumARKFetchers());
        fs.put("bandwidthLiabilityUsageOutputBulk", this.node.nodeStats.getBandwidthLiabilityUsage());
        RequestTracker tracker = this.node.tracker;
        fs.put("numberOfLocalCHKInserts", tracker.getNumLocalCHKInserts());
        fs.put("numberOfRemoteCHKInserts", tracker.getNumRemoteCHKInserts());
        fs.put("numberOfLocalSSKInserts", tracker.getNumLocalSSKInserts());
        fs.put("numberOfRemoteSSKInserts", tracker.getNumRemoteSSKInserts());
        fs.put("numberOfLocalCHKRequests", tracker.getNumLocalCHKRequests());
        fs.put("numberOfRemoteCHKRequests", tracker.getNumRemoteCHKRequests());
        fs.put("numberOfLocalSSKRequests", tracker.getNumLocalSSKRequests());
        fs.put("numberOfRemoteSSKRequests", tracker.getNumRemoteSSKRequests());
        fs.put("numberOfTransferringRequestHandlers", this.node.tracker.getNumTransferringRequestHandlers());
        fs.put("numberOfCHKOfferReplys", tracker.getNumCHKOfferReplies());
        fs.put("numberOfSSKOfferReplys", tracker.getNumSSKOfferReplies());
        fs.put("delayTimeLocalRT", this.nlmDelayRTLocal.currentValue());
        fs.put("delayTimeRemoteRT", this.nlmDelayRTRemote.currentValue());
        fs.put("delayTimeLocalBulk", this.nlmDelayBulkLocal.currentValue());
        fs.put("delayTimeRemoteBulk", this.nlmDelayBulkRemote.currentValue());
        Object object = this.slotTimeoutsSync;
        synchronized (object) {
            fs.put("fatalTimeoutsLocal", this.fatalTimeoutsInWaitLocal);
            fs.put("fatalTimeoutsRemote", this.fatalTimeoutsInWaitRemote);
            fs.put("allocatedSlotLocal", this.allocatedSlotLocal);
            fs.put("allocatedSlotRemote", this.allocatedSlotRemote);
        }
        RequestTracker.WaitingForSlots waitingSlots = tracker.countRequestsWaitingForSlots();
        fs.put("RequestsWaitingSlotsLocal", waitingSlots.local);
        fs.put("RequestsWaitingSlotsRemote", waitingSlots.remote);
        fs.put("successfulLocalCHKFetchTimeBulk", this.successfulLocalCHKFetchTimeAverageBulk.currentValue());
        fs.put("successfulLocalCHKFetchTimeRT", this.successfulLocalCHKFetchTimeAverageRT.currentValue());
        fs.put("unsuccessfulLocalCHKFetchTimeBulk", this.unsuccessfulLocalCHKFetchTimeAverageBulk.currentValue());
        fs.put("unsuccessfulLocalCHKFetchTimeRT", this.unsuccessfulLocalCHKFetchTimeAverageRT.currentValue());
        fs.put("successfulLocalSSKFetchTimeBulk", this.successfulLocalSSKFetchTimeAverageBulk.currentValue());
        fs.put("successfulLocalSSKFetchTimeRT", this.successfulLocalSSKFetchTimeAverageRT.currentValue());
        fs.put("unsuccessfulLocalSSKFetchTimeBulk", this.unsuccessfulLocalSSKFetchTimeAverageBulk.currentValue());
        fs.put("unsuccessfulLocalSSKFetchTimeRT", this.unsuccessfulLocalSSKFetchTimeAverageRT.currentValue());
        long[] total = this.node.collector.getTotalIO();
        long total_output_rate = total[0] / nodeUptimeSeconds;
        long total_input_rate = total[1] / nodeUptimeSeconds;
        long totalPayloadOutput = this.node.getTotalPayloadSent();
        long total_payload_output_rate = totalPayloadOutput / nodeUptimeSeconds;
        int total_payload_output_percent = total[0] == 0L ? -1 : (int)(100L * totalPayloadOutput / total[0]);
        fs.put("totalOutputBytes", total[0]);
        fs.put("totalOutputRate", total_output_rate);
        fs.put("totalPayloadOutputBytes", totalPayloadOutput);
        fs.put("totalPayloadOutputRate", total_payload_output_rate);
        fs.put("totalPayloadOutputPercent", total_payload_output_percent);
        fs.put("totalInputBytes", total[1]);
        fs.put("totalInputRate", total_input_rate);
        long[] rate = this.getNodeIOStats();
        long deltaMS = rate[5] - rate[2];
        double recent_output_rate = deltaMS == 0L ? 0.0 : 1000.0 * (double)(rate[3] - rate[0]) / (double)deltaMS;
        double recent_input_rate = deltaMS == 0L ? 0.0 : 1000.0 * (double)(rate[4] - rate[1]) / (double)deltaMS;
        fs.put("recentOutputRate", recent_output_rate);
        fs.put("recentInputRate", recent_input_rate);
        fs.put("ackOnlyBytes", this.getNotificationOnlyPacketsSentBytes());
        fs.put("resentBytes", this.getResendBytesSent());
        fs.put("updaterOutputBytes", this.getUOMBytesSent());
        fs.put("announcePayloadBytes", this.getAnnounceBytesPayloadSent());
        fs.put("announceSentBytes", this.getAnnounceBytesSent());
        String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(true);
        if (routingBackoffReasons.length != 0) {
            for (String routingBackoffReason : routingBackoffReasons) {
                fs.put("numberWithRoutingBackoffReasonsRT." + routingBackoffReason, this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, true));
            }
        }
        if ((routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons(false)).length != 0) {
            for (String routingBackoffReason : routingBackoffReasons) {
                fs.put("numberWithRoutingBackoffReasonsBulk." + routingBackoffReason, this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReason, false));
            }
        }
        double swaps = this.node.getSwaps();
        double noSwaps = this.node.getNoSwaps();
        double numberOfRemotePeerLocationsSeenInSwaps = this.node.getNumberOfRemotePeerLocationsSeenInSwaps();
        fs.put("numberOfRemotePeerLocationsSeenInSwaps", numberOfRemotePeerLocationsSeenInSwaps);
        double avgConnectedPeersPerNode = 0.0;
        if (numberOfRemotePeerLocationsSeenInSwaps > 0.0 && (swaps > 0.0 || noSwaps > 0.0)) {
            avgConnectedPeersPerNode = numberOfRemotePeerLocationsSeenInSwaps / (swaps + noSwaps);
        }
        fs.put("avgConnectedPeersPerNode", avgConnectedPeersPerNode);
        int startedSwaps = this.node.getStartedSwaps();
        int swapsRejectedAlreadyLocked = this.node.getSwapsRejectedAlreadyLocked();
        int swapsRejectedNowhereToGo = this.node.getSwapsRejectedNowhereToGo();
        int swapsRejectedRateLimit = this.node.getSwapsRejectedRateLimit();
        int swapsRejectedRecognizedID = this.node.getSwapsRejectedRecognizedID();
        double locationChangePerSession = this.node.getLocationChangeSession();
        double locationChangePerSwap = 0.0;
        double locationChangePerMinute = 0.0;
        double swapsPerMinute = 0.0;
        double noSwapsPerMinute = 0.0;
        double swapsPerNoSwaps = 0.0;
        if (swaps > 0.0) {
            locationChangePerSwap = locationChangePerSession / swaps;
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationChangePerMinute = locationChangePerSession / ((double)nodeUptimeSeconds / 60.0);
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            swapsPerMinute = swaps / ((double)nodeUptimeSeconds / 60.0);
        }
        if (noSwaps > 0.0 && nodeUptimeSeconds >= 60L) {
            noSwapsPerMinute = noSwaps / ((double)nodeUptimeSeconds / 60.0);
        }
        if (swaps > 0.0 && noSwaps > 0.0) {
            swapsPerNoSwaps = swaps / noSwaps;
        }
        fs.put("locationChangePerSession", locationChangePerSession);
        fs.put("locationChangePerSwap", locationChangePerSwap);
        fs.put("locationChangePerMinute", locationChangePerMinute);
        fs.put("swapsPerMinute", swapsPerMinute);
        fs.put("noSwapsPerMinute", noSwapsPerMinute);
        fs.put("swapsPerNoSwaps", swapsPerNoSwaps);
        fs.put("swaps", swaps);
        fs.put("noSwaps", noSwaps);
        fs.put("startedSwaps", startedSwaps);
        fs.put("swapsRejectedAlreadyLocked", swapsRejectedAlreadyLocked);
        fs.put("swapsRejectedNowhereToGo", swapsRejectedNowhereToGo);
        fs.put("swapsRejectedRateLimit", swapsRejectedRateLimit);
        fs.put("swapsRejectedRecognizedID", swapsRejectedRecognizedID);
        long fix32kb = 32768L;
        long cachedKeys = this.node.getChkDatacache().keyCount();
        long cachedSize = cachedKeys * fix32kb;
        long storeKeys = this.node.getChkDatastore().keyCount();
        long storeSize = storeKeys * fix32kb;
        long overallKeys = cachedKeys + storeKeys;
        long overallSize = cachedSize + storeSize;
        long maxOverallKeys = this.node.getMaxTotalKeys();
        long maxOverallSize = maxOverallKeys * fix32kb;
        double percentOverallKeysOfMax = (double)(overallKeys * 100L) / (double)maxOverallKeys;
        long cachedStoreHits = this.node.getChkDatacache().hits();
        long cachedStoreMisses = this.node.getChkDatacache().misses();
        long cachedStoreWrites = this.node.getChkDatacache().writes();
        long cacheAccesses = cachedStoreHits + cachedStoreMisses;
        long cachedStoreFalsePositives = this.node.getChkDatacache().getBloomFalsePositive();
        double percentCachedStoreHitsOfAccesses = (double)(cachedStoreHits * 100L) / (double)cacheAccesses;
        long storeHits = this.node.getChkDatastore().hits();
        long storeMisses = this.node.getChkDatastore().misses();
        long storeWrites = this.node.getChkDatastore().writes();
        long storeFalsePositives = this.node.getChkDatastore().getBloomFalsePositive();
        long storeAccesses = storeHits + storeMisses;
        double percentStoreHitsOfAccesses = (double)(storeHits * 100L) / (double)storeAccesses;
        long overallAccesses = storeAccesses + cacheAccesses;
        double avgStoreAccessRate = (double)overallAccesses / (double)nodeUptimeSeconds;
        fs.put("cachedKeys", cachedKeys);
        fs.put("cachedSize", cachedSize);
        fs.put("storeKeys", storeKeys);
        fs.put("storeSize", storeSize);
        fs.put("overallKeys", overallKeys);
        fs.put("overallSize", overallSize);
        fs.put("maxOverallKeys", maxOverallKeys);
        fs.put("maxOverallSize", maxOverallSize);
        fs.put("percentOverallKeysOfMax", percentOverallKeysOfMax);
        fs.put("cachedStoreHits", cachedStoreHits);
        fs.put("cachedStoreMisses", cachedStoreMisses);
        fs.put("cachedStoreWrites", cachedStoreWrites);
        fs.put("cacheAccesses", cacheAccesses);
        fs.put("cachedStoreFalsePositives", cachedStoreFalsePositives);
        fs.put("percentCachedStoreHitsOfAccesses", percentCachedStoreHitsOfAccesses);
        fs.put("storeHits", storeHits);
        fs.put("storeMisses", storeMisses);
        fs.put("storeAccesses", storeAccesses);
        fs.put("storeWrites", storeWrites);
        fs.put("storeFalsePositives", storeFalsePositives);
        fs.put("percentStoreHitsOfAccesses", percentStoreHitsOfAccesses);
        fs.put("overallAccesses", overallAccesses);
        fs.put("avgStoreAccessRate", avgStoreAccessRate);
        Runtime rt = Runtime.getRuntime();
        float freeMemory = rt.freeMemory();
        float totalMemory = rt.totalMemory();
        float maxMemory = rt.maxMemory();
        long usedJavaMem = (long)(totalMemory - freeMemory);
        long allocatedJavaMem = (long)totalMemory;
        long maxJavaMem = (long)maxMemory;
        int availableCpus = rt.availableProcessors();
        fs.put("freeJavaMemory", (long)freeMemory);
        fs.put("usedJavaMemory", usedJavaMem);
        fs.put("allocatedJavaMemory", allocatedJavaMem);
        fs.put("maximumJavaMemory", maxJavaMem);
        fs.put("availableCPUs", availableCpus);
        fs.put("runningThreadCount", this.getActiveThreadCount());
        fs.put("globalFetchPSuccess", this.globalFetchPSuccess.currentValue());
        fs.put("globalFetchCount", this.globalFetchPSuccess.countReports());
        fs.put("chkLocalFetchPSuccess", this.chkLocalFetchPSuccess.currentValue());
        fs.put("chkLocalFetchCount", this.chkLocalFetchPSuccess.countReports());
        fs.put("chkRemoteFetchPSuccess", this.chkRemoteFetchPSuccess.currentValue());
        fs.put("chkRemoteFetchCount", this.chkRemoteFetchPSuccess.countReports());
        fs.put("sskLocalFetchPSuccess", this.sskLocalFetchPSuccess.currentValue());
        fs.put("sskLocalFetchCount", this.sskLocalFetchPSuccess.countReports());
        fs.put("sskRemoteFetchPSuccess", this.sskRemoteFetchPSuccess.currentValue());
        fs.put("sskRemoteFetchCount", this.sskRemoteFetchPSuccess.countReports());
        fs.put("blockTransferPSuccessRT", this.blockTransferPSuccessRT.currentValue());
        fs.put("blockTransferCountRT", this.blockTransferPSuccessRT.countReports());
        fs.put("blockTransferPSuccessBulk", this.blockTransferPSuccessBulk.currentValue());
        fs.put("blockTransferCountBulk", this.blockTransferPSuccessBulk.countReports());
        fs.put("blockTransferFailTimeout", this.blockTransferFailTimeout.currentValue());
        return fs;
    }

    public boolean isTestnetEnabled() {
        return Node.isTestnetEnabled();
    }

    public boolean getRejectReasonsTable(HTMLNode table) {
        return this.preemptiveRejectReasons.toTableRows(table) > 0;
    }

    public boolean getLocalRejectReasonsTable(HTMLNode table) {
        return this.localPreemptiveRejectReasons.toTableRows(table) > 0;
    }

    public synchronized void requestCompleted(boolean succeeded, boolean isRemote, boolean isSSK) {
        this.globalFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        if (isSSK) {
            if (isRemote) {
                this.sskRemoteFetchPSuccess.report(succeeded ? 1.0 : 0.0);
            } else {
                this.sskLocalFetchPSuccess.report(succeeded ? 1.0 : 0.0);
            }
        } else if (isRemote) {
            this.chkRemoteFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        } else {
            this.chkLocalFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        }
    }

    public void fillSuccessRateBox(HTMLNode parent) {
        HTMLNode list = parent.addChild("table", "border", "0");
        RunningAverage[] averages = new RunningAverage[]{this.globalFetchPSuccess, this.chkLocalFetchPSuccess, this.chkRemoteFetchPSuccess, this.sskLocalFetchPSuccess, this.sskRemoteFetchPSuccess, this.blockTransferPSuccessBulk, this.blockTransferPSuccessRT, this.blockTransferPSuccessLocal, this.blockTransferFailTimeout};
        String[] names = new String[]{this.l10n("allRequests"), this.l10n("localCHKs"), this.l10n("remoteCHKs"), this.l10n("localSSKs"), this.l10n("remoteSSKs"), this.l10n("blockTransfersBulk"), this.l10n("blockTransfersRT"), this.l10n("blockTransfersLocal"), this.l10n("transfersTimedOut")};
        HTMLNode row = list.addChild("tr");
        row.addChild("th", this.l10n("group"));
        row.addChild("th", this.l10n("pSuccess"));
        row.addChild("th", this.l10n("count"));
        for (int i = 0; i < averages.length; ++i) {
            row = list.addChild("tr");
            row.addChild("td", names[i]);
            if (averages[i].countReports() == 0L) {
                row.addChild("td", "-");
                row.addChild("td", "0");
                continue;
            }
            row.addChild("td", this.fix3p3pct.format(averages[i].currentValue()));
            row.addChild("td", this.thousandPoint.format(averages[i].countReports()));
        }
        row = list.addChild("tr");
        long[] bulkSuccess = BulkTransmitter.transferSuccess();
        row = list.addChild("tr");
        row.addChild("td", this.l10n("bulkSends"));
        row.addChild("td", this.fix3p3pct.format((double)bulkSuccess[1] / (double)bulkSuccess[0]));
        row.addChild("td", Long.toString(bulkSuccess[0]));
    }

    public synchronized void requestSentBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskRequestSentBytes += (long)x;
        } else {
            this.chkRequestSentBytes += (long)x;
        }
    }

    public synchronized void requestReceivedBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskRequestRcvdBytes += (long)x;
        } else {
            this.chkRequestRcvdBytes += (long)x;
        }
    }

    public synchronized void insertSentBytes(boolean ssk, int x) {
        if (logDEBUG) {
            Logger.debug(this, "insertSentBytes(" + ssk + ", " + x + ")");
        }
        if (ssk) {
            this.sskInsertSentBytes += (long)x;
        } else {
            this.chkInsertSentBytes += (long)x;
        }
    }

    public synchronized void insertReceivedBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskInsertRcvdBytes += (long)x;
        } else {
            this.chkInsertRcvdBytes += (long)x;
        }
    }

    public synchronized long getCHKRequestTotalBytesSent() {
        return this.chkRequestSentBytes;
    }

    public synchronized long getSSKRequestTotalBytesSent() {
        return this.sskRequestSentBytes;
    }

    public synchronized long getCHKInsertTotalBytesSent() {
        return this.chkInsertSentBytes;
    }

    public synchronized long getSSKInsertTotalBytesSent() {
        return this.sskInsertSentBytes;
    }

    public synchronized void offeredKeysSenderReceivedBytes(int x) {
        this.offeredKeysSenderRcvdBytes += (long)x;
    }

    public synchronized void offeredKeysSenderSentBytes(int x) {
        this.offeredKeysSenderSentBytes += (long)x;
    }

    public long getOfferedKeysTotalBytesReceived() {
        return this.offeredKeysSenderRcvdBytes;
    }

    public long getOfferedKeysTotalBytesSent() {
        return this.offeredKeysSenderSentBytes;
    }

    public synchronized long getOffersSentBytesSent() {
        return this.offerKeysSentBytes;
    }

    public synchronized void swappingReceivedBytes(int x) {
        this.swappingRcvdBytes += (long)x;
    }

    public synchronized void swappingSentBytes(int x) {
        this.swappingSentBytes += (long)x;
    }

    public synchronized long getSwappingTotalBytesReceived() {
        return this.swappingRcvdBytes;
    }

    public synchronized long getSwappingTotalBytesSent() {
        return this.swappingSentBytes;
    }

    public synchronized void reportAuthBytes(int x) {
        this.totalAuthBytesSent += (long)x;
    }

    public synchronized long getTotalAuthBytesSent() {
        return this.totalAuthBytesSent;
    }

    public synchronized long getResendBytesSent() {
        return this.resendBytesSent;
    }

    public synchronized void reportUOMBytesSent(int x) {
        this.uomBytesSent += (long)x;
    }

    public synchronized long getUOMBytesSent() {
        return this.uomBytesSent;
    }

    public synchronized long getAnnounceBytesSent() {
        return this.announceBytesSent;
    }

    public synchronized long getAnnounceBytesPayloadSent() {
        return this.announceBytesPayload;
    }

    public synchronized long getRoutingStatusBytes() {
        return this.routingStatusBytesSent;
    }

    public synchronized void networkColoringReceivedBytes(int x) {
        this.networkColoringReceivedBytesCounter += (long)x;
    }

    public synchronized void networkColoringSentBytes(int x) {
        this.networkColoringSentBytesCounter += (long)x;
    }

    public synchronized long getNetworkColoringSentBytes() {
        return this.networkColoringSentBytesCounter;
    }

    public synchronized void pingCounterReceived(int x) {
        this.pingBytesReceived += (long)x;
    }

    public synchronized void pingCounterSent(int x) {
        this.pingBytesSent += (long)x;
    }

    public synchronized long getPingSentBytes() {
        return this.pingBytesSent;
    }

    public synchronized long getProbeRequestSentBytes() {
        return this.probeRequestSentBytes;
    }

    public synchronized long getRoutedMessageSentBytes() {
        return this.routedMessageBytesSent;
    }

    void disconnBytesReceived(int x) {
        this.disconnBytesReceived += (long)x;
    }

    void disconnBytesSent(int x) {
        this.disconnBytesSent += (long)x;
    }

    public long getDisconnBytesSent() {
        return this.disconnBytesSent;
    }

    public synchronized long getInitialMessagesBytesSent() {
        return this.initialMessagesBytesSent;
    }

    public long getChangedIPBytesSent() {
        return this.changedIPBytesSent;
    }

    public long getNodeToNodeBytesSent() {
        return this.nodeToNodeSentBytes;
    }

    public long getAllocationNoticesBytesSent() {
        return this.allocationNoticesCounterBytesSent;
    }

    public long getFOAFBytesSent() {
        return this.foafCounterBytesSent;
    }

    synchronized void reportNotificationOnlyPacketSent(int packetSize) {
        this.notificationOnlySentBytes += (long)packetSize;
    }

    public long getNotificationOnlyPacketsSentBytes() {
        return this.notificationOnlySentBytes;
    }

    public synchronized long getSentOverhead() {
        return this.offerKeysSentBytes + this.swappingSentBytes + this.totalAuthBytesSent + this.resendBytesSent + this.uomBytesSent + this.announceBytesSent + this.routingStatusBytesSent + this.networkColoringSentBytesCounter + this.pingBytesSent + this.probeRequestSentBytes + this.routedMessageBytesSent + this.disconnBytesSent + this.initialMessagesBytesSent + this.changedIPBytesSent + this.nodeToNodeSentBytes + this.notificationOnlySentBytes;
    }

    public double getSentOverheadPerSecond() {
        long uptime = this.node.getUptime();
        return this.getSentOverhead() * TimeUnit.SECONDS.toMillis(1L) / uptime;
    }

    public synchronized void successfulBlockReceive(boolean realTimeFlag, boolean isLocal) {
        TrivialRunningAverage blockTransferPSuccess = realTimeFlag ? this.blockTransferPSuccessRT : this.blockTransferPSuccessBulk;
        blockTransferPSuccess.report(1.0);
        if (isLocal) {
            this.blockTransferPSuccessLocal.report(1.0);
        }
        if (logMINOR) {
            Logger.minor(this, "Successful receives: " + blockTransferPSuccess.currentValue() + " count=" + blockTransferPSuccess.countReports() + " realtime=" + realTimeFlag);
        }
    }

    public synchronized void failedBlockReceive(boolean normalFetch, boolean timeout, boolean realTimeFlag, boolean isLocal) {
        if (normalFetch) {
            this.blockTransferFailTimeout.report(timeout ? 1.0 : 0.0);
        }
        TrivialRunningAverage blockTransferPSuccess = realTimeFlag ? this.blockTransferPSuccessRT : this.blockTransferPSuccessBulk;
        blockTransferPSuccess.report(0.0);
        if (isLocal) {
            this.blockTransferPSuccessLocal.report(0.0);
        }
        if (logMINOR) {
            Logger.minor(this, "Successful receives: " + blockTransferPSuccess.currentValue() + " count=" + blockTransferPSuccess.countReports() + " realtime=" + realTimeFlag);
        }
    }

    public void reportIncomingRequestLocation(double loc) {
        this.incomingRequests.report(loc);
    }

    public int[] getIncomingRequestLocation(int[] retval) {
        return this.incomingRequests.getCounts(retval);
    }

    public void reportOutgoingLocalRequestLocation(double loc) {
        this.outgoingLocalRequests.report(loc);
    }

    public int[] getOutgoingLocalRequestLocation(int[] retval) {
        return this.outgoingLocalRequests.getCounts(retval);
    }

    public void reportOutgoingRequestLocation(double loc) {
        this.outgoingRequests.report(loc);
    }

    public int[] getOutgoingRequestLocation(int[] retval) {
        return this.outgoingRequests.getCounts(retval);
    }

    public void reportCHKOutcome(long rtt, boolean successful, double location, boolean isRealtime) {
        if (successful) {
            (isRealtime ? this.successfulLocalCHKFetchTimeAverageRT : this.successfulLocalCHKFetchTimeAverageBulk).report(rtt);
            this.chkSuccessRatesByLocation.report(location, 1.0);
        } else {
            (isRealtime ? this.unsuccessfulLocalCHKFetchTimeAverageRT : this.unsuccessfulLocalCHKFetchTimeAverageBulk).report(rtt);
            this.chkSuccessRatesByLocation.report(location, 0.0);
        }
        (isRealtime ? this.localCHKFetchTimeAverageRT : this.localCHKFetchTimeAverageBulk).report(rtt);
    }

    public void reportSSKOutcome(long rtt, boolean successful, boolean isRealtime) {
        if (successful) {
            (isRealtime ? this.successfulLocalSSKFetchTimeAverageRT : this.successfulLocalSSKFetchTimeAverageBulk).report(rtt);
        } else {
            (isRealtime ? this.unsuccessfulLocalSSKFetchTimeAverageRT : this.unsuccessfulLocalSSKFetchTimeAverageBulk).report(rtt);
        }
        (isRealtime ? this.localSSKFetchTimeAverageRT : this.localSSKFetchTimeAverageBulk).report(rtt);
    }

    public void fillDetailedTimingsBox(HTMLNode html) {
        HTMLNode table = html.addChild("table");
        HTMLNode row = table.addChild("tr");
        row.addChild("td");
        row.addChild("td", "colspan", "2", "CHK");
        row.addChild("td", "colspan", "2", "SSK");
        row = table.addChild("tr");
        row.addChild("td", this.l10n("successfulHeader"));
        row.addChild("td", TimeUtil.formatTime((long)this.successfulLocalCHKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.successfulLocalCHKFetchTimeAverageRT.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.successfulLocalSSKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.successfulLocalSSKFetchTimeAverageRT.currentValue(), 2, true));
        row = table.addChild("tr");
        row.addChild("td", this.l10n("unsuccessfulHeader"));
        row.addChild("td", TimeUtil.formatTime((long)this.unsuccessfulLocalCHKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.unsuccessfulLocalCHKFetchTimeAverageRT.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.unsuccessfulLocalSSKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.unsuccessfulLocalSSKFetchTimeAverageRT.currentValue(), 2, true));
        row = table.addChild("tr");
        row.addChild("td", this.l10n("averageHeader"));
        row.addChild("td", TimeUtil.formatTime((long)this.localCHKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.localCHKFetchTimeAverageRT.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.localSSKFetchTimeAverageBulk.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((long)this.localSSKFetchTimeAverageRT.currentValue(), 2, true));
    }

    void remoteRequest(boolean ssk, boolean success, boolean local, short htl, double location, boolean realTime, boolean fromOfferedKey) {
        if (logMINOR) {
            Logger.minor(this, "Remote request: sucess=" + success + " htl=" + htl + " locally answered=" + local + " location of key=" + location + " from offered key = " + fromOfferedKey);
        }
        if (!fromOfferedKey) {
            if (realTime) {
                this.hourlyStatsRT.remoteRequest(ssk, success, local, htl, location);
            } else {
                this.hourlyStatsBulk.remoteRequest(ssk, success, local, htl, location);
            }
        }
    }

    public void fillRemoteRequestHTLsBox(HTMLNode html, boolean realTime) {
        if (realTime) {
            this.hourlyStatsRT.fillRemoteRequestHTLsBox(html);
        } else {
            this.hourlyStatsBulk.fillRemoteRequestHTLsBox(html);
        }
    }

    private String sanitizeDBJobType(String jobType) {
        int typeBeginIndex = jobType.lastIndexOf(46);
        int typeEndIndex = jobType.indexOf(64);
        if (typeBeginIndex < 0) {
            typeBeginIndex = jobType.lastIndexOf(58);
        }
        typeBeginIndex = typeBeginIndex < 0 ? 0 : ++typeBeginIndex;
        if (typeEndIndex < 0) {
            typeEndIndex = jobType.length();
        }
        return jobType.substring(typeBeginIndex, typeEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportDatabaseJob(String jobType, long executionTimeMiliSeconds) {
        TrivialRunningAverage avg;
        jobType = this.sanitizeDBJobType(jobType);
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgDatabaseJobExecutionTimes;
        synchronized (hashtable) {
            avg = this.avgDatabaseJobExecutionTimes.get(jobType);
            if (avg == null) {
                avg = new TrivialRunningAverage();
                this.avgDatabaseJobExecutionTimes.put(jobType, avg);
            }
        }
        avg.report(executionTimeMiliSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMandatoryBackoff(String backoffType, long backoffTimeMilliSeconds, boolean realtime) {
        TrivialRunningAverage avg;
        if (realtime) {
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgMandatoryBackoffTimesRT;
            synchronized (hashtable) {
                avg = this.avgMandatoryBackoffTimesRT.get(backoffType);
                if (avg == null) {
                    avg = new TrivialRunningAverage();
                    this.avgMandatoryBackoffTimesRT.put(backoffType, avg);
                }
            }
        }
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgMandatoryBackoffTimesBulk;
        synchronized (hashtable) {
            avg = this.avgMandatoryBackoffTimesBulk.get(backoffType);
            if (avg == null) {
                avg = new TrivialRunningAverage();
                this.avgMandatoryBackoffTimesBulk.put(backoffType, avg);
            }
        }
        avg.report(backoffTimeMilliSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRoutingBackoff(String backoffType, long backoffTimeMilliSeconds, boolean realtime) {
        TrivialRunningAverage avg;
        if (realtime) {
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgRoutingBackoffTimesRT;
            synchronized (hashtable) {
                avg = this.avgRoutingBackoffTimesRT.get(backoffType);
                if (avg == null) {
                    avg = new TrivialRunningAverage();
                    this.avgRoutingBackoffTimesRT.put(backoffType, avg);
                }
            }
        }
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgRoutingBackoffTimesBulk;
        synchronized (hashtable) {
            avg = this.avgRoutingBackoffTimesBulk.get(backoffType);
            if (avg == null) {
                avg = new TrivialRunningAverage();
                this.avgRoutingBackoffTimesBulk.put(backoffType, avg);
            }
        }
        avg.report(backoffTimeMilliSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTransferBackoff(String backoffType, long backoffTimeMilliSeconds, boolean realtime) {
        TrivialRunningAverage avg;
        if (realtime) {
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgTransferBackoffTimesRT;
            synchronized (hashtable) {
                avg = this.avgTransferBackoffTimesRT.get(backoffType);
                if (avg == null) {
                    avg = new TrivialRunningAverage();
                    this.avgTransferBackoffTimesRT.put(backoffType, avg);
                }
            }
        }
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgTransferBackoffTimesBulk;
        synchronized (hashtable) {
            avg = this.avgTransferBackoffTimesBulk.get(backoffType);
            if (avg == null) {
                avg = new TrivialRunningAverage();
                this.avgTransferBackoffTimesBulk.put(backoffType, avg);
            }
        }
        avg.report(backoffTimeMilliSeconds);
    }

    public StoreLocationStats chkStoreStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgStoreCHKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgStoreCHKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestStoreCHKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgStoreCHKLocation, NodeStats.this.node.getChkDatastore());
            }
        };
    }

    public StoreLocationStats chkCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgCacheCHKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgCacheCHKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestCacheCHKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgCacheCHKLocation, NodeStats.this.node.getChkDatacache());
            }
        };
    }

    public StoreLocationStats chkSlashDotCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgSlashdotCacheCHKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgSlashdotCacheCHKSucess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestSlashdotCacheCHKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgSlashdotCacheCHKLocation, NodeStats.this.node.getChkSlashdotCache());
            }
        };
    }

    public StoreLocationStats chkClientCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgClientCacheCHKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgClientCacheCHKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestClientCacheCHKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgClientCacheCHKLocation, NodeStats.this.node.getChkClientCache());
            }
        };
    }

    public StoreLocationStats sskStoreStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgStoreSSKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgStoreSSKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestStoreSSKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgStoreSSKLocation, NodeStats.this.node.getSskDatastore());
            }
        };
    }

    public StoreLocationStats sskCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgCacheSSKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgCacheSSKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestCacheSSKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgCacheSSKLocation, NodeStats.this.node.getSskDatacache());
            }
        };
    }

    public StoreLocationStats sskSlashDotCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgSlashdotCacheSSKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgSlashdotCacheSSKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestSlashdotCacheSSKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgSlashdotCacheSSKLocation, NodeStats.this.node.getSskSlashdotCache());
            }
        };
    }

    public StoreLocationStats sskClientCacheStats() {
        return new StoreLocationStats(){

            @Override
            public double avgLocation() {
                return NodeStats.this.avgClientCacheSSKLocation.currentValue();
            }

            @Override
            public double avgSuccess() {
                return NodeStats.this.avgClientCacheSSKSuccess.currentValue();
            }

            @Override
            public double furthestSuccess() throws StatsNotAvailableException {
                return NodeStats.this.furthestClientCacheSSKSuccess;
            }

            @Override
            public double avgDist() throws StatsNotAvailableException {
                return Location.distance(NodeStats.this.node.lm.getLocation(), this.avgLocation());
            }

            @Override
            public double distanceStats() throws StatsNotAvailableException {
                return NodeStats.this.cappedDistance(NodeStats.this.avgClientCacheSSKLocation, NodeStats.this.node.getSskClientCache());
            }
        };
    }

    private double cappedDistance(DecayingKeyspaceAverage avgLocation, StoreCallback<?> store) {
        double cachePercent = 1.0 * (double)avgLocation.countReports() / (double)store.keyCount();
        if (cachePercent > 1.0) {
            cachePercent = 1.0;
        }
        return cachePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedStats[] getMandatoryBackoffStatistics(boolean realtime) {
        if (realtime) {
            Object[] entries = new TimedStats[this.avgMandatoryBackoffTimesRT.size()];
            int i = 0;
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgMandatoryBackoffTimesRT;
            synchronized (hashtable) {
                for (Map.Entry<String, TrivialRunningAverage> entry : this.avgMandatoryBackoffTimesRT.entrySet()) {
                    TrivialRunningAverage avg = entry.getValue();
                    entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
                }
            }
            Arrays.sort(entries);
            return entries;
        }
        Object[] entries = new TimedStats[this.avgMandatoryBackoffTimesBulk.size()];
        int i = 0;
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgMandatoryBackoffTimesBulk;
        synchronized (hashtable) {
            for (Map.Entry<String, TrivialRunningAverage> entry : this.avgMandatoryBackoffTimesBulk.entrySet()) {
                TrivialRunningAverage avg = entry.getValue();
                entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
            }
        }
        Arrays.sort(entries);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedStats[] getRoutingBackoffStatistics(boolean realtime) {
        if (realtime) {
            Object[] entries = new TimedStats[this.avgRoutingBackoffTimesRT.size()];
            int i = 0;
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgRoutingBackoffTimesRT;
            synchronized (hashtable) {
                for (Map.Entry<String, TrivialRunningAverage> entry : this.avgRoutingBackoffTimesRT.entrySet()) {
                    TrivialRunningAverage avg = entry.getValue();
                    entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
                }
            }
            Arrays.sort(entries);
            return entries;
        }
        Object[] entries = new TimedStats[this.avgRoutingBackoffTimesBulk.size()];
        int i = 0;
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgRoutingBackoffTimesBulk;
        synchronized (hashtable) {
            for (Map.Entry<String, TrivialRunningAverage> entry : this.avgRoutingBackoffTimesBulk.entrySet()) {
                TrivialRunningAverage avg = entry.getValue();
                entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
            }
        }
        Arrays.sort(entries);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedStats[] getTransferBackoffStatistics(boolean realtime) {
        if (realtime) {
            Object[] entries = new TimedStats[this.avgTransferBackoffTimesRT.size()];
            int i = 0;
            Hashtable<String, TrivialRunningAverage> hashtable = this.avgTransferBackoffTimesRT;
            synchronized (hashtable) {
                for (Map.Entry<String, TrivialRunningAverage> entry : this.avgTransferBackoffTimesRT.entrySet()) {
                    TrivialRunningAverage avg = entry.getValue();
                    entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
                }
            }
            Arrays.sort(entries);
            return entries;
        }
        Object[] entries = new TimedStats[this.avgTransferBackoffTimesBulk.size()];
        int i = 0;
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgTransferBackoffTimesBulk;
        synchronized (hashtable) {
            for (Map.Entry<String, TrivialRunningAverage> entry : this.avgTransferBackoffTimesBulk.entrySet()) {
                TrivialRunningAverage avg = entry.getValue();
                entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
            }
        }
        Arrays.sort(entries);
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedStats[] getDatabaseJobExecutionStatistics() {
        Object[] entries = new TimedStats[this.avgDatabaseJobExecutionTimes.size()];
        int i = 0;
        Hashtable<String, TrivialRunningAverage> hashtable = this.avgDatabaseJobExecutionTimes;
        synchronized (hashtable) {
            for (Map.Entry<String, TrivialRunningAverage> entry : this.avgDatabaseJobExecutionTimes.entrySet()) {
                TrivialRunningAverage avg = entry.getValue();
                entries[i++] = new TimedStats(entry.getKey(), avg.countReports(), (long)avg.currentValue(), (long)avg.totalValue());
            }
        }
        Arrays.sort(entries);
        return entries;
    }

    public PeerLoadStats createPeerLoadStats(PeerNode peer, int transfersPerInsert, boolean realTimeFlag) {
        return new PeerLoadStats(peer, transfersPerInsert, realTimeFlag);
    }

    public PeerLoadStats parseLoadStats(PeerNode source, Message m) {
        return new PeerLoadStats(source, m);
    }

    public RunningRequestsSnapshot getRunningRequestsTo(PeerNode peerNode, int transfersPerInsert, boolean realTimeFlag) {
        return new RunningRequestsSnapshot(this.node.tracker, peerNode, true, false, this.outwardTransfersPerInsert(), realTimeFlag);
    }

    public boolean ignoreLocalVsRemoteBandwidthLiability() {
        return this.ignoreLocalVsRemoteBandwidthLiability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAnnounceForwarded(int forwardedRefs, PeerNode source) {
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            ++this.totalAnnouncements;
            this.totalAnnounceForwards += forwardedRefs;
            if (logMINOR) {
                Logger.minor(this, "Announcements: " + this.totalAnnouncements + " average " + (double)this.totalAnnounceForwards * 1.0 / (double)this.totalAnnouncements);
            }
        }
        OpennetManager om = this.node.getOpennet();
        if (om != null && source instanceof SeedClientPeerNode) {
            om.seedTracker.completedAnnounce((SeedClientPeerNode)source, forwardedRefs);
        }
    }

    public synchronized int getTransfersPerAnnounce() {
        if (this.totalAnnouncements == 0) {
            return 1;
        }
        return (int)Math.max(1.0, Math.ceil((double)this.totalAnnounceForwards * 1.0 / (double)this.totalAnnouncements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnouncementDecision shouldAcceptAnnouncement(long uid) {
        int outputPerSecond = this.node.getOutputBandwidthLimit() / 2;
        int inputPerSecond = this.node.getInputBandwidthLimit() / 2;
        int limit = Math.min(inputPerSecond, outputPerSecond);
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            int transfersPerAnnouncement = this.getTransfersPerAnnounce();
            int running = this.runningAnnouncements.size();
            if (running >= 100) {
                if (logMINOR) {
                    Logger.minor(this, "Too many announcements running: " + running);
                }
                return AnnouncementDecision.OVERLOAD;
            }
            int perTransfer = 3072;
            int bandwidthIn30Secs = limit * 30;
            if (perTransfer * transfersPerAnnouncement * running > bandwidthIn30Secs) {
                if (logMINOR) {
                    Logger.minor(this, "Can't complete " + running + " announcements in 30 secs");
                }
                return AnnouncementDecision.OVERLOAD;
            }
            boolean ret = this.runningAnnouncements.add(uid);
            if (logMINOR) {
                if (ret) {
                    Logger.minor(this, "Accepting announcement " + uid);
                } else {
                    Logger.minor(this, "Rejecting (loop) announcement " + uid);
                }
            }
            return ret ? AnnouncementDecision.ACCEPT : AnnouncementDecision.LOOP;
        }
    }

    public synchronized void endAnnouncement(long uid) {
        this.runningAnnouncements.remove(uid);
    }

    @Override
    public void blockTime(long interval, boolean realtime) {
        this.throttledPacketSendAverage.report(interval);
        if (realtime) {
            this.throttledPacketSendAverageRT.report(interval);
        } else {
            this.throttledPacketSendAverageBulk.report(interval);
        }
    }

    public synchronized long maxPeerPingTime() {
        return 2L * this.maxPingTime;
    }

    public void reportNLMDelay(long waitTime, boolean realTime, boolean local) {
        if (realTime) {
            if (local) {
                this.nlmDelayRTLocal.report(waitTime);
            } else {
                this.nlmDelayRTRemote.report(waitTime);
            }
        } else if (local) {
            this.nlmDelayBulkLocal.report(waitTime);
        } else {
            this.nlmDelayBulkRemote.report(waitTime);
        }
        if (logMINOR) {
            Logger.minor(this, "Delay times: realtime: local=" + this.nlmDelayRTLocal.currentValue() + " remote = " + this.nlmDelayRTRemote.currentValue() + " bulk: local=" + this.nlmDelayBulkLocal.currentValue() + " remote=" + this.nlmDelayBulkRemote.currentValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawNewLoadManagementDelayTimes(HTMLNode content) {
        RequestTracker.WaitingForSlots waitingSlots = this.node.tracker.countRequestsWaitingForSlots();
        content.addChild("p").addChild("#", this.l10n("slotsWaiting", new String[]{"local", "remote"}, new String[]{Integer.toString(waitingSlots.local), Integer.toString(waitingSlots.remote)}));
        HTMLNode table = content.addChild("table", "border", "0");
        HTMLNode header = table.addChild("tr");
        header.addChild("th", this.l10n("delayTimes"));
        header.addChild("th", this.l10n("localHeader"));
        header.addChild("th", this.l10n("remoteHeader"));
        HTMLNode row = table.addChild("tr");
        row.addChild("th", this.l10n("realTimeHeader"));
        row.addChild("td", TimeUtil.formatTime((int)this.nlmDelayRTLocal.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((int)this.nlmDelayRTRemote.currentValue(), 2, true));
        row = table.addChild("tr");
        row.addChild("th", this.l10n("bulkHeader"));
        row.addChild("td", TimeUtil.formatTime((int)this.nlmDelayBulkLocal.currentValue(), 2, true));
        row.addChild("td", TimeUtil.formatTime((int)this.nlmDelayBulkRemote.currentValue(), 2, true));
        Object object = this.slotTimeoutsSync;
        synchronized (object) {
            if (this.fatalTimeoutsInWaitLocal + this.fatalTimeoutsInWaitRemote + this.allocatedSlotLocal + this.allocatedSlotRemote > 0L) {
                content.addChild("b", this.l10n("timeoutFractions"));
                table = content.addChild("table", "border", "0");
                header = table.addChild("tr");
                header.addChild("th", this.l10n("localHeader"));
                header.addChild("th", this.l10n("remoteHeader"));
                row = table.addChild("tr");
                row.addChild("td", this.fix3p3pct.format((double)this.fatalTimeoutsInWaitLocal / (double)(this.fatalTimeoutsInWaitLocal + this.allocatedSlotLocal)));
                row.addChild("td", this.fix3p3pct.format((double)this.fatalTimeoutsInWaitRemote / (double)(this.fatalTimeoutsInWaitRemote + this.allocatedSlotRemote)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFatalTimeoutInWait(boolean local) {
        Object object = this.slotTimeoutsSync;
        synchronized (object) {
            if (local) {
                ++this.fatalTimeoutsInWaitLocal;
            } else {
                ++this.fatalTimeoutsInWaitRemote;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAllocatedSlot(boolean local) {
        Object object = this.slotTimeoutsSync;
        synchronized (object) {
            if (local) {
                ++this.allocatedSlotLocal;
            } else {
                ++this.allocatedSlotRemote;
            }
        }
    }

    public boolean enableNewLoadManagement(boolean realTimeFlag) {
        return realTimeFlag ? this.enableNewLoadManagementRT : this.enableNewLoadManagementBulk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNoisyRejectStats() {
        byte[] byArray = this.noisyRejectStats;
        synchronized (this.noisyRejectStats) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.copyOf(this.noisyRejectStats, this.noisyRejectStats.length);
        }
    }

    public final double randomNoise(double input, double sigma) {
        double multiplier = this.node.random.nextGaussian() * sigma + 1.0;
        if (multiplier < 0.5) {
            multiplier = 0.5;
        } else if (multiplier > 1.5) {
            multiplier = 1.5;
        }
        return input * multiplier;
    }

    public final double getBandwidthLiabilityUsage() {
        long now = System.currentTimeMillis();
        long limit = this.getLimitSeconds(false);
        int transfersPerInsert = this.outwardTransfersPerInsert();
        RunningRequestsSnapshot requestsSnapshot = new RunningRequestsSnapshot(this.node.tracker, this.ignoreLocalVsRemoteBandwidthLiability, transfersPerInsert, false);
        double usedBytes = requestsSnapshot.calculate(this.ignoreLocalVsRemoteBandwidthLiability, false);
        double nonOverheadFraction = this.getNonOverheadFraction(now);
        double upperLimit = this.getOutputBandwidthUpperLimit(limit, nonOverheadFraction);
        return usedBytes / upperLimit;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        CHECK_THROTTLE_TIME = TimeUnit.SECONDS.toMillis(60L);
        MAX_PEER_QUEUE_TIME = TimeUnit.MINUTES.toMillis(2L);
        DEFAULT_ONLY_PERIOD = TimeUnit.MINUTES.toMillis(1L);
        DEFAULT_TRANSITION_PERIOD = TimeUnit.MINUTES.toMillis(4L);
    }

    static enum AnnouncementDecision {
        ACCEPT,
        OVERLOAD,
        LOOP;

    }

    public static class TimedStats
    implements Comparable<TimedStats> {
        public final String keyStr;
        public final long count;
        public final long avgTime;
        public final long totalTime;

        public TimedStats(String myKeyStr, long myCount, long myAvgTime, long myTotalTime) {
            this.keyStr = myKeyStr;
            this.count = myCount;
            this.avgTime = myAvgTime;
            this.totalTime = myTotalTime;
        }

        @Override
        public int compareTo(TimedStats o) {
            if (this.totalTime < o.totalTime) {
                return 1;
            }
            if (this.totalTime == o.totalTime) {
                return 0;
            }
            return -1;
        }
    }

    static class RejectReason {
        public final String name;
        public final boolean soft;

        RejectReason(String n, boolean s) {
            this.name = n;
            this.soft = s;
        }

        public String toString() {
            return (this.soft ? "SOFT" : "HARD") + ":" + this.name;
        }
    }

    class RunningRequestsSnapshot {
        final int expectedTransfersOutCHK;
        final int expectedTransfersInCHK;
        final int expectedTransfersOutSSK;
        final int expectedTransfersInSSK;
        final int totalRequests;
        final int expectedTransfersOutCHKSR;
        final int expectedTransfersInCHKSR;
        final int expectedTransfersOutSSKSR;
        final int expectedTransfersInSSKSR;
        final int totalRequestsSR;
        final int averageTransfersPerInsert;
        final boolean realTimeFlag;

        RunningRequestsSnapshot(RequestTracker tracker, boolean ignoreLocalVsRemote, int transfersPerInsert, boolean realTimeFlag) {
            this.averageTransfersPerInsert = transfersPerInsert;
            this.realTimeFlag = realTimeFlag;
            RequestTracker.CountedRequests countCHK = new RequestTracker.CountedRequests();
            RequestTracker.CountedRequests countSSK = new RequestTracker.CountedRequests();
            RequestTracker.CountedRequests countCHKSR = new RequestTracker.CountedRequests();
            RequestTracker.CountedRequests countSSKSR = new RequestTracker.CountedRequests();
            tracker.countRequests(true, false, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(true, true, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(true, false, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(true, true, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(false, false, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(false, true, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(false, false, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(false, true, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(false, false, false, true, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(false, true, false, true, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            this.expectedTransfersInCHK = countCHK.expectedTransfersIn();
            this.expectedTransfersInSSK = countSSK.expectedTransfersIn();
            this.expectedTransfersOutCHK = countCHK.expectedTransfersOut();
            this.expectedTransfersOutSSK = countSSK.expectedTransfersOut();
            this.totalRequests = countCHK.total() + countSSK.total();
            this.expectedTransfersInCHKSR = countCHKSR.expectedTransfersIn();
            this.expectedTransfersInSSKSR = countSSKSR.expectedTransfersIn();
            this.expectedTransfersOutCHKSR = countCHKSR.expectedTransfersOut();
            this.expectedTransfersOutSSKSR = countSSKSR.expectedTransfersOut();
            this.totalRequestsSR = countCHKSR.total() + countSSKSR.total();
        }

        RunningRequestsSnapshot(RequestTracker tracker, PeerNode source, boolean requestsToNode, boolean ignoreLocalVsRemote, int transfersPerInsert, boolean realTimeFlag) {
            this.averageTransfersPerInsert = transfersPerInsert;
            this.realTimeFlag = realTimeFlag;
            if (requestsToNode) {
                ignoreLocalVsRemote = true;
            }
            RequestTracker.CountedRequests countCHK = new RequestTracker.CountedRequests();
            RequestTracker.CountedRequests countSSK = new RequestTracker.CountedRequests();
            RequestTracker.CountedRequests countCHKSR = null;
            RequestTracker.CountedRequests countSSKSR = null;
            if (!requestsToNode) {
                countCHKSR = new RequestTracker.CountedRequests();
                countSSKSR = new RequestTracker.CountedRequests();
            }
            tracker.countRequests(source, requestsToNode, true, false, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(source, requestsToNode, true, true, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(source, requestsToNode, true, false, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(source, requestsToNode, true, true, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(source, requestsToNode, false, false, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(source, requestsToNode, false, true, false, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(source, requestsToNode, false, false, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(source, requestsToNode, false, true, true, false, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            tracker.countRequests(source, requestsToNode, false, false, false, true, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countCHK, countCHKSR);
            tracker.countRequests(source, requestsToNode, false, true, false, true, realTimeFlag, transfersPerInsert, ignoreLocalVsRemote, countSSK, countSSKSR);
            if (!requestsToNode) {
                this.expectedTransfersInCHKSR = countCHKSR.expectedTransfersIn();
                this.expectedTransfersInSSKSR = countSSKSR.expectedTransfersIn();
                this.expectedTransfersOutCHKSR = countCHKSR.expectedTransfersOut();
                this.expectedTransfersOutSSKSR = countSSKSR.expectedTransfersOut();
                this.totalRequestsSR = countCHKSR.total() + countSSKSR.total();
                this.expectedTransfersInCHK = countCHK.expectedTransfersIn() - this.expectedTransfersInCHKSR;
                this.expectedTransfersInSSK = countSSK.expectedTransfersIn() - this.expectedTransfersInSSKSR;
                this.expectedTransfersOutCHK = countCHK.expectedTransfersOut() - this.expectedTransfersOutCHKSR;
                this.expectedTransfersOutSSK = countSSK.expectedTransfersOut() - this.expectedTransfersOutSSKSR;
                this.totalRequests = countCHK.total() + countSSK.total() - this.totalRequestsSR;
            } else {
                this.expectedTransfersInCHK = countCHK.expectedTransfersIn();
                this.expectedTransfersInSSK = countSSK.expectedTransfersIn();
                this.expectedTransfersOutCHK = countCHK.expectedTransfersOut();
                this.expectedTransfersOutSSK = countSSK.expectedTransfersOut();
                this.totalRequests = countCHK.total() + countSSK.total();
                this.expectedTransfersInCHKSR = 0;
                this.expectedTransfersInSSKSR = 0;
                this.expectedTransfersOutCHKSR = 0;
                this.expectedTransfersOutSSKSR = 0;
                this.totalRequestsSR = 0;
            }
        }

        public RunningRequestsSnapshot(PeerLoadStats stats) {
            this.realTimeFlag = stats.realTime;
            this.expectedTransfersInCHK = stats.expectedTransfersInCHK;
            this.expectedTransfersInSSK = stats.expectedTransfersInSSK;
            this.expectedTransfersOutCHK = stats.expectedTransfersOutCHK;
            this.expectedTransfersOutSSK = stats.expectedTransfersOutSSK;
            this.totalRequests = stats.totalRequests;
            this.averageTransfersPerInsert = stats.averageTransfersOutPerInsert;
            this.expectedTransfersInCHKSR = 0;
            this.expectedTransfersInSSKSR = 0;
            this.expectedTransfersOutCHKSR = 0;
            this.expectedTransfersOutSSKSR = 0;
            this.totalRequestsSR = 0;
        }

        private RunningRequestsSnapshot(int averageTransfersPerInsert) {
            this.realTimeFlag = false;
            this.expectedTransfersInCHK = 1;
            this.expectedTransfersInSSK = 1;
            this.expectedTransfersOutCHK = 1;
            this.expectedTransfersOutSSK = 1;
            this.totalRequests = 1;
            this.averageTransfersPerInsert = averageTransfersPerInsert;
            this.expectedTransfersInCHKSR = 0;
            this.expectedTransfersInSSKSR = 0;
            this.expectedTransfersOutCHKSR = 0;
            this.expectedTransfersOutSSKSR = 0;
            this.totalRequestsSR = 0;
        }

        public void log() {
            this.log(null);
        }

        public void log(PeerNode source) {
            String message = "Running (adjusted): CHK in: " + this.expectedTransfersInCHK + " out: " + this.expectedTransfersOutCHK + " SSK in: " + this.expectedTransfersInSSK + " out: " + this.expectedTransfersOutSSK + " total=" + this.totalRequests + (source == null ? "" : " for " + source) + (this.realTimeFlag ? " (realtime)" : " (bulk)");
            if (this.expectedTransfersInCHK < 0 || this.expectedTransfersOutCHK < 0 || this.expectedTransfersInSSK < 0 || this.expectedTransfersOutSSK < 0) {
                Logger.error(this, message);
            } else if (logMINOR) {
                Logger.minor(this, message);
            }
        }

        public double calculate(boolean ignoreLocalVsRemoteBandwidthLiability, boolean input) {
            if (input) {
                return this.expectedTransfersInCHK * 33024 + this.expectedTransfersInSSK * 2304 + this.expectedTransfersOutCHK * 256 + this.expectedTransfersOutSSK * 256;
            }
            return this.expectedTransfersOutCHK * 33024 + this.expectedTransfersOutSSK * 2304 + this.expectedTransfersInCHK * 256 + this.expectedTransfersInSSK * 256;
        }

        public double calculateSR(boolean ignoreLocalVsRemoteBandwidthLiability, boolean input) {
            if (input) {
                return this.expectedTransfersInCHKSR * 33024 + this.expectedTransfersInSSKSR * 2304 + this.expectedTransfersOutCHKSR * 256 + this.expectedTransfersOutSSKSR * 256;
            }
            return this.expectedTransfersOutCHKSR * 33024 + this.expectedTransfersOutSSKSR * 2304 + this.expectedTransfersInCHKSR * 256 + this.expectedTransfersInSSKSR * 256;
        }

        public int totalRequests() {
            return this.totalRequests;
        }

        public int totalOutTransfers() {
            return this.expectedTransfersOutCHK + this.expectedTransfersOutSSK;
        }

        public double calculateMinimum(boolean input, boolean ignoreLocalVsRemoteBandwidthLiability, int averageTransfersPerInsert) {
            return new RunningRequestsSnapshot(averageTransfersPerInsert).calculate(ignoreLocalVsRemoteBandwidthLiability, input);
        }
    }

    public class PeerLoadStats {
        public final PeerNode peer;
        public final int expectedTransfersOutCHK;
        public final int expectedTransfersInCHK;
        public final int expectedTransfersOutSSK;
        public final int expectedTransfersInSSK;
        public final double outputBandwidthLowerLimit;
        public final double outputBandwidthUpperLimit;
        public final double outputBandwidthPeerLimit;
        public final double inputBandwidthLowerLimit;
        public final double inputBandwidthUpperLimit;
        public final double inputBandwidthPeerLimit;
        public final int totalRequests;
        public final int averageTransfersOutPerInsert;
        public final boolean realTime;
        public final int maxTransfersOut;
        public final int maxTransfersOutPeerLimit;
        public final int maxTransfersOutLowerLimit;
        public final int maxTransfersOutUpperLimit;

        public boolean equals(Object o) {
            if (!(o instanceof PeerLoadStats)) {
                return false;
            }
            PeerLoadStats s = (PeerLoadStats)o;
            if (s.peer != this.peer) {
                return false;
            }
            if (s.expectedTransfersOutCHK != this.expectedTransfersOutCHK) {
                return false;
            }
            if (s.expectedTransfersInCHK != this.expectedTransfersInCHK) {
                return false;
            }
            if (s.expectedTransfersOutSSK != this.expectedTransfersOutSSK) {
                return false;
            }
            if (s.expectedTransfersInSSK != this.expectedTransfersInSSK) {
                return false;
            }
            if (s.totalRequests != this.totalRequests) {
                return false;
            }
            if (s.averageTransfersOutPerInsert != this.averageTransfersOutPerInsert) {
                return false;
            }
            if (s.outputBandwidthLowerLimit != this.outputBandwidthLowerLimit) {
                return false;
            }
            if (s.outputBandwidthUpperLimit != this.outputBandwidthUpperLimit) {
                return false;
            }
            if (s.outputBandwidthPeerLimit != this.outputBandwidthPeerLimit) {
                return false;
            }
            if (s.inputBandwidthLowerLimit != this.inputBandwidthLowerLimit) {
                return false;
            }
            if (s.inputBandwidthUpperLimit != this.inputBandwidthUpperLimit) {
                return false;
            }
            if (s.inputBandwidthPeerLimit != this.inputBandwidthPeerLimit) {
                return false;
            }
            if (s.maxTransfersOut != this.maxTransfersOut) {
                return false;
            }
            if (s.maxTransfersOutPeerLimit != this.maxTransfersOutPeerLimit) {
                return false;
            }
            if (s.maxTransfersOutLowerLimit != this.maxTransfersOutLowerLimit) {
                return false;
            }
            return s.maxTransfersOutUpperLimit == this.maxTransfersOutUpperLimit;
        }

        public int hashCode() {
            return this.peer.hashCode();
        }

        public String toString() {
            return this.peer.toString() + ":output:{lower=" + this.outputBandwidthLowerLimit + ",upper=" + this.outputBandwidthUpperLimit + ",this=" + this.outputBandwidthPeerLimit + "},input:lower=" + this.inputBandwidthLowerLimit + ",upper=" + this.inputBandwidthUpperLimit + ",peer=" + this.inputBandwidthPeerLimit + "},requests:in:" + this.expectedTransfersInCHK + "chk/" + this.expectedTransfersInSSK + "ssk:out:" + this.expectedTransfersOutCHK + "chk/" + this.expectedTransfersOutSSK + "ssk transfers=" + this.maxTransfersOut + "/" + this.maxTransfersOutPeerLimit + "/" + this.maxTransfersOutLowerLimit + "/" + this.maxTransfersOutUpperLimit;
        }

        public PeerLoadStats(PeerNode peer, int transfersPerInsert, boolean realTimeFlag) {
            this.peer = peer;
            this.realTime = realTimeFlag;
            long now = System.currentTimeMillis();
            double nonOverheadFraction = NodeStats.this.getNonOverheadFraction(now);
            int limit = NodeStats.this.getLimitSeconds(realTimeFlag);
            boolean ignoreLocalVsRemote = NodeStats.this.ignoreLocalVsRemoteBandwidthLiability();
            RunningRequestsSnapshot runningLocal = new RunningRequestsSnapshot(NodeStats.this.node.tracker, peer, false, ignoreLocalVsRemote, transfersPerInsert, realTimeFlag);
            int peers = NodeStats.this.node.peers.countConnectedPeers();
            this.outputBandwidthUpperLimit = NodeStats.this.getOutputBandwidthUpperLimit(limit, nonOverheadFraction);
            this.outputBandwidthLowerLimit = NodeStats.this.getLowerLimit(this.outputBandwidthUpperLimit, peers);
            this.inputBandwidthUpperLimit = NodeStats.this.getInputBandwidthUpperLimit(limit);
            this.inputBandwidthLowerLimit = NodeStats.this.getLowerLimit(this.inputBandwidthUpperLimit, peers);
            this.maxTransfersOutUpperLimit = NodeStats.this.getMaxTransfersUpperLimit(realTimeFlag, nonOverheadFraction);
            this.maxTransfersOutLowerLimit = (int)Math.max(1.0, NodeStats.this.getLowerLimit(this.maxTransfersOutUpperLimit, peers));
            this.maxTransfersOutPeerLimit = (int)Math.max(1.0, NodeStats.this.getPeerLimit(peer, this.maxTransfersOutUpperLimit - this.maxTransfersOutLowerLimit, false, transfersPerInsert, realTimeFlag, peers, runningLocal.expectedTransfersOutCHKSR + runningLocal.expectedTransfersOutSSKSR));
            this.maxTransfersOut = NodeStats.this.calculateMaxTransfersOut(peer, this.realTime, nonOverheadFraction, this.maxTransfersOutUpperLimit);
            this.outputBandwidthPeerLimit = NodeStats.this.getPeerLimit(peer, this.outputBandwidthUpperLimit - this.outputBandwidthLowerLimit, false, transfersPerInsert, realTimeFlag, peers, runningLocal.calculateSR(ignoreLocalVsRemote, false));
            this.inputBandwidthPeerLimit = NodeStats.this.getPeerLimit(peer, this.inputBandwidthUpperLimit - this.inputBandwidthLowerLimit, true, transfersPerInsert, realTimeFlag, peers, runningLocal.calculateSR(ignoreLocalVsRemote, true));
            this.averageTransfersOutPerInsert = transfersPerInsert;
            RunningRequestsSnapshot runningGlobal = new RunningRequestsSnapshot(NodeStats.this.node.tracker, ignoreLocalVsRemote, transfersPerInsert, realTimeFlag);
            this.expectedTransfersInCHK = runningGlobal.expectedTransfersInCHK - runningLocal.expectedTransfersInCHK;
            this.expectedTransfersInSSK = runningGlobal.expectedTransfersInSSK - runningLocal.expectedTransfersInSSK;
            this.expectedTransfersOutCHK = runningGlobal.expectedTransfersOutCHK - runningLocal.expectedTransfersOutCHK;
            this.expectedTransfersOutSSK = runningGlobal.expectedTransfersOutSSK - runningLocal.expectedTransfersOutSSK;
            this.totalRequests = runningGlobal.totalRequests - runningLocal.totalRequests;
        }

        public PeerLoadStats(PeerNode source, Message m) {
            this.peer = source;
            if (m.getSpec() == DMT.FNPPeerLoadStatusInt) {
                this.expectedTransfersInCHK = m.getInt("otherTransfersInCHK");
                this.expectedTransfersInSSK = m.getInt("otherTransfersInSSK");
                this.expectedTransfersOutCHK = m.getInt("otherTransfersOutCHK");
                this.expectedTransfersOutSSK = m.getInt("otherTransfersOutSSK");
                this.averageTransfersOutPerInsert = m.getInt("averageTransfersOutPerInsert");
                this.maxTransfersOut = m.getInt("maxTransfersOut");
                this.maxTransfersOutUpperLimit = m.getInt("maxTransfersOutUpperLimit");
                this.maxTransfersOutLowerLimit = m.getInt("maxTransfersOutLowerLimit");
                this.maxTransfersOutPeerLimit = m.getInt("maxTransfersOutPeerLimit");
            } else if (m.getSpec() == DMT.FNPPeerLoadStatusShort) {
                this.expectedTransfersInCHK = m.getShort("otherTransfersInCHK") & 0xFFFF;
                this.expectedTransfersInSSK = m.getShort("otherTransfersInSSK") & 0xFFFF;
                this.expectedTransfersOutCHK = m.getShort("otherTransfersOutCHK") & 0xFFFF;
                this.expectedTransfersOutSSK = m.getShort("otherTransfersOutSSK") & 0xFFFF;
                this.averageTransfersOutPerInsert = m.getShort("averageTransfersOutPerInsert") & 0xFFFF;
                this.maxTransfersOut = m.getShort("maxTransfersOut") & 0xFFFF;
                this.maxTransfersOutUpperLimit = m.getShort("maxTransfersOutUpperLimit") & 0xFFFF;
                this.maxTransfersOutLowerLimit = m.getShort("maxTransfersOutLowerLimit") & 0xFFFF;
                this.maxTransfersOutPeerLimit = m.getShort("maxTransfersOutPeerLimit") & 0xFFFF;
            } else if (m.getSpec() == DMT.FNPPeerLoadStatusByte) {
                this.expectedTransfersInCHK = m.getByte("otherTransfersInCHK") & 0xFF;
                this.expectedTransfersInSSK = m.getByte("otherTransfersInSSK") & 0xFF;
                this.expectedTransfersOutCHK = m.getByte("otherTransfersOutCHK") & 0xFF;
                this.expectedTransfersOutSSK = m.getByte("otherTransfersOutSSK") & 0xFF;
                this.averageTransfersOutPerInsert = m.getByte("averageTransfersOutPerInsert") & 0xFF;
                this.maxTransfersOut = m.getByte("maxTransfersOut") & 0xFF;
                this.maxTransfersOutUpperLimit = m.getByte("maxTransfersOutUpperLimit") & 0xFF;
                this.maxTransfersOutLowerLimit = m.getByte("maxTransfersOutLowerLimit") & 0xFF;
                this.maxTransfersOutPeerLimit = m.getByte("maxTransfersOutPeerLimit") & 0xFF;
            } else {
                throw new IllegalArgumentException();
            }
            this.outputBandwidthLowerLimit = m.getInt("outputBandwidthLowerLimit");
            this.outputBandwidthUpperLimit = m.getInt("outputBandwidthUpperLimit");
            this.outputBandwidthPeerLimit = m.getInt("outputBandwidthPeerLimit");
            this.inputBandwidthLowerLimit = m.getInt("inputBandwidthLowerLimit");
            this.inputBandwidthUpperLimit = m.getInt("inputBandwidthUpperLimit");
            this.inputBandwidthPeerLimit = m.getInt("inputBandwidthPeerLimit");
            this.totalRequests = -1;
            this.realTime = m.getBoolean("realTimeFlag");
        }

        public RunningRequestsSnapshot getOtherRunningRequests() {
            return new RunningRequestsSnapshot(this);
        }

        public double peerLimit(boolean input) {
            if (input) {
                return this.inputBandwidthPeerLimit;
            }
            return this.outputBandwidthPeerLimit;
        }

        public double lowerLimit(boolean input) {
            if (input) {
                return this.inputBandwidthLowerLimit;
            }
            return this.outputBandwidthLowerLimit;
        }
    }

    private static class RequestsByLocation {
        private final int[] bins;
        private int count = 0;

        RequestsByLocation(int numBins) {
            this.bins = new int[numBins];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void report(double loc) {
            assert (loc >= 0.0 && loc < 1.0);
            int bin = (int)Math.floor(loc * (double)this.bins.length);
            RequestsByLocation requestsByLocation = this;
            synchronized (requestsByLocation) {
                int n = bin;
                this.bins[n] = this.bins[n] + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int[] getCounts(int[] total) {
            int[] ret = new int[this.bins.length];
            RequestsByLocation requestsByLocation = this;
            synchronized (requestsByLocation) {
                System.arraycopy(this.bins, 0, ret, 0, this.bins.length);
                total[0] = this.count;
            }
            return ret;
        }
    }

    public static enum RequestType {
        CHK_REQUEST,
        SSK_REQUEST,
        CHK_INSERT,
        SSK_INSERT,
        CHK_OFFER_FETCH,
        SSK_OFFER_FETCH;

    }
}

