/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.StdCallLibrary;

public class ProcessPriority {
    private static volatile boolean background = false;

    public static boolean enterBackgroundMode() {
        if (!background) {
            if (Platform.isWindows()) {
                WindowsHolder lib = WindowsHolder.INSTANCE;
                if (lib.SetPriorityClass(lib.GetCurrentProcess(), WindowsHolder.PROCESS_MODE_BACKGROUND_BEGIN)) {
                    System.out.println("SetPriorityClass() succeeded!");
                    background = true;
                    return true;
                }
                if (lib.GetLastError().equals((Object)WindowsHolder.ERROR_PROCESS_MODE_ALREADY_BACKGROUND)) {
                    System.err.println("SetPriorityClass() failed :" + lib.GetLastError());
                    return false;
                }
            } else {
                if (Platform.isLinux()) {
                    return ProcessPriority.handleReturn(LinuxHolder.setpriority(0, 0, 10));
                }
                if (Platform.isMac()) {
                    return ProcessPriority.handleReturn(OSXHolder.setpriority(3, 0, 4096));
                }
            }
        }
        return background;
    }

    private static boolean handleReturn(int ret) {
        if (ret == 0) {
            System.out.println("setpriority() succeeded!");
            background = true;
            return true;
        }
        System.err.println("setpriority() failed :" + ret);
        return false;
    }

    private static class OSXHolder {
        static final int PRIO_DARWIN_THREAD = 3;
        static final int MYSELF = 0;
        static final int PRIO_DARWIN_NORMAL = 0;
        static final int PRIO_DARWIN_BG = 4096;

        private OSXHolder() {
        }

        private static native int setpriority(int var0, int var1, int var2);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }

    private static class LinuxHolder {
        static final int PRIO_PROCESS = 0;
        static final int MYSELF = 0;
        static final int LOWER_PRIORITY = 10;

        private LinuxHolder() {
        }

        private static native int setpriority(int var0, int var1, int var2);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }

    public static interface WindowsHolder
    extends StdCallLibrary {
        public static final WindowsHolder INSTANCE = (WindowsHolder)Native.loadLibrary((String)"kernel32", WindowsHolder.class);
        public static final WinDef.DWORD PROCESS_MODE_BACKGROUND_BEGIN = new WinDef.DWORD(0x100000L);
        public static final WinDef.DWORD PROCESS_MODE_BACKGROUND_END = new WinDef.DWORD(0x200000L);
        public static final WinDef.DWORD ERROR_PROCESS_MODE_ALREADY_BACKGROUND = new WinDef.DWORD(402L);
        public static final WinDef.DWORD ERROR_PROCESS_MODE_NOT_BACKGROUND = new WinDef.DWORD(403L);

        public boolean SetPriorityClass(WinNT.HANDLE var1, WinDef.DWORD var2);

        public WinNT.HANDLE GetCurrentProcess();

        public WinDef.DWORD GetLastError();
    }
}

