/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.FinishedCompressionEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.events.StartedCompressionEvent;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.ExpectedHashes;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.FinishedCompressionMessage;
import freenet.clients.fcp.GeneratedMetadataMessage;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.PersistentRequestRemovedMessage;
import freenet.clients.fcp.PutFailedMessage;
import freenet.clients.fcp.PutFetchableMessage;
import freenet.clients.fcp.PutSuccessfulMessage;
import freenet.clients.fcp.RequestStatusCache;
import freenet.clients.fcp.SimpleProgressMessage;
import freenet.clients.fcp.StartedCompressionMessage;
import freenet.clients.fcp.URIGeneratedMessage;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.NodeClientCore;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

public abstract class ClientPutBase
extends ClientRequest
implements ClientPutCallback,
ClientEventListener {
    private static final long serialVersionUID = 1L;
    final InsertContext ctx;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_EXPECTED_HASHES = 8;
    private static final int VERBOSITY_PUT_FETCHABLE = 256;
    private static final int VERBOSITY_COMPRESSION_START_END = 512;
    protected boolean succeeded;
    protected PutFailedMessage putFailedMessage;
    protected FreenetURI generatedURI;
    protected transient FCPMessage progressMessage;
    protected final FreenetURI publicURI;
    private Bucket generatedMetadata;
    public static final String SALT = "Salt";
    public static final String FILE_HASH = "FileHash";
    private static volatile boolean logMINOR;
    private static Map<Integer, UploadFrom> uploadFromByCode;

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, String charset, FCPConnectionHandler handler, short priorityClass, ClientRequest.Persistence persistence, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, boolean localRequestOnly, int maxRetries, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, String compressorDescriptor, int extraInsertsSingleBlock, int extraInsertsSplitfileHeader, boolean realTimeFlag, InsertContext.CompatibilityMode compatibilityMode, boolean ignoreUSKDatehints, FCPServer server) throws MalformedURLException {
        super(uri, identifier, verbosity, charset, handler, priorityClass, persistence, realTimeFlag, clientToken, global);
        this.ctx = server.core.clientContext.getDefaultPersistentInsertContext();
        this.ctx.getCHKOnly = getCHKOnly;
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.ctx.canWriteClientCache = canWriteClientCache;
        this.ctx.compressorDescriptor = compressorDescriptor;
        this.ctx.forkOnCacheable = forkOnCacheable;
        this.ctx.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.ctx.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeader;
        this.ctx.setCompatibilityMode(compatibilityMode);
        this.ctx.localRequestOnly = localRequestOnly;
        this.ctx.earlyEncode = earlyEncode;
        this.ctx.ignoreUSKDatehints = ignoreUSKDatehints;
        this.publicURI = this.uri.deriveRequestURIFromInsertURI();
    }

    protected ClientPutBase() {
        this.ctx = null;
        this.publicURI = null;
    }

    static FreenetURI checkEmptySSK(FreenetURI uri, String filename, ClientContext context) {
        if ("SSK".equals(uri.getKeyType()) && uri.getDocName() == null && uri.getRoutingKey() == null) {
            if (filename == null || filename.equals("")) {
                filename = "key";
            }
            InsertableClientSSK key = InsertableClientSSK.createRandom(context.random, "");
            return key.getInsertURI().setDocName(filename);
        }
        return uri;
    }

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, String charset, FCPConnectionHandler handler, PersistentRequestClient client, short priorityClass, ClientRequest.Persistence persistence, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, int maxRetries, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, boolean localRequestOnly, int extraInsertsSingleBlock, int extraInsertsSplitfileHeader, boolean realTimeFlag, String compressorDescriptor, InsertContext.CompatibilityMode compatMode, boolean ignoreUSKDatehints, NodeClientCore core) throws MalformedURLException {
        super(uri, identifier, verbosity, charset, handler, client, priorityClass, persistence, realTimeFlag, clientToken, global);
        this.ctx = core.clientContext.getDefaultPersistentInsertContext();
        this.ctx.getCHKOnly = getCHKOnly;
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.ctx.canWriteClientCache = canWriteClientCache;
        this.ctx.compressorDescriptor = compressorDescriptor;
        this.ctx.forkOnCacheable = forkOnCacheable;
        this.ctx.extraInsertsSingleBlock = extraInsertsSingleBlock;
        this.ctx.extraInsertsSplitfileHeaderBlock = extraInsertsSplitfileHeader;
        this.ctx.localRequestOnly = localRequestOnly;
        this.ctx.setCompatibilityMode(compatMode);
        this.ctx.ignoreUSKDatehints = ignoreUSKDatehints;
        this.ctx.earlyEncode = earlyEncode;
        this.publicURI = this.uri.deriveRequestURIFromInsertURI();
    }

    @Override
    public void onLostConnection(ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.cancel(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(BaseClientPutter state) {
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.started = true;
            this.succeeded = true;
            this.finished = true;
            this.completionTime = System.currentTimeMillis();
            if (this.generatedURI == null) {
                Logger.error(this, "No generated URI in onSuccess() for " + this + " from " + state);
            }
        }
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.freeData();
        }
        this.finish();
        this.trySendFinalMessage(null, null);
        if (this.client != null) {
            this.client.notifySuccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, BaseClientPutter state) {
        if (this.finished) {
            return;
        }
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.started = true;
            this.finished = true;
            this.completionTime = System.currentTimeMillis();
            this.putFailedMessage = new PutFailedMessage(e, this.identifier, this.global);
        }
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.freeData();
        }
        this.finish();
        this.trySendFinalMessage(null, null);
        if (this.client != null) {
            this.client.notifyFailure(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGeneratedURI(FreenetURI uri, BaseClientPutter state) {
        RequestStatusCache cache;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.generatedURI != null) {
                if (!uri.equals(this.generatedURI)) {
                    Logger.error(this, "onGeneratedURI(" + uri + ',' + state + ") but already set generatedURI to " + this.generatedURI);
                } else if (logMINOR) {
                    Logger.minor(this, "onGeneratedURI() twice with same value: " + this.generatedURI + " -> " + uri);
                }
            } else {
                this.generatedURI = uri;
            }
        }
        this.trySendGeneratedURIMessage(null, null);
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.gotFinalURI(this.identifier, uri);
        }
    }

    public FreenetURI getGeneratedURI() {
        return this.generatedURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state) {
        boolean delete = false;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.generatedURI != null) {
                Logger.error(this, "Got generated metadata but already have URI on " + this + " from " + state);
            }
            if (this.generatedMetadata != null) {
                Logger.error(this, "Already got generated metadata from " + state + " on " + this);
                delete = true;
            } else {
                this.generatedMetadata = metadata;
            }
        }
        if (delete) {
            metadata.free();
        } else {
            this.trySendGeneratedMetadataMessage(metadata, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestWasRemoved(ClientContext context) {
        Bucket meta;
        if (!this.finished) {
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                this.finished = true;
                InsertException cancelled = new InsertException(InsertException.InsertExceptionMode.CANCELLED);
                this.putFailedMessage = new PutFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendFinalMessage(null, null);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.origHandler.outputHandler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0);
        }
        this.freeData();
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            meta = this.generatedMetadata;
            this.generatedMetadata = null;
        }
        if (meta != null) {
            meta.free();
        }
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            clientPutBase = this;
            synchronized (clientPutBase) {
                this.putFailedMessage = null;
                this.generatedURI = null;
                this.progressMessage = null;
            }
        }
        super.requestWasRemoved(context);
    }

    @Override
    public void receive(ClientEvent ce, ClientContext context) {
        if (this.finished) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Receiving event " + ce + " on " + this);
        }
        if (ce instanceof SplitfileProgressEvent) {
            RequestStatusCache cache;
            if ((this.verbosity & 1) == 1) {
                SimpleProgressMessage progress = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
                this.trySendProgressMessage(progress, 1, null, context);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStatus(this.identifier, (SplitfileProgressEvent)ce);
            }
        } else if (ce instanceof StartedCompressionEvent) {
            if ((this.verbosity & 0x200) == 512) {
                StartedCompressionMessage msg = new StartedCompressionMessage(this.identifier, this.global, ((StartedCompressionEvent)ce).codec);
                this.trySendProgressMessage(msg, 512, null, context);
                this.onStartCompressing();
            }
        } else if (ce instanceof FinishedCompressionEvent) {
            if ((this.verbosity & 0x200) == 512) {
                FinishedCompressionMessage msg = new FinishedCompressionMessage(this.identifier, this.global, (FinishedCompressionEvent)ce);
                this.trySendProgressMessage(msg, 512, null, context);
                this.onStopCompressing();
            }
        } else if (ce instanceof ExpectedHashesEvent && (this.verbosity & 8) == 8) {
            ExpectedHashes msg = new ExpectedHashes((ExpectedHashesEvent)ce, this.identifier, this.global);
            this.trySendProgressMessage(msg, 8, null, context);
        }
    }

    protected abstract void onStopCompressing();

    protected abstract void onStartCompressing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchable(BaseClientPutter putter) {
        if (this.finished) {
            return;
        }
        if ((this.verbosity & 0x100) == 256) {
            FreenetURI temp;
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                temp = this.generatedURI;
            }
            PutFetchableMessage msg = new PutFetchableMessage(this.identifier, this.global, temp);
            this.trySendProgressMessage(msg, 256, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendFinalMessage(FCPConnectionOutputHandler handler, String listRequestIdentifier) {
        FCPMessage msg;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            msg = this.succeeded ? new PutSuccessfulMessage(this.identifier, this.global, this.generatedURI, this.startupTime, this.completionTime) : this.putFailedMessage;
        }
        if (msg == null) {
            Logger.error(this, "Trying to send null message on " + this, (Throwable)new Exception("error"));
        } else {
            if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
                handler = this.origHandler.outputHandler;
            }
            if (handler != null) {
                handler.queue(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier));
            } else {
                this.client.queueClientRequestMessage(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendGeneratedURIMessage(FCPConnectionOutputHandler handler, String listRequestIdentifier) {
        URIGeneratedMessage msg;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            msg = new URIGeneratedMessage(this.generatedURI, this.identifier, this.isGlobalQueue());
        }
        if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier));
        } else {
            this.client.queueClientRequestMessage(msg, 0);
        }
    }

    private void trySendGeneratedMetadataMessage(Bucket metadata, FCPConnectionOutputHandler handler, String listRequestIdentifier) {
        FCPMessage msg = FCPMessage.withListRequestIdentifier(new GeneratedMetadataMessage(this.identifier, this.global, metadata), listRequestIdentifier);
        if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendProgressMessage(FCPMessage msg, int verbosity, FCPConnectionOutputHandler handler, ClientContext context) {
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.persistence != ClientRequest.Persistence.CONNECTION) {
                this.progressMessage = msg;
            }
        }
        if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, verbosity);
        }
    }

    protected abstract FCPMessage persistentTagMessage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPendingMessages(FCPConnectionOutputHandler handler, String listRequestIdentifier, boolean includeData, boolean onlyData) {
        Bucket meta;
        FCPMessage msg = FCPMessage.withListRequestIdentifier(this.persistentTagMessage(), listRequestIdentifier);
        handler.queue(msg);
        boolean generated = false;
        boolean fin = false;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            generated = this.generatedURI != null;
            msg = FCPMessage.withListRequestIdentifier(this.progressMessage, listRequestIdentifier);
            fin = this.finished;
            meta = this.generatedMetadata;
        }
        if (generated) {
            this.trySendGeneratedURIMessage(handler, listRequestIdentifier);
        }
        if (meta != null) {
            this.trySendGeneratedMetadataMessage(meta, handler, listRequestIdentifier);
        }
        if (msg != null) {
            handler.queue(msg);
        }
        if (fin) {
            this.trySendFinalMessage(handler, listRequestIdentifier);
        }
    }

    protected abstract String getTypeName();

    @Override
    public synchronized double getSuccessFraction() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFraction();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getTotalBlocks() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getTotalBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getMinBlocks() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getMinBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFailedBlocks() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFatalyFailedBlocks() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFatalyFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized double getFetchedBlocks() {
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFetchedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    @Override
    public synchronized boolean isTotalFinalized() {
        if (!(this.progressMessage instanceof SimpleProgressMessage)) {
            return false;
        }
        return ((SimpleProgressMessage)this.progressMessage).isTotalFinalized();
    }

    @Override
    public synchronized String getFailureReason(boolean longDescription) {
        if (this.putFailedMessage == null) {
            return null;
        }
        String s = this.putFailedMessage.shortCodeDescription;
        if (longDescription && this.putFailedMessage.extraDescription != null) {
            s = s + ": " + this.putFailedMessage.extraDescription;
        }
        return s;
    }

    public PutFailedMessage getFailureMessage() {
        if (this.putFailedMessage == null) {
            return null;
        }
        return this.putFailedMessage;
    }

    public synchronized void setVarsRestart() {
        this.finished = false;
        this.putFailedMessage = null;
        this.progressMessage = null;
        this.started = false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        uploadFromByCode = new HashMap<Integer, UploadFrom>();
    }

    public static enum UploadFrom {
        DIRECT(0),
        DISK(1),
        REDIRECT(2);

        final int code;

        private UploadFrom(int code) {
            if (uploadFromByCode.containsKey(code)) {
                throw new Error("Duplicate");
            }
            uploadFromByCode.put(code, this);
            this.code = code;
        }

        public static UploadFrom getByCode(int x) {
            UploadFrom u = (UploadFrom)((Object)uploadFromByCode.get(x));
            if (u == null) {
                throw new IllegalArgumentException();
            }
            return u;
        }
    }
}

