/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.HashcodeReferenceSystem;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class TransactionalReferenceSystem
implements ReferenceSystem {
    private final ReferenceSystem _committedReferences;
    private ReferenceSystem _newReferences;

    public TransactionalReferenceSystem() {
        this.createNewReferences();
        this._committedReferences = this.newReferenceSystem();
    }

    private ReferenceSystem newReferenceSystem() {
        return new HashcodeReferenceSystem();
    }

    @Override
    public void addExistingReference(ObjectReference ref) {
        this._committedReferences.addExistingReference(ref);
    }

    @Override
    public void addNewReference(ObjectReference ref) {
        this._newReferences.addNewReference(ref);
    }

    @Override
    public void commit() {
        this.traveseNewReferences(new Visitor4(){

            @Override
            public void visit(Object obj) {
                ObjectReference oref = (ObjectReference)obj;
                Object referent = oref.getObject();
                if (referent != null) {
                    TransactionalReferenceSystem.this._committedReferences.addExistingReference(oref);
                }
            }
        });
        this.createNewReferences();
    }

    public void traveseNewReferences(Visitor4 visitor) {
        this._newReferences.traverseReferences(visitor);
    }

    private void createNewReferences() {
        this._newReferences = this.newReferenceSystem();
    }

    @Override
    public ObjectReference referenceForId(int id) {
        ObjectReference ref = this._newReferences.referenceForId(id);
        if (ref != null) {
            return ref;
        }
        return this._committedReferences.referenceForId(id);
    }

    @Override
    public ObjectReference referenceForObject(Object obj) {
        ObjectReference ref = this._newReferences.referenceForObject(obj);
        if (ref != null) {
            return ref;
        }
        return this._committedReferences.referenceForObject(obj);
    }

    @Override
    public void removeReference(ObjectReference ref) {
        this._newReferences.removeReference(ref);
        this._committedReferences.removeReference(ref);
    }

    @Override
    public void rollback() {
        this.createNewReferences();
    }

    @Override
    public void traverseReferences(Visitor4 visitor) {
        this.traveseNewReferences(visitor);
        this._committedReferences.traverseReferences(visitor);
    }
}

