/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.util.Buffer;

public abstract class FECCode {
    protected int k;
    protected int n;

    protected FECCode(int n, int n2) {
        this.k = n;
        this.n = n2;
    }

    protected abstract void encode(byte[][] var1, int[] var2, byte[][] var3, int[] var4, int[] var5, int var6);

    protected abstract void decode(byte[][] var1, int[] var2, int[] var3, int var4, boolean var5);

    public void encode(Buffer[] bufferArray, Buffer[] bufferArray2, int[] nArray) {
        int n;
        byte[][] byArrayArray = new byte[bufferArray.length][];
        int[] nArray2 = new int[bufferArray.length];
        byte[][] byArrayArray2 = new byte[bufferArray2.length][];
        int[] nArray3 = new int[bufferArray2.length];
        for (n = 0; n < byArrayArray.length; ++n) {
            byArrayArray[n] = bufferArray[n].b;
            nArray2[n] = bufferArray[n].off;
        }
        for (n = 0; n < byArrayArray2.length; ++n) {
            byArrayArray2[n] = bufferArray2[n].b;
            nArray3[n] = bufferArray2[n].off;
        }
        this.encode(byArrayArray, nArray2, byArrayArray2, nArray3, nArray, bufferArray[0].len);
    }

    public void decode(Buffer[] bufferArray, int[] nArray) {
        FECCode.copyShuffle(bufferArray, nArray, this.k);
        byte[][] byArrayArray = new byte[bufferArray.length][];
        int[] nArray2 = new int[bufferArray.length];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = bufferArray[i].b;
            nArray2[i] = bufferArray[i].off;
        }
        this.decode(byArrayArray, nArray2, nArray, bufferArray[0].len, true);
    }

    protected static final void copyShuffle(Buffer[] bufferArray, int[] nArray, int n) {
        byte[] byArray = null;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] >= n || nArray[n2] == n2) {
                ++n2;
                continue;
            }
            int n3 = nArray[n2];
            if (nArray[n3] == n3) {
                throw new IllegalArgumentException("Shuffle Error: Duplicate indexes at " + n2);
            }
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            if (byArray == null) {
                byArray = new byte[bufferArray[0].len];
            }
            System.arraycopy(bufferArray[n2].b, bufferArray[n2].off, byArray, 0, byArray.length);
            System.arraycopy(bufferArray[n3].b, bufferArray[n3].off, bufferArray[n2].b, bufferArray[n2].off, byArray.length);
            System.arraycopy(byArray, 0, bufferArray[n3].b, bufferArray[n3].off, byArray.length);
        }
    }

    protected static final void shuffle(byte[][] byArray, int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (nArray2[n2] >= n || nArray2[n2] == n2) {
                ++n2;
                continue;
            }
            int n3 = nArray2[n2];
            if (nArray2[n3] == n3) {
                throw new IllegalArgumentException("Shuffle error at " + n2);
            }
            byte[] byArray2 = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = byArray2;
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            n4 = nArray2[n2];
            nArray2[n2] = nArray2[n3];
            nArray2[n3] = n4;
        }
    }
}

