/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.PushingTagReplacerCallback;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.clients.http.BookmarkEditorToadlet;
import freenet.clients.http.BrowserTestToadlet;
import freenet.clients.http.ChatForumsToadlet;
import freenet.clients.http.ConfigToadlet;
import freenet.clients.http.ConnectivityToadlet;
import freenet.clients.http.ContentFilterToadlet;
import freenet.clients.http.DarknetAddRefToadlet;
import freenet.clients.http.DarknetConnectionsToadlet;
import freenet.clients.http.DecodeToadlet;
import freenet.clients.http.DiagnosticToadlet;
import freenet.clients.http.ExternalLinkToadlet;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FileInsertWizardToadlet;
import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.HTTPRangeException;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.ImageCreatorToadlet;
import freenet.clients.http.InsertFreesiteToadlet;
import freenet.clients.http.LocalDirectoryConfigToadlet;
import freenet.clients.http.LocalDownloadDirectoryToadlet;
import freenet.clients.http.LocalFileFilterToadlet;
import freenet.clients.http.LocalFileInsertToadlet;
import freenet.clients.http.LocalFileN2NMToadlet;
import freenet.clients.http.N2NTMToadlet;
import freenet.clients.http.OpennetConnectionsToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.PproxyToadlet;
import freenet.clients.http.QueueToadlet;
import freenet.clients.http.RedirectException;
import freenet.clients.http.SecurityLevelsToadlet;
import freenet.clients.http.SimpleHelpToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.StatisticsToadlet;
import freenet.clients.http.SymlinkerToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.TranslationToadlet;
import freenet.clients.http.UserAlertsToadlet;
import freenet.clients.http.WelcomeToadlet;
import freenet.clients.http.ajaxpush.DismissAlertToadlet;
import freenet.clients.http.ajaxpush.LogWritebackToadlet;
import freenet.clients.http.ajaxpush.PushDataToadlet;
import freenet.clients.http.ajaxpush.PushFailoverToadlet;
import freenet.clients.http.ajaxpush.PushKeepaliveToadlet;
import freenet.clients.http.ajaxpush.PushLeavingToadlet;
import freenet.clients.http.ajaxpush.PushNotificationToadlet;
import freenet.clients.http.ajaxpush.PushTesterToadlet;
import freenet.clients.http.updateableelements.ProgressBarElement;
import freenet.clients.http.updateableelements.ProgressInfoElement;
import freenet.config.Config;
import freenet.config.SubConfig;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.node.SecurityLevels;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MediaType;
import freenet.support.MultiValueTable;
import freenet.support.SizeUtil;
import freenet.support.URIPreEncoder;
import freenet.support.URLEncoder;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NoFreeBucket;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class FProxyToadlet
extends Toadlet
implements RequestClient {
    private static byte[] random;
    final NodeClientCore core;
    final ClientContext context;
    final FProxyFetchTracker fetchTracker;
    static final Set<String> prefetchAllowedTypes;
    private static final long FORCE_GRAIN_INTERVAL;
    public static long MAX_LENGTH_WITH_PROGRESS;
    public static long MAX_LENGTH_NO_PROGRESS;
    static final URI welcome;
    public static final short PRIORITY = 1;
    private static volatile boolean logMINOR;
    static final int MAX_PREFETCH = 50;
    static final HTMLNode DOWNLOADS_LINK;
    static final int MAX_RECURSION = 5;

    public FProxyToadlet(HighLevelSimpleClient client, NodeClientCore core, FProxyFetchTracker tracker) {
        super(client);
        client.setMaxLength(MAX_LENGTH_NO_PROGRESS);
        client.setMaxIntermediateLength(MAX_LENGTH_NO_PROGRESS);
        this.core = core;
        this.context = core.clientContext;
        this.fetchTracker = tracker;
    }

    @Override
    public boolean allowPOSTWithoutPassword() {
        return true;
    }

    public void handleMethodPOST(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String ks = uri.getPath();
        if (ks.equals("/") || ks.startsWith("/servlet/")) {
            try {
                throw new RedirectException("/welcome/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(ToadletContext context, Bucket data, BucketFactory bucketFactory, String mimeType, String requestedMimeType, String forceString, boolean forceDownload, String basePath, FreenetURI key, String extras, String referrer, boolean downloadLink, ToadletContext ctx, NodeClientCore core, boolean dontFreeData, String maybeCharset) throws ToadletContextClosedException, IOException {
        if (logMINOR) {
            Logger.minor(FProxyToadlet.class, "handleDownload(data.size=" + data.size() + ", mimeType=" + mimeType + ", requestedMimeType=" + requestedMimeType + ", forceDownload=" + forceDownload + ", basePath=" + basePath + ", key=" + key);
        }
        String extrasNoMime = extras;
        if (!(requestedMimeType == null || mimeType != null && requestedMimeType.equals(mimeType))) {
            if (extras == null) {
                extras = "";
            }
            extras = extras + "&type=" + requestedMimeType;
        }
        long size = data.size();
        long now = System.currentTimeMillis();
        boolean force = false;
        if (forceString != null && (forceString.equals(FProxyToadlet.getForceValue(key, now)) || forceString.equals(FProxyToadlet.getForceValue(key, now - FORCE_GRAIN_INTERVAL)))) {
            force = true;
        }
        if (!force && !forceDownload) {
            if (mimeType.compareTo("application/xhtml+xml") == 0) {
                mimeType = "text/html";
            }
            if (FProxyToadlet.horribleEvilHack(data) && !mimeType.startsWith("application/rss+xml")) {
                boolean mimeRSS;
                PageNode page = context.getPageMaker().getPageNode(FProxyToadlet.l10n("dangerousRSSTitle"), context);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-alert");
                infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("dangerousRSSSubtitle"));
                HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                infoboxContent.addChild("#", NodeL10n.getBase().getString("FProxyToadlet.dangerousRSS", new String[]{"type"}, new String[]{mimeType}));
                infoboxContent.addChild("p", FProxyToadlet.l10n("options"));
                HTMLNode optionList = infoboxContent.addChild("ul");
                HTMLNode option = optionList.addChild("li");
                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openPossRSSAsPlainText", new String[]{"link", "bold"}, new HTMLNode[]{HTMLNode.link(basePath + key.toString() + "?type=text/plain&force=" + FProxyToadlet.getForceValue(key, now) + extrasNoMime), HTMLNode.STRONG});
                option = optionList.addChild("li");
                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openPossRSSForceDisk", new String[]{"link", "bold"}, new HTMLNode[]{HTMLNode.link(basePath + key.toString() + "?forcedownload" + extras), HTMLNode.STRONG});
                boolean bl = mimeRSS = mimeType.startsWith("application/xml+rss") || mimeType.startsWith("text/xml");
                if (!mimeRSS && !mimeType.startsWith("text/plain")) {
                    option = optionList.addChild("li");
                    NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openRSSForce", new String[]{"link", "bold", "mime"}, new HTMLNode[]{HTMLNode.link(basePath + key.toString() + "?force=" + FProxyToadlet.getForceValue(key, now) + extras), HTMLNode.STRONG, HTMLNode.text(mimeType)});
                }
                option = optionList.addChild("li");
                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openRSSAsRSS", new String[]{"link", "bold"}, new HTMLNode[]{HTMLNode.link(basePath + key.toString() + "?type=application/xml+rss&force=" + FProxyToadlet.getForceValue(key, now) + extrasNoMime), HTMLNode.STRONG});
                FProxyToadlet.addDownloadOptions(ctx, optionList, key, mimeType, true, false, core);
                if (referrer != null) {
                    option = optionList.addChild("li");
                    NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.backToReferrer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link(referrer)});
                }
                option = optionList.addChild("li");
                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.backToFProxy", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/")});
                byte[] pageBytes = pageNode.generate().getBytes("UTF-8");
                context.sendReplyHeaders(200, "OK", new MultiValueTable<String, String>(), "text/html; charset=utf-8", pageBytes.length);
                context.writeData(pageBytes);
                return;
            }
        }
        if (forceDownload) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Content-Disposition", "attachment; filename=\"" + key.getPreferredFilename() + '\"');
            headers.put("Cache-Control", "private");
            headers.put("Content-Transfer-Encoding", "binary");
            headers.put("X-Content-Type-Options", "nosniff");
            context.sendReplyHeadersFProxy(200, "OK", headers, "application/force-download", size);
            context.writeData(data);
        } else {
            MultiValueTable<String, String> hdr = context.getHeaders();
            String rangeStr = hdr.get("range");
            if (rangeStr != null) {
                long[] range;
                try {
                    range = FProxyToadlet.parseRange(rangeStr);
                }
                catch (HTTPRangeException e) {
                    ctx.sendReplyHeaders(416, "Requested Range Not Satisfiable", null, null, 0L);
                    return;
                }
                if (range[1] == -1L || range[1] >= size) {
                    range[1] = size - 1L;
                }
                InputStream is = null;
                OutputStream os = null;
                RandomAccessBucket tmpRange = bucketFactory.makeBucket(range[1] - range[0]);
                try {
                    is = data.getInputStream();
                    os = tmpRange.getOutputStream();
                    if (range[0] > 0L) {
                        FileUtil.skipFully(is, range[0]);
                    }
                    FileUtil.copy(is, os, range[1] - range[0] + 1L);
                    os.close();
                    os = null;
                }
                finally {
                    Closer.close(is);
                    Closer.close(os);
                }
                MultiValueTable<String, String> retHdr = new MultiValueTable<String, String>();
                retHdr.put("Content-Range", "bytes " + range[0] + "-" + range[1] + "/" + size);
                retHdr.put("X-Content-Type-Options", "nosniff");
                context.sendReplyHeadersFProxy(206, "Partial content", retHdr, mimeType, tmpRange.size());
                context.writeData(tmpRange);
            } else {
                MultiValueTable<String, String> retHdr = new MultiValueTable<String, String>();
                retHdr.put("X-Content-Type-Options", "nosniff");
                if (this.container.enableCachingForChkAndSskKeys() && (key.isCHK() || key.isSSK())) {
                    context.sendReplyHeadersStatic(200, "OK", retHdr, mimeType, size, new Date());
                } else {
                    context.sendReplyHeadersFProxy(200, "OK", retHdr, mimeType, size);
                }
                context.writeData(data);
            }
        }
    }

    private static void addDownloadOptions(ToadletContext ctx, HTMLNode optionList, FreenetURI key, String mimeType, boolean disableFiltration, boolean dontShowFilter, NodeClientCore core) {
        HTMLNode optionForm;
        HTMLNode option;
        FilterMIMEType type;
        boolean filterChecked;
        SecurityLevels.PHYSICAL_THREAT_LEVEL threatLevel = core.node.securityLevels.getPhysicalThreatLevel();
        SecurityLevels.NETWORK_THREAT_LEVEL netLevel = core.node.securityLevels.getNetworkThreatLevel();
        boolean bl = filterChecked = (threatLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW || netLevel != SecurityLevels.NETWORK_THREAT_LEVEL.LOW) && !disableFiltration;
        if (filterChecked && mimeType != null && !mimeType.equals("application/octet-stream") && !mimeType.equals("") && ((type = ContentFilter.getMIMEType(mimeType)) == null || !type.safeToRead && type.readFilter == null) && threatLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH && threatLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM && netLevel != SecurityLevels.NETWORK_THREAT_LEVEL.HIGH && netLevel != SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
            filterChecked = false;
        }
        if (threatLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM && !core.isDownloadDisabled()) {
            option = optionList.addChild("li");
            optionForm = ctx.addFormChild(option, "/downloads/", "tooBigQueueForm");
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "disk"});
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
            if (mimeType != null && !mimeType.equals("")) {
                optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", mimeType});
            }
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToDiskButton")});
            String downloadLocation = core.getDownloadsDir().getAbsolutePath();
            if (!core.allowDownloadTo(core.getDownloadsDir())) {
                downloadLocation = core.getAllowedDownloadDirs()[0].getAbsolutePath();
            }
            NodeL10n.getBase().addL10nSubstitution(optionForm, "FProxyToadlet.downloadInBackgroundToDisk", new String[]{"dir", "page"}, new HTMLNode[]{new HTMLNode("input", new String[]{"type", "name", "value", "maxlength", "size"}, new String[]{"text", "path", downloadLocation, Integer.toString(0x100000), String.valueOf(downloadLocation.length())}), DOWNLOADS_LINK});
            optionForm.addChild("#", " ");
            NodeL10n.getBase().addL10nSubstitution(optionForm, "FProxyToadlet.downloadToDiskWarningNotFiltered", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "select-location", NodeL10n.getBase().getString("QueueToadlet.browseToChange") + "..."});
            if (!dontShowFilter) {
                HTMLNode filterControl = optionForm.addChild("div", FProxyToadlet.l10n("filterData"));
                HTMLNode f = filterControl.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "filterData", "filterData"});
                if (filterChecked) {
                    f.addAttribute("checked", "checked");
                }
                filterControl.addChild("div", FProxyToadlet.l10n("filterDataMessage"));
            }
            if (threatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) {
                optionForm.addChild("br");
                NodeL10n.getBase().addL10nSubstitution(optionForm, "FProxyToadlet.downloadToDiskSecurityWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            }
        }
        if (threatLevel != SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW || core.isDownloadDisabled()) {
            option = optionList.addChild("li");
            optionForm = ctx.addFormChild(option, "/downloads/", "tooBigQueueForm");
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key.toString()});
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "return-type", "direct"});
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "persistence", "forever"});
            if (mimeType != null && !mimeType.equals("")) {
                optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", mimeType});
            }
            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "download", FProxyToadlet.l10n("downloadInBackgroundToTempSpaceButton")});
            NodeL10n.getBase().addL10nSubstitution(optionForm, "FProxyToadlet.downloadInBackgroundToTempSpace", new String[]{"page", "bold"}, new HTMLNode[]{DOWNLOADS_LINK, HTMLNode.STRONG});
            if (!dontShowFilter) {
                HTMLNode filterControl = optionForm.addChild("div", FProxyToadlet.l10n("filterData"));
                HTMLNode f = filterControl.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "filterData", "filterData"});
                if (filterChecked) {
                    f.addAttribute("checked", "checked");
                }
                filterControl.addChild("div", FProxyToadlet.l10n("filterDataMessage"));
            }
        }
    }

    public static String l10n(String msg) {
        return NodeL10n.getBase().getString("FProxyToadlet." + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean horribleEvilHack(Bucket data) throws IOException {
        DataInputStream is;
        block8: {
            byte[] buf;
            block7: {
                block6: {
                    int sz;
                    block5: {
                        boolean bl;
                        is = null;
                        try {
                            sz = (int)Math.min(data.size(), 512L);
                            if (sz != 0) break block5;
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            Closer.close(is);
                            throw throwable;
                        }
                        Closer.close(is);
                        return bl;
                    }
                    is = new DataInputStream(data.getInputStream());
                    buf = new byte[sz];
                    is.readFully(buf);
                    if (!FProxyToadlet.checkForString(buf, "<rss")) break block6;
                    boolean bl = true;
                    Closer.close(is);
                    return bl;
                }
                if (!FProxyToadlet.checkForString(buf, "<feed")) break block7;
                boolean bl = true;
                Closer.close(is);
                return bl;
            }
            if (!FProxyToadlet.checkForString(buf, "<rdf:RDF")) break block8;
            boolean bl = true;
            Closer.close(is);
            return bl;
        }
        Closer.close(is);
        return false;
    }

    private static boolean checkForString(byte[] buf, String find) {
        int offset = 0;
        int bufProgress = 0;
        while (offset < buf.length) {
            byte b = buf[offset];
            if (b == find.charAt(bufProgress)) {
                if (++bufProgress == find.length()) {
                    return true;
                }
                ++offset;
                continue;
            }
            if (bufProgress == 0) {
                ++offset;
                continue;
            }
            bufProgress = 0;
        }
        return false;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest httprequest, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        this.innerHandleMethodGET(uri, httprequest, ctx, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void innerHandleMethodGET(URI uri, HTTPRequest httprequest, ToadletContext ctx, int recursion) throws ToadletContextClosedException, IOException, RedirectException {
        block107: {
            ks = uri.getPath();
            headers = ctx.getHeaders();
            ua = headers.get("user-agent");
            accept = headers.get("accept");
            if (FProxyToadlet.logMINOR) {
                Logger.minor(this, "UA = " + ua + " accept = " + accept);
            }
            canSendProgress = this.isBrowser(ua) != false && ctx.disableProgressPage() == false && (accept == null || accept.indexOf("text/html") > -1) && httprequest.isParameterSet("forcedownload") == false;
            defaultMaxSize = canSendProgress != false ? FProxyToadlet.MAX_LENGTH_WITH_PROGRESS : FProxyToadlet.MAX_LENGTH_NO_PROGRESS;
            maxRetries = httprequest.getIntParam("max-retries", -2);
            restricted = this.container.publicGatewayMode() != false && ctx.isAllowedFullAccess() == false;
            overrideSize = false;
            maxSize = defaultMaxSize;
            maxSizeDownload = FProxyToadlet.MAX_LENGTH_WITH_PROGRESS;
            if (!restricted && httprequest.isParameterSet("max-size")) {
                maxSize = maxSizeDownload = httprequest.getLongParam("max-size", defaultMaxSize);
                overrideSize = true;
            }
            if (ks.equals("/")) {
                if (httprequest.isParameterSet("key")) {
                    k = httprequest.getParam("key");
                    try {
                        newURI = new FreenetURI(k);
                    }
                    catch (MalformedURLException e) {
                        Logger.normal(this, "Invalid key: " + e + " for " + k, (Throwable)e);
                        this.sendErrorPage(ctx, 404, FProxyToadlet.l10n("notFoundTitle"), NodeL10n.getBase().getString("FProxyToadlet.invalidKeyWithReason", new String[]{"reason"}, new String[]{e.toString()}));
                        return;
                    }
                    if (FProxyToadlet.logMINOR) {
                        Logger.minor(this, "Redirecting to FreenetURI: " + newURI);
                    }
                    requestedMimeType = httprequest.getParam("type");
                    location = this.getLink(newURI, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), maxRetries, overrideSize);
                    this.writeTemporaryRedirect(ctx, null, location);
                    return;
                }
                try {
                    throw new RedirectException(new URI(null, null, null, -1, FProxyToadlet.welcome.getPath(), uri.getQuery(), uri.getFragment()));
                }
                catch (URISyntaxException e) {
                    Logger.error(FProxyToadlet.class, "Unexpected syntax error in URI: " + e);
                    this.writeTemporaryRedirect(ctx, "Internal error. Please check logs and report.", "/");
                    return;
                }
            }
            if (ks.equals("/favicon.ico")) {
                try {
                    throw new RedirectException("/static/favicon.ico");
                }
                catch (URISyntaxException e) {
                    throw new Error(e);
                }
            }
            if (ks.startsWith("/feed/") || ks.equals("/feed")) {
                host = ctx.getHeaders().get("host");
                atom = ctx.getAlertManager().getAtom("http://" + host);
                buf = atom.getBytes("UTF-8");
                ctx.sendReplyHeadersFProxy(200, "OK", null, "application/atom+xml", buf.length);
                ctx.writeData(buf, 0, buf.length);
                return;
            }
            if (ks.equals("/robots.txt") && ctx.doRobots()) {
                this.writeTextReply(ctx, 200, "Ok", "User-agent: *\nDisallow: /");
                return;
            }
            if (ks.startsWith("/darknet/") || ks.equals("/darknet")) {
                FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/friends/");
                return;
            }
            if (ks.startsWith("/opennet/") || ks.equals("/opennet")) {
                FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/strangers/");
                return;
            }
            if (ks.startsWith("/queue/")) {
                FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/downloads/");
                return;
            }
            if (ks.startsWith("/config/")) {
                FProxyToadlet.writePermanentRedirect(ctx, "obsoleted", "/config/node");
                return;
            }
            if (ks.startsWith("/")) {
                ks = ks.substring(1);
            }
            if ((rangeStr = ctx.getHeaders().get("range")) != null) {
                try {
                    FProxyToadlet.parseRange(rangeStr);
                }
                catch (HTTPRangeException e) {
                    Logger.normal(this, "Invalid Range Header: " + rangeStr, (Throwable)e);
                    ctx.sendReplyHeaders(416, "Requested Range Not Satisfiable", null, null, 0L);
                    return;
                }
            }
            try {
                key = new FreenetURI(ks);
            }
            catch (MalformedURLException e) {
                page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("invalidKeyTitle"), ctx);
                pageNode = page.outer;
                contentNode = page.content;
                errorInfobox = contentNode.addChild("div", "class", "infobox infobox-error");
                errorInfobox.addChild("div", "class", "infobox-header", NodeL10n.getBase().getString("FProxyToadlet.invalidKeyWithReason", new String[]{"reason"}, new String[]{e.toString()}));
                errorContent = errorInfobox.addChild("div", "class", "infobox-content");
                errorContent.addChild("#", FProxyToadlet.l10n("expectedKeyButGot"));
                errorContent.addChild("code", ks);
                errorContent.addChild("br");
                errorContent.addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBack")));
                errorContent.addChild("br");
                FProxyToadlet.addHomepageLink(errorContent);
                this.writeHTMLReply(ctx, 400, FProxyToadlet.l10n("invalidKeyTitle"), pageNode.generate());
                return;
            }
            fctx = this.getFetchContext(maxSize);
            maxSize = fctx.maxOutputLength;
            forceString = httprequest.getParam("force");
            now = System.currentTimeMillis();
            force = false;
            if (forceString != null && (forceString.equals(FProxyToadlet.getForceValue(key, now)) || forceString.equals(FProxyToadlet.getForceValue(key, now - FProxyToadlet.FORCE_GRAIN_INTERVAL)))) {
                force = true;
            }
            if (restricted) {
                maxRetries = -2;
            }
            if (maxRetries >= -1) {
                fctx.maxNonSplitfileRetries = maxRetries;
                fctx.maxSplitfileBlockRetries = maxRetries;
            }
            if (!force && !httprequest.isParameterSet("forcedownload")) {
                fctx.filterData = true;
            } else if (FProxyToadlet.logMINOR) {
                Logger.minor(this, "Content filter disabled via request parameter");
            }
            if (this.container.enableInlinePrefetch()) {
                fctx.prefetchHook = new FoundURICallback(){
                    List<FreenetURI> uris = new ArrayList<FreenetURI>();

                    @Override
                    public void foundURI(FreenetURI uri) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void foundURI(FreenetURI uri, boolean inline) {
                        if (!inline) {
                            return;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Prefetching " + uri);
                        }
                        2 var3_3 = this;
                        synchronized (var3_3) {
                            if (this.uris.size() < 50) {
                                this.uris.add(uri);
                            }
                        }
                    }

                    @Override
                    public void onText(String text, String type, URI baseURI) {
                    }

                    @Override
                    public void onFinishedPage() {
                        FProxyToadlet.this.core.node.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                for (FreenetURI uri : uris) {
                                    FProxyToadlet.this.client.prefetch(uri, TimeUnit.SECONDS.toMillis(60L), 524288L, prefetchAllowedTypes);
                                }
                            }
                        });
                    }
                };
            }
            if (this.container.isFProxyWebPushingEnabled()) {
                fctx.tagReplacer = new PushingTagReplacerCallback(this.core.getFProxy().fetchTracker, defaultMaxSize, ctx);
            }
            fctx.overrideMIME = requestedMimeType = httprequest.getParam("type", null);
            override = requestedMimeType == null ? "" : "?type=" + URLEncoder.encode(requestedMimeType, true);
            fctx.charset = maybeCharset = httprequest.isParameterSet("maybecharset") != false ? httprequest.getParam("maybecharset", null) : null;
            if (override.equals("") && maybeCharset != null) {
                override = "?maybecharset=" + URLEncoder.encode(maybeCharset, true);
            }
            if (httprequest.isParameterSet("forcedownload")) {
                override = override.length() == 0 ? "?forcedownload" : override + "&forcedownload";
            }
            data = null;
            mimeType = null;
            referer = this.sanitizeReferer(ctx);
            fe = null;
            fr = null;
            fetch = null;
            try {
                fetch = this.fetchTracker.makeFetcher(key, maxSize, fctx, ctx.getReFilterPolicy());
            }
            catch (FetchException e) {
                fe = e;
            }
            if (fetch != null) {
                while (true) {
                    if ((fr = fetch.getResult(canSendProgress == false)).hasData()) {
                        if (fr.getFetchCount() > 1 && !fr.hasWaited() && fr.getFetchCount() > 1 && key.isUSK() && this.context.uskManager.lookupKnownGood(USK.create(key)) > key.getSuggestedEdition()) {
                            Logger.normal(this, "Loading later edition...");
                            fetch.progress.requestImmediateCancel();
                            fr = null;
                            fetch = null;
                            try {
                                fetch = this.fetchTracker.makeFetcher(key, maxSize, fctx, ctx.getReFilterPolicy());
                            }
                            catch (FetchException e) {
                                fe = e;
                            }
                            if (fetch != null) continue;
                            break;
                        }
                        if (FProxyToadlet.logMINOR) {
                            Logger.minor(this, "Found data");
                        }
                        data = new NoFreeBucket(fr.data);
                        mimeType = fr.mimeType;
                        fetch.close();
                        break;
                    }
                    if (fr.failed != null) {
                        if (FProxyToadlet.logMINOR) {
                            Logger.minor(this, "Request failed");
                        }
                        fe = fr.failed;
                        fetch.close();
                        break;
                    }
                    if (canSendProgress) {
                        if (FProxyToadlet.logMINOR) {
                            Logger.minor(this, "Still in progress");
                        }
                        isJsEnabled = ctx.getContainer().isFProxyJavascriptEnabled() != false && ua != null && ua.contains("AppleWebKit/") == false;
                        isWebPushingEnabled = false;
                        page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("fetchingPageTitle"), ctx);
                        pageNode = page.outer;
                        location = this.getLink(key, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), maxRetries, overrideSize);
                        headNode = page.headNode;
                        if (isJsEnabled) {
                            headNode.addChild("noscript").addChild("meta", "http-equiv", "Refresh").addAttribute("content", "2;URL=" + location);
                            isWebPushingEnabled = ctx.getContainer().isFProxyWebPushingEnabled();
                            if (!isWebPushingEnabled) {
                                scriptNode = headNode.addChild("script", "//abc");
                                scriptNode.addAttribute("type", "text/javascript");
                                scriptNode.addAttribute("src", "/static/js/progresspage.js");
                            }
                        } else {
                            headNode.addChild("meta", "http-equiv", "Refresh").addAttribute("content", "2;URL=" + location);
                        }
                        contentNode = page.content;
                        infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("fetchingPageBox"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addAttribute("id", "infoContent");
                        infoboxContent.addChild(new ProgressInfoElement(this.fetchTracker, key, fctx, maxSize, ctx.isAdvancedModeEnabled(), ctx, isWebPushingEnabled));
                        table = infoboxContent.addChild("table", "border", "0");
                        progressCell = table.addChild("tr").addChild("td", "class", "request-progress");
                        if (fr.totalBlocks <= 0) {
                            progressCell.addChild("#", NodeL10n.getBase().getString("QueueToadlet.unknown"));
                        } else {
                            progressCell.addChild(new ProgressBarElement(this.fetchTracker, key, fctx, maxSize, ctx, isWebPushingEnabled));
                        }
                        infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("fetchingPageOptions"));
                        infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        optionList = infoboxContent.addChild("ul");
                        optionList.addChild("li").addChild("p", FProxyToadlet.l10n("progressOptionZero"));
                        FProxyToadlet.addDownloadOptions(ctx, optionList, key, mimeType, false, false, this.core);
                        optionList.addChild("li").addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                        optionList.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/", NodeL10n.getBase().getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                        retHeaders = new MultiValueTable<String, String>();
                        this.writeHTMLReply(ctx, 200, "OK", retHeaders, pageNode.generate());
                        fr.close();
                        fetch.close();
                        return;
                    }
                    if (fr == null) continue;
                    fr.close();
                }
            }
            try {
                if (FProxyToadlet.logMINOR) {
                    Logger.minor(this, "FProxy fetching " + key + " (" + maxSize + ')');
                }
                if (data == null && fe == null) {
                    needsFetch = true;
                    progress = this.fetchTracker.getFetchInProgress(key, maxSize, fctx);
                    if (progress != null) {
                        waiter = null;
                        result = null;
                        try {
                            waiter = progress.getWaiter();
                            result = waiter.getResult(false);
                            if (result.failed == null && result.data != null) {
                                mimeType = result.mimeType;
                                data = result.data;
                                data = ctx.getBucketFactory().makeBucket(result.data.size());
                                BucketTools.copy(result.data, data);
                                needsFetch = false;
                            }
                        }
                        finally {
                            if (waiter != null) {
                                progress.close(waiter);
                            }
                            if (result != null) {
                                progress.close(result);
                            }
                        }
                    }
                    if (needsFetch) {
                        result = this.fetch(key, maxSize, new RequestClientBuilder().realTime().build(), fctx);
                        data = result.asBucket();
                        mimeType = result.getMimeType();
                    }
                } else if (fe != null) {
                    throw fe;
                }
                this.handleDownload(ctx, data, ctx.getBucketFactory(), mimeType, requestedMimeType, forceString, httprequest.isParameterSet("forcedownload"), "/", key, "&max-size=" + maxSizeDownload, referer, true, ctx, this.core, fr != null, maybeCharset);
            }
            catch (FetchException e) {
                block108: {
                    msg = e.getMessage();
                    if (FProxyToadlet.logMINOR) {
                        Logger.minor(this, "Failed to fetch " + uri + " : " + e);
                    }
                    if (e.newURI == null) break block108;
                    if (accept == null || !accept.startsWith("text/css") && !accept.startsWith("image/") || recursion++ >= 5) ** GOTO lbl269
                    link = this.getLink(e.newURI, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), maxRetries, overrideSize);
                    try {
                        uri = new URI(link);
                        this.innerHandleMethodGET(uri, httprequest, ctx, recursion);
                        return;
                    }
                    catch (URISyntaxException e1) {
                        Logger.error(this, "Caught " + e1 + " parsing new link " + link, (Throwable)e1);
lbl269:
                        // 2 sources

                        Toadlet.writePermanentRedirect(ctx, msg, this.getLink(e.newURI, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), maxRetries, overrideSize));
                        break block107;
                    }
                }
                if (e.mode == FetchException.FetchExceptionMode.TOO_BIG) {
                    page = ctx.getPageMaker().getPageNode(FProxyToadlet.l10n("fileInformationTitle"), ctx);
                    pageNode = page.outer;
                    contentNode = page.content;
                    infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                    infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("largeFile"));
                    infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    fileInformationList = infoboxContent.addChild("ul");
                    option = fileInformationList.addChild("li");
                    option.addChild("#", FProxyToadlet.l10n("filenameLabel") + ' ');
                    option.addChild("a", "href", '/' + key.toString(), FProxyToadlet.getFilename(key, e.getExpectedMimeType()));
                    mime = FProxyToadlet.writeSizeAndMIME(fileInformationList, e);
                    infobox = contentNode.addChild("div", "class", "infobox infobox-information");
                    infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("explanationTitle"));
                    infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    infoboxContent.addChild("#", FProxyToadlet.l10n("largeFileExplanationAndOptions"));
                    optionList = infoboxContent.addChild("ul");
                    if (!restricted) {
                        option = optionList.addChild("li");
                        optionForm = option.addChild("form", new String[]{"action", "method"}, new String[]{'/' + key.toString(), "get"});
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "max-size", String.valueOf(e.expectedSize == -1L ? 0x7FFFFFFFFFFFFFFFL : e.expectedSize * 2L)});
                        if (requestedMimeType != null) {
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "type", requestedMimeType});
                        }
                        if (maxRetries >= -1) {
                            optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "max-retries", Integer.toString(maxRetries)});
                        }
                        optionForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "fetch", FProxyToadlet.l10n("fetchLargeFileAnywayAndDisplayButton")});
                        optionForm.addChild("#", " - " + FProxyToadlet.l10n("fetchLargeFileAnywayAndDisplay"));
                        FProxyToadlet.addDownloadOptions(ctx, optionList, key, mime, false, false, this.core);
                    }
                    optionList.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/", NodeL10n.getBase().getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                    optionList.addChild("li").addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                    this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                } else {
                    page = ctx.getPageMaker().getPageNode(e.getShortMessage(), ctx);
                    pageNode = page.outer;
                    contentNode = page.content;
                    infobox = contentNode.addChild("div", "class", "infobox infobox-error");
                    infobox.addChild("div", "class", "infobox-header", this.l10n("errorWithReason", "error", e.getShortMessage()));
                    infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    fileInformationList = infoboxContent.addChild("ul");
                    option = fileInformationList.addChild("li");
                    option.addChild("#", FProxyToadlet.l10n("filenameLabel") + ' ');
                    option.addChild("a", "href", '/' + key.toString(), FProxyToadlet.getFilename(key, e.getExpectedMimeType()));
                    mime = FProxyToadlet.writeSizeAndMIME(fileInformationList, e);
                    infobox = contentNode.addChild("div", "class", "infobox infobox-error");
                    infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("explanationTitle"));
                    filterException = null;
                    if (e.getCause() != null && e.getCause() instanceof UnsafeContentTypeException) {
                        filterException = (UnsafeContentTypeException)e.getCause();
                    }
                    infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    if (filterException == null) {
                        infoboxContent.addChild("p", FProxyToadlet.l10n("unableToRetrieve"));
                    } else {
                        infoboxContent.addChild("p", FProxyToadlet.l10n("unableToSafelyDisplay"));
                    }
                    if (e.isFatal() && filterException == null) {
                        infoboxContent.addChild("p", FProxyToadlet.l10n("errorIsFatal"));
                    }
                    infoboxContent.addChild("p", msg);
                    if (filterException != null && filterException.details() != null) {
                        detailList = infoboxContent.addChild("ul");
                        for (String detail : filterException.details()) {
                            detailList.addChild("li", detail);
                        }
                    }
                    if (e.errorCodes != null) {
                        infoboxContent.addChild("p").addChild("pre").addChild("#", e.errorCodes.toVerboseString());
                    }
                    infobox = contentNode.addChild("div", "class", "infobox infobox-error");
                    infobox.addChild("div", "class", "infobox-header", FProxyToadlet.l10n("options"));
                    infoboxContent = infobox.addChild("div", "class", "infobox-content");
                    optionList = infoboxContent.addChild("ul");
                    if (e.mode == FetchException.FetchExceptionMode.NOT_IN_ARCHIVE || e.mode == FetchException.FetchExceptionMode.NOT_ENOUGH_PATH_COMPONENTS) {
                        keyUtil = this.core.node.pluginManager.getPluginInfo("plugins.KeyUtils.KeyUtilsPlugin");
                        if (keyUtil != null) {
                            option = optionList.addChild("li");
                            if (keyUtil.getPluginLongVersion() < 5010L) {
                                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openWithKeyExplorer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/KeyUtils/?automf=true&key=" + key.toString())});
                            } else {
                                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openWithKeyExplorer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/KeyUtils/?key=" + key.toString())});
                                option = optionList.addChild("li");
                                NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openWithSiteExplorer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/KeyUtils/Site?key=" + key.toString())});
                            }
                        } else {
                            keyUtil = this.core.node.pluginManager.getPluginInfo("plugins.KeyExplorer.KeyExplorer");
                            if (keyUtil != null) {
                                option = optionList.addChild("li");
                                if (keyUtil.getPluginLongVersion() > 4999L) {
                                    NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openWithKeyExplorer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/KeyExplorer/?automf=true&key=" + key.toString())});
                                } else {
                                    NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openWithKeyExplorer", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/plugins/plugins.KeyExplorer.KeyExplorer/?key=" + key.toString())});
                                }
                            }
                        }
                    }
                    if (filterException != null) {
                        if (mime.equals("application/x-freenet-index") && this.core.node.pluginManager.isPluginLoaded("plugins.ThawIndexBrowser.ThawIndexBrowser")) {
                            option = optionList.addChild("li");
                            NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openAsThawIndex", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/plugins/plugins.ThawIndexBrowser.ThawIndexBrowser/?key=" + key.toString())});
                        }
                        option = optionList.addChild("li");
                        textMediaType = new MediaType("text/plain");
                        textMediaType.setParameter("charset", e.getExpectedMimeType() != null ? MediaType.getCharsetRobust(e.getExpectedMimeType()) : null);
                        NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openAsText", new String[]{"link"}, new HTMLNode[]{HTMLNode.link(this.getLink(key, textMediaType.toString(), maxSize, null, false, maxRetries, overrideSize))});
                        option = optionList.addChild("li");
                        NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openForceDisk", new String[]{"link"}, new HTMLNode[]{HTMLNode.link(this.getLink(key, mime, maxSize, null, true, maxRetries, overrideSize))});
                        if (!mime.equals("application/octet-stream") && !mime.equals("application/x-msdownload") && DefaultMIMETypes.isPlausibleMIMEType(mime)) {
                            option = optionList.addChild("li");
                            NodeL10n.getBase().addL10nSubstitution(option, "FProxyToadlet.openForce", new String[]{"link", "mime"}, new HTMLNode[]{HTMLNode.link(this.getLink(key, mime, maxSize, FProxyToadlet.getForceValue(key, now), false, maxRetries, overrideSize)), HTMLNode.text(HTMLEncoder.encode(mime))});
                        }
                    }
                    if (!(e.isFatal() && filterException == null || !ctx.isAllowedFullAccess() && this.container.publicGatewayMode())) {
                        FProxyToadlet.addDownloadOptions(ctx, optionList, key, mimeType, filterException != null, filterException != null, this.core);
                        if (filterException == null) {
                            optionList.addChild("li").addChild("a", "href", this.getLink(key, requestedMimeType, maxSize, httprequest.getParam("force", null), httprequest.isParameterSet("forcedownload"), maxRetries, overrideSize)).addChild("#", FProxyToadlet.l10n("retryNow"));
                        }
                    }
                    optionList.addChild("li").addChild("a", new String[]{"href", "title"}, new String[]{"/", NodeL10n.getBase().getString("Toadlet.homepage")}, FProxyToadlet.l10n("abortToHomepage"));
                    optionList.addChild("li").addChild(ctx.getPageMaker().createBackLink(ctx, FProxyToadlet.l10n("goBackToPrev")));
                    this.writeHTMLReply(ctx, e.mode == FetchException.FetchExceptionMode.NOT_IN_ARCHIVE ? 404 : 500, "Internal Error", pageNode.generate());
                }
            }
            catch (SocketException e) {
                if (e.getMessage().equals("Broken pipe")) {
                    if (FProxyToadlet.logMINOR) {
                        Logger.minor(this, "Caught " + e + " while handling GET", (Throwable)e);
                    }
                } else {
                    Logger.normal(this, "Caught " + e);
                }
                throw e;
            }
            catch (Throwable t) {
                this.writeInternalError(t, ctx);
            }
            finally {
                if (fr == null && data != null) {
                    data.free();
                }
                if (fr != null) {
                    fr.close();
                }
            }
        }
    }

    private boolean isBrowser(String ua) {
        if (ua == null) {
            return false;
        }
        return ua.contains("Mozilla/") || ua.contains("Opera/");
    }

    private static String writeSizeAndMIME(HTMLNode fileInformationList, FetchException e) {
        boolean finalized = e.finalizedSize();
        long size = e.expectedSize;
        String mime = e.getExpectedMimeType();
        FProxyToadlet.writeSizeAndMIME(fileInformationList, size, mime, finalized);
        return mime;
    }

    private static void writeSizeAndMIME(HTMLNode fileInformationList, long size, String mime, boolean finalized) {
        if (size > 0L) {
            if (finalized) {
                fileInformationList.addChild("li", FProxyToadlet.l10n("sizeLabel") + ' ' + SizeUtil.formatSize(size));
            } else {
                fileInformationList.addChild("li", FProxyToadlet.l10n("sizeLabel") + ' ' + SizeUtil.formatSize(size) + FProxyToadlet.l10n("mayChange"));
            }
        } else {
            fileInformationList.addChild("li", FProxyToadlet.l10n("sizeUnknown"));
        }
        if (mime != null) {
            fileInformationList.addChild("li", NodeL10n.getBase().getString("FProxyToadlet." + (finalized ? "mimeType" : "expectedMimeType"), new String[]{"mime"}, new String[]{mime}));
        } else {
            fileInformationList.addChild("li", FProxyToadlet.l10n("unknownMIMEType"));
        }
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("FProxyToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    public static String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("FProxyToadlet." + key, pattern, value);
    }

    private String getLink(FreenetURI uri, String requestedMimeType, long maxSize, String force, boolean forceDownload, int maxRetries, boolean appendMaxSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(uri.toASCIIString());
        int c = 63;
        if (requestedMimeType != null && requestedMimeType.length() != 0) {
            sb.append((char)c).append("type=").append(URLEncoder.encode(requestedMimeType, false));
            c = 38;
        }
        if (maxSize > 0L && appendMaxSize) {
            sb.append((char)c).append("max-size=").append(maxSize);
            c = 38;
        }
        if (force != null) {
            sb.append((char)c).append("force=").append(force);
            c = 38;
        }
        if (forceDownload) {
            sb.append((char)c).append("forcedownload=true");
            c = 38;
        }
        if (maxRetries >= -1) {
            sb.append((char)c).append("max-retries=").append(maxRetries);
            c = 38;
        }
        return sb.toString();
    }

    private String sanitizeReferer(ToadletContext ctx) {
        String referer = ctx.getHeaders().get("referer");
        if (referer != null) {
            try {
                URI refererURI = new URI(URIPreEncoder.encode(referer));
                String path = refererURI.getPath();
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ("".equals(path)) {
                    return "/";
                }
                FreenetURI furi = new FreenetURI(path);
                HTTPRequestImpl req = new HTTPRequestImpl(refererURI, "GET");
                String type = req.getParam("type");
                referer = "/" + furi.toString();
                if (type != null && type.length() > 0) {
                    referer = referer + "?type=" + type;
                }
            }
            catch (MalformedURLException e) {
                referer = "/";
                Logger.normal(this, "Caught MalformedURLException on the referer : " + e.getMessage());
            }
            catch (Throwable t) {
                Logger.error(this, "Caught handling referrer: " + t + " for " + referer, t);
                referer = null;
            }
        }
        return referer;
    }

    private static String getForceValue(FreenetURI key, long time) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(random);
            bos.write(key.toString().getBytes("UTF-8"));
            bos.write(Long.toString(time / FORCE_GRAIN_INTERVAL).getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new Error(e);
        }
        String f = HexUtil.bytesToHex(SHA256.digest(bos.toByteArray()));
        return f;
    }

    public static void maybeCreateFProxyEtc(NodeClientCore core, Node node, Config config, SimpleToadletServer server) throws IOException {
        HighLevelSimpleClient client = core.makeClient((short)1, true, true);
        random = new byte[32];
        core.random.nextBytes(random);
        FProxyFetchTracker fetchTracker = new FProxyFetchTracker(core.clientContext, client.getFetchContext(), new RequestClientBuilder().realTime().build());
        FProxyToadlet fproxy = new FProxyToadlet(client, core, fetchTracker);
        core.setFProxy(fproxy);
        server.registerMenu("/", "FProxyToadlet.categoryBrowsing", "FProxyToadlet.categoryTitleBrowsing", null);
        server.registerMenu("/downloads/", "FProxyToadlet.categoryQueue", "FProxyToadlet.categoryTitleQueue", null);
        server.registerMenu("/friends/", "FProxyToadlet.categoryFriends", "FProxyToadlet.categoryTitleFriends", null);
        server.registerMenu("/chat/", "FProxyToadlet.categoryChat", "FProxyToadlet.categoryTitleChat", null);
        server.registerMenu("/alerts/", "FProxyToadlet.categoryStatus", "FProxyToadlet.categoryTitleStatus", null);
        server.registerMenu("/seclevels/", "FProxyToadlet.categoryConfig", "FProxyToadlet.categoryTitleConfig", null);
        server.register(fproxy, "FProxyToadlet.categoryBrowsing", "/", false, "FProxyToadlet.welcomeTitle", "FProxyToadlet.welcome", false, null);
        DecodeToadlet decodeKeywordURL = new DecodeToadlet(client, core);
        server.register(decodeKeywordURL, null, "/decode/", true, false);
        InsertFreesiteToadlet siteinsert = new InsertFreesiteToadlet(client);
        server.register(siteinsert, "FProxyToadlet.categoryBrowsing", "/insertsite/", true, "FProxyToadlet.insertFreesiteTitle", "FProxyToadlet.insertFreesite", false, null);
        UserAlertsToadlet alerts = new UserAlertsToadlet(client);
        server.register(alerts, "FProxyToadlet.categoryStatus", "/alerts/", true, "FProxyToadlet.alertsTitle", "FProxyToadlet.alerts", true, null);
        QueueToadlet downloadToadlet = new QueueToadlet(core, core.getFCPServer(), client, false);
        server.register(downloadToadlet, "FProxyToadlet.categoryQueue", "/downloads/", true, "FProxyToadlet.downloadsTitle", "FProxyToadlet.downloads", false, downloadToadlet);
        LocalDownloadDirectoryToadlet localDownloadDirectoryToadlet = new LocalDownloadDirectoryToadlet(core, client, "/downloads/");
        server.register(localDownloadDirectoryToadlet, null, localDownloadDirectoryToadlet.path(), true, false);
        QueueToadlet uploadToadlet = new QueueToadlet(core, core.getFCPServer(), client, true);
        server.register(uploadToadlet, "FProxyToadlet.categoryQueue", "/uploads/", true, "FProxyToadlet.uploadsTitle", "FProxyToadlet.uploads", false, uploadToadlet);
        FileInsertWizardToadlet fiw = new FileInsertWizardToadlet(client, core);
        server.register(fiw, "FProxyToadlet.categoryQueue", "/insertfile/", true, "FProxyToadlet.uploadFileWizardTitle", "FProxyToadlet.uploadFileWizard", false, fiw);
        uploadToadlet.setFIW(fiw);
        LocalFileInsertToadlet localFileInsertToadlet = new LocalFileInsertToadlet(core, client);
        server.register(localFileInsertToadlet, null, "/insert-browse/", true, false);
        ContentFilterToadlet contentFilterToadlet = new ContentFilterToadlet(client, core);
        server.register(contentFilterToadlet, "FProxyToadlet.categoryQueue", "/filterfile/", true, "FProxyToadlet.filterFileTitle", "FProxyToadlet.filterFile", false, contentFilterToadlet);
        LocalFileFilterToadlet localFileFilterToadlet = new LocalFileFilterToadlet(core, client);
        server.register(localFileFilterToadlet, null, "/filter-browse/", true, false);
        SymlinkerToadlet symlinkToadlet = new SymlinkerToadlet(client, node);
        server.register(symlinkToadlet, null, "/sl/", true, false);
        SecurityLevelsToadlet seclevels = new SecurityLevelsToadlet(client, node, core);
        server.register(seclevels, "FProxyToadlet.categoryConfig", "/seclevels/", true, "FProxyToadlet.seclevelsTitle", "FProxyToadlet.seclevels", true, null);
        if (node.pluginManager.isEnabled()) {
            PproxyToadlet pproxy = new PproxyToadlet(client, node);
            server.register(pproxy, "FProxyToadlet.categoryConfig", "/plugins/", true, "FProxyToadlet.pluginsTitle", "FProxyToadlet.plugins", true, null);
        }
        Object[] sc = config.getConfigs();
        Arrays.sort(sc);
        for (Object cfg : sc) {
            String prefix = ((SubConfig)cfg).getPrefix();
            if (prefix.equals("security-levels") || prefix.equals("pluginmanager")) continue;
            LocalDirectoryConfigToadlet localDirectoryConfigToadlet = new LocalDirectoryConfigToadlet(core, client, "/config/" + prefix);
            ConfigToadlet configtoadlet = new ConfigToadlet(localDirectoryConfigToadlet.path(), client, config, (SubConfig)cfg, node, core);
            server.register(configtoadlet, "FProxyToadlet.categoryConfig", "/config/" + prefix, true, "ConfigToadlet." + prefix, "ConfigToadlet.title." + prefix, true, configtoadlet);
            server.register(localDirectoryConfigToadlet, null, localDirectoryConfigToadlet.path(), true, false);
        }
        WelcomeToadlet welcometoadlet = new WelcomeToadlet(client, node);
        server.register(welcometoadlet, null, "/welcome/", true, false);
        ExternalLinkToadlet externalLinkToadlet = new ExternalLinkToadlet(client, node);
        server.register(externalLinkToadlet, null, "/external-link/", true, false);
        DarknetConnectionsToadlet friendsToadlet = new DarknetConnectionsToadlet(node, core, client);
        server.register(friendsToadlet, "FProxyToadlet.categoryFriends", "/friends/", true, "FProxyToadlet.friendsTitle", "FProxyToadlet.friends", true, null);
        DarknetAddRefToadlet addRefToadlet = new DarknetAddRefToadlet(node, client, friendsToadlet);
        server.register(addRefToadlet, "FProxyToadlet.categoryFriends", "/addfriend/", true, "FProxyToadlet.addFriendTitle", "FProxyToadlet.addFriend", true, null);
        OpennetConnectionsToadlet opennetToadlet = new OpennetConnectionsToadlet(node, core, client);
        server.register(opennetToadlet, "FProxyToadlet.categoryStatus", "/strangers/", true, "FProxyToadlet.opennetTitle", "FProxyToadlet.opennet", true, opennetToadlet);
        ChatForumsToadlet chatForumsToadlet = new ChatForumsToadlet(client, node.pluginManager);
        server.register(chatForumsToadlet, "FProxyToadlet.categoryChat", "/chat/", true, "FProxyToadlet.chatForumsTitle", "FProxyToadlet.chatForums", true, chatForumsToadlet);
        N2NTMToadlet n2ntmToadlet = new N2NTMToadlet(node, core, client);
        server.register(n2ntmToadlet, null, "/send_n2ntm/", true, true);
        LocalFileN2NMToadlet localFileN2NMToadlet = new LocalFileN2NMToadlet(core, client);
        server.register(localFileN2NMToadlet, null, "/n2nm-browse/", true, false);
        BookmarkEditorToadlet bookmarkEditorToadlet = new BookmarkEditorToadlet(client, core);
        server.register(bookmarkEditorToadlet, null, "/bookmarkEditor/", true, false);
        BrowserTestToadlet browserTestToadlet = new BrowserTestToadlet(client, core);
        server.register(browserTestToadlet, null, "/test/", true, false);
        StatisticsToadlet statisticsToadlet = new StatisticsToadlet(node, core, client);
        server.register(statisticsToadlet, "FProxyToadlet.categoryStatus", "/stats/", true, "FProxyToadlet.statsTitle", "FProxyToadlet.stats", true, null);
        DiagnosticToadlet diagnosticToadlet = new DiagnosticToadlet(node, core, core.getFCPServer(), client);
        server.register(diagnosticToadlet, "FProxyToadlet.categoryStatus", "/diagnostic/", true, "FProxyToadlet.diagnosticTitle", "FProxyToadlet.diagnostic", true, null);
        ConnectivityToadlet connectivityToadlet = new ConnectivityToadlet(client, node);
        server.register(connectivityToadlet, "FProxyToadlet.categoryStatus", "/connectivity/", true, "ConnectivityToadlet.connectivityTitle", "ConnectivityToadlet.connectivity", true, null);
        TranslationToadlet translationToadlet = new TranslationToadlet(client, core);
        server.register(translationToadlet, "FProxyToadlet.categoryConfig", "/translation/", true, "TranslationToadlet.title", "TranslationToadlet.titleLong", true, null);
        FirstTimeWizardToadlet firstTimeWizardToadlet = new FirstTimeWizardToadlet(client, node, core);
        server.register(firstTimeWizardToadlet, null, "/wizard/", true, false);
        SimpleHelpToadlet simpleHelpToadlet = new SimpleHelpToadlet(client, core);
        server.register(simpleHelpToadlet, null, "/help/", true, false);
        PushDataToadlet pushDataToadlet = new PushDataToadlet(client);
        server.register(pushDataToadlet, null, pushDataToadlet.path(), true, false);
        PushNotificationToadlet pushNotificationToadlet = new PushNotificationToadlet(client);
        server.register(pushNotificationToadlet, null, pushNotificationToadlet.path(), true, false);
        PushKeepaliveToadlet pushKeepaliveToadlet = new PushKeepaliveToadlet(client);
        server.register(pushKeepaliveToadlet, null, pushKeepaliveToadlet.path(), true, false);
        PushFailoverToadlet pushFailoverToadlet = new PushFailoverToadlet(client);
        server.register(pushFailoverToadlet, null, pushFailoverToadlet.path(), true, false);
        PushTesterToadlet pushTesterToadlet = new PushTesterToadlet(client);
        server.register(pushTesterToadlet, null, pushTesterToadlet.path(), true, false);
        PushLeavingToadlet pushLeavingToadlet = new PushLeavingToadlet(client);
        server.register(pushLeavingToadlet, null, pushLeavingToadlet.path(), true, false);
        ImageCreatorToadlet imageCreatorToadlet = new ImageCreatorToadlet(client);
        server.register(imageCreatorToadlet, null, imageCreatorToadlet.path(), true, false);
        LogWritebackToadlet logWritebackToadlet = new LogWritebackToadlet(client);
        server.register(logWritebackToadlet, null, logWritebackToadlet.path(), true, false);
        DismissAlertToadlet dismissAlertToadlet = new DismissAlertToadlet(client);
        server.register(dismissAlertToadlet, null, dismissAlertToadlet.path(), true, false);
    }

    private static String getFilename(FreenetURI uri, String expectedMimeType) {
        return DefaultMIMETypes.forceExtension(uri.getPreferredFilename(), expectedMimeType);
    }

    private static long[] parseRange(String hdrrange) throws HTTPRangeException {
        long[] result = new long[2];
        try {
            String[] units = hdrrange.split("=", 2);
            if (!"bytes".equals(units[0])) {
                throw new HTTPRangeException("Unknown unit, only 'bytes' supportet yet");
            }
            String[] range = units[1].split("-", 2);
            result[0] = Long.parseLong(range[0]);
            if (result[0] < 0L) {
                throw new HTTPRangeException("Negative 'from' value");
            }
            if (range[1].trim().length() > 0) {
                result[1] = Long.parseLong(range[1]);
                if (result[1] <= result[0]) {
                    throw new HTTPRangeException("'from' value must be less then 'to' value");
                }
            } else {
                result[1] = -1L;
            }
        }
        catch (NumberFormatException nfe) {
            throw new HTTPRangeException(nfe);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new HTTPRangeException(ioobe);
        }
        return result;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public String path() {
        return "/";
    }

    @Override
    public boolean realTimeFlag() {
        return true;
    }

    static {
        prefetchAllowedTypes = new HashSet<String>();
        prefetchAllowedTypes.add("image/png");
        prefetchAllowedTypes.add("image/jpeg");
        prefetchAllowedTypes.add("image/gif");
        FORCE_GRAIN_INTERVAL = TimeUnit.HOURS.toMillis(1L);
        MAX_LENGTH_WITH_PROGRESS = 0x3700000L;
        MAX_LENGTH_NO_PROGRESS = 0x233333L;
        try {
            welcome = new URI("/welcome/");
        }
        catch (URISyntaxException e) {
            throw new Error("Broken URI constructor: " + e, e);
        }
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        DOWNLOADS_LINK = QueueToadlet.DOWNLOADS_LINK;
    }
}

