/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.HTMLEntities;
import java.util.HashMap;
import java.util.Map;

public class HTMLEncoder {
    public static final CharTable charTable = new CharTable(HTMLEntities.encodeMap);

    public static String encode(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        HTMLEncoder.encodeToBuffer(n, s, sb);
        return sb.toString();
    }

    public static void encodeToBuffer(String s, StringBuilder sb) {
        HTMLEncoder.encodeToBuffer(s.length(), s, sb);
    }

    private static void encodeToBuffer(int n, String s, StringBuilder sb) {
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            String entity = charTable.get(c);
            if (entity != null) {
                sb.append('&');
                sb.append(entity);
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
    }

    public static String encodeXML(String s) {
        s = s.replace("&", "&#38;");
        s = s.replace("\"", "&#34;");
        s = s.replace("'", "&#39;");
        s = s.replace("<", "&#60;");
        s = s.replace(">", "&#62;");
        return s;
    }

    private static final class CharTable {
        private char[] chars;
        private String[] strings;
        private int modulo = 0;

        public CharTable(HashMap<Character, String> map) {
            int[] keys = new int[map.size()];
            int keyIndex = 0;
            char max = '\u0000';
            for (Character key : map.keySet()) {
                char val = key.charValue();
                keys[keyIndex++] = val;
                if (val <= max) continue;
                max = val;
            }
            this.modulo = map.size();
            int[] collisionTable = new int[max + 1];
            boolean ok = false;
            while (!ok) {
                ++this.modulo;
                ok = true;
                for (int i = 0; ok && i < keys.length; ++i) {
                    keyIndex = keys[i] % this.modulo;
                    if (collisionTable[keyIndex] == this.modulo) {
                        ok = false;
                        continue;
                    }
                    collisionTable[keyIndex] = this.modulo;
                }
            }
            this.chars = new char[this.modulo];
            this.strings = new String[this.modulo];
            for (Map.Entry<Character, String> entry : map.entrySet()) {
                Character character = entry.getKey();
                keyIndex = character.charValue() % this.modulo;
                this.chars[keyIndex] = character.charValue();
                this.strings[keyIndex] = entry.getValue();
            }
            if (this.chars[0] == '\u0000' && this.strings[0] != null) {
                this.chars[0] = '\u0001';
            }
        }

        public String get(char key) {
            return this.chars[key % this.modulo] == key ? this.strings[key % this.modulo] : null;
        }
    }
}

