/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveManager;
import freenet.client.ArchiveRestartException;
import freenet.client.ArchiveStoreContext;
import freenet.client.FetchException;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import java.io.Serializable;

class ArchiveHandlerImpl
implements ArchiveHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private final FreenetURI key;
    private boolean forceRefetchArchive;
    ArchiveManager.ARCHIVE_TYPE archiveType;
    Compressor.COMPRESSOR_TYPE compressorType;

    ArchiveHandlerImpl(FreenetURI key, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE ctype, boolean forceRefetchArchive) {
        this.key = key;
        this.archiveType = archiveType;
        this.compressorType = ctype;
        this.forceRefetchArchive = forceRefetchArchive;
    }

    @Override
    public Bucket get(String internalName, ArchiveContext archiveContext, ArchiveManager manager) throws ArchiveFailureException, ArchiveRestartException, MetadataParseException, FetchException {
        Bucket data;
        if (this.forceRefetchArchive) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Checking cache: " + this.key + ' ' + internalName);
        }
        if ((data = manager.getCached(this.key, internalName)) != null) {
            return data;
        }
        return null;
    }

    @Override
    public Bucket getMetadata(ArchiveContext archiveContext, ArchiveManager manager) throws ArchiveFailureException, ArchiveRestartException, MetadataParseException, FetchException {
        return this.get(".metadata", archiveContext, manager);
    }

    @Override
    public void extractToCache(Bucket bucket, ArchiveContext actx, String element, ArchiveExtractCallback callback, ArchiveManager manager, ClientContext context) throws ArchiveFailureException, ArchiveRestartException {
        this.forceRefetchArchive = false;
        ArchiveStoreContext ctx = manager.makeContext(this.key, this.archiveType, this.compressorType, false);
        manager.extractToCache(this.key, this.archiveType, this.compressorType, bucket, actx, ctx, element, callback, context);
    }

    @Override
    public ArchiveManager.ARCHIVE_TYPE getArchiveType() {
        return this.archiveType;
    }

    public Compressor.COMPRESSOR_TYPE getCompressorType() {
        return this.compressorType;
    }

    @Override
    public FreenetURI getKey() {
        return this.key;
    }

    @Override
    public ArchiveHandler cloneHandler() {
        return new ArchiveHandlerImpl(this.key, this.archiveType, this.compressorType, this.forceRefetchArchive);
    }

    static {
        Logger.registerClass(ArchiveHandlerImpl.class);
    }
}

