/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveManager;
import freenet.client.ArchiveStoreItem;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.LinkedList;

class ArchiveStoreContext {
    private FreenetURI key;
    private final ArchiveManager.ARCHIVE_TYPE archiveType;
    private long lastSize = -1L;
    private byte[] lastHash;
    private final LinkedList<ArchiveStoreItem> myItems;
    private static volatile boolean logMINOR;

    ArchiveStoreContext(FreenetURI key, ArchiveManager.ARCHIVE_TYPE archiveType) {
        this.key = key;
        this.archiveType = archiveType;
        this.myItems = new LinkedList();
    }

    long getLastSize() {
        return this.lastSize;
    }

    void setLastSize(long size) {
        this.lastSize = size;
    }

    byte[] getLastHash() {
        return this.lastHash;
    }

    void setLastHash(byte[] realHash) {
        this.lastHash = realHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCachedItems(ArchiveManager manager) {
        ArchiveStoreItem item = null;
        while (true) {
            LinkedList<ArchiveStoreItem> linkedList = this.myItems;
            synchronized (linkedList) {
                item = this.myItems.peek();
            }
            if (item == null) break;
            manager.removeCachedItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItem(ArchiveStoreItem item) {
        LinkedList<ArchiveStoreItem> linkedList = this.myItems;
        synchronized (linkedList) {
            this.myItems.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(ArchiveStoreItem item) {
        LinkedList<ArchiveStoreItem> linkedList = this.myItems;
        synchronized (linkedList) {
            if (!this.myItems.remove(item)) {
                if (logMINOR) {
                    Logger.minor(this, "Not removing: " + item + " for " + this + " - already removed");
                }
                return;
            }
        }
        item.innerClose();
    }

    public short getArchiveType() {
        return this.archiveType.metadataID;
    }

    public FreenetURI getKey() {
        return this.key;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

