/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.support.Logger;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class CompatibilityAnalyser
implements Serializable {
    private static final long serialVersionUID = 1L;
    InsertContext.CompatibilityMode min;
    InsertContext.CompatibilityMode max;
    byte[] cryptoKey;
    boolean dontCompress;
    boolean definitive;
    static final int VERSION = 2;

    public CompatibilityAnalyser() {
        this.min = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        this.max = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        this.dontCompress = true;
    }

    public void merge(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] cryptoKey, boolean dontCompress, boolean definitive) {
        if (this.definitive) {
            Logger.warning(this, "merge() after definitive", (Throwable)new Exception("debug"));
            return;
        }
        assert (min != InsertContext.CompatibilityMode.COMPAT_CURRENT);
        assert (max != InsertContext.CompatibilityMode.COMPAT_CURRENT);
        if (definitive) {
            this.definitive = true;
        }
        if (!dontCompress) {
            this.dontCompress = false;
        }
        if (min.ordinal() > this.min.ordinal()) {
            this.min = min;
        }
        if (max.ordinal() < this.max.ordinal() || this.max == InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
            this.max = max;
        }
        if (this.cryptoKey == null) {
            this.cryptoKey = cryptoKey;
        } else if (cryptoKey != null && !Arrays.equals(this.cryptoKey, cryptoKey)) {
            Logger.error(this, "Two different crypto keys!");
            this.cryptoKey = null;
        }
    }

    public InsertContext.CompatibilityMode min() {
        return this.min;
    }

    public InsertContext.CompatibilityMode max() {
        return this.max;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public boolean dontCompress() {
        return this.dontCompress;
    }

    public boolean definitive() {
        return this.definitive;
    }

    public InsertContext.CompatibilityMode[] getModes() {
        return new InsertContext.CompatibilityMode[]{this.min(), this.max()};
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(2);
        dos.writeShort(this.min.code);
        dos.writeShort(this.max.code);
        if (this.cryptoKey == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            assert (this.cryptoKey.length == 32);
            dos.write(this.cryptoKey);
        }
        dos.writeBoolean(this.dontCompress);
        dos.writeBoolean(this.definitive);
    }

    public CompatibilityAnalyser(DataInputStream dis) throws IOException, StorageFormatException {
        int ver = dis.readInt();
        if (ver != 2) {
            throw new StorageFormatException("Unknown version for CompatibilityAnalyser");
        }
        try {
            this.min = InsertContext.CompatibilityMode.byCode(dis.readShort());
            this.max = InsertContext.CompatibilityMode.byCode(dis.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad min value");
        }
        if (dis.readBoolean()) {
            this.cryptoKey = new byte[32];
            dis.readFully(this.cryptoKey);
        }
        this.dontCompress = dis.readBoolean();
        this.definitive = dis.readBoolean();
    }
}

