/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.ManifestElement;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.ResumeFailedException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class ContainerInserter
implements ClientPutState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private ArrayList<ContainerElement> containerItems;
    private final BaseClientPutter parent;
    private final PutCompletionCallback cb;
    private boolean cancelled;
    private boolean finished;
    private final boolean persistent;
    private final HashMap<String, Object> origMetadata;
    private final ArchiveManager.ARCHIVE_TYPE archiveType;
    private final FreenetURI targetURI;
    private final Object token;
    private final InsertContext ctx;
    private final boolean reportMetadataOnly;
    private final boolean dontCompress;
    final byte[] forceCryptoKey;
    final byte cryptoAlgorithm;
    private final boolean realTimeFlag;
    private final int hashCode;
    private transient boolean resumed = false;

    public ContainerInserter(BaseClientPutter parent2, PutCompletionCallback cb2, HashMap<String, Object> metadata2, FreenetURI targetURI2, InsertContext ctx2, boolean dontCompress2, boolean reportMetadataOnly2, Object token2, ArchiveManager.ARCHIVE_TYPE archiveType2, boolean freeData, byte[] forceCryptoKey, byte cryptoAlgorithm, boolean realTimeFlag) {
        this.parent = parent2;
        this.cb = cb2;
        this.hashCode = super.hashCode();
        this.persistent = this.parent.persistent();
        this.origMetadata = metadata2;
        this.archiveType = archiveType2;
        this.targetURI = targetURI2;
        this.token = token2;
        this.ctx = ctx2;
        this.dontCompress = dontCompress2;
        this.reportMetadataOnly = reportMetadataOnly2;
        this.containerItems = new ArrayList();
        this.forceCryptoKey = forceCryptoKey;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.realTimeFlag = realTimeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), this, context);
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    @Override
    public void schedule(ClientContext context) throws InsertException {
        this.start(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ClientContext context) {
        InsertBlock block;
        if (logDEBUG) {
            Logger.debug(this, "Atempt to start a container inserter", (Throwable)new Exception("debug"));
        }
        this.makeMetadata(context);
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.finished) {
                return;
            }
        }
        BufferedOutputStream os = null;
        try {
            RandomAccessBucket outputBucket = context.getBucketFactory(this.persistent).makeBucket(-1L);
            os = new BufferedOutputStream(outputBucket.getOutputStream());
            String mimeType = this.archiveType == ArchiveManager.ARCHIVE_TYPE.TAR ? this.createTarBucket(os) : this.createZipBucket(os);
            os = null;
            if (logMINOR) {
                Logger.minor(this, "Archive size is " + outputBucket.size());
            }
            if (logMINOR) {
                Logger.minor(this, "We are using " + (Object)((Object)this.archiveType));
            }
            block = new InsertBlock(outputBucket, new ClientMetadata(mimeType), this.targetURI);
        }
        catch (IOException e) {
            try {
                this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null), context);
            }
            catch (Throwable throwable) {
                Closer.close(os);
                throw throwable;
            }
            Closer.close(os);
            return;
        }
        Closer.close(os);
        boolean dc = this.dontCompress;
        if (!this.dontCompress) {
            dc = this.archiveType == ArchiveManager.ARCHIVE_TYPE.ZIP;
        }
        SingleFileInserter sfi = new SingleFileInserter(this.parent, this.cb, block, false, this.ctx, this.realTimeFlag, dc, this.reportMetadataOnly, this.token, this.archiveType, true, null, true, this.persistent, 0L, 0L, null, this.cryptoAlgorithm, this.forceCryptoKey, -1L);
        if (logMINOR) {
            Logger.minor(this, "Inserting container: " + sfi + " for " + this);
        }
        this.cb.onTransition(this, sfi, context);
        try {
            sfi.schedule(context);
        }
        catch (InsertException e) {
            this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null), context);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void makeMetadata(ClientContext context) {
        bucket = null;
        x = 0;
        md = this.makeManifest(this.origMetadata, "");
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                bucket = md.toBucket(context.getBucketFactory(this.persistent));
                this.containerItems.add(new ContainerElement(bucket, ".metadata"));
                return;
            }
            catch (MetadataUnresolvedException e) {
                try {
                    x = this.resolve(e, x, null, null, context);
                    continue;
                }
                catch (IOException e1) {
                    this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null), context);
                    return;
                }
            }
            ** while (true)
            catch (IOException e) {
                this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null), context);
                return;
            }
            break;
        }
    }

    private int resolve(MetadataUnresolvedException e, int x, FreenetURI key, String element2, ClientContext context) throws IOException {
        Metadata[] metas;
        for (Metadata m : metas = e.mustResolve) {
            try {
                RandomAccessBucket bucket = m.toBucket(context.getBucketFactory(this.persistent));
                String nameInArchive = ".metadata-" + x++;
                this.containerItems.add(new ContainerElement(bucket, nameInArchive));
                m.resolve(nameInArchive);
            }
            catch (MetadataUnresolvedException e1) {
                x = this.resolve(e, x, key, element2, context);
            }
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ClientContext context) {
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        this.cb.onFailure(e, this, context);
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTarBucket(OutputStream os) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Create a TAR Bucket");
        }
        try (TarArchiveOutputStream tarOS = new TarArchiveOutputStream(os);){
            tarOS.setLongFileMode(2);
            for (ContainerElement ph : this.containerItems) {
                if (logMINOR) {
                    Logger.minor(this, "Putting into tar: " + ph + " data length " + ph.data.size() + " name " + ph.targetInArchive);
                }
                TarArchiveEntry ze = new TarArchiveEntry(ph.targetInArchive);
                ze.setModTime(0L);
                long size = ph.data.size();
                ze.setSize(size);
                tarOS.putArchiveEntry((ArchiveEntry)ze);
                BucketTools.copyTo(ph.data, (OutputStream)tarOS, size);
                tarOS.closeArchiveEntry();
            }
        }
        return ArchiveManager.ARCHIVE_TYPE.TAR.mimeTypes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createZipBucket(OutputStream os) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Create a ZIP Bucket");
        }
        try (ZipOutputStream zos = new ZipOutputStream(os);){
            for (ContainerElement ph : this.containerItems) {
                ZipEntry ze = new ZipEntry(ph.targetInArchive);
                ze.setTime(0L);
                zos.putNextEntry(ze);
                BucketTools.copyTo(ph.data, zos, ph.data.size());
                zos.closeEntry();
            }
        }
        return ArchiveManager.ARCHIVE_TYPE.ZIP.mimeTypes[0];
    }

    private Metadata makeManifest(HashMap<String, Object> manifestElements, String archivePrefix) {
        Metadata.SimpleManifestComposer smc = new Metadata.SimpleManifestComposer();
        for (Map.Entry<String, Object> me : manifestElements.entrySet()) {
            Metadata m;
            String name = me.getKey();
            Object o = me.getValue();
            if (o instanceof HashMap) {
                HashMap hm = (HashMap)o;
                HashMap subMap = new HashMap();
                smc.addItem(name, this.makeManifest(hm, archivePrefix + name + '/'));
                if (!logDEBUG) continue;
                Logger.debug(this, "Sub map for " + name + " : " + subMap.size() + " elements from " + hm.size());
                continue;
            }
            if (o instanceof Metadata) {
                smc.addItem(name, (Metadata)o);
                continue;
            }
            ManifestElement element = (ManifestElement)o;
            String mimeType = element.getMimeType();
            ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
            if (element.targetURI != null) {
                m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, element.targetURI, cm);
            } else {
                this.containerItems.add(new ContainerElement(element.getData(), archivePrefix + name));
                m = new Metadata(Metadata.DocumentType.ARCHIVE_INTERNAL_REDIRECT, null, null, archivePrefix + element.fullName, cm);
            }
            smc.addItem(name, m);
        }
        return smc.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        ContainerInserter containerInserter = this;
        synchronized (containerInserter) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        if (this.cb != null && this.cb != this.parent) {
            this.cb.onResume(context);
        }
        if (this.containerItems != null) {
            for (ContainerElement e : this.containerItems) {
                if (e.data == null) continue;
                e.data.onResume(context);
            }
        }
        ContainerInserter.resumeMetadata(this.origMetadata, context);
    }

    public static void resumeMetadata(Map<String, Object> map, ClientContext context) throws ResumeFailedException {
        Map<String, Object> manifestElements = map;
        for (Object o : manifestElements.values()) {
            if (o instanceof HashMap) {
                ContainerInserter.resumeMetadata((Map)o, context);
                continue;
            }
            if (o instanceof ManifestElement) {
                ManifestElement e = (ManifestElement)o;
                e.onResume(context);
                continue;
            }
            if (o instanceof Metadata) continue;
            if (o instanceof BaseManifestPutter.PutHandler) {
                BaseManifestPutter.PutHandler handler = (BaseManifestPutter.PutHandler)o;
                handler.onResume(context);
                continue;
            }
            if (o instanceof ManifestElement) {
                ((ManifestElement)o).onResume(context);
                continue;
            }
            throw new IllegalArgumentException("Unknown manifest element: " + o);
        }
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    static {
        Logger.registerClass(ContainerInserter.class);
    }

    private static class ContainerElement {
        private final Bucket data;
        private final String targetInArchive;

        private ContainerElement(Bucket data2, String targetInArchive2) {
            this.data = data2;
            this.targetInArchive = targetInArchive2;
        }
    }
}

