/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableUSK;
import freenet.keys.USK;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class USKDateHint {
    private GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.US);
    static final String PREFIX = "-DATEHINT-";

    private USKDateHint() {
    }

    public static USKDateHint now() {
        return new USKDateHint();
    }

    public String get(Type t) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.cal.get(1));
        if (t == Type.YEAR) {
            return sb.toString();
        }
        if (t == Type.WEEK) {
            sb.append("-WEEK-");
            sb.append(this.cal.get(3));
            return sb.toString();
        }
        sb.append("-");
        sb.append(this.cal.get(2));
        if (t == Type.MONTH) {
            return sb.toString();
        }
        sb.append("-");
        sb.append(this.cal.get(5));
        return sb.toString();
    }

    public String getData(long edition) {
        return "HINT\n" + Long.toString(edition) + "\n" + this.get(Type.DAY) + "\n";
    }

    public FreenetURI[] getInsertURIs(InsertableUSK key) {
        FreenetURI[] uris = new FreenetURI[Type.values.length];
        int x = 0;
        for (Type t : Type.values) {
            uris[x++] = key.getInsertableSSK(key.siteName + PREFIX + this.get(t)).getInsertURI();
        }
        return uris;
    }

    public ClientSSK[] getRequestURIs(USK key) {
        ClientSSK[] uris = new ClientSSK[Type.values.length];
        int x = 0;
        for (Type t : Type.values) {
            uris[x++] = key.getSSK(key.siteName + PREFIX + this.get(t));
        }
        return uris;
    }

    public static enum Type {
        YEAR,
        MONTH,
        DAY,
        WEEK;

        private static final Type[] values;

        public boolean alwaysMorePreciseThan(Type type) {
            if (this.equals((Object)type)) {
                return false;
            }
            if (this.equals((Object)DAY)) {
                return true;
            }
            if (this.equals((Object)MONTH)) {
                return type.equals((Object)YEAR);
            }
            if (this.equals((Object)WEEK)) {
                return type.equals((Object)YEAR);
            }
            return false;
        }

        static {
            values = Type.values();
        }
    }
}

