/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.DataFilterException;
import freenet.client.filter.OggPage;
import freenet.client.filter.TheoraBitstreamFilter;
import freenet.client.filter.TheoraPacketFilter;
import freenet.client.filter.VorbisBitstreamFilter;
import freenet.client.filter.VorbisPacketFilter;
import freenet.l10n.NodeL10n;
import java.io.IOException;

public class OggBitstreamFilter {
    long lastPageSequenceNumber;
    final int serialNumber;
    boolean isValidStream = true;

    protected OggBitstreamFilter(OggPage page) {
        this.serialNumber = page.getSerial();
        this.lastPageSequenceNumber = page.getPageNumber();
    }

    OggPage parse(OggPage page) throws IOException {
        if ((long)page.getPageNumber() != this.lastPageSequenceNumber + 1L && (long)page.getPageNumber() != this.lastPageSequenceNumber) {
            this.isValidStream = false;
            throw new DataFilterException(this.l10n("MalformedTitle"), this.l10n("MalformedTitle"), this.l10n("MalformedMessage"));
        }
        this.lastPageSequenceNumber = page.getPageNumber();
        return page;
    }

    public static OggBitstreamFilter getBitstreamFilter(OggPage page) {
        int i;
        for (i = 0; i <= VorbisPacketFilter.magicNumber.length; ++i) {
            if (i == VorbisPacketFilter.magicNumber.length) {
                return new VorbisBitstreamFilter(page);
            }
            if (page.payload[i + 1] != VorbisPacketFilter.magicNumber[i]) break;
        }
        for (i = 0; i <= TheoraPacketFilter.magicNumber.length; ++i) {
            if (i == TheoraPacketFilter.magicNumber.length) {
                return new TheoraBitstreamFilter(page);
            }
            if (page.payload[i + 1] != TheoraPacketFilter.magicNumber[i]) break;
        }
        return null;
    }

    protected void invalidate() throws DataFilterException {
        this.isValidStream = false;
        throw new DataFilterException(this.l10n("MalformedTitle"), this.l10n("MalformedTitle"), this.l10n("MalformedMessage"));
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString(this.getClass().getSimpleName() + "." + key);
    }
}

