/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.ContainerInserter;
import freenet.client.async.DefaultManifestPutter;
import freenet.client.async.ManifestPutter;
import freenet.client.async.TooManyFilesInsertException;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientPutDirMessage;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.PersistentPutDir;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.RequestIdentifier;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.RequestStatusCache;
import freenet.clients.fcp.SimpleProgressMessage;
import freenet.clients.fcp.UploadDirRequestStatus;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.support.CurrentTimeUTC;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.ManifestElement;
import freenet.support.io.FileBucket;
import freenet.support.io.ResumeFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;

public class ClientPutDir
extends ClientPutBase {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Object> manifestElements;
    private ManifestPutter putter;
    private final String defaultName;
    private final long totalSize;
    private final int numberOfFiles;
    private final boolean wasDiskPut;
    private static volatile boolean logMINOR;
    private final byte[] overrideSplitfileCryptoKey;

    public ClientPutDir(FCPConnectionHandler handler, ClientPutDirMessage message, HashMap<String, Object> manifestElements, boolean wasDiskPut, FCPServer server) throws IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(message.uri, message.targetFilename != null ? message.targetFilename : "site", server.core.clientContext), message.identifier, message.verbosity, null, handler, message.priorityClass, message.persistence, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.localRequestOnly, message.maxRetries, message.earlyEncode, message.canWriteClientCache, message.forkOnCacheable, message.compressorDescriptor, message.extraInsertsSingleBlock, message.extraInsertsSplitfileHeaderBlock, message.realTimeFlag, message.compatibilityMode, message.ignoreUSKDatehints, server);
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.wasDiskPut = wasDiskPut;
        this.overrideSplitfileCryptoKey = message.overrideSplitfileCryptoKey;
        this.manifestElements = new HashMap();
        this.manifestElements.putAll(manifestElements);
        this.defaultName = message.defaultName;
        this.makePutter(server.core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + this.identifier + " : " + this.priorityClass);
        }
    }

    public ClientPutDir(PersistentRequestClient client, FreenetURI uri, String identifier, int verbosity, short priorityClass, ClientRequest.Persistence persistence, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, File dir, String defaultName, boolean allowUnreadableFiles, boolean includeHiddenFiles, boolean global, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, byte[] overrideSplitfileCryptoKey, NodeClientCore core) throws FileNotFoundException, IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(uri, "site", core.clientContext), identifier, verbosity, null, null, client, priorityClass, persistence, clientToken, global, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, InsertContext.CompatibilityMode.COMPAT_DEFAULT, false, core);
        this.wasDiskPut = true;
        this.overrideSplitfileCryptoKey = overrideSplitfileCryptoKey;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.manifestElements = this.makeDiskDirManifest(dir, "", allowUnreadableFiles, includeHiddenFiles);
        this.defaultName = defaultName;
        this.makePutter(core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + identifier + " : " + priorityClass);
        }
    }

    public ClientPutDir(PersistentRequestClient client, FreenetURI uri, String identifier, int verbosity, short priorityClass, ClientRequest.Persistence persistence, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, HashMap<String, Object> elements, String defaultName, boolean global, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, byte[] overrideSplitfileCryptoKey, NodeClientCore core) throws IdentifierCollisionException, MalformedURLException, TooManyFilesInsertException {
        super(ClientPutDir.checkEmptySSK(uri, "site", core.clientContext), identifier, verbosity, null, null, client, priorityClass, persistence, clientToken, global, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, InsertContext.CompatibilityMode.COMPAT_DEFAULT, false, core);
        this.wasDiskPut = false;
        this.overrideSplitfileCryptoKey = overrideSplitfileCryptoKey;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.manifestElements = elements;
        this.defaultName = defaultName;
        this.makePutter(core.clientContext);
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting data from custom buckets " + identifier + " : " + priorityClass);
        }
    }

    protected ClientPutDir() {
        this.defaultName = null;
        this.totalSize = 0L;
        this.numberOfFiles = 0;
        this.wasDiskPut = false;
        this.overrideSplitfileCryptoKey = null;
    }

    @Override
    void register(boolean noTags) throws IdentifierCollisionException {
        if (this.persistence != ClientRequest.Persistence.CONNECTION) {
            this.client.register(this);
        }
        if (this.persistence != ClientRequest.Persistence.CONNECTION && !noTags) {
            FCPMessage msg = this.persistentTagMessage();
            this.client.queueClientRequestMessage(msg, 0);
        }
    }

    private HashMap<String, Object> makeDiskDirManifest(File dir, String prefix, boolean allowUnreadableFiles, boolean includeHiddenFiles) throws FileNotFoundException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("No such directory");
        }
        for (File f : files) {
            if (f.isHidden() && !includeHiddenFiles) continue;
            if (f.exists() && f.canRead()) {
                if (f.isFile()) {
                    FileBucket bucket = new FileBucket(f, true, false, false, false);
                    if (logMINOR) {
                        Logger.minor(this, "Add file : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), new ManifestElement(f.getName(), prefix + f.getName(), bucket, DefaultMIMETypes.guessMIMEType(f.getName(), true), f.length()));
                    continue;
                }
                if (f.isDirectory()) {
                    if (logMINOR) {
                        Logger.minor(this, "Add dir : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), this.makeDiskDirManifest(f, prefix + f.getName() + "/", allowUnreadableFiles, includeHiddenFiles));
                    continue;
                }
                if (allowUnreadableFiles) continue;
                throw new FileNotFoundException("Not a file and not a directory : " + f);
            }
            if (allowUnreadableFiles) continue;
            throw new FileNotFoundException("The file does not exist or is unreadable : " + f);
        }
        return map;
    }

    private void makePutter(ClientContext context) throws TooManyFilesInsertException {
        this.putter = new DefaultManifestPutter(this, this.manifestElements, this.priorityClass, this.uri, this.defaultName, this.ctx, this.persistence == ClientRequest.Persistence.FOREVER, this.overrideSplitfileCryptoKey, context);
    }

    @Override
    public void start(ClientContext context) {
        if (this.finished) {
            return;
        }
        if (this.started) {
            return;
        }
        try {
            RequestStatusCache cache;
            if (this.putter != null) {
                this.putter.start(context);
            }
            this.started = true;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + this.putter + " for " + this + " persistence=" + (Object)((Object)this.persistence));
            }
            if (this.persistence != ClientRequest.Persistence.CONNECTION && !this.finished) {
                FCPMessage msg = this.persistentTagMessage();
                this.client.queueClientRequestMessage(msg, 0);
            }
        }
        catch (InsertException e) {
            this.started = true;
            this.onFailure(e, null);
        }
    }

    @Override
    public void onLostConnection(ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.cancel(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData() {
        if (logMINOR) {
            Logger.minor(this, "freeData() on " + this + " persistence type = " + (Object)((Object)this.persistence));
        }
        ClientPutDir clientPutDir = this;
        synchronized (clientPutDir) {
            if (this.manifestElements == null) {
                if (logMINOR) {
                    Logger.minor(this, "manifestElements = " + this.manifestElements, (Throwable)new Exception("error"));
                }
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "freeData() more on " + this + " persistence type = " + (Object)((Object)this.persistence));
        }
        this.freeData(this.manifestElements);
        this.manifestElements = null;
    }

    private void freeData(HashMap<String, Object> manifestElements) {
        if (logMINOR) {
            Logger.minor(this, "freeData() inner on " + this + " persistence type = " + (Object)((Object)this.persistence) + " size = " + manifestElements.size());
        }
        for (Object o : manifestElements.values()) {
            if (o instanceof HashMap) {
                this.freeData((HashMap)o);
                continue;
            }
            ManifestElement e = (ManifestElement)o;
            if (logMINOR) {
                Logger.minor(this, "Freeing " + e);
            }
            e.freeData();
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    protected FCPMessage persistentTagMessage() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
        }
        if (this.putter == null) {
            Logger.error(this, "putter == null", (Throwable)new Exception("error"));
        }
        return new PersistentPutDir(this.identifier, this.publicURI, this.uri, this.verbosity, this.priorityClass, this.persistence, this.global, this.defaultName, this.manifestElements, this.clientToken, this.started, this.ctx.maxInsertRetries, this.ctx.dontCompress, this.ctx.compressorDescriptor, this.wasDiskPut, this.isRealTime(), this.putter != null ? this.putter.getSplitfileCryptoKey() : null, this.ctx.getCompatibilityMode());
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    @Override
    protected String getTypeName() {
        return "PUTDIR";
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI() {
        return this.generatedURI;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public long getTotalDataSize() {
        return this.totalSize;
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return true;
    }

    @Override
    public boolean restart(ClientContext context, boolean disableFilterData) {
        RequestStatusCache cache;
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart();
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateStarted(this.identifier, false);
        }
        try {
            this.makePutter(context);
        }
        catch (TooManyFilesInsertException e) {
            this.onFailure(new InsertException(e), null);
        }
        this.start(context);
        return true;
    }

    public void onFailure(FetchException e, ClientGetter state) {
    }

    public void onSuccess(FetchResult result, ClientGetter state) {
    }

    @Override
    public void onSuccess(BaseClientPutter state) {
        super.onSuccess(state);
    }

    @Override
    public void onFailure(InsertException e, BaseClientPutter state) {
        super.onFailure(e, state);
    }

    @Override
    public void requestWasRemoved(ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            this.putter = null;
        }
        super.requestWasRemoved(context);
    }

    @Override
    protected void onStartCompressing() {
    }

    @Override
    protected void onStopCompressing() {
    }

    @Override
    RequestStatus getStatus() {
        FreenetURI finalURI = this.getFinalURI();
        InsertException.InsertExceptionMode failureCode = null;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.putFailedMessage != null) {
            failureCode = this.putFailedMessage.code;
            failureReasonShort = this.putFailedMessage.getShortFailedMessage();
            failureReasonShort = this.putFailedMessage.getLongFailedMessage();
        }
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        Date latestSuccess = CurrentTimeUTC.get();
        Date latestFailure = null;
        boolean totalFinalized = false;
        if (this.progressMessage != null && this.progressMessage instanceof SimpleProgressMessage) {
            SimpleProgressMessage msg = (SimpleProgressMessage)this.progressMessage;
            total = (int)msg.getTotalBlocks();
            min = (int)msg.getMinBlocks();
            fetched = (int)msg.getFetchedBlocks();
            latestSuccess = msg.getLatestSuccess();
            fatal = (int)msg.getFatalyFailedBlocks();
            failed = (int)msg.getFailedBlocks();
            latestFailure = msg.getLatestFailure();
            totalFinalized = msg.isTotalFinalized();
        }
        return new UploadDirRequestStatus(this.identifier, this.persistence, this.started, this.finished, this.succeeded, total, min, fetched, latestSuccess, fatal, failed, latestFailure, totalFinalized, this.priorityClass, finalURI, this.uri, failureCode, failureReasonShort, failureReasonLong, this.totalSize, this.numberOfFiles);
    }

    @Override
    public void innerResume(ClientContext context) throws ResumeFailedException {
        ContainerInserter.resumeMetadata(this.manifestElements, context);
    }

    @Override
    RequestIdentifier.RequestType getType() {
        return RequestIdentifier.RequestType.PUTDIR;
    }

    @Override
    public boolean fullyResumed() {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

