/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.BaseDataCarryingMessage;
import freenet.clients.fcp.ClientHelloMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.LineReadingInputStream;
import freenet.support.io.TooLongException;
import java.io.BufferedInputStream;
import java.io.IOException;
import org.tanukisoftware.wrapper.WrapperManager;

public class FCPConnectionInputHandler
implements Runnable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final FCPConnectionHandler handler;

    FCPConnectionInputHandler(FCPConnectionHandler handler) {
        this.handler = handler;
    }

    void start() {
        if (this.handler.sock == null) {
            return;
        }
        this.handler.server.node.executor.execute(this, "FCP input handler for " + this.handler.sock.getRemoteSocketAddress());
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (TooLongException e) {
            Logger.normal(this, "Caught " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            if (logMINOR) {
                Logger.minor(this, "Caught " + e, (Throwable)e);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            t.printStackTrace();
        }
        this.handler.close();
        this.handler.closedInput();
    }

    public void realRun() throws IOException {
        BufferedInputStream is = new BufferedInputStream(this.handler.sock.getInputStream(), 4096);
        LineReadingInputStream lis = new LineReadingInputStream(is);
        boolean firstMessage = true;
        while (true) {
            ProtocolErrorMessage err;
            ProtocolErrorMessage err2;
            FCPMessage msg;
            block17: {
                if (WrapperManager.hasShutdownHookBeenTriggered()) {
                    ProtocolErrorMessage msg2 = new ProtocolErrorMessage(18, true, "The node is shutting down", "Node", false);
                    this.handler.send(msg2);
                    Closer.close(is);
                    return;
                }
                String messageType = lis.readLine(128, 128, true);
                if (messageType == null) {
                    Closer.close(is);
                    return;
                }
                if (messageType.equals("")) continue;
                SimpleFieldSet fs = new SimpleFieldSet(lis, 4096, 128, true, true, true);
                if (!(firstMessage || fs.getEndMarker() == null || fs.getEndMarker().startsWith("End") || "Data".equals(fs.getEndMarker()))) {
                    ProtocolErrorMessage err3 = new ProtocolErrorMessage(3, false, "Invalid end marker: " + fs.getEndMarker(), fs.get("Identifer"), fs.getBoolean("Global", false));
                    this.handler.send(err3);
                    continue;
                }
                try {
                    if (logDEBUG) {
                        Logger.debug(this, "Incoming FCP message:\n" + messageType + '\n' + fs.toString());
                    }
                    if ((msg = FCPMessage.create(messageType, fs, this.handler.bf, this.handler.server.core.persistentTempBucketFactory)) == null) {
                    }
                    break block17;
                }
                catch (MessageInvalidException e) {
                    if (firstMessage) {
                        err2 = new ProtocolErrorMessage(1, true, null, null, false);
                        this.handler.send(err2);
                        this.handler.close();
                        Closer.close(is);
                        return;
                    }
                    err2 = new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global);
                    this.handler.send(err2);
                }
                continue;
            }
            if (firstMessage && !(msg instanceof ClientHelloMessage)) {
                err = new ProtocolErrorMessage(1, true, null, null, false);
                this.handler.send(err);
                this.handler.close();
                Closer.close(is);
                return;
            }
            if (msg instanceof BaseDataCarryingMessage) {
                try {
                    ((BaseDataCarryingMessage)msg).readFrom(lis, this.handler.bf, this.handler.server);
                }
                catch (MessageInvalidException e) {
                    err2 = new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global);
                    this.handler.send(err2);
                    continue;
                }
            }
            if (!firstMessage && msg instanceof ClientHelloMessage) {
                err = new ProtocolErrorMessage(2, false, null, null, false);
                this.handler.send(err);
                continue;
            }
            try {
                if (logDEBUG) {
                    Logger.debug(this, "Parsed message: " + msg + " for " + this.handler);
                }
                msg.run(this.handler, this.handler.server.node);
            }
            catch (MessageInvalidException e) {
                err2 = new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global);
                this.handler.send(err2);
                continue;
            }
            firstMessage = false;
            if (this.handler.isClosed()) break;
        }
        Closer.close(is);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

