/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.support.SimpleFieldSet;
import freenet.support.StringValidityChecker;
import freenet.support.api.Bucket;
import java.util.UUID;

public final class FCPPluginMessage {
    public final ClientPermissions permissions;
    public final String identifier;
    public final SimpleFieldSet params;
    public final Bucket data;
    public final Boolean success;
    public final String errorCode;
    public final String errorMessage;

    public boolean isReplyMessage() {
        return this.success != null;
    }

    private FCPPluginMessage(ClientPermissions permissions, String identifier, SimpleFieldSet params, Bucket data, Boolean success, String errorCode, String errorMessage) {
        assert (permissions != null || permissions == null);
        assert (identifier != null);
        assert (params != null || params == null);
        assert (data != null || data == null);
        assert (success != null || success == null);
        assert (params != null || data != null || success != null) : "Messages should not be empty";
        assert (errorCode == null || success != null && !success.booleanValue()) : "errorCode should only be provided for reply messages which indicate failure.";
        assert (errorCode == null || StringValidityChecker.isLatinLettersAndNumbersOnly(errorCode)) : "errorCode should be alpha-numeric";
        assert (errorMessage == null || errorCode != null) : "errorCode should always be provided if there is an errorMessage";
        this.permissions = permissions;
        this.identifier = identifier;
        this.params = params;
        this.data = data;
        this.success = success;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static FCPPluginMessage construct(SimpleFieldSet params, Bucket data) {
        return new FCPPluginMessage(null, UUID.randomUUID().toString(), params, data, null, null, null);
    }

    public static FCPPluginMessage construct() {
        return FCPPluginMessage.construct(new SimpleFieldSet(true), null);
    }

    public static FCPPluginMessage constructReplyMessage(FCPPluginMessage originalMessage, SimpleFieldSet params, Bucket data, boolean success, String errorCode, String errorMessage) {
        if (originalMessage.isReplyMessage()) {
            throw new IllegalStateException("Constructing a reply message for a message which was a reply message already not allowed.");
        }
        return new FCPPluginMessage(null, originalMessage.identifier, params, data, success, errorCode, errorMessage);
    }

    public static FCPPluginMessage constructSuccessReply(FCPPluginMessage originalMessage) {
        return FCPPluginMessage.constructReplyMessage(originalMessage, new SimpleFieldSet(true), null, true, null, null);
    }

    public static FCPPluginMessage constructErrorReply(FCPPluginMessage originalMessage, String errorCode, String errorMessage) {
        return FCPPluginMessage.constructReplyMessage(originalMessage, new SimpleFieldSet(true), null, false, errorCode, errorMessage);
    }

    static FCPPluginMessage constructRawMessage(ClientPermissions permissions, String identifier, SimpleFieldSet params, Bucket data, Boolean success, String errorCode, String errorMessage) {
        return new FCPPluginMessage(permissions, identifier, params, data, success, errorCode, errorMessage);
    }

    public String toString() {
        return super.toString() + " (permissions: " + (Object)((Object)this.permissions) + "; identifier: " + this.identifier + "; data: " + this.data + "; success: " + this.success + "; errorCode: " + this.errorCode + "; errorMessage: " + this.errorMessage + "; params: " + '\n' + (this.params != null ? this.params.toOrderedString() : null);
    }

    public static enum ClientPermissions {
        ACCESS_FCP_RESTRICTED,
        ACCESS_FCP_FULL,
        ACCESS_DIRECT;

    }
}

