/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.DataCarryingMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPPluginMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;

public class FCPPluginServerMessage
extends DataCarryingMessage {
    private static final String NAME = "FCPPluginReply";
    public static final String PARAM_PREFIX = "Replies";
    private final long dataLength;
    private final String plugname;
    private final String identifier;
    private final SimpleFieldSet plugparams;
    private final Boolean success;
    private final String errorCode;
    private final String errorMessage;

    @Deprecated
    public FCPPluginServerMessage(String pluginname, String identifier2, SimpleFieldSet fs, Bucket bucket2) {
        this(pluginname, identifier2, fs, bucket2, null, null, null);
    }

    public FCPPluginServerMessage(String pluginname, FCPPluginMessage message) {
        this(pluginname, message.identifier, message.params, message.data, message.success, message.errorCode, message.errorMessage);
        assert (pluginname != null);
    }

    public FCPPluginServerMessage(String pluginname, String identifier2, SimpleFieldSet fs, Bucket bucket2, Boolean success, String errorCode, String errorMessage) {
        this.bucket = bucket2;
        if (this.bucket == null) {
            this.dataLength = -1L;
        } else {
            this.bucket.setReadOnly();
            this.dataLength = this.bucket.size();
        }
        this.plugname = pluginname;
        this.identifier = identifier2;
        this.plugparams = fs;
        this.success = success;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    String getEndString() {
        if (this.dataLength() > 0L) {
            return "Data";
        }
        return "EndMessage";
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("PluginName", this.plugname);
        sfs.putSingle("Identifier", this.identifier);
        if (this.dataLength() > 0L) {
            sfs.put("DataLength", this.dataLength());
        }
        if (this.plugparams != null && !this.plugparams.isEmpty()) {
            sfs.put(PARAM_PREFIX, this.plugparams);
        }
        if (this.success != null) {
            sfs.put("Success", this.success);
            if (!this.success.booleanValue() && this.errorCode != null) {
                sfs.putSingle("ErrorCode", this.errorCode);
                if (this.errorMessage != null) {
                    sfs.putSingle("ErrorMessage", this.errorMessage);
                }
            }
        }
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FCPPluginReply goes from server to client not the other way around", null, false);
    }
}

