/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.events.FinishedCompressionEvent;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;

public class FinishedCompressionMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final int codec;
    final long origSize;
    final long compressedSize;

    public FinishedCompressionMessage(String identifier, boolean global, FinishedCompressionEvent event) {
        this.identifier = identifier;
        this.codec = event.codec;
        this.compressedSize = event.compressedSize;
        this.origSize = event.originalSize;
        this.global = global;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Codec", this.codec);
        if (this.codec != -1) {
            fs.putSingle("Codec.Name", Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID((short)this.codec).name());
        } else {
            fs.putSingle("Codec.Name", "NONE");
        }
        fs.put("OriginalSize", this.origSize);
        fs.put("CompressedSize", this.compressedSize);
        fs.put("Global", this.global);
        return fs;
    }

    @Override
    public String getName() {
        return "FinishedCompression";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FinishedCompression goes from server to client not the other way around", this.identifier, this.global);
    }
}

