/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PeerMessage;
import freenet.clients.fcp.UnknownNodeIdentifierMessage;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.Fields;
import freenet.support.SimpleFieldSet;

public class ModifyPeer
extends FCPMessage {
    static final String NAME = "ModifyPeer";
    final SimpleFieldSet fs;
    final String identifier;

    public ModifyPeer(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        String allowLocalAddressesString;
        String ignoreSourcePortString;
        String isBurstOnlyString;
        String isListenOnlyString;
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ModifyPeer requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.send(msg);
            return;
        }
        if (!(pn instanceof DarknetPeerNode)) {
            throw new MessageInvalidException(31, "ModifyPeer only available for darknet peers", this.identifier, false);
        }
        DarknetPeerNode dpn = (DarknetPeerNode)pn;
        String isDisabledString = this.fs.get("IsDisabled");
        if (isDisabledString != null && !isDisabledString.equals("")) {
            if (Fields.stringToBool(isDisabledString, false)) {
                dpn.disablePeer();
            } else {
                dpn.enablePeer();
            }
        }
        if ((isListenOnlyString = this.fs.get("IsListenOnly")) != null && !isListenOnlyString.equals("")) {
            dpn.setListenOnly(Fields.stringToBool(isListenOnlyString, false));
        }
        if ((isBurstOnlyString = this.fs.get("IsBurstOnly")) != null && !isBurstOnlyString.equals("")) {
            dpn.setBurstOnly(Fields.stringToBool(isBurstOnlyString, false));
        }
        if ((ignoreSourcePortString = this.fs.get("IgnoreSourcePort")) != null && !ignoreSourcePortString.equals("")) {
            dpn.setIgnoreSourcePort(Fields.stringToBool(ignoreSourcePortString, false));
        }
        if ((allowLocalAddressesString = this.fs.get("AllowLocalAddresses")) != null && !allowLocalAddressesString.equals("")) {
            dpn.setAllowLocalAddresses(Fields.stringToBool(allowLocalAddressesString, false));
        }
        handler.send(new PeerMessage(pn, true, true, this.identifier));
    }
}

