/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;

public class NodeData
extends FCPMessage {
    static final String name = "NodeData";
    final Node node;
    final boolean giveOpennetRef;
    final boolean withPrivate;
    final boolean withVolatile;
    final String identifier;

    public NodeData(Node node, boolean giveOpennetRef, boolean withPrivate, boolean withVolatile, String identifier) {
        this.node = node;
        this.giveOpennetRef = giveOpennetRef;
        this.withPrivate = withPrivate;
        this.withVolatile = withVolatile;
        this.identifier = identifier;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet vol;
        SimpleFieldSet fs = this.giveOpennetRef ? (this.withPrivate ? this.node.exportOpennetPrivateFieldSet() : this.node.exportOpennetPublicFieldSet()) : (this.withPrivate ? this.node.exportDarknetPrivateFieldSet() : this.node.exportDarknetPublicFieldSet());
        if (this.withVolatile && !(vol = this.node.exportVolatileFieldSet()).isEmpty()) {
            fs.put("volatile", vol);
        }
        if (this.identifier != null) {
            fs.putSingle("Identifier", this.identifier);
        }
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "NodeData goes from server to client not the other way around", this.identifier, false);
    }
}

