/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.Cookie;
import freenet.support.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;

public final class ReceivedCookie
extends Cookie {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private String notValidatedName;
    private Hashtable<String, String> content;

    private ReceivedCookie(String myName, Hashtable<String, String> myContent) {
        this.notValidatedName = myName;
        this.content = myContent;
        this.version = 1;
    }

    protected static ArrayList<ReceivedCookie> parseHeader(String httpHeader) throws ParseException {
        if (logMINOR) {
            Logger.minor(ReceivedCookie.class, "Received HTTP cookie header:" + httpHeader);
        }
        char[] header = httpHeader.toCharArray();
        String currentCookieName = null;
        Hashtable<String, String> currentCookieContent = new Hashtable<String, String>(16);
        ArrayList<ReceivedCookie> cookies = new ArrayList<ReceivedCookie>(4);
        try {
            int i = 0;
            while (i < header.length) {
                if (Character.isWhitespace(header[i])) {
                    ++i;
                    continue;
                }
                String value = null;
                int keyBeginIndex = i;
                while (i < header.length && header[i] != '=' && header[i] != ';') {
                    ++i;
                }
                int keyEndIndex = i;
                if (keyEndIndex >= header.length || header[keyEndIndex] == ';') {
                    value = "";
                }
                while (Character.isWhitespace(header[keyEndIndex - 1])) {
                    --keyEndIndex;
                }
                String key = new String(header, keyBeginIndex, keyEndIndex - keyBeginIndex).toLowerCase();
                if (key.length() == 0) {
                    throw new ParseException("Invalid cookie: Contains an empty key: " + httpHeader, i);
                }
                if (value == null && ++i < header.length) {
                    int valueEndIndex;
                    int valueBeginIndex;
                    char valueEndChar;
                    while (Character.isWhitespace(header[i])) {
                        ++i;
                    }
                    if (header[i] == '\"') {
                        valueEndChar = '\"';
                        valueBeginIndex = ++i;
                        while (header[i] != valueEndChar) {
                            ++i;
                        }
                    } else {
                        valueEndChar = ';';
                        valueBeginIndex = i;
                        while (i < header.length && header[i] != valueEndChar) {
                            ++i;
                        }
                    }
                    for (valueEndIndex = i; valueEndIndex > valueBeginIndex && Character.isWhitespace(header[valueEndIndex - 1]); --valueEndIndex) {
                    }
                    value = new String(header, valueBeginIndex, valueEndIndex - valueBeginIndex);
                    ++i;
                    if (valueEndChar == '\"') {
                        while (i < header.length && header[i] != ';') {
                            if (!Character.isWhitespace(header[i])) {
                                throw new ParseException("Invalid cookie: Missing terminating semicolon after value quotation: " + httpHeader, i);
                            }
                            ++i;
                        }
                        ++i;
                    }
                } else {
                    value = "";
                }
                if (currentCookieName == null) {
                    if (key.charAt(0) == '$') {
                        currentCookieContent.put(key, value);
                        continue;
                    }
                    currentCookieName = key;
                    currentCookieContent.put(currentCookieName, value);
                    continue;
                }
                if (key.charAt(0) == '$') {
                    currentCookieContent.put(key, value);
                    continue;
                }
                cookies.add(new ReceivedCookie(currentCookieName, currentCookieContent));
                currentCookieName = key;
                currentCookieContent = new Hashtable(16);
                currentCookieContent.put(currentCookieName, value);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ParseException p = new ParseException("Index out of bounds (" + e.getMessage() + ") for cookie " + httpHeader, 0);
            p.setStackTrace(e.getStackTrace());
            throw p;
        }
        if (currentCookieName != null) {
            cookies.add(new ReceivedCookie(currentCookieName, currentCookieContent));
        }
        return cookies;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = ReceivedCookie.validateName(this.notValidatedName);
            this.notValidatedName = null;
        }
        return this.name;
    }

    @Override
    public URI getDomain() {
        if (this.domain == null) {
            try {
                String domainString = this.content.get("$domain");
                if (domainString == null) {
                    return null;
                }
                this.domain = ReceivedCookie.validateDomain(domainString);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.domain;
    }

    @Override
    public URI getPath() {
        if (this.path == null) {
            try {
                this.path = ReceivedCookie.validatePath(this.content.get("$path"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.path;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = ReceivedCookie.validateValue(this.content.get(this.getName()));
        }
        return this.value;
    }

    @Override
    protected String encodeToHeaderValue() {
        throw new UnsupportedOperationException("ReceivedCookie objects cannot be encoded to a HTTP header value, use Cookie objects!");
    }

    static {
        Logger.registerClass(ReceivedCookie.class);
    }
}

