/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.ConfigToadlet;
import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.Option;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;

public class WELCOME
implements Step {
    private final Config config;

    public WELCOME(Config config) {
        this.config = config;
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("homepageTitle"));
        boolean incognito = request.isParameterSet("incognito");
        HTMLNode optionsTable = contentNode.addChild("table");
        HTMLNode tableHeader = optionsTable.addChild("tr");
        HTMLNode tableRow = optionsTable.addChild("tr");
        this.addSecurityTableCell(tableHeader, tableRow, "Low", helper, incognito);
        this.addSecurityTableCell(tableHeader, tableRow, "High", helper, incognito);
        this.addSecurityTableCell(tableHeader, tableRow, "None", helper, incognito);
        HTMLNode languageForm = helper.addFormChild(contentNode, ".", "languageForm");
        Option<?> language = this.config.get("node").getOption("l10n");
        EnumerableOptionCallback l10nCallback = (EnumerableOptionCallback)((Object)language.getCallback());
        HTMLNode dropDown = ConfigToadlet.addComboBox(language.getValueDisplayString(), l10nCallback, language.getName(), false);
        dropDown.addAttribute("onchange", "this.form.submit()");
        languageForm.addChild(dropDown);
        languageForm.addChild("noscript").addChild("input", "type", "submit");
    }

    @Override
    public String postStep(HTTPRequest request) {
        String desiredLanguage = request.getPartAsStringFailsafe("l10n", 4096);
        try {
            this.config.get("node").set("l10n", desiredLanguage);
        }
        catch (InvalidConfigValueException e) {
            Logger.error(this, "Failed to set language to " + desiredLanguage + ". " + e);
        }
        catch (NodeNeedRestartException nodeNeedRestartException) {
            // empty catch block
        }
        return FirstTimeWizardToadlet.WIZARD_STEP.WELCOME.name();
    }

    private void addSecurityTableCell(HTMLNode header, HTMLNode row, String preset, PageHelper helper, boolean incognito) {
        header.addChild("th", "width", "33%", WizardL10n.l10n("presetTitle" + preset));
        HTMLNode tableCell = row.addChild("td");
        tableCell.addChild("p", WizardL10n.l10n("preset" + preset));
        HTMLNode centerForm = tableCell.addChild("div", "style", "text-align:center;");
        HTMLNode secForm = helper.addFormChild(centerForm, ".", "SecForm" + preset);
        secForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "incognito", String.valueOf(incognito)});
        secForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "preset" + preset, WizardL10n.l10n("presetChoose" + preset)});
    }
}

