/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import freenet.io.AddressTracker;
import freenet.io.comm.IOStatisticCollector;
import freenet.io.comm.IncomingPacketFilter;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.Peer;
import freenet.io.comm.PortForwardSensitiveSocketHandler;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import freenet.support.transport.ip.IPUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Random;

public class UdpSocketHandler
implements PrioRunnable,
PacketSocketHandler,
PortForwardSensitiveSocketHandler {
    private final DatagramSocket _sock;
    private final InetAddress _bindTo;
    private final AddressTracker tracker;
    private IncomingPacketFilter lowLevelFilter;
    private Random dropRandom;
    private int _dropProbability;
    private final Node node;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean _isDone;
    private volatile boolean _active = true;
    private final int listenPort;
    private final String title;
    private boolean _started;
    private long startTime;
    private final IOStatisticCollector collector;
    private static final int MAX_RECEIVE_SIZE = 1500;
    static final int MAX_ALLOWED_MTU = 1280;
    static final int UDPv4_HEADERS_LENGTH = 28;
    static final int UDPv6_HEADERS_LENGTH = 48;
    public static final int UDP_HEADERS_LENGTH = 48;
    static final int MIN_IPv4_MTU = 576;
    static final int MIN_IPv6_MTU = 1280;
    public static final int MIN_MTU = 576;
    private volatile int maxPacketSize = 1280;

    public UdpSocketHandler(int listenPort, InetAddress bindto, Node node, long startupTime, String title, IOStatisticCollector collector) throws SocketException {
        this.node = node;
        this.collector = collector;
        this.title = title;
        this._bindTo = bindto;
        this.listenPort = listenPort;
        this._sock = new DatagramSocket(listenPort, bindto);
        int sz = this._sock.getReceiveBufferSize();
        if (sz < 65536) {
            this._sock.setReceiveBufferSize(65536);
        }
        try {
            this._sock.setReuseAddress(true);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        try {
            this._sock.setTrafficClass(node.getTrafficClass().value);
        }
        catch (SocketException e) {
            Logger.error(this, "Failed to setTrafficClass with " + node.getTrafficClass().value, (Throwable)e);
        }
        boolean r = socketOptions.setAddressPreference(this._sock, socketOptions.SOCKET_ADDR_PREFERENCE.IPV6_PREFER_SRC_PUBLIC);
        if (logMINOR) {
            Logger.minor(this, "Setting IPV6_PREFER_SRC_PUBLIC for port " + listenPort + " is a " + (r ? "success" : "failure"));
        }
        this.dropRandom = node.fastWeakRandom;
        this.tracker = AddressTracker.create(node.lastBootID, node.runDir(), listenPort);
        this.tracker.startSend(startupTime);
    }

    @Override
    public void setLowLevelFilter(IncomingPacketFilter f) {
        this.lowLevelFilter = f;
    }

    public InetAddress getBindTo() {
        return this._bindTo;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.tracker.startReceive(System.currentTimeMillis());
        try {
            this.runLoop();
        }
        catch (Throwable t) {
            try {
                System.err.print(t.getClass().getName());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.err.print(t.getMessage());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Runtime r = Runtime.getRuntime();
                System.err.print(r.freeMemory());
                System.err.println();
                System.err.print(r.totalMemory());
                System.err.println();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            System.err.println("run() exiting for UdpSocketHandler on port " + this._sock.getLocalPort());
            Logger.error(this, "run() exiting for UdpSocketHandler on port " + this._sock.getLocalPort());
            UdpSocketHandler udpSocketHandler = this;
            synchronized (udpSocketHandler) {
                this._isDone = true;
                this.notifyAll();
            }
        }
    }

    private void runLoop() {
        byte[] buf = new byte[1500];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        while (this._active) {
            try {
                this.realRun(packet);
            }
            catch (Throwable t) {
                System.err.println("Caught " + t);
                t.printStackTrace(System.err);
                Logger.error(this, "Caught " + t, t);
            }
        }
    }

    private void realRun(DatagramPacket packet) {
        boolean gotPacket = this.getPacket(packet);
        long now = System.currentTimeMillis();
        if (gotPacket) {
            long startTime = System.currentTimeMillis();
            Peer peer = new Peer(packet.getAddress(), packet.getPort());
            this.tracker.receivedPacketFrom(peer);
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > 50L) {
                if (endTime - startTime > 3000L) {
                    Logger.error(this, "packet creation took " + (endTime - startTime) + "ms");
                } else if (logMINOR) {
                    Logger.minor(this, "packet creation took " + (endTime - startTime) + "ms");
                }
            }
            byte[] data = packet.getData();
            int offset = packet.getOffset();
            int length = packet.getLength();
            try {
                if (logMINOR) {
                    Logger.minor(this, "Processing packet of length " + length + " from " + peer);
                }
                startTime = System.currentTimeMillis();
                this.lowLevelFilter.process(data, offset, length, peer, now);
                endTime = System.currentTimeMillis();
                if (endTime - startTime > 50L) {
                    if (endTime - startTime > 3000L) {
                        Logger.error(this, "processing packet took " + (endTime - startTime) + "ms");
                    } else if (logMINOR) {
                        Logger.minor(this, "processing packet took " + (endTime - startTime) + "ms");
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Successfully handled packet length " + length);
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " from " + this.lowLevelFilter, t);
            }
        } else if (logDEBUG) {
            Logger.debug(this, "No packet received");
        }
    }

    private boolean getPacket(DatagramPacket packet) {
        try {
            this._sock.receive(packet);
            InetAddress address = packet.getAddress();
            boolean isLocal = !IPUtil.isValidAddress(address, false);
            this.collector.addInfo(address, packet.getPort(), this.getHeadersLength(address) + packet.getLength(), 0, isLocal);
        }
        catch (SocketTimeoutException e1) {
            return false;
        }
        catch (IOException e2) {
            if (!this._active) {
                return false;
            }
            throw new RuntimeException(e2);
        }
        if (logMINOR) {
            Logger.minor(this, "Received packet");
        }
        return true;
    }

    @Override
    public void sendPacket(byte[] blockToSend, Peer destination, boolean allowLocalAddresses) throws Peer.LocalAddressException {
        assert (blockToSend != null);
        if (!this._active) {
            Logger.error(this, "Trying to send packet but no longer active");
            return;
        }
        if (destination.getAddress(false, allowLocalAddresses) == null) {
            Logger.error(this, "Tried sending to destination without pre-looked up IP address(needs a real Peer.getHostname()): null:" + destination.getPort(), (Throwable)new Exception("error"));
            if (destination.getAddress(true, allowLocalAddresses) == null) {
                Logger.error(this, "Tried sending to bad destination address: null:" + destination.getPort(), (Throwable)new Exception("error"));
                return;
            }
        }
        if (this._dropProbability > 0 && this.dropRandom.nextInt() % this._dropProbability == 0) {
            Logger.normal(this, "DROPPED: " + this._sock.getLocalPort() + " -> " + destination.getPort());
            return;
        }
        InetAddress address = destination.getAddress(false, allowLocalAddresses);
        assert (address != null);
        int port = destination.getPort();
        DatagramPacket packet = new DatagramPacket(blockToSend, blockToSend.length);
        packet.setAddress(address);
        packet.setPort(port);
        try {
            this._sock.send(packet);
            this.tracker.sentPacketTo(destination);
            boolean isLocal = !IPUtil.isValidAddress(address, false) && IPUtil.isValidAddress(address, true);
            this.collector.addInfo(address, port, 0, this.getHeadersLength(address) + blockToSend.length, isLocal);
            if (logMINOR) {
                Logger.minor(this, "Sent packet length " + blockToSend.length + " to " + address + ':' + port);
            }
        }
        catch (IOException e) {
            if (packet.getAddress() instanceof Inet6Address) {
                Logger.normal(this, "Error while sending packet to IPv6 address: " + destination + ": " + e);
            }
            Logger.error(this, "Error while sending packet to " + destination + ": " + e, (Throwable)e);
        }
    }

    @Override
    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public int calculateMaxPacketSize() {
        int newSize;
        int oldSize = this.maxPacketSize;
        this.maxPacketSize = newSize = this.innerCalculateMaxPacketSize();
        if (oldSize != newSize) {
            System.out.println("Max packet size: " + newSize);
        }
        return this.maxPacketSize;
    }

    int innerCalculateMaxPacketSize() {
        int minAdvertisedMTU = this.node.getMinimumMTU();
        this.maxPacketSize = Math.min(1280, minAdvertisedMTU) - 48;
        return this.maxPacketSize;
    }

    @Override
    public int getPacketSendThreshold() {
        return this.getMaxPacketSize() - 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this._active) {
            return;
        }
        UdpSocketHandler udpSocketHandler = this;
        synchronized (udpSocketHandler) {
            this._started = true;
            this.startTime = System.currentTimeMillis();
        }
        this.node.executor.execute(this, "UdpSocketHandler for port " + this.listenPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Logger.normal(this, "Closing.", (Throwable)new Exception("error"));
        UdpSocketHandler udpSocketHandler = this;
        synchronized (udpSocketHandler) {
            this._active = false;
            this._sock.close();
            if (!this._started) {
                return;
            }
            while (!this._isDone) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.tracker.storeData(this.node.bootID, this.node.runDir(), this.listenPort);
    }

    public int getDropProbability() {
        return this._dropProbability;
    }

    public void setDropProbability(int dropProbability) {
        this._dropProbability = dropProbability;
    }

    public int getPortNumber() {
        return this._sock.getLocalPort();
    }

    public String toString() {
        return this._sock.getLocalAddress() + ":" + this._sock.getLocalPort();
    }

    @Override
    public int getHeadersLength() {
        return 48;
    }

    @Override
    public int getHeadersLength(Peer peer) {
        return this.getHeadersLength(peer.getAddress(false));
    }

    int getHeadersLength(InetAddress addr) {
        return addr == null || addr instanceof Inet6Address ? 48 : 28;
    }

    public AddressTracker getAddressTracker() {
        return this.tracker;
    }

    @Override
    public void rescanPortForward() {
        this.tracker.rescan();
    }

    @Override
    public AddressTracker.Status getDetectedConnectivityStatus() {
        return this.tracker.getPortForwardStatus();
    }

    @Override
    public int getPriority() {
        return NativeThread.MAX_PRIORITY;
    }

    public long getStartTime() {
        return this.startTime;
    }

    static {
        Logger.registerClass(UdpSocketHandler.class);
    }

    private static class socketOptions {
        private socketOptions() {
        }

        private static int getFd(DatagramSocket s) {
            int ret = -1;
            try {
                Method m = s.getClass().getDeclaredMethod("getImpl", new Class[0]);
                m.setAccessible(true);
                DatagramSocketImpl impl = (DatagramSocketImpl)m.invoke((Object)s, new Object[0]);
                Field f = DatagramSocketImpl.class.getDeclaredField("fd");
                f.setAccessible(true);
                FileDescriptor fdi = (FileDescriptor)f.get(impl);
                f = FileDescriptor.class.getDeclaredField("fd");
                f.setAccessible(true);
                ret = f.getInt(fdi);
            }
            catch (Exception e) {
                Logger.error(UdpSocketHandler.class, e.getMessage(), (Throwable)e);
            }
            return ret;
        }

        public static boolean setAddressPreference(DatagramSocket s, SOCKET_ADDR_PREFERENCE p) {
            if (!Platform.isLinux()) {
                return false;
            }
            int fd = socketOptions.getFd(s);
            if (fd <= 2) {
                return false;
            }
            int ret = -1;
            try {
                ret = socketOptionsHolder.setsockopt(fd, SOCKET_level.IPPROTO_IPV6.linux, p.option_name.linux, new IntByReference(p.linux).getPointer(), Pointer.SIZE);
            }
            catch (Exception e) {
                Logger.normal(UdpSocketHandler.class, e.getMessage(), (Throwable)e);
            }
            return ret == 0;
        }

        public static enum SOCKET_ADDR_PREFERENCE {
            IPV6_PREFER_SRC_TMP(1),
            IPV6_PREFER_SRC_PUBLIC(2),
            IPV6_PREFER_SRC_PUBTMP_DEFAULT(256),
            IPV6_PREFER_SRC_COA(4),
            IPV6_PREFER_SRC_HOME(1024),
            IPV6_PREFER_SRC_CGA(8),
            IPV6_PREFER_SRC_NONCGA(2048);

            final SOCKET_option_name option_name = SOCKET_option_name.IPV6_ADDR_PREFERENCES;
            final int linux;

            private SOCKET_ADDR_PREFERENCE(int linux) {
                this.linux = linux;
            }
        }

        public static enum SOCKET_option_name {
            IPV6_ADDR_PREFERENCES(72);

            final int linux;

            private SOCKET_option_name(int linux) {
                this.linux = linux;
            }
        }

        public static enum SOCKET_level {
            IPPROTO_IPV6(41);

            final int linux;

            private SOCKET_level(int linux) {
                this.linux = linux;
            }
        }

        private static class socketOptionsHolder {
            private socketOptionsHolder() {
            }

            private static native int setsockopt(int var0, int var1, int var2, Pointer var3, int var4) throws LastErrorException;

            static {
                Native.register((String)Platform.C_LIBRARY_NAME);
            }
        }
    }
}

