/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.crypt.DSAPublicKey;
import freenet.store.BlockMetadata;
import freenet.store.GetPubkey;
import freenet.store.PubkeyStore;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.io.IOException;

public class SimpleGetPubkey
implements GetPubkey {
    final PubkeyStore store;

    public SimpleGetPubkey(PubkeyStore store) {
        this.store = store;
    }

    @Override
    public DSAPublicKey getKey(byte[] hash, boolean canReadClientCache, boolean forULPR, BlockMetadata meta) {
        try {
            return this.store.fetch(hash, false, false, meta);
        }
        catch (IOException e) {
            Logger.error(this, "Caught " + e + " fetching pubkey for " + HexUtil.bytesToHex(hash));
            return null;
        }
    }

    @Override
    public void cacheKey(byte[] hash, DSAPublicKey key, boolean deep, boolean canWriteClientCache, boolean canWriteDatastore, boolean forULPR, boolean writeLocalToDatastore) {
        try {
            this.store.put(hash, key, false);
        }
        catch (IOException e) {
            Logger.error(this, "Caught " + e + " storing pubkey for " + HexUtil.bytesToHex(hash));
        }
    }
}

