/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.saltedhash;

import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.node.MasterKeys;
import freenet.store.saltedhash.SaltedHashFreenetStore;
import freenet.support.ByteArrayWrapper;
import freenet.support.Logger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class CipherManager {
    private byte[] salt;
    private byte[] diskSalt;
    private Map<ByteArrayWrapper, byte[]> digestRoutingKeyCache = new LinkedHashMap<ByteArrayWrapper, byte[]>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ByteArrayWrapper, byte[]> eldest) {
            return this.size() > 128;
        }
    };

    CipherManager(byte[] salt, byte[] diskSalt) {
        assert (salt.length == 16);
        this.salt = salt;
        this.diskSalt = diskSalt;
    }

    byte[] getDiskSalt() {
        return this.diskSalt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getDigestedKey(byte[] plainKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(plainKey);
        Map<ByteArrayWrapper, byte[]> map = this.digestRoutingKeyCache;
        synchronized (map) {
            byte[] dk = this.digestRoutingKeyCache.get(key);
            if (dk != null) {
                return dk;
            }
        }
        MessageDigest digest = SHA256.getMessageDigest();
        try {
            digest.update(plainKey);
            digest.update(this.salt);
            byte[] hashedRoutingKey = digest.digest();
            assert (hashedRoutingKey.length == 32);
            Object object = this.digestRoutingKeyCache;
            synchronized (object) {
                this.digestRoutingKeyCache.put(key, hashedRoutingKey);
            }
            object = hashedRoutingKey;
            return object;
        }
        finally {
            SHA256.returnMessageDigest(digest);
        }
    }

    void encrypt(SaltedHashFreenetStore.Entry entry, Random random) {
        if (entry.isEncrypted) {
            return;
        }
        entry.dataEncryptIV = new byte[16];
        random.nextBytes(entry.dataEncryptIV);
        PCFBMode cipher = this.makeCipher(entry.dataEncryptIV, entry.plainRoutingKey);
        cipher.blockEncipher(entry.header, 0, entry.header.length);
        cipher.blockEncipher(entry.data, 0, entry.data.length);
        entry.getDigestedRoutingKey();
        entry.isEncrypted = true;
    }

    boolean decrypt(SaltedHashFreenetStore.Entry entry, byte[] routingKey) {
        assert (entry.header != null);
        assert (entry.data != null);
        if (!entry.isEncrypted) {
            return Arrays.equals(entry.plainRoutingKey, routingKey);
        }
        if (entry.plainRoutingKey != null ? !Arrays.equals(entry.plainRoutingKey, routingKey) : !Arrays.equals(entry.digestedRoutingKey, this.getDigestedKey(routingKey))) {
            return false;
        }
        entry.plainRoutingKey = routingKey;
        PCFBMode cipher = this.makeCipher(entry.dataEncryptIV, entry.plainRoutingKey);
        cipher.blockDecipher(entry.header, 0, entry.header.length);
        cipher.blockDecipher(entry.data, 0, entry.data.length);
        entry.isEncrypted = false;
        return true;
    }

    PCFBMode makeCipher(byte[] iv, byte[] key) {
        byte[] iv2 = new byte[32];
        System.arraycopy(this.salt, 0, iv2, 0, 16);
        System.arraycopy(iv, 0, iv2, 16, 16);
        try {
            Rijndael aes = new Rijndael(256, 256);
            aes.initialize(key);
            return PCFBMode.create(aes, iv2);
        }
        catch (UnsupportedCipherException e) {
            Logger.error(this, "Rijndael not supported!", (Throwable)e);
            throw new Error("Rijndael not supported!", e);
        }
    }

    public void shutdown() {
        MasterKeys.clear(this.salt);
        MasterKeys.clear(this.diskSalt);
    }
}

