/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.saltedhash;

import freenet.crypt.DSAPublicKey;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.KeyVerifyException;
import freenet.l10n.NodeL10n;
import freenet.node.FastRunnable;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.stats.StoreAccessStats;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.store.saltedhash.CipherManager;
import freenet.store.saltedhash.LockManager;
import freenet.store.saltedhash.ResizablePersistentIntBuffer;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.WrapperKeepalive;
import freenet.support.io.Closer;
import freenet.support.io.Fallocate;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tanukisoftware.wrapper.WrapperManager;

public class SaltedHashFreenetStore<T extends StorableBlock>
implements FreenetStore<T> {
    private static final boolean OPTION_SAVE_PLAINKEY = false;
    static final int OPTION_MAX_PROBE = 5;
    private static final byte FLAG_DIRTY = 1;
    private static final byte FLAG_REBUILD_BLOOM = 2;
    private final ResizablePersistentIntBuffer slotFilter;
    private boolean slotFilterDisabled;
    private static final boolean USE_SLOT_FILTER = true;
    private static final int SLOT_CHECKED = Integer.MIN_VALUE;
    private static final int SLOT_OCCUPIED = 0x40000000;
    private static final int SLOT_NEW_BLOCK = 0x20000000;
    private static final int SLOT_WRONG_STORE = 0x10000000;
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private final File baseDir;
    private final String name;
    private final StoreCallback<T> callback;
    private final boolean collisionPossible;
    private final int headerBlockLength;
    private final int fullKeyLength;
    private final int dataBlockLength;
    private final Random random;
    private final File bloomFile;
    private long storeSize;
    private int generation;
    private int flags;
    private boolean preallocate = true;
    public static boolean NO_CLEANER_SLEEP;
    private SaltedHashFreenetStore<T> altStore;
    private boolean started = false;
    private File metaFile;
    private RandomAccessFile metaRAF;
    private FileChannel metaFC;
    private File hdFile;
    private RandomAccessFile hdRAF;
    private FileChannel hdFC;
    private final int hdPadding;
    private volatile long storeFileOffsetReady = -1L;
    private final File configFile;
    private long prevStoreSize = 0L;
    private Lock cleanerLock = new ReentrantLock();
    private Condition cleanerCondition = this.cleanerLock.newCondition();
    private static Lock cleanerGlobalLock;
    private Cleaner cleanerThread;
    private CleanerStatusUserAlert cleanerStatusUserAlert;
    private final Entry NOT_MODIFIED = new Entry();
    volatile boolean shutdown = false;
    private LockManager lockManager;
    private ReadWriteLock configLock = new ReentrantReadWriteLock();
    private Condition resizeCompleteCondition = this.configLock.writeLock().newCondition();
    private CipherManager cipherManager;
    private AtomicLong hits = new AtomicLong();
    private AtomicLong misses = new AtomicLong();
    private AtomicLong writes = new AtomicLong();
    private AtomicLong keyCount = new AtomicLong();
    private AtomicLong bloomFalsePos = new AtomicLong();
    private long initialHits;
    private long initialMisses;
    private long initialWrites;
    private long initialBloomFalsePos;

    public void setAltStore(SaltedHashFreenetStore<T> store) {
        if (store.altStore != null) {
            throw new IllegalStateException("Target must not have an altStore - deadlock can result");
        }
        this.altStore = store;
    }

    public static <T extends StorableBlock> SaltedHashFreenetStore<T> construct(File baseDir, String name, StoreCallback<T> callback, Random random, long maxKeys, boolean useSlotFilter, SemiOrderedShutdownHook shutdownHook, boolean preallocate, boolean resizeOnStart, Ticker exec, byte[] masterKey) throws IOException {
        return new SaltedHashFreenetStore<T>(baseDir, name, callback, random, maxKeys, useSlotFilter, shutdownHook, preallocate, resizeOnStart, masterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaltedHashFreenetStore(File baseDir, String name, StoreCallback<T> callback, Random random, long maxKeys, boolean enableSlotFilters, SemiOrderedShutdownHook shutdownHook, boolean preallocate, boolean resizeOnStart, byte[] masterKey) throws IOException {
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
        this.baseDir = baseDir;
        this.name = name;
        this.callback = callback;
        this.collisionPossible = callback.collisionPossible();
        this.headerBlockLength = callback.headerLength();
        this.fullKeyLength = callback.fullKeyLength();
        this.dataBlockLength = callback.dataLength();
        this.hdPadding = (this.headerBlockLength + this.dataBlockLength + 512 - 1 & 0xFFFFFE00) - (this.headerBlockLength + this.dataBlockLength);
        this.random = random;
        this.storeSize = maxKeys;
        this.preallocate = preallocate;
        this.lockManager = new LockManager();
        this.baseDir.mkdirs();
        if (this.storeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Store size over MAXINT not supported due to ResizablePersistentIntBuffer limitations.");
        }
        this.configFile = new File(this.baseDir, name + ".config");
        boolean newStore = this.loadConfigFile(masterKey);
        if (this.storeSize != 0L && this.storeSize != maxKeys && this.prevStoreSize == 0L) {
            this.prevStoreSize = this.storeSize;
            this.storeSize = maxKeys;
            this.writeConfigFile();
        }
        newStore |= this.openStoreFiles(baseDir, name);
        this.bloomFile = new File(this.baseDir, name + ".bloom");
        if (this.bloomFile.exists()) {
            this.bloomFile.delete();
            System.err.println("Deleted old bloom filter for " + name + " - obsoleted by slot filter");
            System.err.println("We will need to rebuild the slot filters, it will take a while and there will be a lot of disk access, but once it's done there should be a lot less disk access.");
        }
        File slotFilterFile = new File(this.baseDir, name + ".slotfilter");
        int size = (int)Math.max(this.storeSize, this.prevStoreSize);
        boolean bl = this.slotFilterDisabled = !enableSlotFilters;
        if (!this.slotFilterDisabled) {
            this.slotFilter = new ResizablePersistentIntBuffer(slotFilterFile, size);
            System.err.println("Slot filter (" + slotFilterFile + ") for " + name + " is loaded (new=" + this.slotFilter.isNew() + ").");
            if (newStore && this.slotFilter.isNew()) {
                this.slotFilter.fill(Integer.MIN_VALUE);
            }
        } else {
            if (slotFilterFile.exists()) {
                if (slotFilterFile.delete()) {
                    System.err.println("Old slot filter file deleted as slot filters are disabled, keeping it might cause data loss when they are turned back on.");
                } else {
                    System.err.println("Old slot filter file " + slotFilterFile + " could not be deleted. If you turn on slot filters later you might lose data from your datastore. Please delete it manually.");
                }
            }
            this.slotFilter = null;
        }
        if ((this.flags & 1) != 0) {
            System.err.println("Datastore(" + name + ") is dirty.");
        }
        this.flags |= 1;
        this.writeConfigFile();
        callback.setStore(this);
        shutdownHook.addEarlyJob(new NativeThread(new ShutdownDB(), "Shutdown salted hash store", NativeThread.HIGH_PRIORITY, true));
        this.cleanerThread = new Cleaner();
        this.cleanerStatusUserAlert = new CleanerStatusUserAlert(this.cleanerThread);
        if (resizeOnStart && this.prevStoreSize != 0L && cleanerGlobalLock.tryLock()) {
            System.out.println("Resizing datastore (" + name + ")");
            try {
                this.cleanerThread.resizeStore(this.prevStoreSize, false);
            }
            finally {
                cleanerGlobalLock.unlock();
            }
            this.writeConfigFile();
        }
        if (!this.slotFilterDisabled && this.slotFilter.isNew() && !newStore) {
            this.flags |= 2;
            System.out.println("Rebuilding slot filter because new");
        } else if ((this.flags & 2) != 0) {
            System.out.println("Slot filter still needs rebuilding");
        }
    }

    @Override
    public boolean start(Ticker ticker, boolean longStart) throws IOException {
        if (this.started) {
            return true;
        }
        if (!this.slotFilterDisabled) {
            this.slotFilter.start(ticker);
        }
        long curStoreFileSize = this.hdRAF.length();
        long curMetaFileSize = this.metaRAF.length();
        long smallerSize = this.storeSize;
        if (this.prevStoreSize < this.storeSize && this.prevStoreSize > 0L) {
            smallerSize = this.prevStoreSize;
        }
        if (smallerSize * (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) > curStoreFileSize || smallerSize * 128L > curMetaFileSize) {
            if (longStart) {
                this.setStoreFileSize(this.storeSize);
                curStoreFileSize = this.hdRAF.length();
                curMetaFileSize = this.metaRAF.length();
            } else {
                return true;
            }
        }
        this.storeFileOffsetReady = Math.min(curStoreFileSize / (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding), curMetaFileSize / 128L);
        if (ticker == null) {
            this.cleanerThread.start();
        } else {
            ticker.queueTimedJob(new FastRunnable(){

                @Override
                public void run() {
                    SaltedHashFreenetStore.this.cleanerThread.start();
                }
            }, "Start cleaner thread", 0L, true, false);
        }
        this.started = true;
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    public T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote, boolean canReadClientCache, boolean canReadSlashdotCache, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Entry probeEntry(byte[] digestedKey, byte[] routingKey, boolean withData) throws IOException {
        Entry entry = this.probeEntry0(digestedKey, routingKey, this.storeSize, withData);
        if (entry == null && this.prevStoreSize != 0L) {
            entry = this.probeEntry0(digestedKey, routingKey, this.prevStoreSize, withData);
        }
        return entry;
    }

    private Entry probeEntry0(byte[] digestedKey, byte[] routingKey, long probeStoreSize, boolean withData) throws IOException {
        Entry entry = null;
        long[] offset = this.getOffsetFromDigestedKey(digestedKey, probeStoreSize);
        for (int i = 0; i < offset.length; ++i) {
            if (logDEBUG) {
                Logger.debug(this, "probing for i=" + i + ", offset=" + offset[i]);
            }
            try {
                if (this.storeFileOffsetReady != -1L && offset[i] >= this.storeFileOffsetReady || (entry = this.readEntry(offset[i], digestedKey, routingKey, withData)) == null) continue;
                return entry;
            }
            catch (EOFException e) {
                if (this.prevStoreSize != 0L) continue;
                Logger.error(this, "EOFException on probeEntry", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock) throws IOException, KeyCollisionException {
        this.put(block, data, header, overwrite, isOldBlock, false);
    }

    /*
     * Exception decompiling
     */
    public boolean put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock, boolean wrongStore) throws IOException, KeyCollisionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[FORLOOP]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean onWrite() {
        return this.writes.incrementAndGet() % (this.storeSize * 2L) == 0L;
    }

    public boolean slotCacheLikelyMatch(int value, byte[] digestedRoutingKey) {
        if ((value & Integer.MIN_VALUE) == 0) {
            return false;
        }
        if ((value & 0x40000000) == 0) {
            return false;
        }
        int wanted = (digestedRoutingKey[2] & 0xFF) + ((digestedRoutingKey[1] & 0xFF) << 8) + ((digestedRoutingKey[0] & 0xFF) << 16);
        int got = value & 0xFFFFFF;
        return wanted == got;
    }

    private long translateSlotFlagsToEntryFlags(int cache) {
        long ret = 0L;
        if ((cache & 0x40000000) != 0) {
            ret |= 1L;
        }
        if ((cache & 0x20000000) != 0) {
            ret |= 4L;
        }
        if ((cache & 0x10000000) != 0) {
            ret |= 8L;
        }
        return ret;
    }

    private boolean slotCacheIsFree(int value) {
        return (value & 0x40000000) == 0;
    }

    private boolean openStoreFiles(File baseDir, String name) throws IOException {
        this.metaFile = new File(baseDir, name + ".metadata");
        this.hdFile = new File(baseDir, name + ".hd");
        boolean newStore = !this.metaFile.exists() || !this.hdFile.exists();
        this.metaRAF = new RandomAccessFile(this.metaFile, "rw");
        this.metaFC = this.metaRAF.getChannel();
        this.metaFC.lock();
        this.hdRAF = new RandomAccessFile(this.hdFile, "rw");
        this.hdFC = this.hdRAF.getChannel();
        this.hdFC.lock();
        return newStore;
    }

    private Entry readEntry(long offset, byte[] digestedRoutingKey, byte[] routingKey, boolean withData) throws IOException {
        if (offset >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int cache = 0;
        boolean validCache = false;
        boolean likelyMatch = false;
        if (digestedRoutingKey != null && !this.slotFilterDisabled) {
            cache = this.slotFilter.get((int)offset);
            validCache = (cache & Integer.MIN_VALUE) != 0;
            likelyMatch = this.slotCacheLikelyMatch(cache, digestedRoutingKey);
            if (validCache && !likelyMatch) {
                return null;
            }
        }
        if (validCache && logMINOR) {
            if (likelyMatch) {
                Logger.minor(this, "Likely match");
            } else {
                Logger.minor(this, "Unlikely match");
            }
        }
        ByteBuffer mbf = ByteBuffer.allocate(128);
        do {
            int status;
            if ((status = this.metaFC.read(mbf, 128L * offset + (long)mbf.position())) != -1) continue;
            Logger.error(this, "Failed to access offset " + offset, (Throwable)new Exception("error"));
            throw new EOFException();
        } while (mbf.hasRemaining());
        mbf.flip();
        Entry entry = new Entry(mbf, null);
        entry.curOffset = offset;
        byte[] slotDigestedRoutingKey = entry.digestedRoutingKey;
        int trueCache = entry.getSlotFilterEntry();
        if (trueCache != cache && !this.slotFilterDisabled) {
            if (validCache) {
                Logger.error(this, "Slot cache has changed for slot " + offset + " from " + cache + " to " + trueCache);
            }
            this.slotFilter.put((int)offset, trueCache);
        }
        if (routingKey != null) {
            if (entry.isFree()) {
                if (validCache && !likelyMatch && !this.slotCacheIsFree(cache)) {
                    Logger.error(this, "Slot falsely identified as non-free on slot " + offset + " cache was " + cache);
                    this.bloomFalsePos.incrementAndGet();
                } else if (logMINOR && validCache && !likelyMatch && this.slotCacheIsFree(cache)) {
                    Logger.minor(this, "True negative!");
                }
                return null;
            }
            if (!Arrays.equals(digestedRoutingKey, slotDigestedRoutingKey)) {
                if (validCache && likelyMatch) {
                    Logger.normal(this, "False positive from slot cache on slot " + offset + " cache was " + cache);
                    this.bloomFalsePos.incrementAndGet();
                } else if (logMINOR && validCache && !likelyMatch) {
                    Logger.minor(this, "True negative!");
                }
                return null;
            }
            if (validCache && !likelyMatch) {
                Logger.error(this, "False NEGATIVE from slot cache on slot " + offset + " cache was " + cache);
                this.bloomFalsePos.incrementAndGet();
            }
            if (withData) {
                ByteBuffer hdBuf = this.readHD(offset);
                entry.setHD(hdBuf);
                boolean decrypted = this.cipherManager.decrypt(entry, routingKey);
                if (!decrypted) {
                    if (logMINOR && validCache && likelyMatch) {
                        Logger.minor(this, "True positive but decrypt failed on slot " + offset + " cache was " + cache);
                    }
                    return null;
                }
                if (logMINOR && validCache && likelyMatch) {
                    Logger.minor(this, "True positive!");
                }
            }
        }
        return entry;
    }

    private ByteBuffer readHD(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.headerBlockLength + this.dataBlockLength + this.hdPadding);
        long pos = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * offset;
        do {
            int status;
            if ((status = this.hdFC.read(buf, pos + (long)buf.position())) != -1) continue;
            throw new EOFException();
        } while (buf.hasRemaining());
        buf.flip();
        return buf;
    }

    private long getFlag(long offset, boolean forceReadEntry) throws IOException {
        int cache;
        if (!forceReadEntry && !this.slotFilterDisabled && ((cache = this.slotFilter.get((int)offset)) & Integer.MIN_VALUE) != 0) {
            return this.translateSlotFlagsToEntryFlags(cache);
        }
        Entry entry = this.readEntry(offset, null, null, false);
        return entry.flag;
    }

    private boolean isFree(long offset) throws IOException {
        int cache;
        if (!this.slotFilterDisabled && ((cache = this.slotFilter.get((int)offset)) & Integer.MIN_VALUE) != 0) {
            return this.slotCacheIsFree(cache);
        }
        Entry entry = this.readEntry(offset, null, null, false);
        return entry.isFree();
    }

    private byte[] getDigestedKeyFromOffset(long offset) throws IOException {
        Entry entry = this.readEntry(offset, null, null, false);
        return entry.getDigestedRoutingKey();
    }

    private void writeEntry(Entry entry, byte[] digestedRoutingKey, long offset) throws IOException {
        if (offset >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (!this.slotFilterDisabled) {
            this.slotFilter.put((int)offset, entry.getSlotFilterEntry(digestedRoutingKey, entry.flag));
        }
        this.cipherManager.encrypt(entry, this.random);
        ByteBuffer bf = entry.toMetaDataBuffer();
        do {
            int status;
            if ((status = this.metaFC.write(bf, 128L * offset + (long)bf.position())) != -1) continue;
            throw new EOFException();
        } while (bf.hasRemaining());
        bf = entry.toHDBuffer();
        if (bf != null) {
            long pos = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * offset;
            do {
                int status;
                if ((status = this.hdFC.write(bf, pos + (long)bf.position())) != -1) continue;
                throw new EOFException();
            } while (bf.hasRemaining());
        }
        entry.curOffset = offset;
    }

    private void flushAndClose(boolean abort) {
        Logger.normal(this, "Flush and closing this store: " + this.name);
        try {
            this.metaFC.force(true);
            this.metaFC.close();
        }
        catch (Exception e) {
            Logger.error(this, "error flusing store", (Throwable)e);
        }
        try {
            this.hdFC.force(true);
            this.hdFC.close();
        }
        catch (Exception e) {
            Logger.error(this, "error flusing store", (Throwable)e);
        }
        if (!this.slotFilterDisabled) {
            if (!abort) {
                this.slotFilter.shutdown();
            } else {
                this.slotFilter.abort();
            }
        }
    }

    public void setPreallocate(boolean preallocate) {
        this.preallocate = preallocate;
    }

    private void setStoreFileSize(long storeMaxEntries) {
        try {
            long oldMetaLen = this.metaRAF.length();
            long currentHdLen = this.hdRAF.length();
            long newMetaLen = 128L * storeMaxEntries;
            long newHdLen = (long)(this.headerBlockLength + this.dataBlockLength + this.hdPadding) * storeMaxEntries;
            if (this.preallocate && (oldMetaLen < newMetaLen || currentHdLen < newHdLen)) {
                try (WrapperKeepalive wrapperKeepalive = new WrapperKeepalive();){
                    wrapperKeepalive.start();
                    Fallocate.forChannel(this.metaFC, newMetaLen).fromOffset(oldMetaLen).execute();
                    Fallocate.forChannel(this.hdFC, newHdLen).fromOffset(currentHdLen).execute();
                }
            }
            this.storeFileOffsetReady = 1L + storeMaxEntries;
            this.metaRAF.setLength(newMetaLen);
            this.hdRAF.setLength(newHdLen);
        }
        catch (IOException e) {
            Logger.error(this, "error resizing store file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfigFile(byte[] masterKey) throws IOException {
        boolean bl;
        assert (this.cipherManager == null);
        if (!this.configFile.exists()) {
            byte[] newsalt = new byte[16];
            this.random.nextBytes(newsalt);
            byte[] diskSalt = newsalt;
            if (masterKey != null) {
                Rijndael cipher;
                try {
                    cipher = new Rijndael(256, 128);
                }
                catch (UnsupportedCipherException e) {
                    throw new Error("Impossible: no Rijndael(256,128): " + e, e);
                }
                cipher.initialize(masterKey);
                diskSalt = new byte[16];
                cipher.encipher(newsalt, diskSalt);
                if (logDEBUG) {
                    Logger.debug(this, "Encrypting with " + HexUtil.bytesToHex(newsalt) + " from " + HexUtil.bytesToHex(diskSalt));
                }
            }
            this.cipherManager = new CipherManager(newsalt, diskSalt);
            this.writeConfigFile();
            return true;
        }
        RandomAccessFile raf = new RandomAccessFile(this.configFile, "r");
        try {
            byte[] salt = new byte[16];
            raf.readFully(salt);
            byte[] diskSalt = salt;
            if (masterKey != null) {
                Rijndael cipher;
                try {
                    cipher = new Rijndael(256, 128);
                }
                catch (UnsupportedCipherException e) {
                    throw new Error("Impossible: no Rijndael(256,128): " + e, e);
                }
                cipher.initialize(masterKey);
                salt = new byte[16];
                cipher.decipher(diskSalt, salt);
                if (logDEBUG) {
                    Logger.debug(this, "Encrypting (new) with " + HexUtil.bytesToHex(salt) + " from " + HexUtil.bytesToHex(diskSalt));
                }
            }
            this.cipherManager = new CipherManager(salt, diskSalt);
            this.storeSize = raf.readLong();
            if (this.storeSize <= 0L) {
                throw new IOException("Bogus datastore size");
            }
            this.prevStoreSize = raf.readLong();
            this.keyCount.set(raf.readLong());
            this.generation = raf.readInt();
            this.flags = raf.readInt();
            if ((this.flags & 1) != 0 && ResizablePersistentIntBuffer.getPersistenceTime() != -1) {
                this.flags |= 2;
            }
            try {
                raf.readInt();
                raf.readInt();
                raf.readLong();
                long w = raf.readLong();
                this.writes.set(w);
                this.initialWrites = w;
                Logger.normal(this, "Set writes to saved value " + w);
                this.hits.set(raf.readLong());
                this.initialHits = this.hits.get();
                this.misses.set(raf.readLong());
                this.initialMisses = this.misses.get();
                this.bloomFalsePos.set(raf.readLong());
                this.initialBloomFalsePos = this.bloomFalsePos.get();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                Closer.close(raf);
                throw throwable;
            }
            catch (IOException e) {
                Logger.error(this, "config file corrupted, trying to create a new store: " + this.name, (Throwable)e);
                System.err.println("config file corrupted, trying to create a new store: " + this.name);
                if (this.configFile.exists() && this.configFile.delete()) {
                    File metaFile = new File(this.baseDir, this.name + ".metadata");
                    metaFile.delete();
                    return this.loadConfigFile(masterKey);
                }
                Logger.error(this, "can't delete config file, please delete the store manually: " + this.name, (Throwable)e);
                System.err.println("can't delete config file, please delete the store manually: " + this.name);
                throw e;
            }
        }
        Closer.close(raf);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigFile() {
        this.configLock.writeLock().lock();
        try {
            File tempConfig = new File(this.configFile.getPath() + ".tmp");
            RandomAccessFile raf = new RandomAccessFile(tempConfig, "rw");
            raf.seek(0L);
            raf.write(this.cipherManager.getDiskSalt());
            raf.writeLong(this.storeSize);
            raf.writeLong(this.prevStoreSize);
            raf.writeLong(this.keyCount.get());
            raf.writeInt(this.generation);
            raf.writeInt(this.flags);
            raf.writeInt(0);
            raf.writeInt(0);
            raf.writeLong(0L);
            raf.writeLong(this.writes.get());
            raf.writeLong(this.hits.get());
            raf.writeLong(this.misses.get());
            raf.writeLong(this.bloomFalsePos.get());
            raf.getFD().sync();
            raf.close();
            FileUtil.renameTo(tempConfig, this.configFile);
        }
        catch (IOException ioe) {
            Logger.error(this, "error writing config file for " + this.name, (Throwable)ioe);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    @Override
    public void setUserAlertManager(UserAlertManager userAlertManager) {
        if (this.cleanerStatusUserAlert != null) {
            userAlertManager.register(this.cleanerStatusUserAlert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxKeys(long newStoreSize, boolean shrinkNow) throws IOException {
        long old;
        Logger.normal(this, "[" + this.name + "] Resize newStoreSize=" + newStoreSize + ", shinkNow=" + shrinkNow);
        if (newStoreSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Store size over MAXINT not supported due to ResizablePersistentIntBuffer limitations.");
        }
        this.configLock.writeLock().lock();
        try {
            if (newStoreSize == this.storeSize) {
                return;
            }
            if (this.prevStoreSize != 0L) {
                Logger.normal(this, "[" + this.name + "] resize already in progress, ignore resize request");
                return;
            }
            old = this.storeSize;
            this.prevStoreSize = this.storeSize;
            this.storeSize = newStoreSize;
            if (!this.slotFilterDisabled) {
                this.slotFilter.resize((int)Math.max(this.storeSize, this.prevStoreSize));
            }
            this.writeConfigFile();
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        if (this.cleanerLock.tryLock()) {
            this.cleanerCondition.signal();
            this.cleanerLock.unlock();
        }
        if (shrinkNow) {
            this.configLock.writeLock().lock();
            try {
                System.err.println("Waiting for resize to complete...");
                while (this.prevStoreSize == old) {
                    this.resizeCompleteCondition.awaitUninterruptibly();
                }
                System.err.println("Completed shrink, old size was " + old + " new size was " + newStoreSize + " size is now " + this.storeSize + " (prev=" + this.prevStoreSize + ")");
            }
            finally {
                this.configLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<Long, Condition> lockDigestedKey(byte[] digestedKey, boolean usePrevStoreSize) {
        long l;
        Condition condition;
        void var7_9;
        long[] offsetArray;
        TreeSet<Long> offsets = new TreeSet<Long>();
        long[] arr$ = offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.storeSize);
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            long offset2 = arr$[var7_9];
            offsets.add(offset2);
            ++var7_9;
        }
        if (usePrevStoreSize && this.prevStoreSize != 0L) {
            void var7_11;
            arr$ = offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.prevStoreSize);
            len$ = arr$.length;
            boolean bl2 = false;
            while (var7_11 < len$) {
                long offset = arr$[var7_11];
                offsets.add(offset);
                ++var7_11;
            }
        }
        TreeMap<Long, Condition> locked = new TreeMap<Long, Condition>();
        Iterator<Object> i$ = offsets.iterator();
        while (i$.hasNext() && (condition = this.lockManager.lockEntry(l = ((Long)i$.next()).longValue())) != null) {
            locked.put(l, condition);
        }
        if (locked.size() == offsets.size()) {
            return locked;
        }
        for (Map.Entry entry : locked.entrySet()) {
            this.lockManager.unlockEntry((Long)entry.getKey(), (Condition)entry.getValue());
        }
        return null;
    }

    private void unlockDigestedKey(byte[] digestedKey, boolean usePrevStoreSize, Map<Long, Condition> lockMap) {
        long[] offsetArray;
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (long offset : offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.storeSize)) {
            offsets.add(offset);
        }
        if (usePrevStoreSize && this.prevStoreSize != 0L) {
            for (long offset : offsetArray = this.getOffsetFromDigestedKey(digestedKey, this.prevStoreSize)) {
                offsets.add(offset);
            }
        }
        Iterator i$ = offsets.iterator();
        while (i$.hasNext()) {
            long offset = (Long)i$.next();
            this.lockManager.unlockEntry(offset, lockMap.get(offset));
            lockMap.remove(offset);
        }
    }

    private long[] getOffsetFromPlainKey(byte[] plainKey, long storeSize) {
        return this.getOffsetFromDigestedKey(this.cipherManager.getDigestedKey(plainKey), storeSize);
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean abort) {
        this.shutdown = true;
        this.lockManager.shutdown();
        this.cleanerLock.lock();
        try {
            this.cleanerCondition.signalAll();
            this.cleanerThread.interrupt();
        }
        finally {
            this.cleanerLock.unlock();
        }
        this.configLock.writeLock().lock();
        try {
            this.flushAndClose(abort);
            this.flags &= 0xFFFFFFFE;
            this.writeConfigFile();
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        this.cipherManager.shutdown();
        System.out.println("Successfully closed store " + this.name);
    }

    private long[] getOffsetFromDigestedKey(byte[] digestedKey, long storeSize) {
        long keyValue = Fields.bytesToLong(digestedKey);
        long[] offsets = new long[5];
        for (int i = 0; i < 5; ++i) {
            boolean clear;
            offsets[i] = (keyValue + (long)(141 * (i * i)) + (long)(13 * i) & Long.MAX_VALUE) % storeSize;
            do {
                clear = true;
                for (int j = 0; j < i; ++j) {
                    if (offsets[i] != offsets[j]) continue;
                    offsets[i] = (offsets[i] + 1L) % storeSize;
                    clear = false;
                }
            } while (!clear && 5L <= storeSize);
        }
        return offsets;
    }

    @Override
    public long hits() {
        return this.hits.get();
    }

    @Override
    public long misses() {
        return this.misses.get();
    }

    @Override
    public long writes() {
        return this.writes.get();
    }

    @Override
    public long keyCount() {
        return this.keyCount.get();
    }

    @Override
    public long getMaxKeys() {
        this.configLock.readLock().lock();
        long _storeSize = this.storeSize;
        this.configLock.readLock().unlock();
        return _storeSize;
    }

    @Override
    public long getBloomFalsePositive() {
        return this.bloomFalsePos.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probablyInStore(byte[] routingKey) {
        this.configLock.readLock().lock();
        try {
            boolean likelyMatch;
            boolean validCache;
            int cache;
            if (this.slotFilterDisabled) {
                boolean bl = true;
                return bl;
            }
            byte[] digestedKey = this.cipherManager.getDigestedKey(routingKey);
            long[] offsets = this.getOffsetFromDigestedKey(digestedKey, this.storeSize);
            boolean anyNotValid = false;
            for (long offset : offsets) {
                if (offset > Integer.MAX_VALUE) {
                    boolean bl = true;
                    return bl;
                }
                cache = 0;
                validCache = false;
                likelyMatch = false;
                cache = this.slotFilter.get((int)offset);
                boolean bl = validCache = (cache & Integer.MIN_VALUE) != 0;
                if (!validCache) {
                    anyNotValid = true;
                    continue;
                }
                likelyMatch = this.slotCacheLikelyMatch(cache, digestedKey);
                if (!validCache || !likelyMatch) continue;
                boolean bl2 = true;
                return bl2;
            }
            if (this.prevStoreSize != 0L) {
                offsets = this.getOffsetFromDigestedKey(digestedKey, this.prevStoreSize);
            }
            for (long offset : offsets) {
                if (offset > Integer.MAX_VALUE) {
                    cache = 1;
                    return cache != 0;
                }
                cache = 0;
                validCache = false;
                likelyMatch = false;
                cache = this.slotFilter.get((int)offset);
                boolean bl = validCache = (cache & Integer.MIN_VALUE) != 0;
                if (!validCache) {
                    anyNotValid = true;
                    continue;
                }
                likelyMatch = this.slotCacheLikelyMatch(cache, digestedKey);
                if (!validCache || !likelyMatch) continue;
                boolean bl3 = true;
                return bl3;
            }
            if (anyNotValid) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    public void destruct() {
        this.metaFile.delete();
        this.hdFile.delete();
        this.configFile.delete();
        this.bloomFile.delete();
    }

    public String toString() {
        return super.toString() + ":" + this.name;
    }

    @Override
    public StoreAccessStats getSessionAccessStats() {
        return new StoreAccessStats(){

            @Override
            public long hits() {
                return SaltedHashFreenetStore.this.hits.get() - SaltedHashFreenetStore.this.initialHits;
            }

            @Override
            public long misses() {
                return SaltedHashFreenetStore.this.misses.get() - SaltedHashFreenetStore.this.initialMisses;
            }

            @Override
            public long falsePos() {
                return SaltedHashFreenetStore.this.bloomFalsePos.get() - SaltedHashFreenetStore.this.initialBloomFalsePos;
            }

            @Override
            public long writes() {
                return SaltedHashFreenetStore.this.writes.get() - SaltedHashFreenetStore.this.initialWrites;
            }
        };
    }

    @Override
    public StoreAccessStats getTotalAccessStats() {
        return new StoreAccessStats(){

            @Override
            public long hits() {
                return SaltedHashFreenetStore.this.hits.get();
            }

            @Override
            public long misses() {
                return SaltedHashFreenetStore.this.misses.get();
            }

            @Override
            public long falsePos() {
                return SaltedHashFreenetStore.this.bloomFalsePos.get();
            }

            @Override
            public long writes() {
                return SaltedHashFreenetStore.this.writes.get();
            }
        };
    }

    public void forceValidEmpty() {
        this.slotFilter.replaceAllEntries(0, Integer.MIN_VALUE);
    }

    @Override
    public FreenetStore<T> getUnderlyingStore() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testingWaitForCleanerDone(int delay, int count) throws InterruptedException {
        for (int i = 0; i < count; ++i) {
            this.configLock.readLock().lock();
            try {
                if ((this.flags & 2) == 0) {
                    return;
                }
            }
            finally {
                this.configLock.readLock().unlock();
            }
            Thread.sleep(delay);
        }
        throw new AssertionError();
    }

    static /* synthetic */ LockManager access$4200(SaltedHashFreenetStore x0) {
        return x0.lockManager;
    }

    static /* synthetic */ FileChannel access$4300(SaltedHashFreenetStore x0) {
        return x0.metaFC;
    }

    static {
        NO_CLEANER_SLEEP = false;
        cleanerGlobalLock = new ReentrantLock();
    }

    public class ShutdownDB
    implements Runnable {
        @Override
        public void run() {
            SaltedHashFreenetStore.this.close();
        }
    }

    private final class CleanerStatusUserAlert
    extends AbstractUserAlert {
        private Cleaner cleaner;

        private CleanerStatusUserAlert(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public String anchor() {
            return "store-cleaner-" + SaltedHashFreenetStore.this.name;
        }

        @Override
        public String dismissButtonText() {
            return NodeL10n.getBase().getString("UserAlert.hide");
        }

        @Override
        public HTMLNode getHTMLText() {
            return new HTMLNode("#", this.getText());
        }

        @Override
        public short getPriorityClass() {
            return 1;
        }

        @Override
        public String getShortText() {
            if (this.cleaner.isResizing) {
                return NodeL10n.getBase().getString("SaltedHashFreenetStore.shortResizeProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, String.valueOf(this.cleaner.entriesTotal - this.cleaner.entriesLeft), String.valueOf(this.cleaner.entriesTotal)});
            }
            return NodeL10n.getBase().getString("SaltedHashFreenetStore.shortRebuildProgress" + (SaltedHashFreenetStore.this.slotFilter.isNew() ? "New" : ""), new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, String.valueOf(this.cleaner.entriesTotal - this.cleaner.entriesLeft), String.valueOf(this.cleaner.entriesTotal)});
        }

        @Override
        public String getText() {
            if (this.cleaner.isResizing) {
                return NodeL10n.getBase().getString("SaltedHashFreenetStore.longResizeProgress", new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, String.valueOf(this.cleaner.entriesTotal - this.cleaner.entriesLeft), String.valueOf(this.cleaner.entriesTotal)});
            }
            return NodeL10n.getBase().getString("SaltedHashFreenetStore.longRebuildProgress" + (SaltedHashFreenetStore.this.slotFilter.isNew() ? "New" : ""), new String[]{"name", "processed", "total"}, new String[]{SaltedHashFreenetStore.this.name, String.valueOf(this.cleaner.entriesTotal - this.cleaner.entriesLeft), String.valueOf(this.cleaner.entriesTotal)});
        }

        @Override
        public String getTitle() {
            return NodeL10n.getBase().getString("SaltedHashFreenetStore.cleanerAlertTitle", new String[]{"name"}, new String[]{SaltedHashFreenetStore.this.name});
        }

        @Override
        public boolean isValid() {
            return this.cleaner.isRebuilding || this.cleaner.isResizing;
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public void onDismiss() {
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        @Override
        public boolean userCanDismiss() {
            return false;
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }
    }

    private class Cleaner
    extends NativeThread {
        private static final int CLEANER_PERIOD = 300000;
        private volatile boolean isRebuilding;
        private volatile boolean isResizing;
        private static final int RESIZE_MEMORY_ENTRIES = 128;
        private volatile long entriesLeft;
        private volatile long entriesTotal;

        public Cleaner() {
            super("Store-" + SaltedHashFreenetStore.this.name + "-Cleaner", NativeThread.LOW_PRIORITY, false);
            this.setPriority(MIN_PRIORITY);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void realRun() {
            if (!NO_CLEANER_SLEEP) {
                try {
                    Thread.sleep((int)(150000.0 + 300000.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (SaltedHashFreenetStore.this.shutdown) {
                return;
            }
            while (!SaltedHashFreenetStore.this.shutdown) {
                SaltedHashFreenetStore.this.cleanerLock.lock();
                try {
                    boolean _rebuildBloom;
                    long _prevStoreSize;
                    SaltedHashFreenetStore.this.configLock.readLock().lock();
                    try {
                        _prevStoreSize = SaltedHashFreenetStore.this.prevStoreSize;
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                    }
                    if (_prevStoreSize != 0L && cleanerGlobalLock.tryLock()) {
                        try {
                            this.isResizing = true;
                            this.resizeStore(_prevStoreSize, true);
                        }
                        finally {
                            this.isResizing = false;
                            cleanerGlobalLock.unlock();
                        }
                    }
                    SaltedHashFreenetStore.this.configLock.readLock().lock();
                    try {
                        _rebuildBloom = (SaltedHashFreenetStore.this.flags & 2) != 0;
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.readLock().unlock();
                    }
                    if (_rebuildBloom && SaltedHashFreenetStore.this.prevStoreSize == 0L && cleanerGlobalLock.tryLock()) {
                        try {
                            this.isRebuilding = true;
                            this.rebuildBloom(false);
                        }
                        finally {
                            this.isRebuilding = false;
                            cleanerGlobalLock.unlock();
                        }
                    }
                    SaltedHashFreenetStore.this.writeConfigFile();
                    try {
                        SaltedHashFreenetStore.this.cleanerCondition.await(300000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Logger.debug(this, "interrupted", (Throwable)e);
                    }
                }
                finally {
                    SaltedHashFreenetStore.this.cleanerLock.unlock();
                }
            }
        }

        private void resizeStore(final long _prevStoreSize, boolean sleep) {
            Logger.normal(this, "Starting datastore resize");
            System.out.println("Resizing datastore " + SaltedHashFreenetStore.this.name);
            BatchProcessor resizeProcesser = new BatchProcessor<T>(){
                Deque<Entry> oldEntryList = new LinkedList<Entry>();
                int i = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init() {
                    if (SaltedHashFreenetStore.this.storeSize > _prevStoreSize) {
                        SaltedHashFreenetStore.this.setStoreFileSize(SaltedHashFreenetStore.this.storeSize);
                    }
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.generation++;
                        SaltedHashFreenetStore.this.keyCount.set(0L);
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    WrapperManager.signalStarting((int)((int)(128L * TimeUnit.SECONDS.toMillis(30L) + TimeUnit.SECONDS.toMillis(1L))));
                }

                @Override
                public Entry process(Entry entry) {
                    int oldGeneration = entry.generation;
                    if (oldGeneration != SaltedHashFreenetStore.this.generation) {
                        entry.generation = SaltedHashFreenetStore.this.generation;
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                    }
                    if (entry.storeSize == SaltedHashFreenetStore.this.storeSize) {
                        if (entry.generation != SaltedHashFreenetStore.this.generation) {
                            return entry;
                        }
                        return SaltedHashFreenetStore.this.NOT_MODIFIED;
                    }
                    if (oldGeneration == SaltedHashFreenetStore.this.generation) {
                        Logger.error(this, "new generation object with wrong storeSize. DigestedRoutingKey=" + HexUtil.bytesToHex(entry.getDigestedRoutingKey()) + ", Offset=" + entry.curOffset);
                    }
                    try {
                        entry.setHD(SaltedHashFreenetStore.this.readHD(entry.curOffset));
                        this.oldEntryList.add(entry);
                        if (this.oldEntryList.size() > 128) {
                            this.oldEntryList.poll();
                        }
                    }
                    catch (IOException e) {
                        Logger.error(this, "error reading entry (offset=" + entry.curOffset + ")", (Throwable)e);
                    }
                    return null;
                }

                @Override
                public boolean batch(long entriesLeft) {
                    WrapperManager.signalStarting((int)((int)(128L * TimeUnit.SECONDS.toMillis(30L) + TimeUnit.SECONDS.toMillis(1L))));
                    if (this.i++ % 16 == 0) {
                        SaltedHashFreenetStore.this.writeConfigFile();
                    }
                    if (SaltedHashFreenetStore.this.storeSize < _prevStoreSize) {
                        SaltedHashFreenetStore.this.setStoreFileSize(Math.max(SaltedHashFreenetStore.this.storeSize, entriesLeft));
                    }
                    Iterator<Entry> it = this.oldEntryList.iterator();
                    while (it.hasNext()) {
                        if (!Cleaner.this.resolveOldEntry(it.next())) continue;
                        it.remove();
                    }
                    return _prevStoreSize == SaltedHashFreenetStore.this.prevStoreSize;
                }

                @Override
                public void abort() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finish() {
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        if (_prevStoreSize != SaltedHashFreenetStore.this.prevStoreSize) {
                            return;
                        }
                        SaltedHashFreenetStore.this.prevStoreSize = 0L;
                        if (!SaltedHashFreenetStore.this.slotFilterDisabled) {
                            if (SaltedHashFreenetStore.this.slotFilter.size() != (int)SaltedHashFreenetStore.this.storeSize) {
                                SaltedHashFreenetStore.this.slotFilter.resize((int)SaltedHashFreenetStore.this.storeSize);
                            } else {
                                SaltedHashFreenetStore.this.slotFilter.forceWrite();
                            }
                        }
                        SaltedHashFreenetStore.this.flags &= -3;
                        SaltedHashFreenetStore.this.resizeCompleteCondition.signalAll();
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    Logger.normal(this, "Finish resizing (" + SaltedHashFreenetStore.this.name + ")");
                }

                @Override
                public boolean wantFreeEntries() {
                    return false;
                }
            };
            this.batchProcessEntries(resizeProcesser, _prevStoreSize, true, sleep);
        }

        private void rebuildBloom(boolean sleep) {
            if (SaltedHashFreenetStore.this.slotFilterDisabled) {
                return;
            }
            Logger.normal(this, "Start rebuilding slot filter (" + SaltedHashFreenetStore.this.name + ")");
            BatchProcessor rebuildBloomProcessor = new BatchProcessor<T>(){
                int i = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init() {
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.keyCount.set(0L);
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    WrapperManager.signalStarting((int)((int)(128L * TimeUnit.SECONDS.toMillis(5L) + TimeUnit.SECONDS.toMillis(1L))));
                }

                @Override
                public Entry process(Entry entry) {
                    if (!SaltedHashFreenetStore.this.slotFilterDisabled) {
                        int cache = entry.getSlotFilterEntry();
                        try {
                            SaltedHashFreenetStore.this.slotFilter.put((int)entry.curOffset, cache, true);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Unable to update slot filter in bloom rebuild: " + e, (Throwable)e);
                        }
                    }
                    if (!entry.isFree()) {
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                        if (entry.generation != SaltedHashFreenetStore.this.generation) {
                            entry.generation = SaltedHashFreenetStore.this.generation;
                            return entry;
                        }
                    }
                    return SaltedHashFreenetStore.this.NOT_MODIFIED;
                }

                @Override
                public boolean batch(long entriesLeft) {
                    WrapperManager.signalStarting((int)((int)(128L * TimeUnit.SECONDS.toMillis(5L) + TimeUnit.SECONDS.toMillis(1L))));
                    if (this.i++ % 16 == 0) {
                        SaltedHashFreenetStore.this.writeConfigFile();
                    }
                    if (this.i++ % 1024 == 0 && !SaltedHashFreenetStore.this.slotFilterDisabled) {
                        SaltedHashFreenetStore.this.slotFilter.forceWrite();
                    }
                    return SaltedHashFreenetStore.this.prevStoreSize == 0L;
                }

                @Override
                public void abort() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void finish() {
                    SaltedHashFreenetStore.this.slotFilter.forceWrite();
                    SaltedHashFreenetStore.this.configLock.writeLock().lock();
                    try {
                        SaltedHashFreenetStore.this.flags &= -3;
                        SaltedHashFreenetStore.this.writeConfigFile();
                    }
                    finally {
                        SaltedHashFreenetStore.this.configLock.writeLock().unlock();
                    }
                    System.out.println(SaltedHashFreenetStore.this.name + " cleaner finished successfully.");
                    Logger.normal(this, "Finish rebuilding bloom filter (" + SaltedHashFreenetStore.this.name + ")");
                }

                @Override
                public boolean wantFreeEntries() {
                    return true;
                }
            };
            this.batchProcessEntries(rebuildBloomProcessor, SaltedHashFreenetStore.this.storeSize, false, sleep);
        }

        private void batchProcessEntries(BatchProcessor<T> processor, long storeSize, boolean reverse, boolean sleep) {
            long step;
            long startOffset;
            this.entriesLeft = this.entriesTotal = storeSize;
            if (!reverse) {
                startOffset = 0L;
                step = 128L;
            } else {
                startOffset = (storeSize - 1L) / 128L * 128L;
                step = -128L;
            }
            int i = 0;
            processor.init();
            try {
                for (long curOffset = startOffset; curOffset >= 0L && curOffset < storeSize; curOffset += step) {
                    if (SaltedHashFreenetStore.this.shutdown) {
                        processor.abort();
                        return;
                    }
                    if (i++ % 64 == 0) {
                        System.err.println(SaltedHashFreenetStore.this.name + " cleaner in progress: " + (this.entriesTotal - this.entriesLeft) + "/" + this.entriesTotal);
                    }
                    this.batchProcessEntries(curOffset, 128, processor);
                    long l = this.entriesLeft = reverse ? curOffset : Math.max(storeSize - curOffset - 128L, 0L);
                    if (!processor.batch(this.entriesLeft)) {
                        processor.abort();
                        return;
                    }
                    try {
                        if (!sleep) continue;
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        processor.abort();
                        return;
                    }
                }
                processor.finish();
            }
            catch (Exception e) {
                Logger.error(this, "Caught: " + e + " while shrinking", (Throwable)e);
                processor.abort();
            }
        }

        /*
         * Exception decompiling
         */
        private boolean batchProcessEntries(long offset, int length, BatchProcessor<T> processor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resolveOldEntry(Entry entry) {
            Map lockMap = SaltedHashFreenetStore.this.lockDigestedKey(entry.getDigestedRoutingKey(), false);
            if (lockMap == null) {
                return false;
            }
            try {
                long[] offsets;
                entry.storeSize = SaltedHashFreenetStore.this.storeSize;
                for (long offset : offsets = entry.getOffset()) {
                    try {
                        if (SaltedHashFreenetStore.this.isFree(offset) || !Arrays.equals(SaltedHashFreenetStore.this.getDigestedKeyFromOffset(offset), entry.getDigestedRoutingKey())) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        Logger.debug(this, "IOExcception on resolveOldEntry", (Throwable)e);
                    }
                }
                for (long offset : offsets) {
                    try {
                        if (!SaltedHashFreenetStore.this.isFree(offset)) continue;
                        byte[] digestedKey = entry.getDigestedRoutingKey();
                        SaltedHashFreenetStore.this.writeEntry(entry, digestedKey, offset);
                        SaltedHashFreenetStore.this.keyCount.incrementAndGet();
                        boolean bl = true;
                        return bl;
                    }
                    catch (IOException e) {
                        Logger.debug(this, "IOExcception on resolveOldEntry", (Throwable)e);
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                SaltedHashFreenetStore.this.unlockDigestedKey(entry.getDigestedRoutingKey(), false, lockMap);
            }
        }
    }

    private static interface BatchProcessor<T extends StorableBlock> {
        public void init();

        public boolean batch(long var1);

        public void abort();

        public void finish();

        public Entry process(Entry var1);

        public boolean wantFreeEntries();
    }

    class Entry {
        private static final long ENTRY_FLAG_OCCUPIED = 1L;
        private static final long ENTRY_FLAG_PLAINKEY = 2L;
        private static final long ENTRY_NEW_BLOCK = 4L;
        private static final long ENTRY_WRONG_STORE = 8L;
        private static final int METADATA_LENGTH = 128;
        byte[] plainRoutingKey;
        byte[] digestedRoutingKey;
        byte[] dataEncryptIV;
        private long flag;
        private long storeSize;
        private int generation;
        byte[] header;
        byte[] data;
        boolean isEncrypted;
        private long curOffset = -1L;

        private Entry() {
        }

        private Entry(ByteBuffer metaDataBuf, ByteBuffer hdBuf) {
            assert (metaDataBuf.remaining() == 128);
            this.digestedRoutingKey = new byte[32];
            metaDataBuf.get(this.digestedRoutingKey);
            this.dataEncryptIV = new byte[16];
            metaDataBuf.get(this.dataEncryptIV);
            this.flag = metaDataBuf.getLong();
            this.storeSize = metaDataBuf.getLong();
            if ((this.flag & 2L) != 0L) {
                this.plainRoutingKey = new byte[32];
                metaDataBuf.get(this.plainRoutingKey);
            }
            metaDataBuf.position(96);
            this.generation = metaDataBuf.getInt();
            this.isEncrypted = true;
            if (hdBuf != null) {
                this.setHD(hdBuf);
            }
        }

        private void setHD(ByteBuffer hdBuf) {
            assert (hdBuf.remaining() == SaltedHashFreenetStore.this.headerBlockLength + SaltedHashFreenetStore.this.dataBlockLength + SaltedHashFreenetStore.this.hdPadding);
            assert (this.isEncrypted);
            this.header = new byte[SaltedHashFreenetStore.this.headerBlockLength];
            hdBuf.get(this.header);
            this.data = new byte[SaltedHashFreenetStore.this.dataBlockLength];
            hdBuf.get(this.data);
        }

        private Entry(byte[] plainRoutingKey, byte[] header, byte[] data, boolean newBlock, boolean wrongStore) {
            this.plainRoutingKey = plainRoutingKey;
            this.flag = 1L;
            if (newBlock) {
                this.flag |= 4L;
            }
            if (wrongStore) {
                this.flag |= 8L;
            }
            this.storeSize = SaltedHashFreenetStore.this.storeSize;
            this.generation = SaltedHashFreenetStore.this.generation;
            this.header = Arrays.copyOf(header, SaltedHashFreenetStore.this.headerBlockLength);
            this.data = Arrays.copyOf(data, SaltedHashFreenetStore.this.dataBlockLength);
            this.isEncrypted = false;
        }

        private ByteBuffer toMetaDataBuffer() {
            ByteBuffer out = ByteBuffer.allocate(128);
            SaltedHashFreenetStore.this.cipherManager.encrypt(this, SaltedHashFreenetStore.this.random);
            out.put(this.getDigestedRoutingKey());
            out.put(this.dataEncryptIV);
            out.putLong(this.flag);
            out.putLong(this.storeSize);
            if ((this.flag & 2L) != 0L && this.plainRoutingKey != null) {
                assert (this.plainRoutingKey.length == 32);
                out.put(this.plainRoutingKey);
            }
            out.position(96);
            out.putInt(this.generation);
            out.position(0);
            return out;
        }

        private ByteBuffer toHDBuffer() {
            assert (this.isEncrypted);
            assert (this.header.length == SaltedHashFreenetStore.this.headerBlockLength);
            assert (this.data.length == SaltedHashFreenetStore.this.dataBlockLength);
            if (this.header == null || this.data == null) {
                return null;
            }
            ByteBuffer out = ByteBuffer.allocate(SaltedHashFreenetStore.this.headerBlockLength + SaltedHashFreenetStore.this.dataBlockLength + SaltedHashFreenetStore.this.hdPadding);
            out.put(this.header);
            out.put(this.data);
            out.position(0);
            return out;
        }

        private T getStorableBlock(byte[] routingKey, byte[] fullKey, boolean canReadClientCache, boolean canReadSlashdotCache, BlockMetadata meta, DSAPublicKey knownKey) throws KeyVerifyException {
            if (this.isFree() || this.header == null || this.data == null) {
                return null;
            }
            if (!SaltedHashFreenetStore.this.cipherManager.decrypt(this, routingKey)) {
                return null;
            }
            Object block = SaltedHashFreenetStore.this.callback.construct(this.data, this.header, routingKey, fullKey, canReadClientCache, canReadSlashdotCache, meta, knownKey);
            byte[] blockRoutingKey = block.getRoutingKey();
            if (!Arrays.equals(blockRoutingKey, routingKey)) {
                return null;
            }
            return block;
        }

        private long[] getOffset() {
            if (this.digestedRoutingKey != null) {
                return SaltedHashFreenetStore.this.getOffsetFromDigestedKey(this.digestedRoutingKey, this.storeSize);
            }
            return SaltedHashFreenetStore.this.getOffsetFromPlainKey(this.plainRoutingKey, this.storeSize);
        }

        private boolean isFree() {
            return (this.flag & 1L) == 0L;
        }

        byte[] getDigestedRoutingKey() {
            if (this.digestedRoutingKey == null) {
                if (this.plainRoutingKey == null) {
                    return null;
                }
                this.digestedRoutingKey = SaltedHashFreenetStore.this.cipherManager.getDigestedKey(this.plainRoutingKey);
            }
            return this.digestedRoutingKey;
        }

        public int getSlotFilterEntry(byte[] digestedRoutingKey, long flags) {
            int value = (digestedRoutingKey[2] & 0xFF) + ((digestedRoutingKey[1] & 0xFF) << 8) + ((digestedRoutingKey[0] & 0xFF) << 16);
            value |= Integer.MIN_VALUE;
            if ((flags & 1L) != 0L) {
                value |= 0x40000000;
            }
            if ((flags & 4L) != 0L) {
                value |= 0x20000000;
            }
            if ((flags & 8L) != 0L) {
                value |= 0x10000000;
            }
            return value;
        }

        public int getSlotFilterEntry() {
            return this.getSlotFilterEntry(this.getDigestedRoutingKey(), this.flag);
        }

        static /* synthetic */ StorableBlock access$400(Entry x0, byte[] x1, byte[] x2, boolean x3, boolean x4, BlockMetadata x5, DSAPublicKey x6) throws KeyVerifyException {
            return x0.getStorableBlock(x1, x2, x3, x4, x5, x6);
        }

        static /* synthetic */ long access$378(Entry x0, long x1) {
            return x0.flag |= x1;
        }
    }
}

