/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class RandomArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private final int[] indices;
    private Random random;
    private int i;

    public RandomArrayIterator(E[] array, Random random) {
        this.array = array;
        this.indices = this.sequence(array.length);
        this.reset(random);
    }

    public RandomArrayIterator(E[] array) {
        this(array, null);
    }

    public void reset(Random random) {
        this.random = random;
        this.i = 0;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.indices.length;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.random != null) {
            this.shuffleStep();
        }
        return this.array[this.indices[this.i++]];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int[] sequence(int length) {
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    private void shuffleStep() {
        int j = this.random.nextInt(this.indices.length - this.i) + this.i;
        int tmp = this.indices[j];
        this.indices[j] = this.indices[this.i];
        this.indices[this.i] = tmp;
    }
}

