/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.crypt.EncryptedRandomAccessBuffer;
import freenet.crypt.MasterSecret;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PaddedRandomAccessBuffer;
import freenet.support.io.PooledFileRandomAccessBufferFactory;
import freenet.support.io.ReadOnlyRandomAccessBuffer;
import freenet.support.io.TempBucketFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class MaybeEncryptedRandomAccessBufferFactory
implements LockableRandomAccessBufferFactory {
    private final LockableRandomAccessBufferFactory factory;
    private volatile boolean reallyEncrypt;
    private MasterSecret secret;
    private static volatile boolean logMINOR;

    public MaybeEncryptedRandomAccessBufferFactory(LockableRandomAccessBufferFactory factory, boolean encrypt) {
        this.factory = factory;
        this.reallyEncrypt = encrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(long size) throws IOException {
        long realSize = size;
        long paddedSize = size;
        MasterSecret secret = null;
        MaybeEncryptedRandomAccessBufferFactory maybeEncryptedRandomAccessBufferFactory = this;
        synchronized (maybeEncryptedRandomAccessBufferFactory) {
            if (this.reallyEncrypt && this.secret != null) {
                secret = this.secret;
                paddedSize = PaddedEphemerallyEncryptedBucket.paddedLength(realSize += (long)TempBucketFactory.CRYPT_TYPE.headerLen, 1024L);
                if (logMINOR) {
                    Logger.minor(this, "Encrypting and padding " + size + " to " + paddedSize);
                }
            }
        }
        LockableRandomAccessBuffer raf = this.factory.makeRAF(paddedSize);
        if (secret != null) {
            if (realSize != paddedSize) {
                raf = new PaddedRandomAccessBuffer(raf, realSize);
            }
            try {
                raf = new EncryptedRandomAccessBuffer(TempBucketFactory.CRYPT_TYPE, raf, secret, true);
            }
            catch (GeneralSecurityException e) {
                Logger.error(this, "Cannot create encrypted tempfile: " + e, (Throwable)e);
            }
        }
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(byte[] initialContents, int offset, int size, boolean readOnly) throws IOException {
        boolean reallyEncrypt = false;
        MaybeEncryptedRandomAccessBufferFactory maybeEncryptedRandomAccessBufferFactory = this;
        synchronized (maybeEncryptedRandomAccessBufferFactory) {
            reallyEncrypt = this.reallyEncrypt;
        }
        if (reallyEncrypt) {
            LockableRandomAccessBuffer ret = this.makeRAF(size);
            ret.pwrite(0L, initialContents, offset, size);
            if (readOnly) {
                ret = new ReadOnlyRandomAccessBuffer(ret);
            }
            return ret;
        }
        return this.factory.makeRAF(initialContents, offset, size, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterSecret(MasterSecret secret) {
        MaybeEncryptedRandomAccessBufferFactory maybeEncryptedRandomAccessBufferFactory = this;
        synchronized (maybeEncryptedRandomAccessBufferFactory) {
            this.secret = secret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncryption(boolean value) {
        MaybeEncryptedRandomAccessBufferFactory maybeEncryptedRandomAccessBufferFactory = this;
        synchronized (maybeEncryptedRandomAccessBufferFactory) {
            this.reallyEncrypt = value;
        }
        if (this.factory instanceof PooledFileRandomAccessBufferFactory) {
            ((PooledFileRandomAccessBufferFactory)this.factory).enableCrypto(value);
        }
    }

    static {
        Logger.registerClass(MaybeEncryptedRandomAccessBufferFactory.class);
    }
}

