/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.Dimension;
import freenet.config.InvalidConfigValueException;
import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.support.Fields;
import freenet.support.api.IntCallback;

public class IntOption
extends Option<Integer> {
    private final Dimension dimension;

    public IntOption(SubConfig conf, String optionName, String defaultValueString, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, Dimension dimension) {
        this(conf, optionName, (Integer)Fields.parseInt(defaultValueString, dimension), sortOrder, expert, forceWrite, shortDesc, longDesc, cb, dimension);
    }

    @Deprecated
    public IntOption(SubConfig conf, String optionName, String defaultValueString, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, boolean isSize) {
        this(conf, optionName, defaultValueString, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize ? Dimension.SIZE : Dimension.NOT);
    }

    public IntOption(SubConfig conf, String optionName, Integer defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, Dimension dimension) {
        super(conf, optionName, cb, sortOrder, expert, forceWrite, shortDesc, longDesc, Option.DataType.NUMBER);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.dimension = dimension;
    }

    @Deprecated
    public IntOption(SubConfig conf, String optionName, Integer defaultValue, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, IntCallback cb, boolean isSize) {
        this(conf, optionName, defaultValue, sortOrder, expert, forceWrite, shortDesc, longDesc, cb, isSize ? Dimension.SIZE : Dimension.NOT);
    }

    @Override
    protected Integer parseString(String val) throws InvalidConfigValueException {
        Integer x;
        try {
            x = Fields.parseInt(val, this.dimension);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigValueException(this.l10n("parseError", "val", val));
        }
        return x;
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("IntOption." + key, pattern, value);
    }

    @Override
    protected String toDisplayString(Integer val) {
        return Fields.intToString((int)val, this.dimension);
    }

    @Override
    protected String toString(Integer val) {
        return Fields.intToString((int)val, Dimension.NOT);
    }
}

