/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlob;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.SimpleBlockSet;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.PeerNode;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.updater.MainJarUpdater;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.updater.NodeUpdater;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.WeakHashSet;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.api.RandomAccessBuffer;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileRandomAccessBuffer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpdateOverMandatoryManager
implements RequestClient {
    private static volatile boolean logMINOR;
    final NodeUpdateManager updateManager;
    private final HashSet<PeerNode> nodesSayKeyRevoked;
    private final HashSet<PeerNode> nodesSayKeyRevokedFailedTransfer;
    private final HashSet<PeerNode> nodesSayKeyRevokedTransferring;
    private final HashSet<PeerNode> nodesOfferedMainJar;
    private final HashSet<PeerNode> nodesAskedSendMainJar;
    private final HashSet<PeerNode> nodesSendingMainJar;
    private final HashSet<PeerNode> nodesSentMainJar;
    private final HashSet<PeerNode> allNodesOfferedMainJar;
    static final int MAX_NODES_SENDING_JAR = 2;
    static final long REQUEST_MAIN_JAR_TIMEOUT;
    public static final long GRACE_TIME;
    private UserAlert alert;
    private static final Pattern mainBuildNumberPattern;
    private static final Pattern mainTempBuildNumberPattern;
    private static final Pattern revocationTempBuildNumberPattern;
    protected static final int RANDOM_INSERT_BLOB = 10;
    private boolean fetchingUOM;
    private final HashMap<ShortBuffer, File> dependencies;
    private final WeakHashMap<PeerNode, Integer> peersFetchingDependencies;
    private final HashMap<ShortBuffer, UOMDependencyFetcher> dependencyFetchers;
    static final int MAX_TRANSFERS_PER_PEER = 2;

    public UpdateOverMandatoryManager(NodeUpdateManager manager) {
        this.updateManager = manager;
        this.nodesSayKeyRevoked = new HashSet();
        this.nodesSayKeyRevokedFailedTransfer = new HashSet();
        this.nodesSayKeyRevokedTransferring = new HashSet();
        this.nodesOfferedMainJar = new HashSet();
        this.nodesSentMainJar = new HashSet();
        this.nodesAskedSendMainJar = new HashSet();
        this.nodesSendingMainJar = new HashSet();
        this.allNodesOfferedMainJar = new HashSet();
        this.dependencies = new HashMap();
        this.peersFetchingDependencies = new WeakHashMap();
        this.dependencyFetchers = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAnnounce(Message m, PeerNode source) {
        long mainJarFileLength;
        long mainJarVersion;
        String mainJarKey;
        block17: {
            mainJarKey = m.getString("mainJarKey");
            String revocationKey = m.getString("revocationKey");
            boolean haveRevocationKey = m.getBoolean("haveRevocationKey");
            mainJarVersion = m.getLong("mainJarVersion");
            long revocationKeyLastTried = m.getLong("revocationKeyTimeLastTried");
            int revocationKeyDNFs = m.getInt("revocationKeyDNFCount");
            long revocationKeyFileLength = m.getLong("revocationKeyFileLength");
            mainJarFileLength = m.getLong("mainJarFileLength");
            int pingTime = m.getInt("pingTime");
            int delayTime = m.getInt("bwlimitDelayTime");
            if (logMINOR) {
                Logger.minor(this, "Update Over Mandatory offer from node " + source.getPeer() + " : " + source.userToString() + ":");
                Logger.minor(this, "Main jar key: " + mainJarKey + " version=" + mainJarVersion + " length=" + mainJarFileLength);
                Logger.minor(this, "Revocation key: " + revocationKey + " found=" + haveRevocationKey + " length=" + revocationKeyFileLength + " last had 3 DNFs " + revocationKeyLastTried + " ms ago, " + revocationKeyDNFs + " DNFs so far");
                Logger.minor(this, "Load stats: " + pingTime + "ms ping, " + delayTime + "ms bwlimit delay time");
            }
            if (haveRevocationKey) {
                if (this.updateManager.isBlown()) {
                    return true;
                }
                try {
                    FreenetURI revocationURI = new FreenetURI(revocationKey);
                    if (revocationURI.equals(this.updateManager.getRevocationURI())) {
                        UpdateOverMandatoryManager updateOverMandatoryManager = this;
                        synchronized (updateOverMandatoryManager) {
                            if (this.nodesSayKeyRevokedTransferring.contains(source)) {
                                return true;
                            }
                            if (this.nodesSayKeyRevoked.contains(source)) {
                                return true;
                            }
                            this.nodesSayKeyRevoked.add(source);
                        }
                        this.updateManager.peerClaimsKeyBlown();
                        this.alertUser();
                        System.err.println("Your peer " + source.userToString() + " (build #" + source.getSimpleVersion() + ") says that the auto-update key is blown!");
                        System.err.println("Attempting to fetch it...");
                        this.tryFetchRevocation(source);
                        break block17;
                    }
                    Logger.normal(this, "Node " + source + " sent us a UOM claiming that the auto-update key was blown, but it used a different key to us: \nour key=" + this.updateManager.getRevocationURI() + "\nhis key=" + revocationURI);
                }
                catch (MalformedURLException e) {
                    Logger.error(this, "Node " + source + " sent us a UOMAnnouncement claiming that the auto-update key was blown, but it had an invalid revocation URI: " + revocationKey + " : " + e, (Throwable)e);
                    System.err.println("Node " + source.userToString() + " sent us a UOMAnnouncement claiming that the revocation key was blown, but it had an invalid revocation URI: " + revocationKey + " : " + e);
                }
                catch (NotConnectedException e) {
                    System.err.println("Node " + source + " says that the auto-update key was blown, but has now gone offline! Something bad may be happening!");
                    Logger.error(this, "Node " + source + " says that the auto-update key was blown, but has now gone offline! Something bad may be happening!");
                    UpdateOverMandatoryManager updateOverMandatoryManager = this;
                    synchronized (updateOverMandatoryManager) {
                        this.nodesSayKeyRevoked.remove(source);
                    }
                    this.maybeNotRevoked();
                }
            }
        }
        this.tellFetchers(source);
        if (this.updateManager.isBlown()) {
            return true;
        }
        if (!this.updateManager.isEnabled()) {
            return true;
        }
        long now = System.currentTimeMillis();
        this.handleMainJarOffer(now, mainJarFileLength, mainJarVersion, source, mainJarKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tellFetchers(PeerNode source) {
        HashSet<UOMDependencyFetcher> fetchList;
        HashMap<ShortBuffer, UOMDependencyFetcher> hashMap = this.dependencyFetchers;
        synchronized (hashMap) {
            fetchList = new HashSet<UOMDependencyFetcher>(this.dependencyFetchers.values());
        }
        for (UOMDependencyFetcher f : fetchList) {
            if (source.isDarknet()) {
                f.peerMaybeFreeSlots(source);
            }
            f.start();
        }
    }

    private void tryFetchRevocation(final PeerNode source) throws NotConnectedException {
        Message msg = DMT.createUOMRequestRevocation(this.updateManager.node.random.nextLong());
        source.sendAsync(msg, new AsyncMessageCallback(){

            @Override
            public void acknowledged() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnected() {
                System.err.println("Failed to send request for revocation key to " + source.userToString() + " (build #" + source.getSimpleVersion() + ") because it disconnected!");
                source.failedRevocationTransfer();
                UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                synchronized (updateOverMandatoryManager) {
                    UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.add(source);
                }
            }

            @Override
            public void fatalError() {
                System.err.println("Failed to send request for revocation key to " + source.userToString() + " because of a fatal error.");
            }

            @Override
            public void sent() {
            }
        }, this.updateManager.ctr);
        this.updateManager.node.getTicker().queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                    return;
                }
                UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                synchronized (updateOverMandatoryManager) {
                    if (UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.contains(source)) {
                        return;
                    }
                    if (UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.contains(source)) {
                        return;
                    }
                    UpdateOverMandatoryManager.this.nodesSayKeyRevoked.remove(source);
                }
                System.err.println("Peer " + source + " (build #" + source.getSimpleVersion() + ") said that the auto-update key had been blown, but did not transfer the revocation certificate. The most likely explanation is that the key has not been blown (the node is buggy or malicious), so we are ignoring this.");
                UpdateOverMandatoryManager.this.maybeNotRevoked();
            }
        }, TimeUnit.SECONDS.toMillis(60L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMainJarOffer(long now, long mainJarFileLength, long mainJarVersion, PeerNode source, String jarKey) {
        long started = this.updateManager.getStartedFetchingNextMainJarTimestamp();
        long whenToTakeOverTheNormalUpdater = started > 0L ? started + GRACE_TIME : System.currentTimeMillis() + GRACE_TIME;
        boolean isOutdated = this.updateManager.node.isOudated();
        Logger.normal(this, "We received a valid UOMAnnouncement (main) : (isOutdated=" + isOutdated + " version=" + mainJarVersion + " whenToTakeOverTheNormalUpdater=" + TimeUtil.formatTime(whenToTakeOverTheNormalUpdater - now) + ") file length " + mainJarFileLength + " updateManager version " + this.updateManager.newMainJarVersion());
        if (mainJarVersion > (long)Version.buildNumber() && mainJarFileLength > 0L && mainJarVersion > (long)this.updateManager.newMainJarVersion()) {
            source.setMainJarOfferedVersion(mainJarVersion);
            if (logMINOR) {
                Logger.minor(this, "Offer is valid");
            }
            if (isOutdated || whenToTakeOverTheNormalUpdater < now) {
                if (!isOutdated) {
                    String howLong = TimeUtil.formatTime(now - started);
                    Logger.error(this, "The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1)");
                    System.out.println("The update process seems to have been stuck for " + howLong + "; let's switch to UoM! SHOULD NOT HAPPEN! (1)");
                } else if (logMINOR) {
                    Logger.minor(this, "Fetching via UOM as our build is deprecated");
                }
                try {
                    FreenetURI mainJarURI = new FreenetURI(jarKey).setSuggestedEdition(mainJarVersion);
                    if (mainJarURI.equals(this.updateManager.getURI().setSuggestedEdition(mainJarVersion))) {
                        this.sendUOMRequest(source, true);
                    } else {
                        System.err.println("Node " + source.userToString() + " offered us a new main jar (version " + mainJarVersion + ") but his key was different to ours:\nour key: " + this.updateManager.getURI() + "\nhis key:" + mainJarURI);
                    }
                }
                catch (MalformedURLException e) {
                    Logger.error(this, "Node " + source + " sent us a UOMAnnouncement claiming to have a new ext jar, but it had an invalid URI: " + jarKey + " : " + e, (Throwable)e);
                    System.err.println("Node " + source.userToString() + " sent us a UOMAnnouncement claiming to have a new ext jar, but it had an invalid URI: " + jarKey + " : " + e);
                }
                UpdateOverMandatoryManager updateOverMandatoryManager = this;
                synchronized (updateOverMandatoryManager) {
                    this.allNodesOfferedMainJar.add(source);
                }
            }
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesOfferedMainJar.add(source);
                this.allNodesOfferedMainJar.add(source);
            }
            this.updateManager.node.getTicker().queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                        return;
                    }
                    if (!UpdateOverMandatoryManager.this.updateManager.isEnabled()) {
                        return;
                    }
                    if (UpdateOverMandatoryManager.this.updateManager.hasNewMainJar()) {
                        return;
                    }
                    if (!UpdateOverMandatoryManager.this.updateManager.node.isOudated()) {
                        Logger.error(this, "The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2) (ext)");
                        System.out.println("The update process seems to have been stuck for too long; let's switch to UoM! SHOULD NOT HAPPEN! (2) (ext)");
                    }
                    UpdateOverMandatoryManager.this.maybeRequestMainJar();
                }
            }, whenToTakeOverTheNormalUpdater - now);
        } else {
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.allNodesOfferedMainJar.add(source);
            }
        }
        this.startSomeDependencyFetchers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUOMRequest(final PeerNode source, boolean addOnFail) {
        String name = "Main";
        String lname = "main";
        if (logMINOR) {
            Logger.minor(this, "sendUOMRequestMain(" + source + "," + addOnFail + ")");
        }
        if (!source.isConnected() || source.isSeed()) {
            if (logMINOR) {
                Logger.minor(this, "Not sending UOM " + lname + " request to " + source + " (disconnected or seednode)");
            }
            return;
        }
        final HashSet<PeerNode> sendingJar = this.nodesSendingMainJar;
        final HashSet<PeerNode> askedSendJar = this.nodesAskedSendMainJar;
        boolean wasFetchingUOM = false;
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            long offeredVersion = source.getMainJarOfferedVersion();
            long updateVersion = this.updateManager.newMainJarVersion();
            if (offeredVersion < updateVersion) {
                if (offeredVersion <= 0L) {
                    Logger.error(this, "Not sending UOM " + lname + " request to " + source + " because it hasn't offered anything!");
                } else if (logMINOR) {
                    Logger.minor(this, "Not sending UOM " + lname + " request to " + source + " because we already have its offered version " + offeredVersion);
                }
                return;
            }
            int curVersion = this.updateManager.getMainVersion();
            if ((long)curVersion >= offeredVersion) {
                if (logMINOR) {
                    Logger.minor(this, "Not fetching from " + source + " because current " + lname + " jar version " + curVersion + " is more recent than " + offeredVersion);
                }
                return;
            }
            if (askedSendJar.contains(source)) {
                if (logMINOR) {
                    Logger.minor(this, "Recently asked node " + source + " (" + lname + ") so not re-asking yet.");
                }
                return;
            }
            if (addOnFail && askedSendJar.size() + sendingJar.size() >= 2) {
                HashSet<PeerNode> offeredJar = this.nodesOfferedMainJar;
                if (offeredJar.add(source)) {
                    System.err.println("Offered " + lname + " jar by " + source.userToString() + " (already fetching from " + sendingJar.size() + "), but will use this offer if our current fetches fail).");
                }
                return;
            }
            if (sendingJar.contains(source)) {
                if (logMINOR) {
                    Logger.minor(this, "Not fetching " + lname + " jar from " + source.userToString() + " because already fetching from that node");
                }
                return;
            }
            sendingJar.add(source);
            wasFetchingUOM = this.fetchingUOM;
            this.fetchingUOM = true;
        }
        if (!wasFetchingUOM) {
            this.updateManager.onStartFetchingUOM();
        }
        Message msg = DMT.createUOMRequestMainJar(this.updateManager.node.random.nextLong());
        try {
            System.err.println("Fetching " + lname + " jar from " + source.userToString());
            source.sendAsync(msg, new AsyncMessageCallback(){

                @Override
                public void acknowledged() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void disconnected() {
                    Logger.normal(this, "Disconnected from " + source.userToString() + " after sending UOMRequestMainJar");
                    UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager) {
                        sendingJar.remove(source);
                    }
                    UpdateOverMandatoryManager.this.maybeRequestMainJar();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fatalError() {
                    Logger.normal(this, "Fatal error from " + source.userToString() + " after sending UOMRequestMainJar");
                    UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                    synchronized (updateOverMandatoryManager) {
                        askedSendJar.remove(source);
                    }
                    UpdateOverMandatoryManager.this.maybeRequestMainJar();
                }

                @Override
                public void sent() {
                    UpdateOverMandatoryManager.this.updateManager.node.ticker.queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                            synchronized (updateOverMandatoryManager) {
                                if (!askedSendJar.remove(source)) {
                                    return;
                                }
                            }
                            UpdateOverMandatoryManager.this.maybeRequestMainJar();
                        }
                    }, REQUEST_MAIN_JAR_TIMEOUT);
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            UpdateOverMandatoryManager updateOverMandatoryManager2 = this;
            synchronized (updateOverMandatoryManager2) {
                askedSendJar.remove(source);
            }
            this.maybeRequestMainJar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void maybeRequestMainJar() {
        PeerNode[] peerNodeArray = this;
        // MONITORENTER : this
        if (this.nodesAskedSendMainJar.size() + this.nodesSendingMainJar.size() >= 2) {
            // MONITOREXIT : peerNodeArray
            return;
        }
        if (this.nodesOfferedMainJar.isEmpty()) {
            // MONITOREXIT : peerNodeArray
            return;
        }
        PeerNode[] offers = this.nodesOfferedMainJar.toArray(new PeerNode[this.nodesOfferedMainJar.size()]);
        // MONITOREXIT : peerNodeArray
        peerNodeArray = offers;
        int n = peerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PeerNode offer = peerNodeArray[n2];
            if (offer.isConnected()) {
                PeerNode[] peerNodeArray2 = this;
                // MONITORENTER : this
                if (this.nodesAskedSendMainJar.size() + this.nodesSendingMainJar.size() >= 2) {
                    // MONITOREXIT : peerNodeArray2
                    return;
                }
                if (this.nodesSendingMainJar.contains(offer)) {
                    // MONITOREXIT : peerNodeArray2
                } else if (this.nodesAskedSendMainJar.contains(offer)) {
                    // MONITOREXIT : peerNodeArray2
                } else {
                    // MONITOREXIT : peerNodeArray2
                    super.sendUOMRequest(offer, false);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertUser() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (this.alert != null) {
                return;
            }
            this.alert = new PeersSayKeyBlownAlert();
        }
        this.updateManager.node.clientCore.alerts.register(this.alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNode[][] getNodesSayBlown() {
        ArrayList<PeerNode> nodesConnectedSayRevoked = new ArrayList<PeerNode>();
        ArrayList<PeerNode> nodesDisconnectedSayRevoked = new ArrayList<PeerNode>();
        ArrayList<PeerNode> nodesFailedSayRevoked = new ArrayList<PeerNode>();
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            PeerNode[] nodesSayRevoked;
            for (PeerNode pn : nodesSayRevoked = this.nodesSayKeyRevoked.toArray(new PeerNode[this.nodesSayKeyRevoked.size()])) {
                if (this.nodesSayKeyRevokedFailedTransfer.contains(pn)) {
                    nodesFailedSayRevoked.add(pn);
                    continue;
                }
                nodesConnectedSayRevoked.add(pn);
            }
        }
        for (int i = 0; i < nodesConnectedSayRevoked.size(); ++i) {
            PeerNode pn = (PeerNode)nodesConnectedSayRevoked.get(i);
            if (pn.isConnected()) continue;
            nodesDisconnectedSayRevoked.add(pn);
            nodesConnectedSayRevoked.remove(i);
            --i;
        }
        return new PeerNode[][]{nodesConnectedSayRevoked.toArray(new PeerNode[nodesConnectedSayRevoked.size()]), nodesDisconnectedSayRevoked.toArray(new PeerNode[nodesDisconnectedSayRevoked.size()]), nodesFailedSayRevoked.toArray(new PeerNode[nodesFailedSayRevoked.size()])};
    }

    public boolean handleRequestRevocation(Message m, final PeerNode source) {
        BulkTransmitter bt;
        final RandomAccessBuffer data = this.updateManager.revocationChecker.getBlobBuffer();
        if (data == null) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for the revocation key but we don't have it!");
            return true;
        }
        final long uid = m.getLong("uid");
        long length = data.size();
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, data, true);
        try {
            bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr, true);
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected: " + e, (Throwable)e);
            data.close();
            return true;
        }
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!bt.send()) {
                        Logger.error(this, "Failed to send revocation key blob to " + source.userToString() + " : " + bt.getCancelReason());
                    } else {
                        Logger.normal(this, "Sent revocation key blob to " + source.userToString());
                    }
                }
                catch (DisconnectedException e) {
                    Logger.warning(this, "Failed to send revocation key blob (disconnected) to " + source.userToString() + " : " + bt.getCancelReason());
                }
                finally {
                    data.close();
                }
            }
        };
        Message msg = DMT.createUOMSendingRevocation(uid, length, this.updateManager.getRevocationURI().toString());
        try {
            source.sendAsync(msg, new AsyncMessageCallback(){

                @Override
                public void acknowledged() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending data...");
                    }
                    UpdateOverMandatoryManager.this.updateManager.node.executor.execute(r, "Revocation key send for " + uid + " to " + source.userToString());
                }

                @Override
                public void disconnected() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected when we tried to send the UOMSendingRevocation");
                }

                @Override
                public void fatalError() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then got a fatal error when we tried to send the UOMSendingRevocation");
                }

                @Override
                public void sent() {
                    if (logMINOR) {
                        Logger.minor(this, "Message sent, data soon");
                    }
                }

                public String toString() {
                    return super.toString() + "(" + uid + ":" + source.getPeer() + ")";
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, then disconnected when we tried to send the UOMSendingRevocation: " + e, (Throwable)e);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSendingRevocation(Message m, final PeerNode source) {
        FileRandomAccessBuffer raf;
        File temp;
        FreenetURI revocationURI;
        long uid = m.getLong("uid");
        long length = m.getLong("fileLength");
        String key = m.getString("revocationKey");
        try {
            revocationURI = new FreenetURI(key);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Failed receiving recovation because URI not parsable: " + e + " for " + key, (Throwable)e);
            System.err.println("Failed receiving recovation because URI not parsable: " + e + " for " + key);
            e.printStackTrace();
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (!revocationURI.equals(this.updateManager.getRevocationURI())) {
            System.err.println("Node sending us a revocation certificate from the wrong URI:\nNode: " + source.userToString() + "\nOur   URI: " + this.updateManager.getRevocationURI() + "\nTheir URI: " + revocationURI);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (this.updateManager.isBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Already blown, so not receiving from " + source + "(" + uid + ")");
            }
            this.cancelSend(source, uid);
            return true;
        }
        if (length > 131072L) {
            System.err.println("Node " + source.userToString() + " offered us a revocation certificate " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer. No real revocation cert would be this big.");
            Logger.error(this, "Node " + source.userToString() + " offered us a revocation certificate " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer. No real revocation cert would be this big.");
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        if (length <= 0L) {
            System.err.println("Revocation key is zero bytes from " + source + " - ignoring as this is almost certainly a bug or an attack, it is definitely not valid.");
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesSayKeyRevoked.remove(source);
                this.nodesSayKeyRevokedTransferring.remove(source);
            }
            this.cancelSend(source, uid);
            this.maybeNotRevoked();
            return true;
        }
        System.err.println("Transferring auto-updater revocation certificate length " + length + " from " + source);
        try {
            temp = File.createTempFile("revocation-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Cannot save revocation certificate to disk and therefore cannot fetch it from our peer!: " + e);
            e.printStackTrace();
            this.updateManager.blow("Cannot fetch the revocation certificate from our peer because we cannot write it to disk: " + e, true);
            this.cancelSend(source, uid);
            return true;
        }
        try {
            raf = new FileRandomAccessBuffer(temp, length, false);
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, (Throwable)e);
            this.updateManager.blow("Internal error after fetching the revocation certificate from our peer, maybe out of disk space, file disappeared " + temp + " : " + e, true);
            return true;
        }
        catch (IOException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the revocation key, we have downloaded it but now can't read the file due to a disk I/O error: " + e, (Throwable)e);
            this.updateManager.blow("Internal error after fetching the revocation certificate from our peer, maybe out of disk space or other disk I/O error, file disappeared " + temp + " : " + e, true);
            return true;
        }
        UpdateOverMandatoryManager e = this;
        synchronized (e) {
            this.nodesSayKeyRevokedTransferring.add(source);
            this.nodesSayKeyRevoked.remove(source);
        }
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, false);
        final BulkReceiver br = new BulkReceiver(prb, source, uid, this.updateManager.ctr);
        this.updateManager.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block13: {
                    try {
                        if (br.receive()) {
                            UpdateOverMandatoryManager.this.processRevocationBlob(temp, source);
                            break block13;
                        }
                        Logger.error(this, "Failed to transfer revocation certificate from " + source);
                        System.err.println("Failed to transfer revocation certificate from " + source);
                        source.failedRevocationTransfer();
                        int count = source.countFailedRevocationTransfers();
                        boolean retry = count < 3;
                        UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                        synchronized (updateOverMandatoryManager) {
                            UpdateOverMandatoryManager.this.nodesSayKeyRevokedFailedTransfer.add(source);
                            UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.remove(source);
                            if (retry) {
                                if (UpdateOverMandatoryManager.this.nodesSayKeyRevoked.contains(source)) {
                                    retry = false;
                                } else {
                                    UpdateOverMandatoryManager.this.nodesSayKeyRevoked.add(source);
                                }
                            }
                        }
                        UpdateOverMandatoryManager.this.maybeNotRevoked();
                        if (retry) {
                            UpdateOverMandatoryManager.this.tryFetchRevocation(source);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught error while transferring revocation certificate from " + source + " : " + t, t);
                        System.err.println("Peer " + source + " said that the revocation key has been blown, but we got an internal error while transferring it:");
                        t.printStackTrace();
                        UpdateOverMandatoryManager.this.updateManager.blow("Internal error while fetching the revocation certificate from our peer " + source + " : " + t, true);
                        UpdateOverMandatoryManager updateOverMandatoryManager = UpdateOverMandatoryManager.this;
                        synchronized (updateOverMandatoryManager) {
                            UpdateOverMandatoryManager.this.nodesSayKeyRevokedTransferring.remove(source);
                        }
                    }
                }
            }
        }, "Revocation key receive for " + uid + " from " + source.userToString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeNotRevoked() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            if (!this.updateManager.peersSayBlown()) {
                return;
            }
            if (this.mightBeRevoked()) {
                return;
            }
            this.updateManager.notPeerClaimsKeyBlown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mightBeRevoked() {
        PeerNode[] peerNodeArray = this;
        synchronized (this) {
            PeerNode[] started = this.nodesSayKeyRevoked.toArray(new PeerNode[this.nodesSayKeyRevoked.size()]);
            PeerNode[] transferring = this.nodesSayKeyRevokedTransferring.toArray(new PeerNode[this.nodesSayKeyRevokedTransferring.size()]);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            for (PeerNode peer : started) {
                if (!peer.isConnected() || peer.countFailedRevocationTransfers() > 3) continue;
                return true;
            }
            for (PeerNode peer : transferring) {
                if (!peer.isConnected() || peer.countFailedRevocationTransfers() > 3) continue;
                return true;
            }
            return false;
        }
    }

    void processRevocationBlob(File temp, PeerNode source) {
        this.processRevocationBlob(new FileBucket(temp, true, false, false, true), source.userToString(), false);
    }

    /*
     * Exception decompiling
     */
    void processRevocationBlob(Bucket temp, String source, boolean fromDisk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void insertBlob(RandomAccessBucket bucket, final String type, short priority) {
        ClientPutCallback callback = new ClientPutCallback(){

            @Override
            public void onFailure(InsertException e, BaseClientPutter state) {
                Logger.error(this, "Failed to insert " + type + " binary blob: " + e, (Throwable)e);
            }

            @Override
            public void onFetchable(BaseClientPutter state) {
            }

            @Override
            public void onGeneratedURI(FreenetURI uri, BaseClientPutter state) {
            }

            @Override
            public void onSuccess(BaseClientPutter state) {
                Logger.normal(this, "Inserted " + type + " binary blob");
            }

            @Override
            public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state) {
                Logger.error(this, "Got onGeneratedMetadata inserting blob from " + state, (Throwable)new Exception("error"));
                metadata.free();
            }

            @Override
            public void onResume(ClientContext context) {
            }

            @Override
            public RequestClient getRequestClient() {
                return UpdateOverMandatoryManager.this;
            }
        };
        InsertContext ctx = this.updateManager.node.clientCore.makeClient((short)1, false, false).getInsertContext(true);
        ClientPutter putter = new ClientPutter(callback, bucket, FreenetURI.EMPTY_CHK_URI, null, ctx, priority, false, null, true, this.updateManager.node.clientCore.clientContext, null, -1L);
        try {
            this.updateManager.node.clientCore.clientContext.start(putter);
        }
        catch (InsertException e1) {
            Logger.error(this, "Failed to start insert of " + type + " binary blob: " + e1, (Throwable)e1);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
    }

    private void cancelSend(PeerNode source, long uid) {
        Message msg = DMT.createFNPBulkReceiveAborted(uid);
        try {
            source.sendAsync(msg, null, this.updateManager.ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public void killAlert() {
        this.updateManager.node.clientCore.alerts.unregister(this.alert);
    }

    public void handleRequestJar(Message m, final PeerNode source) {
        Message msg;
        BulkTransmitter bt;
        FileRandomAccessBuffer raf;
        FreenetURI uri;
        int version;
        File data;
        String name = "main";
        if (source.isOpennet() && this.updateManager.dontAllowUOM()) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for " + "main" + "; We are a seenode, so we ignore it!");
            return;
        }
        if (source.getVersionNumber() < 1481) {
            data = this.updateManager.getTransitionMainBlob();
            version = 1481;
            uri = NodeUpdateManager.previousMainJarUSK;
        } else {
            data = this.updateManager.getCurrentVersionBlobFile();
            version = Version.buildNumber();
            uri = this.updateManager.getURI();
        }
        if (data == null) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar but we don't have it!");
            return;
        }
        final long uid = m.getLong("uid");
        if (!source.sendingUOMJar(false)) {
            Logger.error(this, "Peer " + source + " asked for UOM main jar twice");
            return;
        }
        try {
            try {
                raf = new FileRandomAccessBuffer(data, true);
            }
            catch (FileNotFoundException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, (Throwable)e);
                return;
            }
            catch (IOException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, we have downloaded it but can't read the file due to a disk I/O error: " + e, (Throwable)e);
                return;
            }
            long length = raf.size();
            PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, true);
            try {
                bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr, true);
            }
            catch (DisconnectedException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, then disconnected: " + e, (Throwable)e);
                raf.close();
                return;
            }
            msg = DMT.createUOMSendingMainJar(uid, length, uri.toString(), version);
        }
        catch (RuntimeException e) {
            source.finishedSendingUOMJar(false);
            throw e;
        }
        catch (Error e) {
            source.finishedSendingUOMJar(false);
            throw e;
        }
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!bt.send()) {
                        Logger.error(this, "Failed to send main jar blob to " + source.userToString() + " : " + bt.getCancelReason());
                    } else {
                        Logger.normal(this, "Sent main jar blob to " + source.userToString());
                    }
                    raf.close();
                }
                catch (DisconnectedException disconnectedException) {
                }
                finally {
                    source.finishedSendingUOMJar(false);
                    raf.close();
                }
            }
        };
        try {
            source.sendAsync(msg, new AsyncMessageCallback(){

                @Override
                public void acknowledged() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending data...");
                    }
                    UpdateOverMandatoryManager.this.updateManager.node.executor.execute(r, "main jar send for " + uid + " to " + source.userToString());
                }

                @Override
                public void disconnected() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, then disconnected when we tried to send the UOMSendingMainJar");
                    source.finishedSendingUOMJar(false);
                }

                @Override
                public void fatalError() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, then got a fatal error when we tried to send the UOMSendingMainJar");
                    source.finishedSendingUOMJar(false);
                }

                @Override
                public void sent() {
                    if (logMINOR) {
                        Logger.minor(this, "Message sent, data soon");
                    }
                }

                public String toString() {
                    return super.toString() + "(" + uid + ":" + source.getPeer() + ")";
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + "main" + " jar, then disconnected when we tried to send the UOMSendingMainJar: " + e, (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            source.finishedSendingUOMJar(false);
            throw e;
        }
        catch (Error e) {
            source.finishedSendingUOMJar(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSendingMain(Message m, final PeerNode source) {
        FileRandomAccessBuffer raf;
        File temp;
        FreenetURI jarURI;
        long uid = m.getLong("uid");
        long length = m.getLong("fileLength");
        String key = m.getString("mainJarKey");
        final int version = m.getInt("mainJarVersion");
        try {
            jarURI = new FreenetURI(key).setSuggestedEdition(version);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Failed receiving main jar " + version + " because URI not parsable: " + e + " for " + key, (Throwable)e);
            System.err.println("Failed receiving main jar " + version + " because URI not parsable: " + e + " for " + key);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (!jarURI.equals(this.updateManager.getURI().setSuggestedEdition(version))) {
            System.err.println("Node sending us a main jar update (" + version + ") from the wrong URI:\nNode: " + source.userToString() + "\nOur   URI: " + this.updateManager.getURI() + "\nTheir URI: " + jarURI);
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (this.updateManager.isBlown()) {
            if (logMINOR) {
                Logger.minor(this, "Key blown, so not receiving main jar from " + source + "(" + uid + ")");
            }
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        if (length > 0x1000000L) {
            System.err.println("Node " + source.userToString() + " offered us a main jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            Logger.error(this, "Node " + source.userToString() + " offered us a main jar (" + version + ") " + SizeUtil.formatSize(length) + " long. This is unacceptably long so we have refused the transfer.");
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager e = this;
            synchronized (e) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        System.out.println("Receiving main jar " + version + " from " + source.userToString());
        try {
            temp = File.createTempFile("main-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            temp.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Cannot save new main jar to disk and therefore cannot fetch it from our peer!: " + e);
            e.printStackTrace();
            this.cancelSend(source, uid);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        try {
            raf = new FileRandomAccessBuffer(temp, length, false);
        }
        catch (IOException e) {
            Logger.error(this, "Peer " + source + " sending us a main jar binary blob, but we " + (e instanceof FileNotFoundException ? "lost the temp file " : "cannot read the temp file ") + temp + " : " + e, (Throwable)e);
            UpdateOverMandatoryManager updateOverMandatoryManager = this;
            synchronized (updateOverMandatoryManager) {
                this.nodesAskedSendMainJar.remove(source);
            }
            return true;
        }
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, false);
        final BulkReceiver br = new BulkReceiver(prb, source, uid, this.updateManager.ctr);
        this.updateManager.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<UpdateOverMandatoryManager> clazz;
                boolean success = false;
                try {
                    clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesAskedSendMainJar.remove(source);
                        UpdateOverMandatoryManager.this.nodesSendingMainJar.add(source);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        success = br.receive();
                        if (success) {
                            UpdateOverMandatoryManager.this.processMainJarBlob(temp, source, version, jarURI);
                        } else {
                            Logger.error(this, "Failed to transfer main jar " + version + " from " + source);
                            System.err.println("Failed to transfer main jar " + version + " from " + source);
                            temp.delete();
                        }
                    }
                }
                finally {
                    clazz = UpdateOverMandatoryManager.class;
                    synchronized (UpdateOverMandatoryManager.class) {
                        UpdateOverMandatoryManager.this.nodesSendingMainJar.remove(source);
                        if (success) {
                            UpdateOverMandatoryManager.this.nodesSentMainJar.add(source);
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                }
                {
                    return;
                }
            }
        }, "Main jar (" + version + ") receive for " + uid + " from " + source.userToString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processMainJarBlob(final File temp, final PeerNode source, final int version, FreenetURI uri) {
        File f;
        SimpleBlockSet blocks = new SimpleBlockSet();
        final String toString = source == null ? "(local)" : source.userToString();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(temp)));
            BinaryBlob.readBinaryBlob((DataInputStream)dis, blocks, true);
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Somebody deleted " + temp + " ? We lost the main jar (" + version + ") from " + toString + "!");
            System.err.println("Somebody deleted " + temp + " ? We lost the main jar (" + version + ") from " + toString + "!");
            return;
        }
        catch (IOException e) {
            Logger.error(this, "Could not read main jar (" + version + ") from temp file " + temp + " from node " + toString + " !");
            System.err.println("Could not read main jar (" + version + ") from temp file " + temp + " from node " + toString + " !");
            return;
        }
        catch (BinaryBlobFormatException e2) {
            Logger.error(this, "Peer " + toString + " sent us an invalid main jar (" + version + ")!: " + e2, (Throwable)e2);
            System.err.println("Peer " + toString + " sent us an invalid main jar (" + version + ")!: " + e2);
            e2.printStackTrace();
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        FetchContext seedContext = this.updateManager.node.clientCore.makeClient((short)0, true, false).getFetchContext();
        FetchContext tempContext = new FetchContext(seedContext, 0, true, blocks);
        tempContext.localRequestOnly = true;
        FileBucket b = null;
        try {
            f = File.createTempFile("main-", ".fblob.tmp", this.updateManager.node.clientCore.getPersistentTempDir());
            f.deleteOnExit();
            b = new FileBucket(f, false, false, true, true);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot share main jar from " + toString + " with our peers because cannot write the cleaned version to disk: " + e, (Throwable)e);
            System.err.println("Cannot share main jar from " + toString + " with our peers because cannot write the cleaned version to disk: " + e);
            e.printStackTrace();
            b = null;
            f = null;
        }
        FileBucket cleanedBlob = b;
        final File cleanedBlobFile = f;
        ClientGetCallback myCallback = new ClientGetCallback(){

            @Override
            public void onFailure(FetchException e, ClientGetter state) {
                if (e.mode == FetchException.FetchExceptionMode.CANCELLED) {
                    Logger.error(this, "Cancelled fetch from store/blob of main jar (" + version + ") from " + toString);
                    System.err.println("Cancelled fetch from store/blob of main jar (" + version + ") from " + toString + " to " + temp + " - please report to developers");
                } else if (e.newURI != null) {
                    temp.delete();
                    Logger.error(this, "URI changed fetching main jar " + version + " from " + toString);
                    System.out.println("URI changed fetching main jar " + version + " from " + toString);
                } else if (e.isFatal()) {
                    temp.delete();
                    Logger.error(this, "Failed to fetch main jar " + version + " from " + toString + " : fatal error (update was probably inserted badly): " + e, (Throwable)e);
                    System.err.println("Failed to fetch main jar " + version + " from " + toString + " : fatal error (update was probably inserted badly): " + e);
                } else {
                    Logger.error(this, "Failed to fetch main jar " + version + " from blob from " + toString);
                    System.err.println("Failed to fetch main jar " + version + " from blob from " + toString);
                }
            }

            @Override
            public void onSuccess(FetchResult result, ClientGetter state) {
                System.err.println("Got main jar version " + version + " from " + toString);
                if (result.size() == 0L) {
                    System.err.println("Ignoring because 0 bytes long");
                    return;
                }
                MainJarUpdater mainUpdater = UpdateOverMandatoryManager.this.updateManager.getMainUpdater();
                if (mainUpdater == null) {
                    System.err.println("Not updating because updater is disabled!");
                    return;
                }
                mainUpdater.onSuccess(result, state, cleanedBlobFile, version);
                temp.delete();
                UpdateOverMandatoryManager.this.maybeInsertMainJar(mainUpdater, source, version);
            }

            @Override
            public void onResume(ClientContext context) {
            }

            @Override
            public RequestClient getRequestClient() {
                return UpdateOverMandatoryManager.this;
            }
        };
        ClientGetter cg = new ClientGetter(myCallback, uri, tempContext, 0, null, new BinaryBlobWriter(cleanedBlob), null);
        try {
            this.updateManager.node.clientCore.clientContext.start(cg);
        }
        catch (FetchException e1) {
            myCallback.onFailure(e1, cg);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
    }

    protected void maybeInsertMainJar(NodeUpdater mainUpdater, PeerNode source, int version) {
        int priority = 4;
        if (source != null) {
            priority = 2;
        } else if (this.updateManager.node.lastVersion > 0 && this.updateManager.node.lastVersion != version) {
            priority = 2;
        } else if (this.updateManager.node.fastWeakRandom.nextInt(10) != 0) {
            return;
        }
        this.insertBlob(mainUpdater.getBlobBucket(version), "main jar", (short)priority);
    }

    protected boolean removeOldTempFiles() {
        File[] oldTempFiles;
        File oldTempFilesPeerDir = this.updateManager.node.clientCore.getPersistentTempDir();
        if (!oldTempFilesPeerDir.exists()) {
            return false;
        }
        if (!oldTempFilesPeerDir.isDirectory()) {
            Logger.error(this, "Persistent temporary files location is not a directory: " + oldTempFilesPeerDir.getPath());
            return false;
        }
        boolean gotError = false;
        for (File fileToDelete : oldTempFiles = oldTempFilesPeerDir.listFiles(new FileFilter(){
            private final int lastGoodMainBuildNumber = Version.lastGoodBuild();

            @Override
            public boolean accept(File file) {
                block6: {
                    String fileName = file.getName();
                    if (fileName.startsWith("revocation-") && fileName.endsWith(".fblob.tmp")) {
                        return true;
                    }
                    Matcher mainBuildNumberMatcher = mainBuildNumberPattern.matcher(fileName);
                    Matcher mainTempBuildNumberMatcher = mainTempBuildNumberPattern.matcher(fileName);
                    Matcher revocationTempBuildNumberMatcher = revocationTempBuildNumberPattern.matcher(fileName);
                    if (mainBuildNumberMatcher.matches()) {
                        try {
                            String buildNumberStr = mainBuildNumberMatcher.group(1);
                            int buildNumber = Integer.parseInt(buildNumberStr);
                            if (buildNumber < this.lastGoodMainBuildNumber) {
                                return true;
                            }
                            break block6;
                        }
                        catch (NumberFormatException e) {
                            Logger.error(this, "Wierd file in persistent temp: " + fileName);
                            return false;
                        }
                    }
                    if (mainTempBuildNumberMatcher.matches() || revocationTempBuildNumberMatcher.matches()) {
                        return true;
                    }
                }
                return false;
            }
        })) {
            String fileToDeleteName = fileToDelete.getName();
            if (fileToDelete.delete()) continue;
            if (fileToDelete.exists()) {
                Logger.error(this, "Cannot delete temporary persistent file " + fileToDeleteName + " even though it exists: must be TOO persistent :)");
            } else {
                Logger.normal(this, "Temporary persistent file does not exist when deleting: " + fileToDeleteName);
            }
            gotError = true;
        }
        return !gotError;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(PeerNode pn) {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            this.nodesSayKeyRevoked.remove(pn);
            this.nodesSayKeyRevokedFailedTransfer.remove(pn);
            this.nodesSayKeyRevokedTransferring.remove(pn);
            this.nodesOfferedMainJar.remove(pn);
            this.allNodesOfferedMainJar.remove(pn);
            this.nodesSentMainJar.remove(pn);
            this.nodesAskedSendMainJar.remove(pn);
            this.nodesSendingMainJar.remove(pn);
        }
        this.maybeNotRevoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchingFromTwo() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            return this.nodesSendingMainJar.size() >= 2;
        }
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFetchingMain() {
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            return this.nodesSendingMainJar.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(byte[] expectedHash, File filename) {
        if (logMINOR) {
            Logger.minor(this, "Add dependency: " + filename + " for " + HexUtil.bytesToHex(expectedHash));
        }
        HashMap<ShortBuffer, File> hashMap = this.dependencies;
        synchronized (hashMap) {
            this.dependencies.put(new ShortBuffer(expectedHash), filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFetchDependency(Message m, final PeerNode source) {
        BulkTransmitter bt;
        PartiallyReceivedBulk prb;
        FileRandomAccessBuffer raf;
        File data;
        final ShortBuffer buf = (ShortBuffer)m.getObject("expectedHash");
        long length = m.getLong("fileLength");
        long uid = m.getLong("uid");
        HashMap<ShortBuffer, File> hashMap = this.dependencies;
        synchronized (hashMap) {
            data = this.dependencies.get(buf);
        }
        boolean fail = !this.incrementDependencies(source);
        try {
            if (data != null) {
                raf = new FileRandomAccessBuffer(data, true);
            } else {
                Logger.error(this, "Dependency with hash " + HexUtil.bytesToHex(buf.getData()) + " not found!");
                fail = true;
                raf = null;
            }
        }
        catch (IOException e) {
            Logger.error(this, "Peer " + source + " asked us for the dependency with hash " + HexUtil.bytesToHex(buf.getData()) + " jar, we have downloaded it but " + (e instanceof FileNotFoundException ? "don't have the file" : "can't read the file") + " even though we did have it when we checked!: " + e, (Throwable)e);
            raf = null;
            fail = true;
        }
        if (raf != null) {
            long thisLength = raf.size();
            prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), thisLength, 1024, raf, true);
            if (length != thisLength) {
                fail = true;
            }
        } else {
            prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), 0L, 1024, new ByteArrayRandomAccessBuffer(new byte[0]), true);
            fail = true;
        }
        try {
            bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr, true);
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the dependency with hash " + HexUtil.bytesToHex(buf.getData()) + " jar then disconnected", (Throwable)e);
            raf.close();
            this.decrementDependencies(source);
            return;
        }
        if (fail) {
            this.cancelSend(source, uid);
            this.decrementDependencies(source);
        } else {
            final FileRandomAccessBuffer r = raf;
            this.updateManager.node.executor.execute(new Runnable(){

                @Override
                public void run() {
                    source.incrementUOMSends();
                    try {
                        bt.send();
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected while sending dependency with hash " + HexUtil.bytesToHex(buf.getData()) + " to " + source);
                    }
                    finally {
                        source.decrementUOMSends();
                        UpdateOverMandatoryManager.this.decrementDependencies(source);
                        r.close();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementDependencies(PeerNode source) {
        WeakHashMap<PeerNode, Integer> weakHashMap = this.peersFetchingDependencies;
        synchronized (weakHashMap) {
            Integer x = this.peersFetchingDependencies.get(source);
            if (x == null) {
                Logger.error(this, "Inconsistent dependency counting? Should not be null for " + source);
            } else if (x == 1) {
                this.peersFetchingDependencies.remove(source);
            } else if (x <= 0) {
                Logger.error(this, "Inconsistent dependency counting? Counter is " + x + " for " + source);
                this.peersFetchingDependencies.remove(source);
            } else {
                this.peersFetchingDependencies.put(source, x - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean incrementDependencies(PeerNode source) {
        WeakHashMap<PeerNode, Integer> weakHashMap = this.peersFetchingDependencies;
        synchronized (weakHashMap) {
            Integer x = this.peersFetchingDependencies.get(source);
            if (x == null) {
                x = 0;
            }
            Integer n = x;
            Integer n2 = x = Integer.valueOf(x + 1);
            if (x > 2) {
                Logger.normal(this, "Too many dependency transfers for peer " + source + " - rejecting");
                return false;
            }
            this.peersFetchingDependencies.put(source, x);
            return true;
        }
    }

    boolean fetchingUOM() {
        return this.fetchingUOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UOMDependencyFetcher fetchDependency(byte[] expectedHash, long size, File saveTo, boolean executable, UOMDependencyFetcherCallback cb) {
        final UOMDependencyFetcher f = new UOMDependencyFetcher(expectedHash, size, saveTo, executable, cb);
        UpdateOverMandatoryManager updateOverMandatoryManager = this;
        synchronized (updateOverMandatoryManager) {
            this.dependencyFetchers.put(f.expectedHashBuffer, f);
        }
        this.updateManager.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                f.start();
            }
        });
        f.start();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSomeDependencyFetchers() {
        UOMDependencyFetcher[] uOMDependencyFetcherArray = this;
        synchronized (this) {
            UOMDependencyFetcher[] fetchers = this.dependencyFetchers.values().toArray(new UOMDependencyFetcher[this.dependencyFetchers.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (UOMDependencyFetcher f : fetchers) {
                f.start();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void peerMaybeFreeAllSlots(PeerNode fetchFrom) {
        UOMDependencyFetcher[] uOMDependencyFetcherArray = this;
        synchronized (this) {
            UOMDependencyFetcher[] fetchers = this.dependencyFetchers.values().toArray(new UOMDependencyFetcher[this.dependencyFetchers.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (UOMDependencyFetcher f : fetchers) {
                f.peerMaybeFreeSlots(fetchFrom);
            }
            return;
        }
    }

    static {
        Logger.registerClass(UpdateOverMandatoryManager.class);
        REQUEST_MAIN_JAR_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
        GRACE_TIME = TimeUnit.HOURS.toMillis(3L);
        mainBuildNumberPattern = Pattern.compile("^main(?:-jar)?-(\\d+)\\.fblob$");
        mainTempBuildNumberPattern = Pattern.compile("^main(?:-jar)?-(\\d+-)?(\\d+)\\.fblob\\.tmp*$");
        revocationTempBuildNumberPattern = Pattern.compile("^revocation(?:-jar)?-(\\d+-)?(\\d+)\\.fblob\\.tmp*$");
    }

    class UOMDependencyFetcher {
        final byte[] expectedHash;
        final ShortBuffer expectedHashBuffer;
        final long size;
        final File saveTo;
        final boolean executable;
        private boolean completed;
        private final UOMDependencyFetcherCallback cb;
        private final WeakHashSet<PeerNode> peersFailed;
        private final HashSet<PeerNode> peersFetching;

        private UOMDependencyFetcher(byte[] expectedHash, long size, File saveTo, boolean executable, UOMDependencyFetcherCallback callback) {
            this.expectedHash = expectedHash;
            this.expectedHashBuffer = new ShortBuffer(expectedHash);
            this.size = size;
            this.executable = executable;
            this.saveTo = saveTo;
            this.cb = callback;
            this.peersFailed = new WeakHashSet();
            this.peersFetching = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void peerMaybeFreeSlots(PeerNode fetchFrom) {
            UOMDependencyFetcher uOMDependencyFetcher = this;
            synchronized (uOMDependencyFetcher) {
                if (!this.peersFailed.remove(fetchFrom)) {
                    return;
                }
                if (this.completed) {
                    return;
                }
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeFetch() {
            PeerNode chosen;
            block22: {
                boolean tryEverything = false;
                chosen = null;
                do {
                    HashSet<PeerNode> uomPeers;
                    UOMDependencyFetcher uOMDependencyFetcher = this;
                    synchronized (uOMDependencyFetcher) {
                        if (this.peersFetching.size() >= 2) {
                            if (logMINOR) {
                                Logger.minor(this, "Already fetching jar from 2 peers " + this.peersFetching);
                            }
                            return false;
                        }
                        if (this.completed) {
                            return false;
                        }
                    }
                    Object object = UpdateOverMandatoryManager.this;
                    synchronized (object) {
                        uomPeers = new HashSet<PeerNode>(UpdateOverMandatoryManager.this.nodesSentMainJar);
                    }
                    chosen = this.chooseRandomPeer(uomPeers);
                    if (chosen != null) break block22;
                    object = UpdateOverMandatoryManager.this;
                    synchronized (object) {
                        uomPeers = new HashSet(UpdateOverMandatoryManager.this.nodesSendingMainJar);
                    }
                    chosen = this.chooseRandomPeer(uomPeers);
                    if (chosen != null) break block22;
                    object = UpdateOverMandatoryManager.this;
                    synchronized (object) {
                        uomPeers = new HashSet(UpdateOverMandatoryManager.this.allNodesOfferedMainJar);
                    }
                    chosen = this.chooseRandomPeer(uomPeers);
                    if (chosen != null) break block22;
                    if (tryEverything) {
                        Logger.minor(this, "Could not find a peer to send request to for " + this.saveTo);
                        return false;
                    }
                    object = this;
                    synchronized (object) {
                        if (this.peersFailed.size() != 0) {
                            System.out.println("UOM trying peers which have failed downloads for " + this.saveTo.getName() + " because nowhere else to go ...");
                            this.peersFailed.clear();
                            tryEverything = true;
                        }
                    }
                } while (tryEverything);
                Logger.minor(this, "Could not find a peer to send request to for " + this.saveTo);
                return false;
            }
            if (chosen == null) {
                return false;
            }
            final PeerNode fetchFrom = chosen;
            UpdateOverMandatoryManager.this.updateManager.node.executor.execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            return true;
        }

        private synchronized PeerNode chooseRandomPeer(HashSet<PeerNode> uomPeers) {
            if (this.completed) {
                return null;
            }
            if (this.peersFetching.size() >= 2) {
                if (logMINOR) {
                    Logger.minor(this, "Already fetching jar from 2 peers " + this.peersFetching);
                }
                return null;
            }
            if (logMINOR) {
                Logger.minor(this, "Trying to choose peer from " + uomPeers.size());
            }
            ArrayList<PeerNode> notTried = null;
            for (PeerNode pn : uomPeers) {
                if (this.peersFetching.contains(pn)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Already fetching from " + pn);
                    continue;
                }
                if (this.peersFailed.contains(pn)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Peer already failed for " + this.saveTo + " : " + pn);
                    continue;
                }
                if (!pn.isConnected()) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Peer not connected: " + pn);
                    continue;
                }
                if (notTried == null) {
                    notTried = new ArrayList<PeerNode>();
                }
                notTried.add(pn);
            }
            if (notTried == null) {
                if (logMINOR) {
                    Logger.minor(this, "No peers to ask for " + this.saveTo);
                }
                return null;
            }
            PeerNode fetchFrom = (PeerNode)notTried.get(UpdateOverMandatoryManager.this.updateManager.node.fastWeakRandom.nextInt(notTried.size()));
            this.peersFetching.add(fetchFrom);
            return fetchFrom;
        }

        void start() {
            while (this.maybeFetch()) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this;
            synchronized (object) {
                this.completed = true;
            }
            object = UpdateOverMandatoryManager.this;
            synchronized (object) {
                UpdateOverMandatoryManager.this.dependencyFetchers.remove(this.expectedHashBuffer);
            }
        }

        static /* synthetic */ boolean access$1600(UOMDependencyFetcher x0) {
            return x0.completed;
        }

        static /* synthetic */ boolean access$1602(UOMDependencyFetcher x0, boolean x1) {
            x0.completed = x1;
            return x0.completed;
        }

        static /* synthetic */ UOMDependencyFetcherCallback access$1800(UOMDependencyFetcher x0) {
            return x0.cb;
        }

        static /* synthetic */ WeakHashSet access$1900(UOMDependencyFetcher x0) {
            return x0.peersFailed;
        }

        static /* synthetic */ HashSet access$2000(UOMDependencyFetcher x0) {
            return x0.peersFetching;
        }
    }

    public static interface UOMDependencyFetcherCallback {
        public void onSuccess();
    }

    private class PeersSayKeyBlownAlert
    extends AbstractUserAlert {
        public PeersSayKeyBlownAlert() {
            super(false, null, null, null, null, (short)2, true, null, false, null);
        }

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode list;
            HTMLNode div = new HTMLNode("div");
            div.addChild("p").addChild("#", this.l10n("intro"));
            PeerNode[][] nodes = UpdateOverMandatoryManager.this.getNodesSayBlown();
            PeerNode[] nodesSayBlownConnected = nodes[0];
            PeerNode[] nodesSayBlownDisconnected = nodes[1];
            PeerNode[] nodesSayBlownFailedTransfer = nodes[2];
            if (nodesSayBlownConnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("fetching"));
            } else {
                div.addChild("p").addChild("#", this.l10n("failedFetch"));
            }
            if (nodesSayBlownConnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("connectedSayBlownLabel"));
                list = div.addChild("ul");
                for (PeerNode pn : nodesSayBlownConnected) {
                    list.addChild("li", pn.userToString() + " (" + pn.getPeer() + ")");
                }
            }
            if (nodesSayBlownDisconnected.length > 0) {
                div.addChild("p").addChild("#", this.l10n("disconnectedSayBlownLabel"));
                list = div.addChild("ul");
                for (PeerNode pn : nodesSayBlownDisconnected) {
                    list.addChild("li", pn.userToString() + " (" + pn.getPeer() + ")");
                }
            }
            if (nodesSayBlownFailedTransfer.length > 0) {
                div.addChild("p").addChild("#", this.l10n("failedTransferSayBlownLabel"));
                list = div.addChild("ul");
                for (PeerNode pn : nodesSayBlownFailedTransfer) {
                    list.addChild("li", pn.userToString() + " (" + pn.getPeer() + ")");
                }
            }
            return div;
        }

        private String l10n(String key) {
            return NodeL10n.getBase().getString("PeersSayKeyBlownAlert." + key);
        }

        private String l10n(String key, String pattern, String value) {
            return NodeL10n.getBase().getString("PeersSayKeyBlownAlert." + key, pattern, value);
        }

        @Override
        public String getText() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.l10n("intro")).append("\n\n");
            PeerNode[][] nodes = UpdateOverMandatoryManager.this.getNodesSayBlown();
            PeerNode[] nodesSayBlownConnected = nodes[0];
            PeerNode[] nodesSayBlownDisconnected = nodes[1];
            PeerNode[] nodesSayBlownFailedTransfer = nodes[2];
            if (nodesSayBlownConnected.length > 0) {
                sb.append(this.l10n("fetching")).append("\n\n");
            } else {
                sb.append(this.l10n("failedFetch")).append("\n\n");
            }
            if (nodesSayBlownConnected.length > 0) {
                sb.append(this.l10n("connectedSayBlownLabel")).append("\n\n");
                for (PeerNode pn : nodesSayBlownConnected) {
                    sb.append(pn.userToString() + " (" + pn.getPeer() + ")").append("\n");
                }
                sb.append("\n");
            }
            if (nodesSayBlownDisconnected.length > 0) {
                sb.append(this.l10n("disconnectedSayBlownLabel"));
                for (PeerNode pn : nodesSayBlownDisconnected) {
                    sb.append(pn.userToString() + " (" + pn.getPeer() + ")").append("\n");
                }
                sb.append("\n");
            }
            if (nodesSayBlownFailedTransfer.length > 0) {
                sb.append(this.l10n("failedTransferSayBlownLabel"));
                for (PeerNode pn : nodesSayBlownFailedTransfer) {
                    sb.append(pn.userToString() + " (" + pn.getPeer() + ")").append('\n');
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        @Override
        public String getTitle() {
            return this.l10n("titleWithCount", "count", Integer.toString(UpdateOverMandatoryManager.this.nodesSayKeyRevoked.size()));
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public boolean isValid() {
            if (UpdateOverMandatoryManager.this.updateManager.isBlown()) {
                return false;
            }
            return UpdateOverMandatoryManager.this.mightBeRevoked();
        }

        @Override
        public String getShortText() {
            return this.l10n("short");
        }
    }
}

