/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.client.async.ClientContext;
import freenet.crypt.AEADInputStream;
import freenet.crypt.AEADOutputStream;
import freenet.crypt.MasterSecret;
import freenet.node.NodeStarter;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class AEADCryptBucket
implements Bucket,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Bucket underlying;
    private final byte[] key;
    private boolean readOnly;
    static final int OVERHEAD = 32;
    public static final int MAGIC = -1302646058;
    static final int VERSION = 1;

    public AEADCryptBucket(Bucket underlying, byte[] key) {
        this.underlying = underlying;
        this.key = Arrays.copyOf(key, key.length);
    }

    protected AEADCryptBucket() {
        this.underlying = null;
        this.key = null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this.getOutputStreamUnbuffered());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        AEADCryptBucket aEADCryptBucket = this;
        synchronized (aEADCryptBucket) {
            if (this.readOnly) {
                throw new IOException("Read only");
            }
        }
        OutputStream os = this.underlying.getOutputStreamUnbuffered();
        return AEADOutputStream.createAES(os, this.key, NodeStarter.getGlobalSecureRandom());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        InputStream is = this.underlying.getInputStreamUnbuffered();
        return AEADInputStream.createAES(is, this.key);
    }

    @Override
    public String getName() {
        return "AEADEncrypted:" + this.underlying.getName();
    }

    @Override
    public long size() {
        return this.underlying.size() - 32L;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public Bucket createShadow() {
        Bucket undershadow = this.underlying.createShadow();
        AEADCryptBucket ret = new AEADCryptBucket(undershadow, this.key);
        ret.setReadOnly();
        return ret;
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlying.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-1302646058);
        dos.writeInt(1);
        dos.writeByte(this.key.length);
        dos.write(this.key);
        dos.writeBoolean(this.readOnly);
        this.underlying.storeTo(dos);
    }

    public AEADCryptBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Unknown version " + version);
        }
        byte keyLength = dis.readByte();
        if (keyLength < 0 || keyLength != 16 && keyLength != 24 && keyLength != 32) {
            throw new StorageFormatException("Unknown key length " + keyLength);
        }
        this.key = new byte[keyLength];
        dis.readFully(this.key);
        this.readOnly = dis.readBoolean();
        this.underlying = BucketTools.restoreFrom(dis, fg, persistentFileTracker, masterKey);
    }
}

