/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.client.filter.TagReplacerCallback;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.crypt.HashResult;
import freenet.crypt.MultiHashInputStream;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class ClientGetWorkerThread
extends Thread {
    private InputStream input;
    private final URI uri;
    private final HashResult[] hashes;
    private final boolean filterData;
    private final String charset;
    private final FoundURICallback prefetchHook;
    private final TagReplacerCallback tagReplacer;
    private final LinkFilterExceptionProvider linkFilterExceptionProvider;
    private final String mimeType;
    private OutputStream output;
    private boolean finished = false;
    private Throwable error = null;
    private ClientMetadata clientMetadata = null;
    private static volatile boolean logMINOR;
    private static int counter;

    private static synchronized int counter() {
        return counter++;
    }

    public ClientGetWorkerThread(InputStream input, OutputStream output, FreenetURI uri, String mimeType, HashResult[] hashes, boolean filterData, String charset, FoundURICallback prefetchHook, TagReplacerCallback tagReplacer, LinkFilterExceptionProvider linkFilterExceptionProvider) throws URISyntaxException {
        super("ClientGetWorkerThread-" + ClientGetWorkerThread.counter());
        this.input = input;
        this.uri = uri != null ? uri.toURI("/") : null;
        if (mimeType != null && mimeType.compareTo("application/xhtml+xml") == 0) {
            mimeType = "text/html";
        }
        this.mimeType = mimeType;
        this.hashes = hashes;
        this.output = output;
        this.filterData = filterData;
        this.charset = charset;
        this.prefetchHook = prefetchHook;
        this.tagReplacer = tagReplacer;
        this.linkFilterExceptionProvider = linkFilterExceptionProvider;
        if (logMINOR) {
            Logger.minor(this, "Created worker thread for " + uri + " mime type " + mimeType + " filter data = " + filterData + " charset " + charset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "Starting worker thread for " + this.uri + " mime type " + this.mimeType + " filter data = " + this.filterData + " charset " + this.charset);
        }
        try {
            HashResult[] results;
            this.input = new BufferedInputStream(this.input);
            MultiHashInputStream hashStream = null;
            if (this.hashes != null) {
                hashStream = new MultiHashInputStream(this.input, HashResult.makeBitmask(this.hashes));
                this.input = hashStream;
            }
            if (this.filterData) {
                if (logMINOR) {
                    Logger.minor(this, "Running content filter... Prefetch hook: " + this.prefetchHook + " tagReplacer: " + this.tagReplacer);
                }
                if (this.mimeType == null || this.uri == null || this.input == null || this.output == null) {
                    throw new IOException("Insufficient arguements to worker thread");
                }
                ContentFilter.FilterStatus filterStatus = ContentFilter.filter(this.input, this.output, this.mimeType, this.uri, this.prefetchHook, this.tagReplacer, this.charset, this.linkFilterExceptionProvider);
                String detectedMIMEType = filterStatus.mimeType.concat(filterStatus.charset == null ? "" : "; charset=" + filterStatus.charset);
                ClientGetWorkerThread clientGetWorkerThread = this;
                synchronized (clientGetWorkerThread) {
                    this.clientMetadata = new ClientMetadata(detectedMIMEType);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring content filter. The final result has not been written. Writing now.");
                }
                FileUtil.copy(this.input, this.output, -1L);
            }
            try {
                byte[] buf;
                int r;
                while ((r = this.input.read(buf = new byte[4096])) >= 0) {
                }
            }
            catch (EOFException buf) {
                // empty catch block
            }
            this.input.close();
            this.output.close();
            if (this.hashes != null && !HashResult.strictEquals(results = hashStream.getResults(), this.hashes)) {
                Logger.error(this, "Hashes failed verification (length read is " + hashStream.getReadBytes() + ")  for " + this.uri);
                throw new FetchException(FetchException.FetchExceptionMode.CONTENT_HASH_FAILED);
            }
            this.onFinish();
        }
        catch (Throwable t) {
            if (!(t instanceof FetchException || t instanceof UnsafeContentTypeException || t instanceof CompressionOutputSizeException)) {
                Logger.error(this, "Exception caught while processing fetch: " + t, t);
            } else if (logMINOR) {
                Logger.minor(this, "Exception caught while processing fetch: " + t, t);
            }
            this.setError(t);
        }
        finally {
            Closer.close(this.input);
            Closer.close(this.output);
        }
    }

    public synchronized ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public synchronized void setError(Throwable t) {
        if (this.error != null) {
            return;
        }
        this.error = t;
        this.onFinish();
    }

    public synchronized void getError() throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
    }

    public synchronized void onFinish() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void waitFinished() throws Throwable {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.getError();
    }

    static {
        Logger.registerClass(ClientGetWorkerThread.class);
    }
}

