/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.support.CurrentTimeUTC;
import freenet.support.TimeUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class Cookie {
    private static final HashSet<Character> invalidValueCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('='), Character.valueOf(','), Character.valueOf('\"'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf(':'), Character.valueOf(';')));
    public static final HashSet<Character> httpSeparatorCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('@'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('/'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(' '), Character.valueOf('\t')));
    private static final Charset usasciiCharset = Charset.forName("US-ASCII");
    protected int version;
    protected URI domain;
    protected URI path;
    protected String name;
    protected String value;
    protected Date expirationDate;
    protected boolean discard;

    public Cookie(URI myPath, String myName, String myValue, Date myExpirationDate) {
        this.version = 1;
        this.domain = null;
        this.path = Cookie.validatePath(myPath);
        this.name = Cookie.validateName(myName);
        this.value = myValue != null ? Cookie.validateValue(myValue) : "";
        this.expirationDate = Cookie.validateExpirationDate(myExpirationDate);
        this.discard = true;
    }

    protected Cookie() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)obj;
        URI myDomain = this.getDomain();
        URI otherDomain = other.getDomain();
        if (myDomain != null ? otherDomain == null || !otherDomain.toString().equals(myDomain.toString()) : otherDomain != null) {
            return false;
        }
        if (!this.getPath().toString().equals(other.getPath().toString())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.domain.hashCode() + this.path.hashCode() + this.name.hashCode();
    }

    public static URI validateDomain(String domainString) throws URISyntaxException {
        return Cookie.validateDomain(new URI(domainString.toLowerCase()));
    }

    public static URI validateDomain(URI domain) {
        String scheme = domain.getScheme().toLowerCase();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            throw new IllegalArgumentException("Illegal cookie domain, must be http or https: " + domain);
        }
        String path = domain.getPath();
        if (!"".equals(path) && !"/".equals(path)) {
            throw new IllegalArgumentException("Illegal cookie domain, contains a path: " + domain);
        }
        return domain;
    }

    public static URI validatePath(String stringPath) throws URISyntaxException {
        return Cookie.validatePath(new URI(stringPath));
    }

    public static URI validatePath(URI path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException("Illegal cookie path, must be relative: " + path);
        }
        if (!path.toString().startsWith("/")) {
            throw new IllegalArgumentException("Illegal cookie path, must start with /: " + path);
        }
        return path;
    }

    public static String validateName(String name) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("Name is empty.");
        }
        if (!Cookie.isUSASCII(name)) {
            throw new IllegalArgumentException("Invalid name, contains non-US-ASCII characters: " + name);
        }
        name = name.trim().toLowerCase();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isWhitespace(c.charValue())) {
                throw new IllegalArgumentException("Invalid name, contains whitespace: " + name);
            }
            if (Character.isISOControl(c.charValue())) {
                throw new IllegalArgumentException("Invalid name, contains control characters.");
            }
            if (!httpSeparatorCharacters.contains(c)) continue;
            throw new IllegalArgumentException("Invalid name, contains one of the explicitely disallowed characters: " + name);
        }
        if (name.startsWith("$") || "comment".equals(name) || "discard".equals(name) || "domain".equals(name) || "expires".equals(name) || "max-age".equals(name) || "path".equals(name) || "secure".equals(name) || "version".equals(name)) {
            throw new IllegalArgumentException("Name is reserved: " + name);
        }
        return name;
    }

    private static boolean isUSASCII(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String validateValue(String value) {
        if (!Cookie.isUSASCII(value)) {
            throw new IllegalArgumentException("Invalid value, contains non-US-ASCII characters: " + value);
        }
        value = value.trim();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isISOControl(c.charValue())) {
                throw new IllegalArgumentException("Invalid value, contains control characters.");
            }
            if (!invalidValueCharacters.contains(c)) continue;
            throw new IllegalArgumentException("Invalid value, contains one of the explicitely disallowed characters: " + value);
        }
        return value;
    }

    public static Date validateExpirationDate(Date expirationDate) {
        if (CurrentTimeUTC.get().after(expirationDate)) {
            throw new IllegalArgumentException("Illegal expiration date, is in past: " + expirationDate);
        }
        return expirationDate;
    }

    public URI getDomain() {
        return this.domain;
    }

    public URI getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected String encodeToHeaderValue() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.name);
        sb.append("=");
        sb.append(this.value);
        sb.append(';');
        sb.append("version=");
        sb.append(this.version);
        sb.append(';');
        if (this.domain != null) {
            sb.append("domain=");
            sb.append(this.domain);
            sb.append(';');
        }
        sb.append("path=");
        sb.append(this.path);
        sb.append(';');
        sb.append("expires=");
        sb.append(TimeUtil.makeHTTPDate(this.expirationDate.getTime()));
        sb.append(';');
        if (this.discard) {
            sb.append("discard=");
            sb.append(this.discard);
            sb.append(';');
        }
        return sb.toString();
    }
}

