/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.KnownUnsafeContentTypeException;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.ClientPut;
import freenet.clients.fcp.ClientPutDir;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.DownloadRequestStatus;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.RequestCompletionCallback;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.UploadDirRequestStatus;
import freenet.clients.fcp.UploadFileRequestStatus;
import freenet.clients.fcp.UploadRequestStatus;
import freenet.clients.http.FileInsertWizardToadlet;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.SecurityLevelsToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.WelcomeToadlet;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.node.useralerts.StoringUserEvent;
import freenet.node.useralerts.UserEvent;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueueToadlet
extends Toadlet
implements RequestCompletionCallback,
LinkEnabledCallback {
    private static final int MAX_IDENTIFIER_LENGTH = 0x100000;
    static final int MAX_FILENAME_LENGTH = 0x100000;
    private static final int MAX_TYPE_LENGTH = 1024;
    static final int MAX_KEY_LENGTH = 0x100000;
    private NodeClientCore core;
    final FCPServer fcp;
    private FileInsertWizardToadlet fiw;
    private static volatile boolean logMINOR;
    private boolean isReversed = false;
    private final boolean uploads;
    private static final String KEY_LIST_LOCATION = "listKeys.txt";
    private final HashSet<String> completedRequestIdentifiers = new HashSet();
    private final Map<String, GetCompletedEvent> completedGets = new LinkedHashMap<String, GetCompletedEvent>();
    private final Map<String, PutCompletedEvent> completedPuts = new LinkedHashMap<String, PutCompletedEvent>();
    private final Map<String, PutDirCompletedEvent> completedPutDirs = new LinkedHashMap<String, PutDirCompletedEvent>();
    static final String PATH_UPLOADS = "/uploads/";
    static final String PATH_DOWNLOADS = "/downloads/";
    static final HTMLNode DOWNLOADS_LINK;
    static final HTMLNode UPLOADS_LINK;

    void setFIW(FileInsertWizardToadlet fiw) {
        this.fiw = fiw;
    }

    public QueueToadlet(NodeClientCore core, FCPServer fcp, HighLevelSimpleClient client, boolean uploads) {
        super(client);
        this.core = core;
        this.fcp = fcp;
        this.uploads = uploads;
        if (fcp == null) {
            throw new NullPointerException();
        }
        fcp.setCompletionCallback(this);
        try {
            this.loadCompletedIdentifiers();
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleChangePriority(HTTPRequest request, ToadletContext ctx, String suffix) throws ToadletContextClosedException, IOException {
        short newPriority = Short.parseShort(request.getPartAsStringFailsafe("priority" + suffix, 32));
        String identifier = "";
        for (String part : request.getParts()) {
            if (!part.startsWith("identifier-") || (identifier = part.substring("identifier-".length())).length() > 50) continue;
            identifier = request.getPartAsStringFailsafe(part, 0x100000);
            try {
                this.fcp.modifyGlobalRequestBlocking(identifier, null, newPriority);
            }
            catch (PersistenceDisabledException e) {
                this.sendPersistenceDisabledError(ctx);
                return;
            }
        }
        QueueToadlet.writePermanentRedirect(ctx, "Done", this.path());
    }

    private void downloadDisallowedPage(NotAllowedException e, String downloadPath, ToadletContext ctx) throws IOException, ToadletContextClosedException {
        PageNode page = ctx.getPageMaker().getPageNode(QueueToadlet.l10n("downloadFiles"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        Logger.warning(this, e.toString());
        HTMLNode alert = ctx.getPageMaker().getInfobox("infobox-alert", QueueToadlet.l10n("downloadFiles"), contentNode, "grouped-downloads", true);
        alert.addChild("ul", QueueToadlet.l10n("downloadDisallowed", "directory", downloadPath));
        alert.addChild("a", "href", this.path(), NodeL10n.getBase().getString("Toadlet.returnToQueuepage"));
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private File getDownloadsDir(String downloadPath) throws NotAllowedException {
        File downloadsDir = new File(downloadPath);
        if (!this.core.allowDownloadTo(downloadsDir) || (!downloadsDir.exists() || !downloadsDir.isDirectory()) && downloadsDir.mkdirs()) {
            throw new NotAllowedException();
        }
        return downloadsDir;
    }

    private void sendPanicingPage(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        this.writeHTMLReply(ctx, 200, "OK", WelcomeToadlet.sendRestartingPageInner(ctx).generate());
    }

    private void sendConfirmPanicPage(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(QueueToadlet.l10n("confirmPanicButtonPageTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", QueueToadlet.l10n("confirmPanicButtonPageTitle"), contentNode, "confirm-panic", true).addChild("div", "class", "infobox-content");
        content.addChild("p", QueueToadlet.l10n("confirmPanicButton"));
        HTMLNode form = ctx.addFormChild(content, this.path(), "confirmPanicButton");
        form.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirmpanic", QueueToadlet.l10n("confirmPanicButtonYes")});
        form.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "noconfirmpanic", QueueToadlet.l10n("confirmPanicButtonNo")});
        if (this.uploads) {
            content.addChild("p").addChild("a", "href", this.path(), QueueToadlet.l10n("backToUploadsPage"));
        } else {
            content.addChild("p").addChild("a", "href", this.path(), QueueToadlet.l10n("backToDownloadsPage"));
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void sendPersistenceDisabledError(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String title = QueueToadlet.l10n("awaitingPasswordTitle" + (this.uploads ? "Uploads" : "Downloads"));
        if (this.core.node.awaitingPassword()) {
            PageNode page = ctx.getPageMaker().getPageNode(title, ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("infobox-error", title, contentNode, null, true);
            SecurityLevelsToadlet.generatePasswordFormPage(false, this.container, infoboxContent, false, false, false, null, this.path());
            QueueToadlet.addHomepageLink(infoboxContent);
            this.writeHTMLReply(ctx, 500, "Internal Server Error", pageNode.generate());
            return;
        }
        if (this.core.node.isStopping()) {
            this.sendErrorPage(ctx, 200, QueueToadlet.l10n("shuttingDownTitle"), QueueToadlet.l10n("shuttingDown"));
        } else {
            this.sendErrorPage(ctx, 200, QueueToadlet.l10n("persistenceBrokenTitle"), QueueToadlet.l10n("persistenceBroken", new String[]{"TEMPDIR", "DBFILE"}, new String[]{FileUtil.getCanonicalFile(this.core.getPersistentTempDir()).toString() + File.separator, this.core.node.getDatabasePath()}));
        }
    }

    private void writeError(String header, String message, ToadletContext context) throws ToadletContextClosedException, IOException {
        this.writeError(header, message, context, true, false);
    }

    private void writeError(String header, String message, ToadletContext context, boolean returnToQueuePage, boolean returnToInsertPage) throws ToadletContextClosedException, IOException {
        PageMaker pageMaker = context.getPageMaker();
        PageNode page = pageMaker.getPageNode(header, context);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (context.isAllowedFullAccess()) {
            contentNode.addChild(context.getAlertManager().createSummary());
        }
        HTMLNode infoboxContent = pageMaker.getInfobox("infobox-error", header, contentNode, "queue-error", false);
        infoboxContent.addChild("#", message);
        if (returnToQueuePage) {
            NodeL10n.getBase().addL10nSubstitution(infoboxContent.addChild("div"), "QueueToadlet.returnToQueuePage", new String[]{"link"}, new HTMLNode[]{HTMLNode.link(this.path())});
        } else if (returnToInsertPage) {
            NodeL10n.getBase().addL10nSubstitution(infoboxContent.addChild("div"), "QueueToadlet.tryAgainUploadFilePage", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/insertfile/")});
        }
        this.writeHTMLReply(context, 400, "Bad request", pageNode.generate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, final ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String plainText;
        HTMLNode pageNode;
        if (!this.fcp.enabled) {
            this.writeError(QueueToadlet.l10n("fcpIsMissing"), QueueToadlet.l10n("pleaseEnableFCP"), ctx, false, false);
            return;
        }
        if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
            this.sendUnauthorizedPage(ctx);
            return;
        }
        String requestPath = request.getPath().substring(this.path().length());
        boolean countRequests = false;
        boolean listKeys = false;
        if (requestPath.length() > 0) {
            if (requestPath.equals("countRequests.html") || requestPath.equals("/countRequests.html")) {
                countRequests = true;
            } else if (requestPath.equals(KEY_LIST_LOCATION)) {
                listKeys = true;
            }
        }
        class OutputWrapper {
            boolean done;
            HTMLNode pageNode;
            String plainText;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        final PageMaker pageMaker = ctx.getPageMaker();
        final boolean count = countRequests;
        boolean keys = listKeys;
        if (!count && !keys) {
            try {
                RequestStatus[] reqs = this.fcp.getGlobalRequests();
                MultiValueTable<String, String> pageHeaders = new MultiValueTable<String, String>();
                HTMLNode pageNode2 = this.handleGetInner(pageMaker, reqs, this.core.clientContext, request, ctx);
                this.writeHTMLReply(ctx, 200, "OK", pageHeaders, pageNode2.generate());
                return;
            }
            catch (PersistenceDisabledException e) {
                this.sendPersistenceDisabledError(ctx);
                return;
            }
        }
        try {
            this.core.clientContext.jobRunner.queue(new PersistentJob(){
                {
                }

                public String toString() {
                    return "QueueToadlet ShowQueue";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean run(ClientContext context) {
                    HTMLNode pageNode = null;
                    String plainText = null;
                    try {
                        if (count) {
                            long queued = ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchSchedulerBulk.countPersistentWaitingKeys() + ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchSchedulerRT.countPersistentWaitingKeys();
                            Logger.minor(this, "Total waiting CHKs: " + queued);
                            long reallyQueued = ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchSchedulerBulk.countQueuedRequests() + ((QueueToadlet)QueueToadlet.this).core.requestStarters.chkFetchSchedulerRT.countQueuedRequests();
                            Logger.minor(this, "Total queued CHK requests (including transient): " + reallyQueued);
                            PageNode page = pageMaker.getPageNode(QueueToadlet.l10n("title"), ctx);
                            pageNode = page.outer;
                            HTMLNode contentNode = page.content;
                            if (ctx.isAllowedFullAccess()) {
                                contentNode.addChild(ctx.getAlertManager().createSummary());
                            }
                            HTMLNode infoboxContent = pageMaker.getInfobox("infobox-information", "Queued requests status", contentNode, null, false);
                            infoboxContent.addChild("p", "Total awaiting CHKs: " + queued);
                            infoboxContent.addChild("p", "Total queued CHK requests: " + reallyQueued);
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            plainText = QueueToadlet.this.makeKeysList(context, QueueToadlet.this.uploads);
                        }
                        catch (PersistenceDisabledException e) {
                            plainText = null;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        OutputWrapper outputWrapper = ow;
                        synchronized (outputWrapper) {
                            ow.done = true;
                            ow.pageNode = pageNode;
                            ow.plainText = plainText;
                            ow.notifyAll();
                        }
                    }
                }
            }, NativeThread.HIGH_PRIORITY);
        }
        catch (PersistenceDisabledException e1) {
            this.sendPersistenceDisabledError(ctx);
            return;
        }
        OutputWrapper pageNode2 = ow;
        synchronized (pageNode2) {
            while (true) {
                if (ow.done) break;
                try {
                    ow.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            pageNode = ow.pageNode;
            plainText = ow.plainText;
        }
        MultiValueTable<String, String> pageHeaders = new MultiValueTable<String, String>();
        if (pageNode != null) {
            this.writeHTMLReply(ctx, 200, "OK", pageHeaders, pageNode.generate());
        } else if (plainText != null) {
            this.writeReply(ctx, 200, "text/plain", "OK", plainText);
        } else if (this.core.killedDatabase()) {
            this.sendPersistenceDisabledError(ctx);
        } else {
            this.writeError("Internal error", "Internal error", ctx);
        }
    }

    protected String makeKeysList(ClientContext context, boolean inserts) throws PersistenceDisabledException {
        RequestStatus[] reqs = this.fcp.getGlobalRequests();
        StringBuilder sb = new StringBuilder();
        for (RequestStatus req : reqs) {
            UploadRequestStatus put;
            FreenetURI uri;
            if (!inserts && req instanceof DownloadRequestStatus) {
                DownloadRequestStatus get = (DownloadRequestStatus)req;
                uri = get.getURI();
                sb.append(uri.toString());
                sb.append("\n");
                continue;
            }
            if (!inserts || !(req instanceof UploadRequestStatus) || (uri = (put = (UploadRequestStatus)req).getURI()) == null) continue;
            sb.append(uri.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private HTMLNode handleGetInner(PageMaker pageMaker, RequestStatus[] reqs, ClientContext context, final HTTPRequest request, ToadletContext ctx) throws PersistenceDisabledException {
        HTMLNode uncompletedContent;
        String atype;
        LinkedList getters;
        Object[] types;
        HTMLNode failedContent;
        String atype2;
        Object[] types2;
        LinkedList<DownloadRequestStatus> completedDownloadToDisk = new LinkedList<DownloadRequestStatus>();
        LinkedList<DownloadRequestStatus> completedDownloadToTemp = new LinkedList<DownloadRequestStatus>();
        LinkedList<UploadRequestStatus> completedUpload = new LinkedList<UploadRequestStatus>();
        LinkedList<UploadRequestStatus> completedDirUpload = new LinkedList<UploadRequestStatus>();
        LinkedList<DownloadRequestStatus> failedDownload = new LinkedList<DownloadRequestStatus>();
        LinkedList<UploadRequestStatus> failedUpload = new LinkedList<UploadRequestStatus>();
        LinkedList<UploadRequestStatus> failedDirUpload = new LinkedList<UploadRequestStatus>();
        LinkedList<DownloadRequestStatus> uncompletedDownload = new LinkedList<DownloadRequestStatus>();
        LinkedList<UploadRequestStatus> uncompletedUpload = new LinkedList<UploadRequestStatus>();
        LinkedList<UploadRequestStatus> uncompletedDirUpload = new LinkedList<UploadRequestStatus>();
        HashMap<String, LinkedList<DownloadRequestStatus>> failedUnknownMIMEType = new HashMap<String, LinkedList<DownloadRequestStatus>>();
        HashMap<String, LinkedList<DownloadRequestStatus>> failedBadMIMEType = new HashMap<String, LinkedList<DownloadRequestStatus>>();
        if (logMINOR) {
            Logger.minor(this, "Request count: " + reqs.length);
        }
        if (reqs.length < 1) {
            return this.sendEmptyQueuePage(ctx, pageMaker);
        }
        int lowestQueuedPrio = 6;
        long totalQueuedDownloadSize = 0L;
        long totalQueuedUploadSize = 0L;
        boolean added = false;
        for (RequestStatus req : reqs) {
            UploadRequestStatus upload;
            if (req instanceof DownloadRequestStatus && !this.uploads) {
                DownloadRequestStatus download = (DownloadRequestStatus)req;
                if (download.hasSucceeded()) {
                    if (download.toTempSpace()) {
                        completedDownloadToTemp.add(download);
                    } else {
                        completedDownloadToDisk.add(download);
                    }
                } else if (download.hasFinished()) {
                    FetchException.FetchExceptionMode failureCode = download.getFailureCode();
                    String mimeType = download.getMIMEType();
                    if (mimeType == null && (failureCode == FetchException.FetchExceptionMode.CONTENT_VALIDATION_UNKNOWN_MIME || failureCode == FetchException.FetchExceptionMode.CONTENT_VALIDATION_BAD_MIME)) {
                        Logger.error(this, "MIME type is null but failure code is " + FetchException.getMessage(failureCode) + " for " + download.getIdentifier() + " : " + download.getURI());
                        mimeType = "application/octet-stream";
                    }
                    if (failureCode == FetchException.FetchExceptionMode.CONTENT_VALIDATION_UNKNOWN_MIME) {
                        LinkedList<DownloadRequestStatus> list = (LinkedList<DownloadRequestStatus>)failedUnknownMIMEType.get(mimeType = ContentFilter.stripMIMEType(mimeType));
                        if (list == null) {
                            list = new LinkedList<DownloadRequestStatus>();
                            failedUnknownMIMEType.put(mimeType, list);
                        }
                        list.add(download);
                    } else if (failureCode == FetchException.FetchExceptionMode.CONTENT_VALIDATION_BAD_MIME) {
                        LinkedList<DownloadRequestStatus> list;
                        FilterMIMEType type = ContentFilter.getMIMEType(mimeType = ContentFilter.stripMIMEType(mimeType));
                        if (type == null) {
                            Logger.error(this, "Bad MIME failure code yet MIME is " + mimeType + " which does not have a handler!");
                            list = (LinkedList<DownloadRequestStatus>)failedUnknownMIMEType.get(mimeType);
                            if (list == null) {
                                list = new LinkedList<DownloadRequestStatus>();
                                failedUnknownMIMEType.put(mimeType, list);
                            }
                        } else {
                            list = (LinkedList<DownloadRequestStatus>)failedBadMIMEType.get(mimeType);
                            if (list == null) {
                                list = new LinkedList<DownloadRequestStatus>();
                                failedBadMIMEType.put(mimeType, list);
                            }
                        }
                        list.add(download);
                    } else {
                        failedDownload.add(download);
                    }
                } else {
                    int prio = download.getPriority();
                    if (prio < lowestQueuedPrio) {
                        lowestQueuedPrio = prio;
                    }
                    uncompletedDownload.add(download);
                    long size = download.getDataSize();
                    if (size > 0L) {
                        totalQueuedDownloadSize += size;
                    }
                }
                added = true;
                continue;
            }
            if (req instanceof UploadFileRequestStatus && this.uploads) {
                upload = (UploadFileRequestStatus)req;
                if (upload.hasSucceeded()) {
                    completedUpload.add(upload);
                } else if (upload.hasFinished()) {
                    failedUpload.add(upload);
                } else {
                    int prio = upload.getPriority();
                    if (prio < lowestQueuedPrio) {
                        lowestQueuedPrio = prio;
                    }
                    uncompletedUpload.add(upload);
                }
                long size = ((UploadFileRequestStatus)upload).getDataSize();
                if (size > 0L) {
                    totalQueuedUploadSize += size;
                }
                added = true;
                continue;
            }
            if (!(req instanceof UploadDirRequestStatus) || !this.uploads) continue;
            upload = (UploadDirRequestStatus)req;
            if (upload.hasSucceeded()) {
                completedDirUpload.add(upload);
            } else if (upload.hasFinished()) {
                failedDirUpload.add(upload);
            } else {
                int prio = upload.getPriority();
                if (prio < lowestQueuedPrio) {
                    lowestQueuedPrio = prio;
                }
                uncompletedDirUpload.add(upload);
            }
            long size = ((UploadDirRequestStatus)upload).getTotalDataSize();
            if (size > 0L) {
                totalQueuedUploadSize += size;
            }
            added = true;
        }
        if (!added) {
            return this.sendEmptyQueuePage(ctx, pageMaker);
        }
        Logger.minor(this, "Total queued downloads: " + SizeUtil.formatSize(totalQueuedDownloadSize));
        Logger.minor(this, "Total queued uploads: " + SizeUtil.formatSize(totalQueuedUploadSize));
        Comparator<RequestStatus> jobComparator = new Comparator<RequestStatus>(){

            @Override
            public int compare(RequestStatus firstRequest, RequestStatus secondRequest) {
                if (firstRequest == secondRequest) {
                    return 0;
                }
                int result = 0;
                boolean isSet = true;
                if (request.isParameterSet("sortBy")) {
                    String sortBy = request.getParam("sortBy");
                    if (sortBy.equals("id")) {
                        result = firstRequest.getIdentifier().compareToIgnoreCase(secondRequest.getIdentifier());
                        if (result == 0) {
                            result = firstRequest.getIdentifier().compareTo(secondRequest.getIdentifier());
                        }
                    } else if (sortBy.equals("size")) {
                        result = Fields.compare(firstRequest.getTotalBlocks(), secondRequest.getTotalBlocks());
                    } else if (sortBy.equals("progress")) {
                        boolean firstFinalized = firstRequest.isTotalFinalized();
                        boolean secondFinalized = secondRequest.isTotalFinalized();
                        if (firstFinalized && !secondFinalized) {
                            result = 1;
                        } else if (secondFinalized && !firstFinalized) {
                            result = -1;
                        } else {
                            double firstProgress = (double)firstRequest.getFetchedBlocks() / (double)firstRequest.getMinBlocks();
                            double secondProgress = (double)secondRequest.getFetchedBlocks() / (double)secondRequest.getMinBlocks();
                            result = Fields.compare(firstProgress, secondProgress);
                        }
                    } else if (sortBy.equals("lastActivity")) {
                        result = Fields.compare(firstRequest.getLastSuccess(), secondRequest.getLastSuccess());
                    } else if (sortBy.equals("lastFailure")) {
                        result = Fields.compare(firstRequest.getLastFailure(), secondRequest.getLastFailure());
                    } else {
                        isSet = false;
                    }
                } else {
                    isSet = false;
                }
                if (!isSet && (result = Fields.compare(firstRequest.getPriority(), secondRequest.getPriority())) == 0) {
                    result = firstRequest.getIdentifier().compareTo(secondRequest.getIdentifier());
                }
                if (result == 0) {
                    return 0;
                }
                if (request.isParameterSet("reversed")) {
                    QueueToadlet.this.isReversed = true;
                    return result > 0 ? -1 : 1;
                }
                QueueToadlet.this.isReversed = false;
                return result < 0 ? -1 : 1;
            }
        };
        Collections.sort(completedDownloadToDisk, jobComparator);
        Collections.sort(completedDownloadToTemp, jobComparator);
        Collections.sort(completedUpload, jobComparator);
        Collections.sort(completedDirUpload, jobComparator);
        Collections.sort(failedDownload, jobComparator);
        Collections.sort(failedUpload, jobComparator);
        Collections.sort(failedDirUpload, jobComparator);
        Collections.sort(uncompletedDownload, jobComparator);
        Collections.sort(uncompletedUpload, jobComparator);
        Collections.sort(uncompletedDirUpload, jobComparator);
        String pageName = this.uploads ? "(" + (uncompletedDirUpload.size() + uncompletedUpload.size()) + '/' + (failedDirUpload.size() + failedUpload.size()) + '/' + (completedDirUpload.size() + completedUpload.size()) + ") " + QueueToadlet.l10n("titleUploads") : "(" + uncompletedDownload.size() + '/' + failedDownload.size() + '/' + (completedDownloadToDisk.size() + completedDownloadToTemp.size()) + ") " + QueueToadlet.l10n("titleDownloads");
        PageNode page = pageMaker.getPageNode(pageName, ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        InfoboxNode infobox = pageMaker.getInfobox("navbar", QueueToadlet.l10n("requestNavigation"), null, false);
        HTMLNode navigationBar = infobox.outer;
        HTMLNode navigationContent = infobox.content.addChild("ul");
        boolean includeNavigationBar = false;
        if (!completedDownloadToTemp.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDownloadToTemp", QueueToadlet.l10n("completedDtoTemp", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToTemp.size())}));
            includeNavigationBar = true;
        }
        if (!completedDownloadToDisk.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDownloadToDisk", QueueToadlet.l10n("completedDtoDisk", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToDisk.size())}));
            includeNavigationBar = true;
        }
        if (!completedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedUpload", QueueToadlet.l10n("completedU", new String[]{"size"}, new String[]{String.valueOf(completedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!completedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#completedDirUpload", QueueToadlet.l10n("completedDU", new String[]{"size"}, new String[]{String.valueOf(completedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (!failedDownload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedDownload", QueueToadlet.l10n("failedD", new String[]{"size"}, new String[]{String.valueOf(failedDownload.size())}));
            includeNavigationBar = true;
        }
        if (!failedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedUpload", QueueToadlet.l10n("failedU", new String[]{"size"}, new String[]{String.valueOf(failedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!failedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#failedDirUpload", QueueToadlet.l10n("failedDU", new String[]{"size"}, new String[]{String.valueOf(failedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (failedUnknownMIMEType.size() > 0) {
            types2 = failedUnknownMIMEType.keySet().toArray(new String[failedUnknownMIMEType.size()]);
            Arrays.sort(types2);
            for (Object type : types2) {
                atype2 = ((String)type).replace("-", "--").replace('/', '-');
                navigationContent.addChild("li").addChild("a", "href", "#failedDownload-unknowntype-" + atype2, QueueToadlet.l10n("failedDUnknownMIME", new String[]{"size", "type"}, new String[]{String.valueOf(((LinkedList)failedUnknownMIMEType.get(type)).size()), type}));
            }
        }
        if (failedBadMIMEType.size() > 0) {
            types2 = failedBadMIMEType.keySet().toArray(new String[failedBadMIMEType.size()]);
            Arrays.sort(types2);
            for (Object type : types2) {
                atype2 = ((String)type).replace("-", "--").replace('/', '-');
                navigationContent.addChild("li").addChild("a", "href", "#failedDownload-badtype-" + atype2, QueueToadlet.l10n("failedDBadMIME", new String[]{"size", "type"}, new String[]{String.valueOf(((LinkedList)failedBadMIMEType.get(type)).size()), type}));
            }
        }
        if (!uncompletedDownload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedDownload", QueueToadlet.l10n("DinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedDownload.size())}));
            includeNavigationBar = true;
        }
        if (!uncompletedUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedUpload", QueueToadlet.l10n("UinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedUpload.size())}));
            includeNavigationBar = true;
        }
        if (!uncompletedDirUpload.isEmpty()) {
            navigationContent.addChild("li").addChild("a", "href", "#uncompletedDirUpload", QueueToadlet.l10n("DUinProgress", new String[]{"size"}, new String[]{String.valueOf(uncompletedDirUpload.size())}));
            includeNavigationBar = true;
        }
        if (totalQueuedDownloadSize > 0L) {
            navigationContent.addChild("li", QueueToadlet.l10n("totalQueuedDownloads", "size", SizeUtil.formatSize(totalQueuedDownloadSize)));
            includeNavigationBar = true;
        }
        if (totalQueuedUploadSize > 0L) {
            navigationContent.addChild("li", QueueToadlet.l10n("totalQueuedUploads", "size", SizeUtil.formatSize(totalQueuedUploadSize)));
            includeNavigationBar = true;
        }
        navigationContent.addChild("li").addChild("a", "href", KEY_LIST_LOCATION, QueueToadlet.l10n("openKeyList"));
        if (includeNavigationBar) {
            contentNode.addChild(navigationBar);
        }
        String[] priorityClasses = new String[]{QueueToadlet.l10n("priority0"), QueueToadlet.l10n("priority1"), QueueToadlet.l10n("priority2"), QueueToadlet.l10n("priority3"), QueueToadlet.l10n("priority4"), QueueToadlet.l10n("priority5"), QueueToadlet.l10n("priority6")};
        boolean advancedModeEnabled = pageMaker.advancedMode(request, this.container);
        HTMLNode legendContent = pageMaker.getInfobox("legend", QueueToadlet.l10n("legend"), contentNode, "queue-legend", true);
        HTMLNode legendTable = legendContent.addChild("table", "class", "queue");
        HTMLNode legendRow = legendTable.addChild("tr");
        for (int i = 0; i < 7; ++i) {
            if (i <= 1 && !advancedModeEnabled && i > lowestQueuedPrio) continue;
            legendRow.addChild("td", "class", "priority" + i, priorityClasses[i]);
        }
        if (SimpleToadletServer.isPanicButtonToBeShown) {
            contentNode.addChild(this.createPanicBox(pageMaker, ctx));
        }
        QueueColumn[] advancedModeFailure = new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PROGRESS, QueueColumn.REASON, QueueColumn.PERSISTENCE, QueueColumn.KEY};
        QueueColumn[] simpleModeFailure = new QueueColumn[]{QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.PROGRESS, QueueColumn.REASON, QueueColumn.KEY};
        if (!completedDownloadToTemp.isEmpty()) {
            contentNode.addChild("a", "id", "completedDownloadToTemp");
            HTMLNode completedDownloadsToTempContent = pageMaker.getInfobox("completed_requests", QueueToadlet.l10n("completedDinTempDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToTemp.size())}), contentNode, "request-completed", false);
            if (advancedModeEnabled) {
                completedDownloadsToTempContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToTemp, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PERSISTENCE, QueueColumn.KEY, QueueColumn.COMPAT_MODE}, priorityClasses, advancedModeEnabled, "completed-temp", QueueType.CompletedDownloadToTemp));
            } else {
                completedDownloadsToTempContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToTemp, new QueueColumn[]{QueueColumn.SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-temp", QueueType.CompletedDownloadToTemp));
            }
        }
        if (!completedDownloadToDisk.isEmpty()) {
            contentNode.addChild("a", "id", "completedDownloadToDisk");
            HTMLNode completedToDiskInfoboxContent = pageMaker.getInfobox("completed_requests", QueueToadlet.l10n("completedDinDownloadDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDownloadToDisk.size())}), contentNode, "request-completed", false);
            if (advancedModeEnabled) {
                completedToDiskInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToDisk, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PERSISTENCE, QueueColumn.KEY, QueueColumn.COMPAT_MODE}, priorityClasses, advancedModeEnabled, "completed-disk", QueueType.CompletedDownloadToDisk));
            } else {
                completedToDiskInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedDownloadToDisk, new QueueColumn[]{QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-disk", QueueType.CompletedDownloadToDisk));
            }
        }
        if (!completedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "completedUpload");
            HTMLNode completedUploadInfoboxContent = pageMaker.getInfobox("completed_requests", QueueToadlet.l10n("completedU", new String[]{"size"}, new String[]{String.valueOf(completedUpload.size())}), contentNode, "download-completed", false);
            if (advancedModeEnabled) {
                completedUploadInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedUpload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-upload-file", QueueType.CompletedUpload));
            } else {
                completedUploadInfoboxContent.addChild(this.createRequestTable(pageMaker, ctx, completedUpload, new QueueColumn[]{QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-upload-file", QueueType.CompletedUpload));
            }
        }
        if (!completedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "completedDirUpload");
            HTMLNode completedUploadDirContent = pageMaker.getInfobox("completed_requests", QueueToadlet.l10n("completedUDirectory", new String[]{"size"}, new String[]{String.valueOf(completedDirUpload.size())}), contentNode, "download-completed", false);
            if (advancedModeEnabled) {
                completedUploadDirContent.addChild(this.createRequestTable(pageMaker, ctx, completedDirUpload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILES, QueueColumn.TOTAL_SIZE, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-upload-dir", QueueType.CompletedDirUpload));
            } else {
                completedUploadDirContent.addChild(this.createRequestTable(pageMaker, ctx, completedDirUpload, new QueueColumn[]{QueueColumn.FILES, QueueColumn.TOTAL_SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "completed-upload-dir", QueueType.CompletedDirUpload));
            }
        }
        if (!failedDownload.isEmpty()) {
            contentNode.addChild("a", "id", "failedDownload");
            failedContent = pageMaker.getInfobox("failed_requests", QueueToadlet.l10n("failedD", new String[]{"size"}, new String[]{String.valueOf(failedDownload.size())}), contentNode, "download-failed", false);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDownload, advancedModeFailure, priorityClasses, advancedModeEnabled, "failed-download", QueueType.FailedDownload));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDownload, simpleModeFailure, priorityClasses, advancedModeEnabled, "failed-download", QueueType.FailedDownload));
            }
        }
        if (!failedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "failedUpload");
            failedContent = pageMaker.getInfobox("failed_requests", QueueToadlet.l10n("failedU", new String[]{"size"}, new String[]{String.valueOf(failedUpload.size())}), contentNode, "upload-failed", false);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedUpload, advancedModeFailure, priorityClasses, advancedModeEnabled, "failed-upload-file", QueueType.FailedUpload));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedUpload, simpleModeFailure, priorityClasses, advancedModeEnabled, "failed-upload-file", QueueType.FailedUpload));
            }
        }
        if (!failedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "failedDirUpload");
            failedContent = pageMaker.getInfobox("failed_requests", QueueToadlet.l10n("failedU", new String[]{"size"}, new String[]{String.valueOf(failedDirUpload.size())}), contentNode, "upload-failed", false);
            if (advancedModeEnabled) {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDirUpload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILES, QueueColumn.TOTAL_SIZE, QueueColumn.PROGRESS, QueueColumn.REASON, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-upload-dir", QueueType.FailedDirUpload));
            } else {
                failedContent.addChild(this.createRequestTable(pageMaker, ctx, failedDirUpload, new QueueColumn[]{QueueColumn.FILES, QueueColumn.TOTAL_SIZE, QueueColumn.PROGRESS, QueueColumn.REASON, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-upload-dir", QueueType.FailedDirUpload));
            }
        }
        if (!failedBadMIMEType.isEmpty()) {
            types = failedBadMIMEType.keySet().toArray(new String[failedBadMIMEType.size()]);
            Arrays.sort(types);
            for (Object type : types) {
                getters = (LinkedList)failedBadMIMEType.get(type);
                atype = ((String)type).replace("-", "--").replace('/', '-');
                contentNode.addChild("a", "id", "failedDownload-badtype-" + atype);
                FilterMIMEType typeHandler = ContentFilter.getMIMEType((String)type);
                HTMLNode failedContent2 = pageMaker.getInfobox("failed_requests", QueueToadlet.l10n("failedDBadMIME", new String[]{"size", "type"}, new String[]{String.valueOf(getters.size()), type}), contentNode, "download-failed-" + atype, false);
                KnownUnsafeContentTypeException e = new KnownUnsafeContentTypeException(typeHandler);
                failedContent2.addChild("p", QueueToadlet.l10n("badMIMETypeIntro", "type", (String)type));
                List<String> detail = e.details();
                if (detail != null && !detail.isEmpty()) {
                    HTMLNode list = failedContent2.addChild("ul");
                    for (String s : detail) {
                        list.addChild("li", s);
                    }
                }
                failedContent2.addChild("p", QueueToadlet.l10n("mimeProblemFetchAnyway"));
                Collections.sort(getters, jobComparator);
                if (advancedModeEnabled) {
                    failedContent2.addChild(this.createRequestTable(pageMaker, ctx, getters, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-download-file-badmime", (String)type, QueueType.FailedBadMIMEType));
                    continue;
                }
                failedContent2.addChild(this.createRequestTable(pageMaker, ctx, getters, new QueueColumn[]{QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-download-file-badmime", (String)type, QueueType.FailedBadMIMEType));
            }
        }
        if (!failedUnknownMIMEType.isEmpty()) {
            types = failedUnknownMIMEType.keySet().toArray(new String[failedUnknownMIMEType.size()]);
            Arrays.sort(types);
            for (Object type : types) {
                getters = (LinkedList)failedUnknownMIMEType.get(type);
                atype = ((String)type).replace("-", "--").replace('/', '-');
                contentNode.addChild("a", "id", "failedDownload-unknowntype-" + atype);
                HTMLNode failedContent3 = pageMaker.getInfobox("failed_requests", QueueToadlet.l10n("failedDUnknownMIME", new String[]{"size", "type"}, new String[]{String.valueOf(getters.size()), type}), contentNode, "download-failed-" + atype, false);
                failedContent3.addChild("p", NodeL10n.getBase().getString("UnknownContentTypeException.explanation", "type", (String)type));
                failedContent3.addChild("p", QueueToadlet.l10n("mimeProblemFetchAnyway"));
                Collections.sort(getters, jobComparator);
                if (advancedModeEnabled) {
                    failedContent3.addChild(this.createRequestTable(pageMaker, ctx, getters, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-download-file-unknownmime", (String)type, QueueType.FailedUnknownMIMEType));
                    continue;
                }
                failedContent3.addChild(this.createRequestTable(pageMaker, ctx, getters, new QueueColumn[]{QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "failed-download-file-unknownmime", (String)type, QueueType.FailedUnknownMIMEType));
            }
        }
        if (!uncompletedDownload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedDownload");
            uncompletedContent = pageMaker.getInfobox("requests_in_progress", QueueToadlet.l10n("wipD", new String[]{"size"}, new String[]{String.valueOf(uncompletedDownload.size())}), contentNode, "download-progressing", false);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDownload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.PRIORITY, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.PERSISTENCE, QueueColumn.FILENAME, QueueColumn.KEY, QueueColumn.COMPAT_MODE}, priorityClasses, advancedModeEnabled, "uncompleted-download", QueueType.UncompletedDownload));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDownload, new QueueColumn[]{QueueColumn.PRIORITY, QueueColumn.SIZE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "uncompleted-download", QueueType.UncompletedDownload));
            }
        }
        if (!uncompletedUpload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedUpload");
            uncompletedContent = pageMaker.getInfobox("requests_in_progress", QueueToadlet.l10n("wipU", new String[]{"size"}, new String[]{String.valueOf(uncompletedUpload.size())}), contentNode, "upload-progressing", false);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedUpload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.PRIORITY, QueueColumn.SIZE, QueueColumn.MIME_TYPE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.PERSISTENCE, QueueColumn.FILENAME, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "uncompleted-upload-file", QueueType.UncompletedUpload));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedUpload, new QueueColumn[]{QueueColumn.PRIORITY, QueueColumn.FILENAME, QueueColumn.SIZE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "uncompleted-upload-file", QueueType.UncompletedUpload));
            }
        }
        if (!uncompletedDirUpload.isEmpty()) {
            contentNode.addChild("a", "id", "uncompletedDirUpload");
            uncompletedContent = pageMaker.getInfobox("requests_in_progress", QueueToadlet.l10n("wipDU", new String[]{"size"}, new String[]{String.valueOf(uncompletedDirUpload.size())}), contentNode, "download-progressing upload-progressing", false);
            if (advancedModeEnabled) {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDirUpload, new QueueColumn[]{QueueColumn.IDENTIFIER, QueueColumn.FILES, QueueColumn.PRIORITY, QueueColumn.TOTAL_SIZE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.PERSISTENCE, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "uncompleted-upload-dir", QueueType.UncompletedDirUpload));
            } else {
                uncompletedContent.addChild(this.createRequestTable(pageMaker, ctx, uncompletedDirUpload, new QueueColumn[]{QueueColumn.PRIORITY, QueueColumn.FILES, QueueColumn.TOTAL_SIZE, QueueColumn.PROGRESS, QueueColumn.LAST_ACTIVITY, QueueColumn.KEY}, priorityClasses, advancedModeEnabled, "uncompleted-upload-dir", QueueType.UncompletedDirUpload));
            }
        }
        if (!this.uploads) {
            contentNode.addChild(this.createBulkDownloadForm(ctx, pageMaker));
        }
        return pageNode;
    }

    private HTMLNode sendEmptyQueuePage(ToadletContext ctx, PageMaker pageMaker) {
        PageNode page = pageMaker.getPageNode(QueueToadlet.l10n("title" + (this.uploads ? "Uploads" : "Downloads")), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        HTMLNode infoboxContent = pageMaker.getInfobox("infobox-information", QueueToadlet.l10n("globalQueueIsEmpty"), contentNode, "queue-empty", true);
        infoboxContent.addChild("#", QueueToadlet.l10n("noTaskOnGlobalQueue"));
        if (!this.uploads) {
            contentNode.addChild(this.createBulkDownloadForm(ctx, pageMaker));
        }
        return pageNode;
    }

    private HTMLNode createReasonCell(String failureReason) {
        HTMLNode reasonCell = new HTMLNode("td", "class", "request-reason");
        if (failureReason == null) {
            reasonCell.addChild("span", "class", "failure_reason_unknown", QueueToadlet.l10n("unknown"));
        } else {
            reasonCell.addChild("span", "class", "failure_reason_is", failureReason);
        }
        return reasonCell;
    }

    public static HTMLNode createProgressCell(boolean advancedMode, boolean started, ClientPut.COMPRESS_STATE compressing, int fetched, int failed, int fatallyFailed, int min, int total, boolean finalized, boolean upload) {
        HTMLNode progressCell = new HTMLNode("td", "class", "request-progress");
        if (!started) {
            progressCell.addChild("#", QueueToadlet.l10n("starting"));
            return progressCell;
        }
        if (compressing == ClientPut.COMPRESS_STATE.WAITING && advancedMode) {
            progressCell.addChild("#", QueueToadlet.l10n("awaitingCompression"));
            return progressCell;
        }
        if (compressing != ClientPut.COMPRESS_STATE.WORKING) {
            progressCell.addChild("#", QueueToadlet.l10n("compressing"));
            return progressCell;
        }
        if (!advancedMode || total < min) {
            total = min;
        }
        if (fetched < 0 || total <= 0) {
            progressCell.addChild("span", "class", "progress_fraction_unknown", QueueToadlet.l10n("unknown"));
        } else {
            int fetchedPercent = (int)((double)fetched / (double)total * 100.0);
            int failedPercent = (int)((double)failed / (double)total * 100.0);
            int fatallyFailedPercent = (int)((double)fatallyFailed / (double)total * 100.0);
            int minPercent = (int)((double)min / (double)total * 100.0);
            HTMLNode progressBar = progressCell.addChild("div", "class", "progressbar");
            progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-done", "width: " + fetchedPercent + "%;"});
            if (failed > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed", "width: " + failedPercent + "%;"});
            }
            if (fatallyFailed > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed2", "width: " + fatallyFailedPercent + "%;"});
            }
            if (fetched + failed + fatallyFailed < min) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-min", "width: " + (minPercent - fetchedPercent) + "%;"});
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            String prefix = '(' + Integer.toString(fetched) + "/ " + Integer.toString(min) + "): ";
            if (finalized) {
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_finalized", prefix + QueueToadlet.l10n("progressbarAccurate")}, nf.format((double)((int)((double)fetched / (double)min * 1000.0)) / 10.0) + '%');
            } else {
                String text = nf.format((double)((int)((double)fetched / (double)min * 1000.0)) / 10.0) + '%';
                if (!finalized) {
                    text = "" + fetched + " (" + text + "??)";
                }
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_not_finalized", prefix + NodeL10n.getBase().getString(upload ? "QueueToadlet.uploadProgressbarNotAccurate" : "QueueToadlet.progressbarNotAccurate")}, text);
            }
        }
        return progressCell;
    }

    private HTMLNode createNumberCell(int numberOfFiles) {
        HTMLNode numberCell = new HTMLNode("td", "class", "request-files");
        numberCell.addChild("span", "class", "number_of_files", String.valueOf(numberOfFiles));
        return numberCell;
    }

    private HTMLNode createFilenameCell(File filename) {
        HTMLNode filenameCell = new HTMLNode("td", "class", "request-filename");
        if (filename != null) {
            filenameCell.addChild("span", "class", "filename_is", filename.toString());
        } else {
            filenameCell.addChild("span", "class", "filename_none", QueueToadlet.l10n("none"));
        }
        return filenameCell;
    }

    private HTMLNode createPriorityCell(short priorityClass, String[] priorityClasses) {
        HTMLNode priorityCell = new HTMLNode("td", "class", "request-priority");
        if (priorityClass < 0 || priorityClass >= priorityClasses.length) {
            priorityCell.addChild("span", "class", "priority_unknown", QueueToadlet.l10n("unknown"));
        } else {
            priorityCell.addChild("span", "class", "priority_is", priorityClasses[priorityClass]);
        }
        return priorityCell;
    }

    private HTMLNode createPriorityControl(PageMaker pageMaker, ToadletContext ctx, short priorityClass, String[] priorityClasses, boolean advancedModeEnabled, boolean isUpload, String controlSuffix) {
        HTMLNode priorityDiv = new HTMLNode("div", "class", "request-priority nowrap");
        priorityDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "change_priority" + controlSuffix, NodeL10n.getBase().getString(isUpload ? "QueueToadlet.changeUploadPriorities" : "QueueToadlet.changeDownloadPriorities")});
        HTMLNode prioritySelect = priorityDiv.addChild("select", "name", "priority" + controlSuffix);
        for (int p = 0; p < 7; ++p) {
            if (p <= 1 && !advancedModeEnabled) continue;
            if (p == priorityClass) {
                prioritySelect.addChild("option", new String[]{"value", "selected"}, new String[]{String.valueOf(p), "selected"}, priorityClasses[p]);
                continue;
            }
            prioritySelect.addChild("option", "value", String.valueOf(p), priorityClasses[p]);
        }
        return priorityDiv;
    }

    private HTMLNode createRecommendControl(PageMaker pageMaker, ToadletContext ctx) {
        HTMLNode recommendDiv = new HTMLNode("div", "class", "request-recommend");
        recommendDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "recommend_request", QueueToadlet.l10n("recommendFilesToFriends")});
        return recommendDiv;
    }

    private HTMLNode createDeleteControl(PageMaker pageMaker, ToadletContext ctx, String mimeType, QueueType queueType) {
        HTMLNode deleteDiv = new HTMLNode("div", "class", "request-delete");
        if (queueType == QueueType.CompletedDownloadToTemp) {
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "delete_request", QueueToadlet.l10n("deleteFilesFromTemp")});
        } else if (!queueType.isCompleted) {
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_request", QueueToadlet.l10n("cancelSelected")});
        } else {
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_request", QueueToadlet.l10n("removeFilesFromList")});
        }
        if (queueType == QueueType.CompletedDownloadToDisk) {
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_finished_downloads_request", QueueToadlet.l10n("removeFinishedDownloads")});
        }
        if (queueType == QueueType.CompletedUpload) {
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "remove_finished_uploads_request", QueueToadlet.l10n("removeFinishedUploads")});
        }
        if (queueType.isFailed) {
            String restartName = NodeL10n.getBase().getString("QueueToadlet.restartSelected");
            deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart_request", restartName});
            if (mimeType != null) {
                HTMLNode input = deleteDiv.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "disableFilterData", "disableFilterData"});
                deleteDiv.addChild("#", QueueToadlet.l10n("disableFilter", "type", mimeType));
            }
        }
        return deleteDiv;
    }

    private HTMLNode createPanicBox(PageMaker pageMaker, ToadletContext ctx) {
        InfoboxNode infobox = pageMaker.getInfobox("infobox-alert", QueueToadlet.l10n("panicButtonTitle"), "panic-button", true);
        HTMLNode panicBox = infobox.outer;
        HTMLNode panicForm = ctx.addFormChild(infobox.content, this.path(), "queuePanicForm");
        panicForm.addChild("#", (SimpleToadletServer.noConfirmPanic ? QueueToadlet.l10n("panicButtonNoConfirmation") : QueueToadlet.l10n("panicButtonWithConfirmation")) + ' ');
        panicForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "panic", QueueToadlet.l10n("panicButton")});
        return panicBox;
    }

    private HTMLNode createIdentifierCell(FreenetURI uri, String identifier, boolean directory) {
        HTMLNode identifierCell = new HTMLNode("td", "class", "request-identifier");
        if (uri != null) {
            identifierCell.addChild("span", "class", "identifier_with_uri").addChild("a", "href", "/" + uri + (directory ? "/" : ""), identifier);
        } else {
            identifierCell.addChild("span", "class", "identifier_without_uri", identifier);
        }
        return identifierCell;
    }

    private HTMLNode createPersistenceCell(boolean persistent, boolean persistentForever) {
        HTMLNode persistenceCell = new HTMLNode("td", "class", "request-persistence");
        if (persistentForever) {
            persistenceCell.addChild("span", "class", "persistence_forever", QueueToadlet.l10n("persistenceForever"));
        } else if (persistent) {
            persistenceCell.addChild("span", "class", "persistence_reboot", QueueToadlet.l10n("persistenceReboot"));
        } else {
            persistenceCell.addChild("span", "class", "persistence_none", QueueToadlet.l10n("persistenceNone"));
        }
        return persistenceCell;
    }

    private HTMLNode createTypeCell(String type) {
        HTMLNode typeCell = new HTMLNode("td", "class", "request-type");
        if (type != null) {
            typeCell.addChild("span", "class", "mimetype_is", type);
        } else {
            typeCell.addChild("span", "class", "mimetype_unknown", QueueToadlet.l10n("unknown"));
        }
        return typeCell;
    }

    private HTMLNode createSizeCell(long dataSize, boolean confirmed, boolean advancedModeEnabled) {
        HTMLNode sizeCell = new HTMLNode("td", "class", "request-size");
        if (dataSize > 0L && (confirmed || advancedModeEnabled)) {
            sizeCell.addChild("span", "class", "filesize_is", (confirmed ? "" : ">= ") + SizeUtil.formatSize(dataSize) + (confirmed ? "" : " ??"));
        } else {
            sizeCell.addChild("span", "class", "filesize_unknown", QueueToadlet.l10n("unknown"));
        }
        return sizeCell;
    }

    private HTMLNode createKeyCell(FreenetURI uri, boolean addSlash) {
        HTMLNode keyCell = new HTMLNode("td", "class", "request-key");
        if (uri != null) {
            keyCell.addChild("span", "class", "key_is").addChild("a", "href", '/' + uri.toString() + (addSlash ? "/" : ""), uri.toShortString() + (addSlash ? "/" : ""));
        } else {
            keyCell.addChild("span", "class", "key_unknown", QueueToadlet.l10n("unknown"));
        }
        return keyCell;
    }

    private HTMLNode createBulkDownloadForm(ToadletContext ctx, PageMaker pageMaker) {
        InfoboxNode infobox = pageMaker.getInfobox(QueueToadlet.l10n("downloadFiles"), "grouped-downloads", true);
        HTMLNode downloadBox = infobox.outer;
        HTMLNode downloadBoxContent = infobox.content;
        HTMLNode downloadForm = ctx.addFormChild(downloadBoxContent, this.path(), "queueDownloadForm");
        downloadForm.addChild("#", QueueToadlet.l10n("downloadFilesInstructions"));
        downloadForm.addChild("br");
        downloadForm.addChild("textarea", new String[]{"id", "name", "cols", "rows"}, new String[]{"bulkDownloads", "bulkDownloads", "120", "8"});
        downloadForm.addChild("br");
        SecurityLevels.PHYSICAL_THREAT_LEVEL threatLevel = this.core.node.securityLevels.getPhysicalThreatLevel();
        if (threatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH || threatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM || this.core.isDownloadDisabled()) {
            downloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "target", "direct"});
        } else if (threatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
            downloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "target", "disk"});
            this.selectLocation(downloadForm);
        } else {
            downloadForm.addChild("br");
            downloadForm.addChild("input", new String[]{"type", "value", "name"}, new String[]{"radio", "disk", "target"}, ' ' + QueueToadlet.l10n("bulkDownloadSelectOptionDisk") + ' ');
            this.selectLocation(downloadForm);
            downloadForm.addChild("br");
            downloadForm.addChild("input", new String[]{"type", "value", "name", "checked"}, new String[]{"radio", "direct", "target", "checked"}, ' ' + QueueToadlet.l10n("bulkDownloadSelectOptionDirect") + ' ');
        }
        HTMLNode filterControl = downloadForm.addChild("div", QueueToadlet.l10n("filterData"));
        filterControl.addChild("input", new String[]{"type", "name", "value", "checked"}, new String[]{"checkbox", "filterData", "filterData", "checked"});
        filterControl.addChild("#", QueueToadlet.l10n("filterDataMessage"));
        downloadForm.addChild("br");
        downloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "insert", QueueToadlet.l10n("download")});
        return downloadBox;
    }

    private void selectLocation(HTMLNode node) {
        String downloadLocation = this.core.getDownloadsDir().getAbsolutePath();
        if (!this.core.allowDownloadTo(this.core.getDownloadsDir())) {
            downloadLocation = this.core.getAllowedDownloadDirs()[0].getAbsolutePath();
        }
        node.addChild("input", new String[]{"type", "name", "value", "maxlength", "size"}, new String[]{"text", "path", downloadLocation, Integer.toString(0x100000), String.valueOf(downloadLocation.length())});
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "select-location", QueueToadlet.l10n("browseToChange") + "..."});
    }

    private HTMLNode createLastActivityCell(long now, Date lastActivity) {
        HTMLNode lastActivityCell = new HTMLNode("td", "class", "request-last-activity");
        if (lastActivity == null) {
            lastActivityCell.addChild("i", QueueToadlet.l10n("lastActivity.unknown"));
        } else {
            lastActivityCell.addChild("#", QueueToadlet.l10n("lastActivity.ago", "time", TimeUtil.formatTime(now - lastActivity.getTime())));
        }
        return lastActivityCell;
    }

    private HTMLNode createLastFailureCell(long now, Date lastFailure) {
        HTMLNode lastFailureCell = new HTMLNode("td", "class", "request-last-failure");
        if (lastFailure == null) {
            lastFailureCell.addChild("i", QueueToadlet.l10n("lastFailure.never"));
        } else {
            lastFailureCell.addChild("#", QueueToadlet.l10n("lastFailure.ago", "time", TimeUtil.formatTime(now - lastFailure.getTime())));
        }
        return lastFailureCell;
    }

    private HTMLNode createRequestTable(PageMaker pageMaker, ToadletContext ctx, List<? extends RequestStatus> requests, QueueColumn[] columns, String[] priorityClasses, boolean advancedModeEnabled, String id, QueueType queueType) {
        return this.createRequestTable(pageMaker, ctx, requests, columns, priorityClasses, advancedModeEnabled, id, null, queueType);
    }

    /*
     * WARNING - void declaration
     */
    private HTMLNode createRequestTable(PageMaker pageMaker, ToadletContext ctx, List<? extends RequestStatus> requests, QueueColumn[] columns, String[] priorityClasses, boolean advancedModeEnabled, String id, String mimeType, QueueType queueType) {
        void var19_21;
        boolean hasFriends = this.core.node.getDarknetConnections().length > 0;
        long now = System.currentTimeMillis();
        HTMLNode formDiv = new HTMLNode("div", "class", "request-table-form");
        HTMLNode form = ctx.addFormChild(formDiv, this.path(), "request-table-form-" + id + (advancedModeEnabled ? "-advanced" : "-simple"));
        this.createRequestTableButtons(form, pageMaker, ctx, mimeType, hasFriends, advancedModeEnabled, priorityClasses, true, queueType);
        HTMLNode table = form.addChild("table", "class", "requests");
        HTMLNode headerRow = table.addChild("tr", "class", "table-header");
        headerRow.addChild("th");
        QueueColumn[] queueColumnArray = columns;
        int n = queueColumnArray.length;
        boolean bl = false;
        while (var19_21 < n) {
            QueueColumn column = queueColumnArray[var19_21];
            switch (column) {
                case IDENTIFIER: {
                    headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=id" : "?sortBy=id&reversed").addChild("#", QueueToadlet.l10n("identifier"));
                    break;
                }
                case SIZE: {
                    headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=size" : "?sortBy=size&reversed").addChild("#", QueueToadlet.l10n("size"));
                    break;
                }
                case MIME_TYPE: {
                    headerRow.addChild("th", QueueToadlet.l10n("mimeType"));
                    break;
                }
                case PERSISTENCE: {
                    headerRow.addChild("th", QueueToadlet.l10n("persistence"));
                    break;
                }
                case KEY: {
                    headerRow.addChild("th", QueueToadlet.l10n("key"));
                    break;
                }
                case FILENAME: {
                    headerRow.addChild("th", QueueToadlet.l10n("fileName"));
                    break;
                }
                case PRIORITY: {
                    headerRow.addChild("th", QueueToadlet.l10n("priority"));
                    break;
                }
                case FILES: {
                    headerRow.addChild("th", QueueToadlet.l10n("files"));
                    break;
                }
                case TOTAL_SIZE: {
                    headerRow.addChild("th", QueueToadlet.l10n("totalSize"));
                    break;
                }
                case PROGRESS: {
                    headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=progress" : "?sortBy=progress&reversed").addChild("#", QueueToadlet.l10n("progress"));
                    break;
                }
                case REASON: {
                    headerRow.addChild("th", QueueToadlet.l10n("reason"));
                    break;
                }
                case LAST_ACTIVITY: {
                    headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=lastActivity" : "?sortBy=lastActivity&reversed", QueueToadlet.l10n("lastActivity"));
                    break;
                }
                case LAST_FAILURE: {
                    headerRow.addChild("th").addChild("a", "href", this.isReversed ? "?sortBy=lastFailure" : "?sortBy=lastFailure&reversed", QueueToadlet.l10n("lastFailure"));
                    break;
                }
                case COMPAT_MODE: {
                    headerRow.addChild("th", QueueToadlet.l10n("compatibilityMode"));
                }
            }
            ++var19_21;
        }
        int x = 0;
        for (RequestStatus requestStatus : requests) {
            HTMLNode requestRow = table.addChild("tr", "class", "priority" + requestStatus.getPriority());
            requestRow.addChild(this.createCheckboxCell(requestStatus, x++));
            block34: for (QueueColumn column : columns) {
                switch (column) {
                    case IDENTIFIER: {
                        requestRow.addChild(this.createIdentifierCell(requestStatus.getURI(), requestStatus.getIdentifier(), requestStatus instanceof UploadDirRequestStatus));
                        continue block34;
                    }
                    case SIZE: {
                        boolean isFinal = true;
                        if (requestStatus instanceof DownloadRequestStatus) {
                            isFinal = ((DownloadRequestStatus)requestStatus).isTotalFinalized();
                        }
                        requestRow.addChild(this.createSizeCell(requestStatus.getDataSize(), isFinal, advancedModeEnabled));
                        continue block34;
                    }
                    case MIME_TYPE: {
                        if (requestStatus instanceof DownloadRequestStatus) {
                            requestRow.addChild(this.createTypeCell(((DownloadRequestStatus)requestStatus).getMIMEType()));
                            continue block34;
                        }
                        if (!(requestStatus instanceof UploadFileRequestStatus)) continue block34;
                        requestRow.addChild(this.createTypeCell(((UploadFileRequestStatus)requestStatus).getMIMEType()));
                        continue block34;
                    }
                    case PERSISTENCE: {
                        requestRow.addChild(this.createPersistenceCell(requestStatus.isPersistent(), requestStatus.isPersistentForever()));
                        continue block34;
                    }
                    case KEY: {
                        if (requestStatus instanceof DownloadRequestStatus) {
                            requestRow.addChild(this.createKeyCell(((DownloadRequestStatus)requestStatus).getURI(), false));
                            continue block34;
                        }
                        if (requestStatus instanceof UploadFileRequestStatus) {
                            requestRow.addChild(this.createKeyCell(((UploadFileRequestStatus)requestStatus).getFinalURI(), false));
                            continue block34;
                        }
                        requestRow.addChild(this.createKeyCell(((UploadDirRequestStatus)requestStatus).getFinalURI(), true));
                        continue block34;
                    }
                    case FILENAME: {
                        if (requestStatus instanceof DownloadRequestStatus) {
                            requestRow.addChild(this.createFilenameCell(((DownloadRequestStatus)requestStatus).getDestFilename()));
                            continue block34;
                        }
                        if (!(requestStatus instanceof UploadFileRequestStatus)) continue block34;
                        requestRow.addChild(this.createFilenameCell(((UploadFileRequestStatus)requestStatus).getOrigFilename()));
                        continue block34;
                    }
                    case PRIORITY: {
                        requestRow.addChild(this.createPriorityCell(requestStatus.getPriority(), priorityClasses));
                        continue block34;
                    }
                    case FILES: {
                        requestRow.addChild(this.createNumberCell(((UploadDirRequestStatus)requestStatus).getNumberOfFiles()));
                        continue block34;
                    }
                    case TOTAL_SIZE: {
                        requestRow.addChild(this.createSizeCell(((UploadDirRequestStatus)requestStatus).getTotalDataSize(), true, advancedModeEnabled));
                        continue block34;
                    }
                    case PROGRESS: {
                        if (requestStatus instanceof UploadFileRequestStatus) {
                            requestRow.addChild(QueueToadlet.createProgressCell(ctx.isAdvancedModeEnabled(), requestStatus.isStarted(), ((UploadFileRequestStatus)requestStatus).isCompressing(), requestStatus.getFetchedBlocks(), requestStatus.getFailedBlocks(), requestStatus.getFatalyFailedBlocks(), requestStatus.getMinBlocks(), requestStatus.getTotalBlocks(), requestStatus.isTotalFinalized() || requestStatus instanceof UploadFileRequestStatus, queueType.isUpload));
                            continue block34;
                        }
                        requestRow.addChild(QueueToadlet.createProgressCell(ctx.isAdvancedModeEnabled(), requestStatus.isStarted(), ClientPut.COMPRESS_STATE.WORKING, requestStatus.getFetchedBlocks(), requestStatus.getFailedBlocks(), requestStatus.getFatalyFailedBlocks(), requestStatus.getMinBlocks(), requestStatus.getTotalBlocks(), requestStatus.isTotalFinalized() || requestStatus instanceof UploadFileRequestStatus, queueType.isUpload));
                        continue block34;
                    }
                    case REASON: {
                        requestRow.addChild(this.createReasonCell(requestStatus.getFailureReason(false)));
                        continue block34;
                    }
                    case LAST_ACTIVITY: {
                        requestRow.addChild(this.createLastActivityCell(now, requestStatus.getLastSuccess()));
                        continue block34;
                    }
                    case LAST_FAILURE: {
                        requestRow.addChild(this.createLastFailureCell(now, requestStatus.getLastFailure()));
                        continue block34;
                    }
                    case COMPAT_MODE: {
                        if (requestStatus instanceof DownloadRequestStatus) {
                            requestRow.addChild(this.createCompatModeCell((DownloadRequestStatus)requestStatus));
                            continue block34;
                        }
                        requestRow.addChild("td");
                    }
                }
            }
        }
        this.createRequestTableButtons(form, pageMaker, ctx, mimeType, hasFriends, advancedModeEnabled, priorityClasses, false, queueType);
        return formDiv;
    }

    private boolean queueCannotRecommend(QueueType queueType) {
        return queueType.isUpload && !queueType.isCompleted;
    }

    private void createRequestTableButtons(HTMLNode form, PageMaker pageMaker, ToadletContext ctx, String mimeType, boolean hasFriends, boolean advancedModeEnabled, String[] priorityClasses, boolean top, QueueType queueType) {
        form.addChild(this.createDeleteControl(pageMaker, ctx, mimeType, queueType));
        if (hasFriends && !this.queueCannotRecommend(queueType)) {
            form.addChild(this.createRecommendControl(pageMaker, ctx));
        }
        if (!queueType.isFailed && !queueType.isCompleted) {
            form.addChild(this.createPriorityControl(pageMaker, ctx, (short)4, priorityClasses, advancedModeEnabled, queueType.isUpload, top ? "_top" : "_bottom"));
        }
    }

    private HTMLNode createCheckboxCell(RequestStatus clientRequest, int counter) {
        FreenetURI uri;
        HTMLNode cell = new HTMLNode("td", "class", "checkbox-cell");
        String identifier = clientRequest.getIdentifier();
        cell.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", "identifier-" + counter, identifier});
        long size = -1L;
        String filename = null;
        if (clientRequest instanceof DownloadRequestStatus) {
            uri = clientRequest.getURI();
            size = clientRequest.getDataSize();
        } else if (clientRequest instanceof UploadRequestStatus) {
            uri = ((UploadRequestStatus)clientRequest).getFinalURI();
            size = clientRequest.getDataSize();
        } else {
            uri = null;
        }
        if (uri != null) {
            cell.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key-" + counter, uri.toASCIIString()});
        }
        filename = clientRequest.getPreferredFilenameSafe();
        if (size != -1L) {
            cell.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "size-" + counter, Long.toString(size)});
        }
        if (filename != null) {
            cell.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "filename-" + counter, filename});
        }
        return cell;
    }

    private HTMLNode createCompatModeCell(DownloadRequestStatus get) {
        HTMLNode compatCell = new HTMLNode("td", "class", "request-compat-mode");
        InsertContext.CompatibilityMode[] compat = get.getCompatibilityMode();
        if (compat[0] != InsertContext.CompatibilityMode.COMPAT_UNKNOWN || compat[1] != InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
            if (compat[0] == compat[1]) {
                compatCell.addChild("#", NodeL10n.getBase().getString("InsertContext.CompatibilityMode." + compat[0].name()));
            } else {
                compatCell.addChild("#", NodeL10n.getBase().getString("InsertContext.CompatibilityMode." + compat[0].name()) + " - " + NodeL10n.getBase().getString("InsertContext.CompatibilityMode." + compat[1].name()));
            }
            byte[] overrideCryptoKey = get.getOverriddenSplitfileCryptoKey();
            if (overrideCryptoKey != null) {
                compatCell.addChild("#", " - " + QueueToadlet.l10n("overriddenCryptoKeyInCompatCell") + ": " + HexUtil.bytesToHex(overrideCryptoKey));
            }
            if (get.detectedDontCompress()) {
                compatCell.addChild("#", " (" + QueueToadlet.l10n("dontCompressInCompatCell") + ")");
            }
        }
        return compatCell;
    }

    @Override
    public void notifyFailure(ClientRequest req) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySuccess(ClientRequest req) {
        if (this.uploads == req instanceof ClientGet) {
            return;
        }
        HashSet<String> hashSet = this.completedRequestIdentifiers;
        synchronized (hashSet) {
            this.completedRequestIdentifiers.add(req.getIdentifier());
        }
        this.registerAlert(req);
        this.saveCompletedIdentifiersOffThread();
    }

    private void saveCompletedIdentifiersOffThread() {
        this.core.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                QueueToadlet.this.saveCompletedIdentifiers();
            }
        }, "Save completed identifiers");
    }

    private void loadCompletedIdentifiers() throws PersistenceDisabledException {
        String dl = this.uploads ? "uploads" : "downloads";
        File completedIdentifiersList = this.core.node.userDir().file("completed.list." + dl);
        File completedIdentifiersListNew = this.core.node.userDir().file("completed.list." + dl + ".bak");
        File oldCompletedIdentifiersList = this.core.node.userDir().file("completed.list");
        boolean migrated = false;
        if (!this.readCompletedIdentifiers(completedIdentifiersList)) {
            if (!this.readCompletedIdentifiers(completedIdentifiersListNew)) {
                this.readCompletedIdentifiers(oldCompletedIdentifiersList);
                migrated = true;
            }
        } else {
            oldCompletedIdentifiersList.delete();
        }
        final boolean writeAnyway = migrated;
        this.core.clientContext.jobRunner.queue(new PersistentJob(){

            public String toString() {
                return "QueueToadlet LoadCompletedIdentifiers";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                String[] identifiers;
                boolean changed = writeAnyway;
                String[] stringArray = QueueToadlet.this.completedRequestIdentifiers;
                synchronized (stringArray) {
                    identifiers = QueueToadlet.this.completedRequestIdentifiers.toArray(new String[QueueToadlet.this.completedRequestIdentifiers.size()]);
                }
                for (String identifier : identifiers) {
                    ClientRequest req = QueueToadlet.this.fcp.getGlobalRequest(identifier);
                    if (req == null || req instanceof ClientGet == QueueToadlet.this.uploads) {
                        HashSet hashSet = QueueToadlet.this.completedRequestIdentifiers;
                        synchronized (hashSet) {
                            QueueToadlet.this.completedRequestIdentifiers.remove(identifier);
                        }
                        changed = true;
                        continue;
                    }
                    QueueToadlet.this.registerAlert(req);
                }
                if (changed) {
                    QueueToadlet.this.saveCompletedIdentifiers();
                }
                return false;
            }
        }, NativeThread.HIGH_PRIORITY);
    }

    /*
     * Exception decompiling
     */
    private boolean readCompletedIdentifiers(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCompletedIdentifiers() {
        File temp;
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        String dl = this.uploads ? "uploads" : "downloads";
        File completedIdentifiersList = this.core.node.userDir().file("completed.list." + dl);
        File completedIdentifiersListNew = this.core.node.userDir().file("completed.list." + dl + ".bak");
        try {
            temp = File.createTempFile("completed.list", ".tmp", this.core.node.getUserDir());
            temp.deleteOnExit();
            fos = new FileOutputStream(temp);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            String[] stringArray = this.completedRequestIdentifiers;
            synchronized (this.completedRequestIdentifiers) {
                String[] identifiers = this.completedRequestIdentifiers.toArray(new String[this.completedRequestIdentifiers.size()]);
                // ** MonitorExit[var9_12] (shouldn't be in output)
                for (String identifier : identifiers) {
                    bw.write(identifier + '\n');
                }
            }
        }
        catch (FileNotFoundException e) {
            Logger.error(this, "Unable to save completed requests list (can't find node directory?!!?): " + e, (Throwable)e);
            return;
        }
        catch (IOException e) {
            Logger.error(this, "Unable to save completed requests list: " + e, (Throwable)e);
            return;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        {
            completedIdentifiersListNew.delete();
            temp.renameTo(completedIdentifiersListNew);
            if (!completedIdentifiersListNew.renameTo(completedIdentifiersList)) {
                completedIdentifiersList.delete();
                if (!completedIdentifiersListNew.renameTo(completedIdentifiersList)) {
                    Logger.error(this, "Unable to store completed identifiers list because unable to rename " + completedIdentifiersListNew + " to " + completedIdentifiersList);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAlert(ClientRequest req) {
        String identifier = req.getIdentifier();
        if (logMINOR) {
            Logger.minor(this, "Registering alert for " + identifier);
        }
        if (!req.hasFinished()) {
            if (logMINOR) {
                Logger.minor(this, "Request hasn't finished: " + req + " for " + identifier, (Throwable)new Exception("debug"));
            }
            return;
        }
        if (req instanceof ClientGet) {
            FreenetURI uri = ((ClientGet)req).getURI();
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientGet)req).getDataSize();
            GetCompletedEvent event = new GetCompletedEvent(identifier, uri, size);
            Map<String, GetCompletedEvent> map = this.completedGets;
            synchronized (map) {
                this.completedGets.put(identifier, event);
            }
            this.core.alerts.register(event);
        } else if (req instanceof ClientPut) {
            FreenetURI uri = ((ClientPut)req).getFinalURI();
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientPut)req).getDataSize();
            PutCompletedEvent event = new PutCompletedEvent(identifier, uri, size);
            Map<String, PutCompletedEvent> map = this.completedPuts;
            synchronized (map) {
                this.completedPuts.put(identifier, event);
            }
            this.core.alerts.register(event);
        } else if (req instanceof ClientPutDir) {
            FreenetURI uri = ((ClientPutDir)req).getFinalURI();
            if (uri == null) {
                Logger.error(this, "No URI for supposedly finished request " + req);
                return;
            }
            long size = ((ClientPutDir)req).getTotalDataSize();
            int files = ((ClientPutDir)req).getNumberOfFiles();
            PutDirCompletedEvent event = new PutDirCompletedEvent(identifier, uri, size, files);
            Map<String, PutDirCompletedEvent> map = this.completedPutDirs;
            synchronized (map) {
                this.completedPutDirs.put(identifier, event);
            }
            this.core.alerts.register(event);
        }
    }

    static String l10n(String key) {
        return NodeL10n.getBase().getString("QueueToadlet." + key);
    }

    static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("QueueToadlet." + key, pattern, value);
    }

    static String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("QueueToadlet." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemove(ClientRequest req) {
        String identifier = req.getIdentifier();
        Map<String, StoringUserEvent> map = this.completedRequestIdentifiers;
        synchronized (map) {
            this.completedRequestIdentifiers.remove(identifier);
        }
        if (req instanceof ClientGet) {
            map = this.completedGets;
            synchronized (map) {
                this.completedGets.remove(identifier);
            }
        }
        if (req instanceof ClientPut) {
            map = this.completedPuts;
            synchronized (map) {
                this.completedPuts.remove(identifier);
            }
        }
        if (req instanceof ClientPutDir) {
            map = this.completedPutDirs;
            synchronized (map) {
                this.completedPutDirs.remove(identifier);
            }
        }
        this.saveCompletedIdentifiersOffThread();
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        return !this.container.publicGatewayMode() || ctx != null && ctx.isAllowedFullAccess();
    }

    @Override
    public String path() {
        if (this.uploads) {
            return PATH_UPLOADS;
        }
        return PATH_DOWNLOADS;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        DOWNLOADS_LINK = HTMLNode.link(PATH_DOWNLOADS).setReadOnly();
        UPLOADS_LINK = HTMLNode.link(PATH_UPLOADS).setReadOnly();
    }

    private class PutDirCompletedEvent
    extends StoringUserEvent<PutDirCompletedEvent> {
        private final String identifier;
        private final FreenetURI uri;
        private final long size;
        private final int files;

        public PutDirCompletedEvent(String identifier, FreenetURI uri, long size, int files) {
            super(UserEvent.Type.PutDirCompleted, true, null, null, null, null, (short)3, true, NodeL10n.getBase().getString("UserAlert.hide"), true, null, QueueToadlet.this.completedPutDirs);
            this.identifier = identifier;
            this.uri = uri;
            this.size = size;
            this.files = files;
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            QueueToadlet.this.saveCompletedIdentifiersOffThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEventDismiss() {
            HashSet hashSet = QueueToadlet.this.completedRequestIdentifiers;
            synchronized (hashSet) {
                QueueToadlet.this.completedRequestIdentifiers.remove(this.identifier);
            }
        }

        @Override
        public HTMLNode getEventHTMLText() {
            String name = this.uri.getPreferredFilename();
            HTMLNode text = new HTMLNode("div");
            NodeL10n.getBase().addL10nSubstitution(text, "QueueToadlet.siteUploadSucceeded", new String[]{"link", "filename", "size", "files"}, new HTMLNode[]{HTMLNode.link("/" + this.uri.toASCIIString()), HTMLNode.text(name), HTMLNode.text(SizeUtil.formatSize(this.size)), HTMLNode.text(this.files)});
            return text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getTitle() {
            String title = null;
            Map map = this.events;
            synchronized (map) {
                title = this.events.size() == 1 ? QueueToadlet.l10n("siteUploadSucceededTitle", "filename", this.uri.getPreferredFilename()) : QueueToadlet.l10n("sitesUploadSucceededTitle", "nr", Integer.toString(this.events.size()));
            }
            return title;
        }

        @Override
        public String getShortText() {
            return this.getTitle();
        }

        @Override
        public String getEventText() {
            return QueueToadlet.l10n("siteUploadSucceededTitle", "filename", this.uri.getPreferredFilename());
        }
    }

    private class PutCompletedEvent
    extends StoringUserEvent<PutCompletedEvent> {
        private final String identifier;
        private final FreenetURI uri;
        private final long size;

        public PutCompletedEvent(String identifier, FreenetURI uri, long size) {
            super(UserEvent.Type.PutCompleted, true, null, null, null, null, (short)3, true, NodeL10n.getBase().getString("UserAlert.hide"), true, null, QueueToadlet.this.completedPuts);
            this.identifier = identifier;
            this.uri = uri;
            this.size = size;
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            QueueToadlet.this.saveCompletedIdentifiersOffThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEventDismiss() {
            HashSet hashSet = QueueToadlet.this.completedRequestIdentifiers;
            synchronized (hashSet) {
                QueueToadlet.this.completedRequestIdentifiers.remove(this.identifier);
            }
        }

        @Override
        public HTMLNode getEventHTMLText() {
            HTMLNode text = new HTMLNode("div");
            NodeL10n.getBase().addL10nSubstitution(text, "QueueToadlet.uploadSucceeded", new String[]{"link", "filename", "size"}, new HTMLNode[]{HTMLNode.link("/" + this.uri.toASCIIString()), HTMLNode.text(this.uri.getPreferredFilename()), HTMLNode.text(SizeUtil.formatSize(this.size))});
            return text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getTitle() {
            String title = null;
            Map map = this.events;
            synchronized (map) {
                title = this.events.size() == 1 ? QueueToadlet.l10n("uploadSucceededTitle", "filename", this.uri.getPreferredFilename()) : QueueToadlet.l10n("uploadsSucceededTitle", "nr", Integer.toString(this.events.size()));
            }
            return title;
        }

        @Override
        public String getShortText() {
            return this.getTitle();
        }

        @Override
        public String getEventText() {
            return QueueToadlet.l10n("uploadSucceededTitle", "filename", this.uri.getPreferredFilename());
        }
    }

    private class GetCompletedEvent
    extends StoringUserEvent<GetCompletedEvent> {
        private final String identifier;
        private final FreenetURI uri;
        private final long size;

        public GetCompletedEvent(String identifier, FreenetURI uri, long size) {
            super(UserEvent.Type.GetCompleted, true, null, null, null, null, (short)3, true, NodeL10n.getBase().getString("UserAlert.hide"), true, null, QueueToadlet.this.completedGets);
            this.identifier = identifier;
            this.uri = uri;
            this.size = size;
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            QueueToadlet.this.saveCompletedIdentifiersOffThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEventDismiss() {
            HashSet hashSet = QueueToadlet.this.completedRequestIdentifiers;
            synchronized (hashSet) {
                QueueToadlet.this.completedRequestIdentifiers.remove(this.identifier);
            }
        }

        @Override
        public HTMLNode getEventHTMLText() {
            HTMLNode text = new HTMLNode("div");
            NodeL10n.getBase().addL10nSubstitution(text, "QueueToadlet.downloadSucceeded", new String[]{"link", "origlink", "filename", "size"}, new HTMLNode[]{HTMLNode.link("/" + this.uri.toASCIIString() + "?max-size=" + this.size), HTMLNode.link("/" + this.uri.toASCIIString()), HTMLNode.text(this.uri.getPreferredFilename()), HTMLNode.text(SizeUtil.formatSize(this.size))});
            return text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getTitle() {
            String title = null;
            Map map = this.events;
            synchronized (map) {
                title = this.events.size() == 1 ? QueueToadlet.l10n("downloadSucceededTitle", "filename", this.uri.getPreferredFilename()) : QueueToadlet.l10n("downloadsSucceededTitle", "nr", Integer.toString(this.events.size()));
            }
            return title;
        }

        @Override
        public String getShortText() {
            return this.getTitle();
        }

        @Override
        public String getEventText() {
            return QueueToadlet.l10n("downloadSucceededTitle", "filename", this.uri.getPreferredFilename());
        }
    }

    private static enum QueueType {
        CompletedDownloadToTemp(true, false, false),
        CompletedDownloadToDisk(true, false, false),
        CompletedUpload(true, false, true),
        CompletedDirUpload(true, false, true),
        FailedDownload(false, true, false),
        FailedUpload(false, true, true),
        FailedDirUpload(false, true, true),
        FailedBadMIMEType(false, true, false),
        FailedUnknownMIMEType(false, true, false),
        UncompletedDownload(false, false, false),
        UncompletedUpload(false, false, true),
        UncompletedDirUpload(false, false, true);

        final boolean isCompleted;
        final boolean isFailed;
        final boolean isUpload;

        private QueueType(boolean isCompleted, boolean isFailed, boolean isUpload) {
            this.isCompleted = isCompleted;
            this.isFailed = isFailed;
            this.isUpload = isUpload;
        }
    }

    public static enum QueueColumn {
        IDENTIFIER,
        SIZE,
        MIME_TYPE,
        PERSISTENCE,
        KEY,
        FILENAME,
        PRIORITY,
        FILES,
        TOTAL_SIZE,
        PROGRESS,
        REASON,
        LAST_ACTIVITY,
        LAST_FAILURE,
        COMPAT_MODE;

    }
}

