/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.utils;

import freenet.config.Option;
import freenet.support.MultiValueTable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class UriFilterProxyHeaderParser {
    private UriFilterProxyHeaderParser() {
    }

    public static SchemeAndHostWithPort parse(Option<?> fProxyPortConfig, Option<?> fProxyBindToConfig, String uriScheme, String uriHost, MultiValueTable<String, String> headers) {
        String host2;
        String protocol;
        HashSet<String> safeProtocols = new HashSet<String>(Arrays.asList("http", "https"));
        List bindToHosts = Arrays.stream(fProxyBindToConfig.getValueString().split(",")).map(host -> host.contains(":") ? "[" + host + "]" : host).collect(Collectors.toList());
        String firstBindToHost = (String)bindToHosts.get(0);
        if (firstBindToHost.isEmpty()) {
            firstBindToHost = "127.0.0.1";
        }
        String port = fProxyPortConfig.getValueString().isEmpty() ? "8888" : fProxyPortConfig.getValueString();
        HashSet safeHosts = new HashSet(bindToHosts);
        safeHosts.addAll(safeHosts.stream().map(host -> host + ":" + port).collect(Collectors.toList()));
        String string = headers.containsKey("x-forwarded-proto") ? headers.get("x-forwarded-proto") : (protocol = uriScheme != null && !uriScheme.trim().isEmpty() ? uriScheme : "http");
        String string2 = headers.containsKey("x-forwarded-host") ? headers.get("x-forwarded-host") : (host2 = uriHost != null && !uriHost.trim().isEmpty() ? uriHost : headers.get("host"));
        if (!safeProtocols.contains(protocol)) {
            protocol = "http";
        }
        if (!safeHosts.contains(host2)) {
            host2 = firstBindToHost + ":" + port;
        }
        return new SchemeAndHostWithPort(protocol, host2);
    }

    public static class SchemeAndHostWithPort {
        private final String scheme;
        private final String host;

        SchemeAndHostWithPort(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
        }

        public String toString() {
            return this.scheme + "://" + this.host;
        }
    }
}

