/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptFormatException;
import freenet.crypt.CryptoKey;
import freenet.crypt.Global;
import freenet.crypt.Util;
import freenet.node.FSParseException;
import freenet.support.Base64;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DSAGroup
extends CryptoKey {
    private static final long serialVersionUID = -1L;
    protected static final int Q_BIT_LENGTH = 256;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;

    public DSAGroup(BigInteger p, BigInteger q, BigInteger g) {
        this.p = p;
        this.q = q;
        this.g = g;
        if (p.signum() != 1 || q.signum() != 1 || g.signum() != 1) {
            throw new IllegalArgumentException();
        }
    }

    private DSAGroup(DSAGroup group) {
        this.p = new BigInteger(1, group.p.toByteArray());
        this.q = new BigInteger(1, group.q.toByteArray());
        this.g = new BigInteger(1, group.g.toByteArray());
    }

    protected DSAGroup() {
        this.p = null;
        this.q = null;
        this.g = null;
    }

    public static CryptoKey read(InputStream i) throws IOException, CryptFormatException {
        BigInteger p = Util.readMPI(i);
        BigInteger q = Util.readMPI(i);
        BigInteger g = Util.readMPI(i);
        try {
            DSAGroup group = new DSAGroup(p, q, g);
            if (group.equals(Global.DSAgroupBigA)) {
                return Global.DSAgroupBigA;
            }
            return group;
        }
        catch (IllegalArgumentException e) {
            throw (CryptFormatException)new CryptFormatException("Invalid group: " + e).initCause(e);
        }
    }

    @Override
    public String keyType() {
        return "DSA.g-" + this.p.bitLength();
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    @Override
    public byte[] fingerprint() {
        BigInteger[] fp = new BigInteger[]{this.p, this.q, this.g};
        return this.fingerprint(fp);
    }

    @Override
    public byte[] asBytes() {
        byte[] pb = Util.MPIbytes(this.p);
        byte[] qb = Util.MPIbytes(this.q);
        byte[] gb = Util.MPIbytes(this.g);
        byte[] tb = new byte[pb.length + qb.length + gb.length];
        System.arraycopy(pb, 0, tb, 0, pb.length);
        System.arraycopy(qb, 0, tb, pb.length, qb.length);
        System.arraycopy(gb, 0, tb, pb.length + qb.length, gb.length);
        return tb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DSAGroup && this.p.equals(((DSAGroup)o).p) && this.q.equals(((DSAGroup)o).q) && this.g.equals(((DSAGroup)o).g);
    }

    public boolean equals(DSAGroup o) {
        if (this == o) {
            return true;
        }
        return this.p.equals(o.p) && this.q.equals(o.q) && this.g.equals(o.g);
    }

    public int hashCode() {
        return this.p.hashCode() ^ this.q.hashCode() ^ this.g.hashCode();
    }

    public SimpleFieldSet asFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("p", Base64.encode(this.p.toByteArray()));
        fs.putSingle("q", Base64.encode(this.q.toByteArray()));
        fs.putSingle("g", Base64.encode(this.g.toByteArray()));
        return fs;
    }

    public static DSAGroup create(SimpleFieldSet fs) throws IllegalBase64Exception, FSParseException {
        BigInteger g;
        BigInteger q;
        String myP = fs.get("p");
        String myQ = fs.get("q");
        String myG = fs.get("g");
        if (myP == null || myQ == null || myG == null) {
            throw new FSParseException("The given SFS doesn't contain required fields!");
        }
        BigInteger p = new BigInteger(1, Base64.decode(myP));
        DSAGroup dg = new DSAGroup(p, q = new BigInteger(1, Base64.decode(myQ)), g = new BigInteger(1, Base64.decode(myG)));
        if (dg.equals(Global.DSAgroupBigA)) {
            return Global.DSAgroupBigA;
        }
        return dg;
    }

    @Override
    public String toString() {
        if (this == Global.DSAgroupBigA) {
            return "Global.DSAgroupBigA";
        }
        return super.toString();
    }

    @Override
    public String toLongString() {
        if (this == Global.DSAgroupBigA) {
            return "Global.DSAgroupBigA";
        }
        return "p=" + HexUtil.biToHex(this.p) + ", q=" + HexUtil.biToHex(this.q) + ", g=" + HexUtil.biToHex(this.g);
    }

    public DSAGroup cloneKey() {
        if (this == Global.DSAgroupBigA) {
            return this;
        }
        return new DSAGroup(this);
    }
}

