/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.LowLevelGetException;
import freenet.node.NodeClientCore;
import freenet.node.RequestCompletionListener;
import freenet.node.RequestScheduler;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class SendableGetRequestSender
implements SendableRequestSender {
    private static volatile boolean logMINOR;

    @Override
    public boolean sendIsBlocking() {
        return false;
    }

    @Override
    public boolean send(NodeClientCore core, RequestScheduler sched, final ClientContext context, final ChosenBlock req) {
        SendableRequestItem keyNum = req.token;
        ClientKey key = req.ckey;
        if (key == null) {
            Logger.error(SendableGet.class, "Key is null in send(): keyNum = " + keyNum + " for " + req);
            return false;
        }
        if (logMINOR) {
            Logger.minor(SendableGet.class, "Sending get for key " + keyNum + " : " + key);
        }
        if (req.isCancelled()) {
            if (logMINOR) {
                Logger.minor(SendableGet.class, "Cancelled: " + req);
            }
            req.onFailure(new LowLevelGetException(9), context);
            return false;
        }
        try {
            try {
                Key k = key.getNodeKey();
                core.asyncGet(k, false, new RequestCompletionListener(){

                    @Override
                    public void onSucceeded() {
                        req.onFetchSuccess(context);
                    }

                    @Override
                    public void onFailed(LowLevelGetException e) {
                        req.onFailure(e, context);
                    }
                }, !req.ignoreStore, req.canWriteClientCache, req.realTimeFlag, req.localRequestOnly, req.ignoreStore);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                req.onFailure(new LowLevelGetException(3), context);
                return true;
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            req.onFailure(new LowLevelGetException(3), context);
            return true;
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

