/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.FetchException;
import freenet.client.filter.UnsafeContentTypeException;

public class DataFilterException
extends UnsafeContentTypeException {
    private static final long serialVersionUID = -1L;
    final String rawTitle;
    final String encodedTitle;
    final String explanation;

    DataFilterException(String explanation) {
        this.encodedTitle = this.explanation = explanation;
        this.rawTitle = this.explanation;
    }

    DataFilterException(String raw, String encoded, String explanation) {
        this.rawTitle = raw;
        this.encodedTitle = encoded;
        this.explanation = explanation;
    }

    @Override
    public String getMessage() {
        return this.explanation;
    }

    @Override
    public String getHTMLEncodedTitle() {
        return this.encodedTitle;
    }

    @Override
    public String getRawTitle() {
        return this.rawTitle;
    }

    @Override
    public String toString() {
        return this.rawTitle;
    }

    @Override
    public FetchException recreateFetchException(FetchException e, String mime) {
        return new FetchException(e.expectedSize, this, mime);
    }

    @Override
    public FetchException createFetchException(String mime, long expectedSize) {
        return new FetchException(expectedSize, this, mime);
    }
}

