/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.node.BasePeerNode;
import freenet.node.MessageFragment;
import freenet.node.MessageItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SparseBitmap;
import java.util.Arrays;

public class MessageWrapper {
    private final MessageItem item;
    private final boolean isShortMessage;
    private final int messageID;
    private boolean reportedSent;
    private final long created;
    private int resends;
    private final SparseBitmap acks = new SparseBitmap();
    private final SparseBitmap sent = new SparseBitmap();
    private final SparseBitmap everSent = new SparseBitmap();
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean alreadyAcked = false;

    public MessageWrapper(MessageItem item, int messageID) {
        this.item = item;
        this.isShortMessage = item.buf.length <= 255;
        this.messageID = messageID;
        this.created = System.currentTimeMillis();
    }

    public boolean ack(int start, int end) {
        return this.ack(start, end, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ack(int start, int end, BasePeerNode pn) {
        SparseBitmap sparseBitmap = this.acks;
        synchronized (sparseBitmap) {
            this.acks.add(start, end);
            if (this.acks.contains(0, this.item.buf.length - 1)) {
                if (!this.alreadyAcked) {
                    if (this.item.cb != null) {
                        for (AsyncMessageCallback cb : this.item.cb) {
                            cb.acknowledged();
                        }
                    }
                    this.alreadyAcked = true;
                    if (logMINOR) {
                        Logger.minor(this, "Total round trip time for message " + this.messageID + " : " + this.item + " : " + (System.currentTimeMillis() - this.created) + " in " + this.resends + " resends" + (pn == null ? "" : " for " + pn.shortToString()));
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lost(int start, int end) {
        if (logDEBUG) {
            Logger.debug(this, "Lost from " + start + " to " + end + " on " + this.messageID);
        }
        int size = end - start + 1;
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            SparseBitmap sparseBitmap2 = this.acks;
            synchronized (sparseBitmap2) {
                ++this.resends;
                this.sent.remove(start, end);
                for (int[] range : this.acks) {
                    int toAddEnd;
                    int toAddStart;
                    if (range[1] < start || range[0] > end || (toAddStart = Math.max(start, range[0])) == (toAddEnd = Math.min(end, range[1])) || toAddStart > toAddEnd) continue;
                    Logger.warning(this, "Lost range (" + start + "->" + end + ") is overlapped by acked range (" + range[0] + "->" + range[1] + "). Adding " + toAddStart + "->" + toAddEnd + " to sent");
                    this.sent.add(toAddStart, toAddEnd);
                    size -= toAddEnd - toAddStart + 1;
                }
            }
        }
        return size;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public int getLength() {
        return this.item.buf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFragmented(int length) {
        if (length < this.item.buf.length) {
            return true;
        }
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            SparseBitmap sparseBitmap2 = this.acks;
            synchronized (sparseBitmap2) {
                if (this.sent.isEmpty() && this.acks.isEmpty()) {
                    return false;
                }
            }
            if (this.sent.contains(0, this.item.buf.length - 1)) {
                return false;
            }
        }
        return true;
    }

    public int getPriority() {
        return this.item.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstFragment() {
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            SparseBitmap sparseBitmap2 = this.acks;
            synchronized (sparseBitmap2) {
                return this.sent.isEmpty() && this.acks.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFragment getMessageFragment(int maxLength) {
        byte[] fragmentData;
        int dataLength;
        int start = 0;
        int end = this.item.buf.length - 1;
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            for (int[] range : this.sent) {
                if (range[0] == start) {
                    start = range[1] + 1;
                    continue;
                }
                if (range[0] - start <= 0) continue;
                end = range[0] - 1;
            }
            if (start >= this.item.buf.length) {
                return null;
            }
            dataLength = maxLength - 2 - (this.isShortMessage ? 1 : 2);
            if (this.isFragmented(dataLength)) {
                dataLength -= this.isShortMessage ? 1 : 3;
            }
            if ((dataLength = Math.min(end - start + 1, dataLength)) <= 0) {
                return null;
            }
            fragmentData = Arrays.copyOfRange(this.item.buf, start, start + dataLength);
            this.sent.add(start, start + dataLength - 1);
            if (logDEBUG) {
                Logger.debug(this, "Using range " + start + " to " + (start + dataLength - 1) + " gives " + this.sent + " on " + this.messageID);
            }
        }
        boolean isFragmented = start != 0 || dataLength != this.item.buf.length;
        return new MessageFragment(this.isShortMessage, isFragmented, start == 0, this.messageID, dataLength, this.item.buf.length, start, fragmentData, this);
    }

    public void onDisconnect() {
        this.item.onDisconnect();
    }

    MessageItem getItem() {
        return this.item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSent() {
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            return this.sent.contains(0, this.item.buf.length - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSent(int start, int end, int overhead, BasePeerNode pn) {
        int report = 0;
        int resent = 0;
        boolean completed = false;
        SparseBitmap sparseBitmap = this.sent;
        synchronized (sparseBitmap) {
            if (this.everSent.contains(start, end)) {
                report = 0;
                resent = end - start + 1 + overhead;
            } else {
                report = this.everSent.notOverlapping(start, end);
                resent = end - start + 1 - report;
                if (report > 0 && resent == 0) {
                    report += overhead;
                } else if (resent > 0 && report == 0) {
                    resent += overhead;
                } else {
                    report += overhead / 2;
                    resent += overhead - overhead / 2;
                }
            }
            this.everSent.add(start, end);
            if (this.everSent.contains(0, this.item.buf.length - 1)) {
                if (this.reportedSent) {
                    completed = false;
                } else {
                    completed = true;
                    this.reportedSent = true;
                }
            }
        }
        if (report != 0) {
            this.item.onSent(report);
        }
        if (resent != 0 && pn != null) {
            pn.resentBytes(resent);
        }
        if (completed) {
            this.item.onSentAll();
        }
    }

    SparseBitmap getSent() {
        return new SparseBitmap(this.sent);
    }

    SparseBitmap getAcks() {
        return new SparseBitmap(this.acks);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

